/*
 * synaptiks -- a touchpad control tool
 *
 *
 * Copyright (C) 2009, 2010 Sebastian Wiesner <basti.wiesner@gmx.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef MOUSEDEVICESVIEW_H
#define MOUSEDEVICESVIEW_H

/**
 * @file
 *
 * Provides a KConfig XT specific QListView subclass
 */


#include <QtGui/QListView>


namespace synaptiks {
    /**
     * This class exposes MouseDevicesModel as list.
     *
     * Works around limitations of KConfigDialogManager, which can only deal
     * with widgets and doesn't understand other QObject-derived classes
     * such as model classes.  In order to use MouseDevicesModel with
     * KConfigXT, this class is required.
     */
    class MouseDevicesView: public QListView {
        Q_OBJECT
        /**
         * @brief All checked devices
         */
        Q_PROPERTY(QStringList checkedDevices
                   READ checkedDevices
                   WRITE setCheckedDevices)

    public:
        /**
         * @brief Create a new view.
         *
         * @param parent the parent widget
         */
        MouseDevicesView(QWidget *parent);

        /**
         * @brief Check all given @p devices.
         *
         * @param devices a list of uids
         */
        void setCheckedDevices(const QStringList &devices);

        /**
         * @brief Query checked devices.
         *
         * @return a list of uids of checked devices.
         */
        QStringList checkedDevices();

        /**
         * @brief Ignore touchpads.
         *
         * @param ignored if @c true, touchpads are ignored
         */
        void setTouchpadsIgnored(bool ignored);

        /**
         * @brief Are touchpads ignored?
         *
         * @return @c true, if touchpads are ignored, @c false otherwise
         */
        bool touchpadsIgnored() const;

    Q_SIGNALS:
        /**
         * @brief Signal a change of checked devices.
         *
         * @param devices the newly checked devices
         */
        void checkedDevicesChanged(const QStringList &devices);
    };
}
#endif /* MOUSEDEVICESVIEW_H */
