/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "f2c_syrthes.h"
# include "tree.h"
# include "abs.h"
# include "interfaces.h"


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | box_3d                                                               |
  |         Optimisation de la boite englobante en 3d                    |
  |======================================================================| */
void box_3d(int npoin,double *cooray)
{

  int n,vpd;
  double xm,ym,zm,xm2,ym2,zm2,xmym,xmzm,ymzm;
  double c11,c22,c33,c12,c13,c21,c23,c31,c32,a,b,c;
  double a11,a22,a33,a12,a13,a23;
  double b11,b22,b33,b12,b13,b21,b23,b31,b32;
  double x1,x2,x3,x,y,z;
  double ux,uy,uz,vx,vy,vz,wx,wy,wz,tx,ty,tz,det;
  double epsi,epsir,delta ;
  double p,q,racp,aux,phi,pi ;

  epsi = 1e-6 ; epsir = 1e-20 ;
  pi = 3.141592653589793;


  xm=ym=zm=0.;
  for (n=0;n<npoin;n++)
    {
      xm += cooray[n];
      ym += cooray[n+npoin];
      zm += cooray[n+npoin*2];
    }
   xm /= npoin; ym /= npoin;   zm /= npoin;


  xm2=ym2=zm2=xmym=xmzm=ymzm=0.;
  for (n=0;n<npoin;n++)
    {
      xm2  += cooray[n]         * cooray[n];
      ym2  += cooray[n+npoin]   * cooray[n+npoin];
      zm2  += cooray[n+npoin*2] * cooray[n+npoin*2];
      xmym += cooray[n]         * cooray[n+npoin];
      xmzm += cooray[n]         * cooray[n+npoin*2];
      ymzm += cooray[n+npoin]   * cooray[n+npoin*2];
    }
  
  c11 = xm2/npoin -xm*xm;
  c22 = ym2/npoin -ym*ym;
  c33 = zm2/npoin -zm*zm;
  c12 = c21 = xmym/npoin - xm*ym;
  c13 = c31 = xmzm/npoin - xm*zm;
  c23 = c32 = ymzm/npoin - ym*zm;
      printf("systeme origine \n");
      printf("%f %f %f\n",c11,c12,c13);
      printf("%f %f %f\n",c21,c22,c23);
      printf("%f %f %f\n",c31,c32,c33);
      
      
  a = -(c11+c22+c33);
  b = -(-c11*c22 - c11*c33 - c22*c33 + c13*c31 + c12*c21 + c32*c23);
  c = -(c11*c22*c33 + c21*c32*c13 + c12*c23*c31 - c13*c31*c22 - c21*c12*c33 - c32*c23*c11);
    
  p = (3*b-a*a)/9.;
  q = a*a*a/27. -a*b/6. +c/2 ;

  if ( p < -epsir && p*p*p-q*q < -epsir )
    {
      racp = sqrt(-p) ;
      aux = - q/(p*racp) ;
      if (aux>1) aux=1;
      if (aux<-1) aux=-1;
      phi = acos(aux);

      x1 = -2*racp*cos(phi/3)       -a/3 ;
      x2 =  2*racp*cos((pi-phi)/3.) -a/3 ;
      x3 =  2*racp*cos((pi+phi)/3.) -a/3.;
      printf(" Valeur propres de la transformation l1=%f l2=%f l3=%f \n",x1,x2,x3);
    }
  else
    {
      printf(" $$ box_3d : pas de valeurs propres reelles 1\n");
      return;
    }

  /* recherche des valeurs propres multiples */
  /* elle est triple => rien a faire */
  if (abs(x1-x2)<epsi && abs(x1-x3)<epsi && abs(x3-x2)<epsi) return;
  /* vp double */
  if (abs(x1-x2)<epsi) vpd=12;
  else if (abs(x1-x3)<epsi) vpd=13;
  else if (abs(x2-x3)<epsi) vpd=23;
  else vpd=0;


  delta=x1*0.00001;
  a11=c11-x1-delta; a12=c12          ; a13=c13   ;
                    a22=c22-x1-delta ; a23=c23   ;
                                       a33=c33-x1-delta;
  printf("systeme 1\n");
  det=a11*a22*a33 + 2*a12*a23*a13  -a13*a13*a22 -a11*a23*a23 -a33*a12*a12;
  b11=(a22*a33-a23*a23)/det ; b12=-(a12*a33-a13*a23)/det ; b13= (a12*a23-a13*a22)/det ;
  b21=b12                   ; b22= (a11*a33-a13*a13)/det ; b23=-(a11*a23-a12*a13)/det ;
  b31=b13                   ; b32=b23                    ; b33= (a11*a22-a12*a12)/det ;
  
  resoud3(b11,b12,b13,b21,b22,b23,b31,b32,b33,&ux,&uy,&uz);
  printf("vecteur 1 : %f %f %f\n",ux,uy,uz);

  if (vpd!=12)
    {
      printf("systeme 2\n");
      delta=x2*0.00001;
      a11=c11-x2-delta;  a22=c22-x2-delta ;  a33=c33-x2-delta;

      det=a11*a22*a33 + 2*a12*a23*a13  -a13*a13*a22 -a11*a23*a23 -a33*a12*a12;
      b11=(a22*a33-a23*a23)/det ; b12=-(a12*a33-a13*a23)/det ; b13= (a12*a23-a13*a22)/det ;
      b21=b12                   ; b22= (a11*a33-a13*a13)/det ; b23=-(a11*a23-a12*a13)/det ;
      b31=b13                   ; b32=b23                    ; b33= (a11*a22-a12*a12)/det ;

      resoud3(b11,b12,b13,b21,b22,b23,b31,b32,b33,&vx,&vy,&vz);
      printf("vecteur 2 : %f %f %f\n",vx,vy,vz);
    }


   if (vpd!=13 && vpd!=23)    
     {
      printf("systeme 3\n");
      delta=x3*0.00001;
      a11=c11-x3-delta;  a22=c22-x3-delta ;  a33=c33-x3-delta;

      det=a11*a22*a33 + 2*a12*a23*a13  -a13*a13*a22 -a11*a23*a23 -a33*a12*a12;
      b11=(a22*a33-a23*a23)/det ; b12=-(a12*a33-a13*a23)/det ; b13= (a12*a23-a13*a22)/det ;
      b21=b12                   ; b22= (a11*a33-a13*a13)/det ; b23=-(a11*a23-a12*a13)/det ;
      b31=b13                   ; b32=b23                    ; b33= (a11*a22-a12*a12)/det ;

      resoud3(b11,b12,b13,b21,b22,b23,b31,b32,b33,&wx,&wy,&wz);
      printf("vecteur 3 : %f %f %f\n",wx,wy,wz);
     }


  if (vpd!=0) 
    switch (vpd)
      {
      case 12 : vx = wy*uz-wz*uy;
	        vy =-wx*uz+wz*ux;
	        vz = wx*uy-wy*ux;
	        break;

      case 13 : wx = uy*vz-uz*vy;
	        wy =-ux*vz+uz*vx;
	        wz = ux*vy-uy*vx;
	        break;

	
      case 23 : wx = uy*vz-uz*vy;
	        wy =-ux*vz+uz*vx;
	        wz = ux*vy-uy*vx;
	        break;

      }


  printf("vecteurs propres :\n");
  printf("   u : %f %f %f :\n",ux,uy,uz);
  printf("   v : %f %f %f :\n",vx,vy,vz);
  printf("   w : %f %f %f :\n",wx,wy,wz);


  tx=uy*vz-uz*vy;  ty=uz*vx-ux*vz;  tz=ux*vy-uy*vx;
  if (abs(tx-wx)>epsi || abs(ty-wy)>epsi || abs(tz-wz)>epsi)
    {wx =-wx; wy=-wy; wz=-wz;}

  for (n=0;n<npoin;n++)
    {
      x = ux*cooray[n] + vx*cooray[n+npoin] + wx*cooray[n+npoin*2];
      y = uy*cooray[n] + vy*cooray[n+npoin] + wy*cooray[n+npoin*2];
      z = uz*cooray[n] + vz*cooray[n+npoin] + wz*cooray[n+npoin*2];
      cooray[n] = x;
      cooray[n+npoin] = y;  
      cooray[n+npoin*2] = z;
    }
}
/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | box_2d                                                               |
  |         Optimisation de la boite englobante en 2d                    |
  |======================================================================| */
void box_2d(int npoin,double *cooray)
{

  int n,ok;
  double xm,ym,xm2,ym2,xmym;
  double c11,c22,c12,c21,a11,a12,a21,a22,a,b,c;
  double epsi,delta,x1,x2,ux,uy,vx,vy,x,y,an,z;

  epsi=1.e-6;

  xm=ym=0.;
  for (n=0;n<npoin;n++)
    {
      xm += cooray[n];
      ym += cooray[n+npoin];
    }
   xm /= npoin; ym /= npoin;  


  xm2=ym2=xmym=0.;
  for (n=0;n<npoin;n++)
    {
      xm2  += cooray[n]         * cooray[n];
      ym2  += cooray[n+npoin]   * cooray[n+npoin];
      xmym += cooray[n]         * cooray[n+npoin];
    }
  
  c11 = xm2/npoin -xm*xm;
  c22 = ym2/npoin -ym*ym;
  c12 = c21 = xmym/npoin - xm*ym;
      
      
  a = 1.;
  b = - (c11+c22);
  c = c11*c22 - c12*c21;
    
  ok = 1;
  delta = b*b - 4*a*c;
  if (delta<0)
    {
      printf("$$ box_2d : On ne trouve pas de valeurs propres pour realigner la boite\n");
      ok=0;
    }
  else if (abs(delta)<epsi)
    {
      printf("$$ box_2d : Les valeurs propres pour realigner la boite sont confondues\n");
      ok=0;
    }
  else
    {
      x1 = -0.5*(b-sqrt(delta))/a; 
      x2 = -0.5*(b+sqrt(delta))/a; 
    }

  if (ok)
    {
      a11 = c11-x1; a12 = c12;
      a21 = c21   ; a22 = c22-x1;
      if (abs(a11)>epsi)  { ux = a12/a11; uy = 1.;}
      else                { ux = 1;       uy = 0.;}
      
      a11 = c11-x2; a12 = c12;
      a21 = c21   ; a22 = c22-x2;
      if (abs(a11)>epsi)  { vx = a12/a11; vy = 1.;}
      else                { vx = 1;       vy = 0.;}
      
      an = sqrt( ux*ux +  uy*uy);
      ux /= an; uy /= an;
      an = sqrt( vx*vx + vy*vy);
      vx /= an; vy /= an;
      
      z= ux*vy - uy*vx;
      if (z<0.)
	{ x=ux;  y=uy;
	  ux=vx; uy=vy;
	  vx=x;  vy=y;
	}


  
      for (n=0;n<npoin;n++)
	{
	  x = ux*cooray[n] + vx*cooray[n+npoin];
	  y = uy*cooray[n] + vy*cooray[n+npoin];
	  
	  cooray[n] = x;
	  cooray[n+npoin] = y;  
	}

    }
}

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | resoud3                                                              |
  |                                                                      |
  |======================================================================| */
void resoud3(double b11,double b12,double b13,double b21,double b22,
	     double b23,double b31,double b32,double b33,
	     double *ux,double *uy,double *uz)
{  
  double xx,yy,zz,xn,x,y,z;
  double epsi;
  int n;

  epsi=1.E-8;
  x=y=z=1.;
  xx=0; yy=0; zz=0;
  n=0;

  while (abs(abs(xx)-abs(x))>epsi || 
         abs(abs(zz)-abs(z))>epsi || abs(abs(yy)-abs(y))>epsi)
    {
      n+=1;
      xx=x; yy=y; zz=z;
      x=b11*xx+b12*yy+b13*zz;
      y=b21*xx+b22*yy+b23*zz;
      z=b31*xx+b32*yy+b33*zz;
      xn=sqrt(x*x+y*y+z*z); x/=xn; y/=xn; z/= xn;
    }

  printf(" >>> resoud3 : vecteur propre en %d iterations\n",n);
  *ux=x; *uy=y; *uz=z;
}
      
