/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "tree.h"
# include "f2c_syrthes.h"
# include "interfaces.h"



/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | cfdf3d                                                               |
  |         Gestion du calcul des facteurs de forme en dimension 3       |
  |======================================================================| */

proc(void coumst,void COUMST) (int *ndim,int *nelray,int *npoinr,int *nodray,
		     double *cooray,int *nfmst,int *ngfmst,int *nblblr)

{
  double *xnfray;
       
  if (*ndim==2)
    {
      xnfray=(double*)malloc(*nelray * 2 * sizeof(double));
      if (xnfray==NULL) 
	{printf(" ERREUR coumst : probleme d'allocation memoire\n");
	 exit(0);}
      cnor_2d(*ndim,*nelray,*npoinr,nodray,cooray,xnfray);
      couple_mst_2d(*nfmst,ngfmst,*nelray,*npoinr,
		    nodray,cooray,xnfray,*nblblr);
      free(xnfray);
    }
  else
    {
      xnfray=(double*)malloc(*nelray * 3 * sizeof(double));
      if (xnfray==NULL) 
	{printf(" ERREUR coumst : probleme d'allocation memoire\n");
	 exit(0);}
      cnor_3d(*ndim,*nelray,*npoinr,nodray,cooray,xnfray);
      
      couple_mst_3d(*nfmst,ngfmst,*nelray,*npoinr,
		    nodray,cooray,xnfray,*nblblr);
      free(xnfray);
    }
}

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | couple_mst                                                           |
  |     determination des couples de facettes des msts                   |
  |======================================================================| */
void couple_mst_2d(int nfmst,int *ngfmst,
                   int nelray,int npoinr,int *nodray,
                   double *cooray,double *xnf,int nblblr)
{
  int i,j,num1,num2,n1,n2,nmin,jmin;
  double xn1,yn1,xn2,yn2,x1,x2,y1,y2;
  double xc1,yc1,xc2,yc2;
  double dmin,d;


  for (i=nfmst;i<2*nfmst;i++) ngfmst[i]=0;

  for (i=0;i<nfmst;i++)
    if (ngfmst[nfmst+i]==0)
      {
	num1=ngfmst[i];
	n1=nodray[num1-1]; n2=nodray[num1-1+nelray];
	xn1=xnf[num1-1];   yn1=xnf[num1-1+ nelray];
	x1 =cooray[n1-1];  y1=cooray[n1-1+npoinr]; 
	x2 =cooray[n2-1];  y2=cooray[n2-1+npoinr]; 
        xc1=(x1+x2)*0.5; yc1=(y1+y2)*0.5;
        dmin=1.e6;
	for (j=0;j<nfmst;j++)
	  if (ngfmst[nfmst+j]==0 && i!=j)
	    {
	      num2=ngfmst[j];
	      n1=nodray[num2-1]; n2=nodray[num2-1+nelray];
	      x1 =cooray[n1-1];  y1=cooray[n1-1+npoinr];  
	      x2 =cooray[n2-1];  y2=cooray[n2-1+npoinr];  
	      xc2=(x1+x2)*0.5;  yc2=(y1+y2)*0.5; 
	      d=(xc2-xc1)*(xc2-xc1)+(yc2-yc1)*(yc2-yc1);
	      if (d<dmin)
		{
		  xn2=xnf[num2-1];  yn2=xnf[num2-1+nelray]; 
		  if (xn1*xn2+yn1*yn2<0){dmin=d; nmin=num2;jmin=j;}
		}
	    }
	ngfmst[nfmst+i]=jmin+1; ngfmst[nfmst+jmin]=i+1;
/*	ngfmst[nfmst+i]=num2; 	ngfmst[nfmst+jmin]=num1; */
      } 

  if (nblblr>=10)
    {
      printf("   *** COUPLE_MST_2D : couples de facettes rayonnement MSTS\n");
      printf("                       facette    num_global   Vis-a-vis : local    global\n");
      for (i=0;i<nfmst;i++)
	printf("                     %7d       %7d             %7d    %7d\n",
                 i+1,ngfmst[i],ngfmst[i+nfmst],ngfmst[ngfmst[i+nfmst]-1]);
    }
} 

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | couple_mst                                                           |
  |     determination des couples de facettes des msts                   |
  |======================================================================| */
void couple_mst_3d(int nfmst,int *ngfmst,
                   int nelray,int npoinr,int *nodray,
                   double *cooray,double *xnf,int nblblr)
{
  int i,j,num1,num2,n1,n2,n3,nmin,jmin;
  double xn1,yn1,zn1,xn2,yn2,zn2,x1,x2,x3,y1,y2,y3,z1,z2,z3;
  double tiers,xc1,yc1,zc1,xc2,yc2,zc2;
  double dmin,d;


  tiers=1./3.;
  for (i=nfmst;i<2*nfmst;i++) ngfmst[i]=0;

  for (i=0;i<nfmst;i++)
    if (ngfmst[nfmst+i]==0)
      {
	num1=ngfmst[i];
	n1=nodray[num1-1]; n2=nodray[num1-1+nelray]; n3=nodray[num1-1+nelray*2];
	xn1=xnf[num1-1];   yn1=xnf[num1-1+ nelray]; zn1=xnf[num1-1+ nelray*2];
	x1 =cooray[n1-1];  y1=cooray[n1-1+npoinr];   z1=cooray[n1-1+npoinr*2];
	x2 =cooray[n2-1];  y2=cooray[n2-1+npoinr];   z2=cooray[n2-1+npoinr*2];
	x3 =cooray[n3-1];  y3=cooray[n3-1+npoinr];   z3=cooray[n3-1+npoinr*2];
        xc1=(x1+x2+x3)*tiers; yc1=(y1+y2+y3)*tiers;  zc1=(z1+z2+z3)*tiers;
        dmin=1.e6;
	for (j=0;j<nfmst;j++)
	  if (ngfmst[nfmst+j]==0 && i!=j)
	    {
	      num2=ngfmst[j];
	      n1=nodray[num2-1]; n2=nodray[num2-1+nelray]; n3=nodray[num2-1+nelray*2];
	      x1 =cooray[n1-1];  y1=cooray[n1-1+npoinr];   z1=cooray[n1-1+npoinr*2];
	      x2 =cooray[n2-1];  y2=cooray[n2-1+npoinr];   z2=cooray[n2-1+npoinr*2];
	      x3 =cooray[n3-1];  y3=cooray[n3-1+npoinr];   z3=cooray[n3-1+npoinr*2];
	      xc2=(x1+x2+x3)*tiers; yc2=(y1+y2+y3)*tiers;  zc2=(z1+z2+z3)*tiers;
	      d=(xc2-xc1)*(xc2-xc1)+(yc2-yc1)*(yc2-yc1)+(zc1-zc2)*(zc1-zc2);
	      if (d<dmin)
		{
		  xn2=xnf[num2-1];  yn2=xnf[num2-1+nelray];   zn2=xnf[num2-1+nelray*2];
		  if (xn1*xn2+yn1*yn2+zn1*zn2<0){dmin=d; nmin=num2;jmin=j;}
		}
	    }
	ngfmst[nfmst+i]=jmin+1; 	ngfmst[nfmst+jmin]=i+1;
/*	ngfmst[nfmst+i]=num2; 	ngfmst[nfmst+jmin]=num1;*/
      } 

  if (nblblr>=10)
    {
      printf("   *** COUPLE_MST_3D : couples de facettes rayonnement MSTS\n");
      printf("                       facette    num_global   Vis-a-vis : local    global\n");
      for (i=0;i<nfmst;i++)
	printf("                     %7d       %7d             %7d    %7d\n",
                 i+1,ngfmst[i],ngfmst[i+nfmst],ngfmst[ngfmst[i+nfmst]-1]);
    } 
}

