/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>

#include "tree.h"

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | elague_tree                                                          |
  |         Faire du menage dans l'arbre                                 |
  |======================================================================| */
void elague_tree(struct node *pere,struct node *n1,int nbfils)

{
    int i,nbf;
    struct element *el1,*el2;
    struct child *f1;

    nbf=nbfils-1;

    if (n1->lfils != NULL)
      {
        if (n1 != pere)
	  {
	    el1=n1->lelement;
	    while (el1!=NULL)
	      {
		el2=el1->suivant;
		free(el1);
		el1=el2;
	      } 
	    n1->lelement = NULL;
	  }

	f1 = n1->lfils;
	elague_tree(pere,f1->fils,nbfils);
	f1 = f1->suivant;
	for (i=0;i<nbf;i++)
	  {
	    elague_tree(pere,f1->fils,nbfils);
            f1 = f1->suivant;
	  }
      }
}	    
/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | tuer_tree                                                            |
  |         Tuer l'arbre...                                              |
  |======================================================================| */
void tuer_tree(struct node *noeud,int nbfils)

{
    int i,nbf;
    struct element *el1,*el2;
    struct child *f1,*f2;

    nbf=nbfils-1;

    /* elimination de la liste d'element si elle existe */
    if (noeud->lelement != NULL)
      {
        el1=noeud->lelement;
        while (el1!=NULL)
          {
            el2=el1->suivant;
            free(el1);
            el1=el2;
          } 
	noeud->lelement = NULL;
      }

    if (noeud->lfils != NULL)
      {
	f1 = noeud->lfils;
	tuer_tree(f1->fils,nbfils);
	f2 = f1->suivant;
        free(f1);
        f1=f2;
	for (i=0;i<nbf;i++)
	  {
	    tuer_tree(f1->fils,nbfils);
            f2 = f1->suivant;
            free(f1);
            f1=f2;
	  }
      }
}	    

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | affiche_tree                                                         |
  |         Afficher un arbre                                            |
  |======================================================================| */
void affiche_tree(struct node *n1, int nbfils)

{
    int i,nbf;
    struct element *fa1;
    struct child *f1;

    nbf=nbfils-1;

    fa1 = n1->lelement;
    if (fa1 != NULL)
        {
            if (nbfils==4)
   	       printf("centre %f %f taille x et y %f %f \n",
	              n1->xc,n1->yc,n1->sizx,n1->sizy);
            else
   	       printf("centre %f %f %f taille x y z %f %f %f \n",
	              n1->xc,n1->yc,n1->zc,
                      n1->sizx,n1->sizy,n1->sizz);
        }

    while (fa1 != NULL) 
	{
            printf(" element  %d \n",fa1->num);
	    fa1=fa1->suivant;
	}
    f1 = n1->lfils;
    if (f1 != NULL)
	{
	    /* printf("noeud %d \n",f1->name);*/
	    affiche_tree(f1->fils,nbfils);
            f1 = f1->suivant;

            for (i=0;i<nbf;i++)
              {
        	    if (f1->fils != NULL)
	     		{
			    /* printf("noeud %d \n",f1->name);*/
			    affiche_tree(f1->fils,nbfils);
			}
           	 f1 = f1->suivant;
      	      }
	}
	
}	    
