C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=MOBMX2,SSI=0
                        SUBROUTINE MOBMX2
C                       *****************
C
C      -----------------------------------------
     * (NDIM,NDIELE,NPOINS,NELEMS,NDMATS,NBFACE,
     *  NODES,NREFS,NREFAC,COORDS)
C      -----------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C     SOLIDES EN TRANSLATION : GENERATION DU SECOND MAILLAGE TRANSLATE *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! Dimension du probleme                        !
C !  NDIELE   !  E ! D  ! Dimension des elements triangles ou tetra)  !
C !  NPOINS   !  E ! D  ! Nombre de noeuds du maillage solide          !
C !  NELEMS   !  E ! D  ! Nombre d'elements du maillage solide         !
C !  NDMATS   !  E ! D  ! Nombre de noeuds par element volumique       !
C !  NBFACE   !  E ! D  ! NOMBRE DE FACES DES ELTS VOL SOLIDES         !
C !  NODES    ! TE ! M  ! Connectivite maillage volumique solide       !
C !  NREFS    ! TE ! M  ! Reference des noeuds du maillage vol. solide |
C !  NREFAC   ! TE ! M  ! Reference des faces                          |
C !  COORDS   ! TR ! M  ! Coordonnees des noeuds                       |
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "mobil.h"
#include "xrefer.h"
#include "nlofes.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NDIELE,NELEMS,NDMATS,NPOINS,NBFACE
      INTEGER NODES(NELEMS,NDMATS),NREFS(NPOINS),NREFAC(NELEMS,NBFACE)
      DOUBLE PRECISION COORDS(NPOINS,NDIM)
C
C.. Variables internes
      LOGICAL LVERIF
      INTEGER N,I,J
C***********************************************************************
C
C
C     0- INITIALISATIONS
C     ==================
C
      LVERIF = .FALSE.
C
C     1- DUPLICATION DES COORDONNEES
C     ------------------------------
C
      DO 100 N=1,NBNMA1
        COORDS(NBNMA1+N,1) = COORDS(N,1) 
        COORDS(NBNMA1+N,2) = COORDS(N,2) 
  100 CONTINUE
C
      IF (NDIM.EQ.3) THEN       
        DO 110 N=1,NBNMA1
          COORDS(NBNMA1+N,3) = COORDS(N,3) 
  110   CONTINUE
      ENDIF
C
C
C     2- DUPLICATION DES REFERENCES DES NOEUDS
C     ----------------------------------------
      DO 200 N=1,NBNMA1
        NREFS(NBNMA1+N) = NREFS(N)
  200 CONTINUE
C
C
C     3- DUPLICATION DES ELEMENTS
C     ---------------------------
C
      DO 300 I=1,NDMATS
       DO 310 N=1,NBEMA1
         NODES(NBEMA1+N,I) = NODES(N,I) + NBNMA1
  310  CONTINUE
  300 CONTINUE
C
C     4- DUPLICATION DES REFERENCES DES FACES
C     ---------------------------------------
C
      IF (LCFACE) THEN
C
        DO 400 J=1,NBFACE
         DO 410 I=1,NBEMA1
           NREFAC(NBEMA1+I,J) = NREFAC(I,J)
  410    CONTINUE
  400   CONTINUE
C
      ENDIF
C
      END
