C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE OPENCT
C                       *****************
C      -------
     * (CTYPE)
C      -------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C
C BUT :  CENTRALISATION DES OUVERTURES DE TOUS LES FICHIERS DE SYRTHES
C ----    
C
C
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C ! CTYPE     !    !    !  TYPE DES FICHIERS                           !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !___________!____!____!______________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C ! /FICHCT/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT  : POINTO
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C***********************************************************************
C
#include "divct.h"
#include "fichct.h"
#include "optct.h"
#include "nlofct.h"
#include "nlofes.h"
#ifdef MED
#include "med.hf"
#endif
C           
C***********************************************************************
C
C... Declarations des variables externes
      CHARACTER CTYPE*5
C
C
C... Declarations des variables internes
C
      CHARACTER NAME*200,FICH*200,CH*5
#ifdef HAVE_C_IO
      CHARACTER MSGIOS*80
#endif
      INTEGER NFIC,IOS,II1,II2,N1,N2,N3,LPOS,IDEB,IFIN,LCH,N,IRET
      INTEGER LE
      LOGICAL LEXTEN
C
C***********************************************************************
C                    
C
C***********************************************************************
C
C     ======================
C     1- FICHIER OBLIGATOIRE
C     ======================
C
C
C     1.1- FICHIER DE DONNEES DU COUPLAGE THERMIQUE syrthes.data
C     ---------------------------------------------------------
C
      IF (CTYPE .EQ. 'OBLIG') THEN
C
           FICH = ' '
           FICH = RAMON  
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTCL
           CALL VERLOS ( NAME, N1, N2, LPOS )
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFCLCT
           OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *            STATUS='OLD',FORM='FORMATTED',
     *            ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
           REWIND ( UNIT=NFIC,ERR=99 )
C
C
C     ============================================================
C     1. bis - FICHIER OBLIGATOIRE POUR LE RAYONNEMENT syrthes.ray
C     ============================================================
C 
      ELSEIF (CTYPE .EQ. 'RAYOB') THEN
           FICH = ' '
           FICH = RAMON  
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTCLRA
           CALL VERLOS ( NAME, N1, N2, LPOS )
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFCLRA
           OPEN ( UNIT= NFIC, FILE=FICH (II1:II2), STATUS='OLD',
     &            FORM='FORMATTED',ACCESS='SEQUENTIAL',
     &            IOSTAT=IOS , ERR=99      )
           REWIND(UNIT=NFIC,ERR=99)
C
C     =============================
C     2- FICHIER GEOMETRIE RESULTAT
C     =============================
C
C     2.1- FICHIER 1 DE RESULTATS SOLIDE (GEOMETRIE)
C     ----------------------------------------------
C
      ELSEIF (CTYPE .EQ. 'RGEOM') THEN
C
           FICH = ' '
           FICH = RAVAL
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTGRF1
           CALL VERLOS ( NAME, N1, N2, LPOS )
           LEXTEN = .FALSE.
           DO N=N1,N2
              IF (NAME(N:N).EQ.'.') LEXTEN = .TRUE.
           ENDDO
           TYPGS='SYR'
           IF (LEXTEN.AND.NAME(N2-2:N2).EQ.'med') TYPGS='MED'
#ifndef MED
           TYPGS='SYR'
#endif
C
           IF (LSDEPL .OR. LSROTA) THEN
             WRITE(CH,2000) NTSYR
             CALL VERLOS (CH,IDEB,IFIN,LCH)
             LEXTEN = .FALSE.
             DO N=N1,N2
               IF (NAME(N:N).EQ.'.') THEN
                 N3 = N
                 LEXTEN = .TRUE.
               ENDIF
             ENDDO
             IF (LEXTEN) THEN
               NAME = NAME(N1:N3-1)//'_'//CH(IDEB:IFIN)//NAME(N3:N2)
             ELSE
               NAME = NAME(N1:N2)//'_'//CH(IDEB:IFIN)
             ENDIF
             CALL VERLOS ( NAME, N1, N2, LPOS )
           ENDIF
C
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFGGCT
           IF (TYPGS.EQ.'SYR') THEN
            OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *            STATUS='UNKNOWN',FORM='FORMATTED',
     *            ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
            REWIND ( UNIT=NFIC,ERR=99 )
           ELSE
#ifdef MED
            CALL EFOUVR(NFGGCT,FICH(II1:II2),MED_REMP,IRET)
#endif
           ENDIF
C
C     ===================
C     3- FICHIER RESULTAT 
C     ===================
C
C      3.1- FICHIER 2 DE RESULTATS SOLIDE (RESULTATS)
C      ----------------------------------------------
C
      ELSEIF (CTYPE .EQ. 'RESUL') THEN
C
           FICH = ' '
           FICH = RAVAL 
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTGRF2
           CALL VERLOS ( NAME, N1, N2, LPOS )
           LEXTEN = .FALSE.
           DO N=N1,N2
              IF (NAME(N:N).EQ.'.') LEXTEN = .TRUE.
           ENDDO
           TYPRS='SYR'
           IF (LEXTEN.AND.NAME(N2-2:N2).EQ.'med') TYPRS='MED'
#ifndef MED
           TYPRS='SYR'
#endif
C
           IF (LSDEPL .OR. LSROTA) THEN
             WRITE(CH,2000) NTSYR
             CALL VERLOS (CH,IDEB,IFIN,LCH)
             LEXTEN = .FALSE.
             DO 130 N=N1,N2
               IF (NAME(N:N).EQ.'.') THEN
                 N3 = N
                 LEXTEN = .TRUE.
               ENDIF
  130        CONTINUE
             IF (LEXTEN) THEN
               NAME = NAME(N1:N3-1)//'_'//CH(IDEB:IFIN)//NAME(N3:N2)
             ELSE
               NAME = NAME(N1:N2)//'_'//CH(IDEB:IFIN)
             ENDIF
             CALL VERLOS ( NAME, N1, N2, LPOS )
           ENDIF
C
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFGRCT
           IF (TYPRS.EQ.'SYR') THEN
            OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *            STATUS='UNKNOWN',FORM='FORMATTED',
     *            ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
            REWIND ( UNIT=NFIC,ERR=99 )
           ELSE
#ifdef MED
            CALL EFOUVR(NFGRCT,FICH(II1:II2),MED_REMP,IRET)
#endif
           ENDIF
C
C     ========================
C     4- FICHIER CHRONOLOGIQUE
C     ========================
C
C       4.1- FICHIER 2 DE RESULTATS SOLIDE (CHRONOLOGIQUE)
C       --------------------------------------------------
C
      ELSEIF (CTYPE .EQ. 'RCHRO') THEN
C
           FICH = ' '
           FICH = RAVAL
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTGF2C
           CALL VERLOS ( NAME, N1, N2, LPOS )
           LEXTEN = .FALSE.
           DO N=N1,N2
              IF (NAME(N:N).EQ.'.') LEXTEN = .TRUE.
           ENDDO
           TYPCS='SYR'
           IF (LEXTEN.AND.NAME(N2-2:N2).EQ.'med') TYPCS='MED'
#ifndef MED
           TYPCS='SYR'
#endif
C
           IF (LSDEPL .OR. LSROTA) THEN
             WRITE(CH,2000) NTSYR
             CALL VERLOS (CH,IDEB,IFIN,LCH)
             LEXTEN = .FALSE.
             DO 140 N=N1,N2
               IF (NAME(N:N).EQ.'.') THEN
                 N3 = N
                 LEXTEN = .TRUE.
               ENDIF
  140        CONTINUE
             IF (LEXTEN) THEN
               NAME = NAME(N1:N3-1)//'_'//CH(IDEB:IFIN)//NAME(N3:N2)
             ELSE
               NAME = NAME(N1:N2)//'_'//CH(IDEB:IFIN)
             ENDIF
             CALL VERLOS ( NAME, N1, N2, LPOS )
           ENDIF
C
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFGCCT
           IF (TYPCS.EQ.'SYR') THEN
            OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *            STATUS='UNKNOWN',FORM='FORMATTED',
     *            ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
            REWIND ( UNIT=NFIC,ERR=99 )
           ELSE
#ifdef MED
            CALL EFOUVR(NFGCCT,FICH(II1:II2),MED_REMP,IRET)
#endif
           ENDIF
C
C     ==================
C     5- AUTRES FICHIERS
C     ==================
C
      ELSEIF (CTYPE .EQ. 'AUTRE') THEN
C
C       5.1- FICHIER SUITE DE RESULTATS SOLIDE (RESULTATS)
C       --------------------------------------------------
C
         IF ( LSUISO ) THEN
           FICH = ' '
           FICH = RSUITE
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTSUIT
           CALL VERLOS ( NAME, N1, N2, LPOS )
           LEXTEN = .FALSE.
           DO N=N1,N2
              IF (NAME(N:N).EQ.'.') LEXTEN = .TRUE.
           ENDDO
           TYPSU='SYR'
           IF (LEXTEN.AND.NAME(N2-2:N2).EQ.'med') TYPSU='MED'
#ifndef MED
           TYPSU='SYR'
#endif
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFGSCT
           IF (TYPSU.EQ.'SYR') THEN
            OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *            STATUS='OLD',FORM='FORMATTED',
     *            ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
            REWIND ( UNIT=NFIC,ERR=99 )
           ELSE
#ifdef MED
            CALL EFOUVR(NFGSCT,FICH(II1:II2),MED_LECT,IRET)
#endif
           ENDIF
         ENDIF
C
C         5.2- FICHIER DE DONNEES DU MAILLAGE ELEMENTS FINIS SOLIDE
C         ---------------------------------------------------------
C 
           FICH = ' '
           FICH = RAMON  
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTMAEF
           CALL VERLOS ( NAME, N1, N2, LPOS )
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFSGCT
           TYPEF = ' '
           IF (NAME(N2-2:N2).EQ.'unv') THEN
              TYPEF = 'IDE'
           ELSEIF (NAME(N2-2:N2).EQ.'des') THEN
              TYPEF = 'SIM'
           ELSEIF (NAME(N2-2:N2).EQ.'syr') THEN
              TYPEF = 'SYR'
#ifdef MED
           ELSEIF (NAME(N2-2:N2).EQ.'med') THEN
              TYPEF = 'MED'
#endif
           ELSE
              WRITE(NFECRA,1200)
              STOP
           ENDIF
           IF (TYPEF.EQ.'SIM') THEN
#ifndef HAVE_C_IO
             OPEN ( UNIT= NFIC, FILE=FICH (II1:II2), STATUS='OLD',
     &             FORM='UNFORMATTED', IOSTAT=IOS , ERR=99      )
             REWIND(UNIT=NFIC,ERR=99)
#else
             CALL OPENBF(FICH(II1:II2), II2-II1+1, 'r', 1, NFIC, IOS)
             IF (IOS .NE. 0) GOTO 98
	     LE=56
             CALL TENDBF(NFIC,LE,IOS)
             IF (IOS .NE. 0) GOTO 98
#endif
           ELSEIF (TYPEF.EQ.'IDE' .OR. TYPEF.EQ.'SYR') THEN
             OPEN ( UNIT= NFIC, FILE=FICH(II1:II2), STATUS='OLD',
     &           FORM='FORMATTED', IOSTAT=IOS , ERR=99      )
             REWIND(UNIT=NFIC,ERR=99)
#ifdef MED
           ELSEIF (TYPEF.EQ.'MED') THEN
             CALL EFOUVR(NFSGCT,FICH(II1:II2),MED_LECT,IRET)
#endif
           ENDIF
C
C
C          5.3- FICHIER DE SAUVEGARDE DU MAILLAGE EF FLUIDE 
C               (noeuds couples)
C          ----------------------------------------------------
          IF (LGEOMF) THEN
C
           FICH = ' '
           FICH = RAVAL 
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTGEOF
           CALL VERLOS ( NAME, N1, N2, LPOS )
           LEXTEN = .FALSE.
           DO N=N1,N2
              IF (NAME(N:N).EQ.'.') LEXTEN = .TRUE.
           ENDDO
           TYPGF='SYR'
           IF (LEXTEN.AND.NAME(N2-2:N2).EQ.'med') TYPGF='MED'
#ifndef MED
           TYPGF='SYR'
#endif
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFGFCT
           IF (TYPGF.EQ.'SYR') THEN
            OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *            STATUS='UNKNOWN',FORM='FORMATTED',
     *            ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
            REWIND ( UNIT=NFIC,ERR=99 )
           ELSE
#ifdef MED
            CALL EFOUVR(NFGFCT,FICH(II1:II2),MED_REMP,IRET)
#endif
           ENDIF
C
          ENDIF
C
C          5.4- FICHIER DE RESULTATS SUR LE MAILLAGE EF FLUIDE 
C               (noeuds couples, temperature de peau du fluide 
C                et coefficients d'echange)
C          ----------------------------------------------------
          IF (LRESUF) THEN
C
           FICH = ' '
           FICH = RAVAL 
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTRESF
           CALL VERLOS ( NAME, N1, N2, LPOS )
           LEXTEN = .FALSE.
           DO N=N1,N2
              IF (NAME(N:N).EQ.'.') LEXTEN = .TRUE.
           ENDDO
           TYPRF='SYR'
           IF (LEXTEN.AND.NAME(N2-2:N2).EQ.'med') TYPRF='MED'
#ifndef MED
           TYPRF='SYR'
#endif
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFRFCT
           IF (TYPRF.EQ.'SYR') THEN
            OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *            STATUS='UNKNOWN',FORM='FORMATTED',
     *            ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
            REWIND ( UNIT=NFIC,ERR=99 )
           ELSE
#ifdef MED
            CALL EFOUVR(NFRFCT,FICH(II1:II2),MED_REMP,IRET)
#endif
           ENDIF
C
          ENDIF
C
C          5.5- FICHIER DE RESULTATS SUR LE MAILLAGE EF FLUIDE 
C               (noeuds couples, temperature de peau du fluide 
C                et coefficients d'echange)
C          ----------------------------------------------------
          IF (LCHROF) THEN
C
           FICH = ' '
           FICH = RAVAL 
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTCHOF
           CALL VERLOS ( NAME, N1, N2, LPOS )
           LEXTEN = .FALSE.
           DO N=N1,N2
              IF (NAME(N:N).EQ.'.') LEXTEN = .TRUE.
           ENDDO
           TYPCF='SYR'
           IF (LEXTEN.AND.NAME(N2-2:N2).EQ.'med') TYPCF='MED'
#ifndef MED
           TYPCF='SYR'
#endif
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFCFCT
           IF (TYPCF.EQ.'SYR') THEN
            OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *            STATUS='UNKNOWN',FORM='FORMATTED',
     *            ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
            REWIND ( UNIT=NFIC,ERR=99 )
           ELSE
#ifdef MED
            CALL EFOUVR(NFCFCT,FICH(II1:II2),MED_REMP,IRET)
#endif
           ENDIF
C
          ENDIF
C
C          5.6- HISTORIQUES SOLIDES RESULTATS
C          ----------------------------------
C
         IF (LHISOL) THEN
           FICH = ' '
           FICH = RAVAL 
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTHISR
           CALL VERLOS ( NAME, N1, N2, LPOS )
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFHRCT
           OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *            STATUS='UNKNOWN',FORM='FORMATTED',
     *            ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
           REWIND ( UNIT=NFIC,ERR=99 )
         ENDIF 
C
C          5.7- STOCKAGE-LECTURE DES CORRESPONDANTS FLUIDE/SOLIDE
C          ------------------------------------------------------
         IF (LSTOKC .OR. LECCOR) THEN
           FICH = ' '
           FICH = RSUITE
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTCORR
           CALL VERLOS ( NAME, N1, N2, LPOS )
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFCOCT
           IF (LECCOR) THEN
              OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *               STATUS='OLD',FORM='FORMATTED',
     *               ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
           ELSE
              OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *               STATUS='UNKNOWN',FORM='FORMATTED',
     *               ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
           ENDIF
           REWIND ( UNIT=NFIC,ERR=99 )
         ENDIF
C
C
C     ==============
C     6- RAYONNEMENT
C     ==============
C
      ELSEIF (CTYPE .EQ. 'RAYTT') THEN
C
C         6.1- RAYONNEMENT MAILLAGE ELEMENTS FINIS DE PEAU
C         -----------------------------------------------
C
           FICH = ' '
           FICH = RAMON  
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTGERA
           CALL VERLOS ( NAME, N1, N2, LPOS )
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFSGRA
           TYPRA = ' '
           IF (NAME(N2-2:N2).EQ.'unv') THEN
              TYPRA = 'IDE'
           ELSEIF (NAME(N2-2:N2).EQ.'des') THEN
              TYPRA = 'SIM'
           ELSEIF (NAME(N2-2:N2).EQ.'syr') THEN
              TYPRA = 'SYR'
#ifdef MED
           ELSEIF (NAME(N2-2:N2).EQ.'med') THEN
              TYPRA = 'MED'
#endif
           ELSE
              WRITE(NFECRA,1210)
              STOP
           ENDIF
           IF (TYPRA.EQ.'SIM') THEN
#ifndef HAVE_C_IO
             OPEN ( UNIT= NFIC, FILE=FICH (II1:II2), STATUS='OLD',
     &             FORM='UNFORMATTED', IOSTAT=IOS , ERR=99      )
             REWIND(UNIT=NFIC,ERR=99)
#else
             CALL OPENBF(FICH(II1:II2), II2-II1+1, 'r', 1, NFIC, IOS)
             IF (IOS .NE. 0) GOTO 98
             LE=56
             CALL TENDBF(NFIC,LE,IOS)
             IF (IOS .NE. 0) GOTO 98
#endif
           ELSEIF (TYPRA.EQ.'IDE' .OR. TYPRA.EQ.'SYR') THEN
             OPEN ( UNIT= NFIC, FILE=FICH(II1:II2), STATUS='OLD',
     &           FORM='FORMATTED', IOSTAT=IOS , ERR=99      )
             REWIND(UNIT=NFIC,ERR=99)
#ifdef MED
           ELSEIF (TYPRA.EQ.'MED') THEN
             CALL EFOUVR(NFSGRA,FICH(II1:II2),MED_LECT,IRET)
#endif
           ENDIF
C
C
C          6.2- RAYONNEMENT : MAILLAGE  RESULTAT
C                    - FORMAT SYRTHES -
C          --------------------------------------
           FICH = ' '
           FICH = RAVAL 
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTRGRA
           CALL VERLOS ( NAME, N1, N2, LPOS )
           LEXTEN = .FALSE.
           DO N=N1,N2
              IF (NAME(N:N).EQ.'.') LEXTEN = .TRUE.
           ENDDO
           TYPGR='SYR'
           IF (LEXTEN.AND.NAME(N2-2:N2).EQ.'med') TYPGR='MED'
#ifndef MED
           TYPGR='SYR'
#endif
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFGGRA
           IF (TYPGR.EQ.'SYR') THEN
            OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *            STATUS='UNKNOWN',FORM='FORMATTED',
     *            ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
            REWIND ( UNIT=NFIC,ERR=99 )
           ELSE
#ifdef MED
             CALL EFOUVR(NFGGRA,FICH(II1:II2),MED_REMP,IRET)
#endif
           ENDIF
C
C
C          6.3- RAYONNEMENT : RESULTAT MAILLAGE DE RAYONNEMENT
C                    - FORMAT SYRTHES -
C          ---------------------------------------------
           FICH = ' '
           FICH = RAVAL 
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTRRRA
           CALL VERLOS ( NAME, N1, N2, LPOS )
           LEXTEN = .FALSE.
           DO N=N1,N2
              IF (NAME(N:N).EQ.'.') LEXTEN = .TRUE.
           ENDDO
           TYPRR='SYR'
           IF (LEXTEN.AND.NAME(N2-2:N2).EQ.'med') TYPRR='MED'
#ifndef MED
           TYPRR='SYR'
#endif
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFGRRA
           IF (TYPRR.EQ.'SYR') THEN
            OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *            STATUS='UNKNOWN',FORM='FORMATTED',
     *            ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
            REWIND ( UNIT=NFIC,ERR=99 )
           ELSE
#ifdef MED
             CALL EFOUVR(NFGRRA,FICH(II1:II2),MED_REMP,IRET)
#endif
           ENDIF
C
C
C          6.4- RAYONNEMENT : CHRONO DE RAYONNEMENT
C                    - FORMAT SYRTHES -
C          ----------------------------------------
          IF (NCHROR.GT.0) THEN
           FICH = ' '
           FICH = RAVAL 
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTRCRA
           CALL VERLOS ( NAME, N1, N2, LPOS )
           LEXTEN = .FALSE.
           DO N=N1,N2
              IF (NAME(N:N).EQ.'.') LEXTEN = .TRUE.
           ENDDO
           TYPCR='SYR'
           IF (LEXTEN.AND.NAME(N2-2:N2).EQ.'med') TYPCR='MED'
#ifndef MED
           TYPCR='SYR'
#endif
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFGCRA
           IF (TYPCR.EQ.'SYR') THEN
            OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *            STATUS='UNKNOWN',FORM='FORMATTED',
     *            ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
            REWIND ( UNIT=NFIC,ERR=99 )
           ELSE
#ifdef MED
             CALL EFOUVR(NFGCRA,FICH(II1:II2),MED_REMP,IRET)
#endif
           ENDIF
          ENDIF
C
C
C
C          6.5- STOCKAGE-LECTURE DES FACTEURS DE FORME
C          -------------------------------------------
         IF (LSTOKF .OR. LECFDF) THEN
           FICH = ' '
           FICH = RSUITE
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTFFRA
           CALL VERLOS ( NAME, N1, N2, LPOS )
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
            II2 = II2 + LPOS  
           NFIC = NFFFRA
           IF (LECFDF) THEN
              OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *               STATUS='OLD',FORM='FORMATTED',
     *               ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
           ELSE
              OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *               STATUS='UNKNOWN',FORM='FORMATTED',
     *               ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
           ENDIF
           REWIND ( UNIT=NFIC,ERR=99 )
         ENDIF
C
C          6.6- STOCKAGE-LECTURE DES CORRESPONDANTS RAYONNEMENT
C          ----------------------------------------------------
         IF (LSTORA .OR. LLCORA) THEN
           FICH = ' '
           FICH = RSUITE
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTCORA
           CALL VERLOS ( NAME, N1, N2, LPOS )
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFCORA
           IF (LLCORA) THEN
              OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *               STATUS='OLD',FORM='FORMATTED',
     *               ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
           ELSE
              OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *               STATUS='UNKNOWN',FORM='FORMATTED',
     *               ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
           ENDIF
           REWIND ( UNIT=NFIC,ERR=99 )
         ENDIF
C
C
C          6.6- STOCKAGE-LECTURE DES CORRESPONDANTS RAYONNEMENT
C          ----------------------------------------------------
         IF (LSTORA .OR. LLCORA) THEN
           FICH = ' '
           FICH = RSUITE
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTCORA
           CALL VERLOS ( NAME, N1, N2, LPOS )
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFCORA
           IF (LLCORA) THEN
              OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *               STATUS='OLD',FORM='FORMATTED',
     *               ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
           ELSE
              OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *               STATUS='UNKNOWN',FORM='FORMATTED',
     *               ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
           ENDIF
           REWIND ( UNIT=NFIC,ERR=99 )
         ENDIF
C
C          6.7- HISTORIQUES RAYONNEMENT
C          ----------------------------
         IF (LHISOR) THEN
           FICH = ' '
           FICH = RAVAL 
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTHIRA
           CALL VERLOS ( NAME, N1, N2, LPOS )
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFHIRA
           OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *            STATUS='UNKNOWN',FORM='FORMATTED',
     *            ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
           REWIND ( UNIT=NFIC,ERR=99 )
         ENDIF
C
C     ================
C     7- FICHIERS MSTS
C     ================
C
C
      ELSEIF (CTYPE .EQ. 'FMSTS') THEN
C
C        7.1- Fichier de resultats
C        -------------------------
         FICH = ' '
         FICH = RAVAL 
         CALL VERLOS ( FICH, II1, II2, LPOS )
         NAME 	= ' '
         NAME = CTRMRA
         CALL VERLOS ( NAME, N1, N2, LPOS )
         FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
         II2 = II2 + LPOS  
         NFIC = NFRMRA
         OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *          STATUS='UNKNOWN',FORM='FORMATTED',
     *          ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
         REWIND ( UNIT=NFIC,ERR=99 )
C
C        7.2- Fichier suite
C        ------------------
         IF ( LSUISO ) THEN
           FICH = ' '
           FICH = RSUITE
           CALL VERLOS ( FICH, II1, II2, LPOS )
           NAME = ' '
           NAME = CTSMRA
           CALL VERLOS ( NAME, N1, N2, LPOS )
           FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
           II2 = II2 + LPOS  
           NFIC = NFSMRA
           OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *            STATUS='OLD',FORM='FORMATTED',
     *            ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
           REWIND ( UNIT=NFIC,ERR=99 )
         ENDIF
C
C        7.3- Fichier resu epaisseur msts
C        --------------------------------
         FICH = ' '
         FICH = RAVAL 
         CALL VERLOS ( FICH, II1, II2, LPOS )
         NAME 	= ' '
         NAME = CTEMRA
         CALL VERLOS ( NAME, N1, N2, LPOS )
         FICH ( II2+1:II2+LPOS ) = NAME ( N1:N2 )
         II2 = II2 + LPOS  
         NFIC = NFEMRA
         OPEN ( UNIT=NFIC, FILE=FICH (II1:II2),  
     *          STATUS='UNKNOWN',FORM='FORMATTED',
     *          ACCESS='SEQUENTIAL', IOSTAT=IOS, ERR=99 )
         REWIND ( UNIT=NFIC,ERR=99 )
C
      ENDIF
C
      RETURN
C
C    =====================
C    3- ERREUR D'OUVERTURE
C    =====================
C
#ifdef HAVE_C_IO
   98 CONTINUE
      CALL STREBF (MSGIOS, LEN(MSGIOS), IOS)
      WRITE ( NFECRA,9998 ) FICH (II1:II2), NFIC, MSGIOS
      STOP
#endif
   99 CONTINUE
      WRITE ( NFECRA,9999 ) FICH (II1:II2), NFIC, IOS
      STOP
C
C-------
C FORMAT
C-------
C
 1000 FORMAT( /,' %% ERREUR OPENCT : MOT CLE INCONNU :', 1X,A,/ )
 1200 FORMAT(/,' %% ERREUR OPENCT : LE TYPE DE FICHIER DU MAILLAGE',
     &       ' SOLIDE EST INCONNU',/,
     &        20X, 'Les types reconnus sont :',/,
     &        23X, '- Fichier SIMAIL   : suffixe ".des"',/,
     &        23X, '- Fichier IDEAS    : suffixe ".unv"',/,
     &        23X, '- Fichier SYRTHES  : suffixe ".syr"',/,
     &        23X, '- Fichier MED      : suffixe ".med"')
 1210 FORMAT(/,' %% ERREUR OPENCT : LE TYPE DE FICHIER DU MAILLAGE',
     &       ' POUR LE RAYONNEMENT EST INCONNU',/,
     &        20X, 'Les types reconnus sont :',/,
     &        23X, '- Fichier SIMAIL   : suffixe ".des"',/,
     &        23X, '- Fichier IDEAS    : suffixe ".unv"',/,
     &        23X, '- Fichier SYRTHES  : suffixe ".syr"',/,
     &        23X, '- Fichier MED      : suffixe ".med"')
 2000 FORMAT(I5)
#ifdef HAVE_C_IO
 9998 FORMAT ( /,1X,'%% ERREUR D''OUVERTURE SUR LE FICHIER :',1X,A,/,
     * 4X,'DE NUMERO D''UNITE LOGIQUE :',1X,I2,/
     * 4X,'AVEC L''ERREUR SUIVANTE    :',1X,A )
#endif
 9999 FORMAT ( /,1X,'%% ERREUR D''OUVERTURE SUR LE FICHIER :',1X,A,/,
     * 4X,'DE NUMERO D''UNITE LOGIQUE :',1X,I2,/
     * 4X,'AVEC UN IOSTAT EGAL A     :',1X,I6 )
C
C----
C FIN
C----
C
      END
