use Test;
use Data::Dumper;
use Carp;
use strict;
use vars qw($config);

BEGIN {
    
    # Set up 20 tests to run
    
    plan tests => 10;
    
    # Here is a trick to make it look like this was called with those args
    # on the command line before SCConfig runs.

    @ARGV = qw(--norunboot --cfgfile t/cfg/boot.cfg);
}

eval {
    use SCConfig;
    return 1;
};

ok($@,'') or croak("No point in going any further");

eval {
    use Boot;
    return 1;
};

ok($@,'') or croak("No point in going any further");

# We loaded the file... now lets setup a fake directory to use

my $root = $config->root();

if(!$root) {
    croak("Running this not chroot is way too dangerous");
}


!system("mkdir -p $root/boot/grub") or croak("Cannot create $root/boot/grub");
!system("mkdir -p $root/etc") or croak("Cannot create $root/etc");
!system("cp t/boot/device.map $root/boot/grub/") or croak("Cannot write into $root/boot/grub");
!system("cp t/boot/fstab $root/etc/fstab") or croak("Cannot write into $root/etc");
!system("mkdir -p $root/proc") or croak("Cannot create $root/proc");
!system("cp t/boot/partitions $root/proc/partitions") or croak("Cannot write into $root/proc");
!system("mkdir -p $root/usr/sbin") or croak("Couldn't build $root/usr/sbin for testing");  

open(OUT,">$root/usr/sbin/grub");
print OUT "test\n";
close(OUT);
chmod 0755, "$root/usr/sbin/grub";

open(OUT,">$root/usr/sbin/e2label");
print OUT "fake e2label\n";
close(OUT);
chmod 0755, "$root/usr/sbin/e2label";

open(OUT, ">$root/boot/vmlinuz");
print OUT "test\n";
close(OUT);
chmod 0644, "$root/boot/vmlinuz";

open(OUT, ">$root/boot/initrd-2.4.2-2.img");
print OUT "test\n";
close(OUT);
chmod 0644, "$root/boot/initrd-2.4.2-2.img";

{
    # This takes care of running which in the chroot land
    local %ENV = %ENV;
    $ENV{PATH} = '/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin:/usr/local/sbin:' . $ENV{PATH};
    $ENV{PATH} = join ':', (map {"$root$_"} split(/:/,$ENV{PATH}));
    Boot::install_config($config);
}
	
open(IN,"<$root/boot/grub/menu.lst") or croak("Can't open $root/boot/grub/menu.lst");
	
local($/) = undef;   
my $grubconf = <IN>;    
ok($grubconf,'/timeout 5/');
ok($grubconf,'/default 0/');    
ok($grubconf,'/title linux-multi/');
ok($grubconf,'/kernel \(hd0,0\)/vmlinuz root=/dev/sda5 ro/');
ok($grubconf,'/initrd \(hd0,0\)/initrd-2.4.2-2.img/');
ok($grubconf,'/title linux-single/');
ok($grubconf,'/kernel \(hd0,0\)/vmlinuz root=/dev/sda5 ro single/');
ok($grubconf,'/initrd \(hd0,0\)/initrd-2.4.2-2.img/');

close(IN);

system("rm -rf $root");















































