/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.plaf.basic;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.UIResource;
import sun.awt.AppContext;

public class TransferHandler
implements Serializable {
    public static final int NONE = 0;
    public static final int COPY = 1;
    public static final int MOVE = 2;
    public static final int COPY_OR_MOVE = 3;
    private String propertyName;
    private static SwingDragGestureRecognizer recognizer = null;
    private static DropTargetListener dropLinkage = null;
    static final Action cutAction = new TransferAction("cut");
    static final Action copyAction = new TransferAction("copy");
    static final Action pasteAction = new TransferAction("paste");

    public static Action getCutAction() {
        return cutAction;
    }

    public static Action getCopyAction() {
        return copyAction;
    }

    public static Action getPasteAction() {
        return pasteAction;
    }

    public TransferHandler(String string) {
        this.propertyName = string;
    }

    protected TransferHandler() {
        this(null);
    }

    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        int n2 = this.getSourceActions(jComponent);
        int n3 = n2 & n;
        if (!(inputEvent instanceof MouseEvent)) {
            n3 = 0;
        }
        if (n3 != 0) {
            if (recognizer == null) {
                recognizer = new SwingDragGestureRecognizer(new DragHandler());
            }
            recognizer.gestured(jComponent, (MouseEvent)inputEvent, n2, n3);
        } else {
            this.exportDone(jComponent, null, 0);
        }
    }

    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
        boolean bl = false;
        Transferable transferable = null;
        int n2 = this.getSourceActions(jComponent) & n;
        if (n2 != 0 && (transferable = this.createTransferable(jComponent)) != null) {
            clipboard.setContents(transferable, null);
            bl = true;
        }
        if (bl) {
            this.exportDone(jComponent, transferable, n2);
        } else {
            this.exportDone(jComponent, null, 0);
        }
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        if (propertyDescriptor != null) {
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null) {
                return false;
            }
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1) {
                return false;
            }
            DataFlavor dataFlavor = this.getPropertyDataFlavor(classArray[0], transferable.getTransferDataFlavors());
            if (dataFlavor != null) {
                try {
                    Object object = transferable.getTransferData(dataFlavor);
                    Object[] objectArray = new Object[]{object};
                    method.invoke((Object)jComponent, objectArray);
                    return true;
                }
                catch (Exception exception) {
                    System.err.println("Invocation failed");
                }
            }
        }
        return false;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        if (propertyDescriptor != null) {
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null) {
                return false;
            }
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1) {
                return false;
            }
            DataFlavor dataFlavor = this.getPropertyDataFlavor(classArray[0], dataFlavorArray);
            if (dataFlavor != null) {
                return true;
            }
        }
        return false;
    }

    public int getSourceActions(JComponent jComponent) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        if (propertyDescriptor != null) {
            return 1;
        }
        return 0;
    }

    public Icon getVisualRepresentation(Transferable transferable) {
        return null;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        if (propertyDescriptor != null) {
            return new PropertyTransferable(propertyDescriptor, jComponent);
        }
        return null;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
    }

    private PropertyDescriptor getPropertyDescriptor(JComponent jComponent) {
        BeanInfo beanInfo;
        if (this.propertyName == null) {
            return null;
        }
        Class<?> clazz = jComponent.getClass();
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            Class<?>[] classArray;
            Method method;
            if (this.propertyName.equals(propertyDescriptorArray[n].getName()) && (method = propertyDescriptorArray[n].getReadMethod()) != null && ((classArray = method.getParameterTypes()) == null || classArray.length == 0)) {
                return propertyDescriptorArray[n];
            }
            ++n;
        }
        return null;
    }

    private DataFlavor getPropertyDataFlavor(Class clazz, DataFlavor[] dataFlavorArray) {
        int n = 0;
        while (n < dataFlavorArray.length) {
            DataFlavor dataFlavor = dataFlavorArray[n];
            if ("application".equals(dataFlavor.getPrimaryType()) && "x-java-jvm-local-objectref".equals(dataFlavor.getSubType()) && clazz.isAssignableFrom(dataFlavor.getRepresentationClass())) {
                return dataFlavor;
            }
            ++n;
        }
        return null;
    }

    private static DropTargetListener getDropTargetListener() {
        if (dropLinkage == null) {
            dropLinkage = new DropHandler();
        }
        return dropLinkage;
    }

    static class TransferAction
    extends AbstractAction
    implements UIResource {
        private boolean canAccessSystemClipboard = true;
        private static Object SandboxClipboardKey = new Object();

        TransferAction(String string) {
            super(string);
            this.canAccessSystemClipboard();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JDNDAdapter) {
                JDNDAdapter jDNDAdapter = (JDNDAdapter)object;
                TransferHandler transferHandler = jDNDAdapter.getTransferHandler();
                Clipboard clipboard = this.getClipboard((JComponent)((Object)jDNDAdapter));
                String string = (String)this.getValue("Name");
                if (clipboard != null && transferHandler != null && string != null) {
                    Transferable transferable;
                    if ("cut".equals(string)) {
                        transferHandler.exportToClipboard((JComponent)((Object)jDNDAdapter), clipboard, 2);
                    } else if ("copy".equals(string)) {
                        transferHandler.exportToClipboard((JComponent)((Object)jDNDAdapter), clipboard, 1);
                    } else if ("paste".equals(string) && (transferable = clipboard.getContents(null)) != null) {
                        transferHandler.importData((JComponent)((Object)jDNDAdapter), transferable);
                    }
                }
            }
        }

        private Clipboard getClipboard(JComponent jComponent) {
            if (this.canAccessSystemClipboard()) {
                return jComponent.getToolkit().getSystemClipboard();
            }
            Clipboard clipboard = (Clipboard)AppContext.getAppContext().get(SandboxClipboardKey);
            if (clipboard == null) {
                clipboard = new Clipboard("Sandboxed Component Clipboard");
                AppContext.getAppContext().put(SandboxClipboardKey, clipboard);
            }
            return clipboard;
        }

        private boolean canAccessSystemClipboard() {
            if (this.canAccessSystemClipboard) {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    try {
                        securityManager.checkSystemClipboardAccess();
                        return true;
                    }
                    catch (SecurityException securityException) {
                        this.canAccessSystemClipboard = false;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    }

    private static class SwingDragGestureRecognizer
    extends DragGestureRecognizer {
        SwingDragGestureRecognizer(DragGestureListener dragGestureListener) {
            super(DragSource.getDefaultDragSource(), null, 0, dragGestureListener);
        }

        void gestured(JComponent jComponent, MouseEvent mouseEvent, int n, int n2) {
            this.setComponent(jComponent);
            this.setSourceActions(n);
            this.appendEvent(mouseEvent);
            this.fireDragGestureRecognized(n2, mouseEvent.getPoint());
        }

        protected void registerListeners() {
        }

        protected void unregisterListeners() {
        }
    }

    private static class DragHandler
    implements DragGestureListener,
    DragSourceListener {
        private boolean scrolls;

        private DragHandler() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            JDNDAdapter jDNDAdapter = (JDNDAdapter)((Object)dragGestureEvent.getComponent());
            TransferHandler transferHandler = jDNDAdapter.getTransferHandler();
            Transferable transferable = transferHandler.createTransferable((JComponent)((Object)jDNDAdapter));
            if (transferable != null) {
                this.scrolls = ((JComponent)((Object)jDNDAdapter)).getAutoscrolls();
                ((JComponent)((Object)jDNDAdapter)).setAutoscrolls(false);
                try {
                    dragGestureEvent.startDrag(null, transferable, this);
                    return;
                }
                catch (RuntimeException runtimeException) {
                    ((JComponent)((Object)jDNDAdapter)).setAutoscrolls(this.scrolls);
                }
            }
            transferHandler.exportDone((JComponent)((Object)jDNDAdapter), null, 0);
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            DragSourceContext dragSourceContext = dragSourceDropEvent.getDragSourceContext();
            JDNDAdapter jDNDAdapter = (JDNDAdapter)((Object)dragSourceContext.getComponent());
            if (dragSourceDropEvent.getDropSuccess()) {
                jDNDAdapter.getTransferHandler().exportDone((JComponent)((Object)jDNDAdapter), dragSourceContext.getTransferable(), dragSourceDropEvent.getDropAction());
            } else {
                jDNDAdapter.getTransferHandler().exportDone((JComponent)((Object)jDNDAdapter), null, 0);
            }
            ((JComponent)((Object)jDNDAdapter)).setAutoscrolls(this.scrolls);
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }

    private static class DropHandler
    implements DropTargetListener,
    Serializable {
        private boolean canImport;

        private DropHandler() {
        }

        private boolean actionSupported(int n) {
            return (n & 3) != 0;
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
            JDNDAdapter jDNDAdapter = (JDNDAdapter)((Object)dropTargetDragEvent.getDropTargetContext().getComponent());
            TransferHandler transferHandler = jDNDAdapter.getTransferHandler();
            this.canImport = transferHandler != null && transferHandler.canImport((JComponent)((Object)jDNDAdapter), dataFlavorArray);
            int n = dropTargetDragEvent.getDropAction();
            if (this.canImport && this.actionSupported(n)) {
                dropTargetDragEvent.acceptDrag(n);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            int n = dropTargetDragEvent.getDropAction();
            if (this.canImport && this.actionSupported(n)) {
                dropTargetDragEvent.acceptDrag(n);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            int n = dropTargetDropEvent.getDropAction();
            JDNDAdapter jDNDAdapter = (JDNDAdapter)((Object)dropTargetDropEvent.getDropTargetContext().getComponent());
            TransferHandler transferHandler = jDNDAdapter.getTransferHandler();
            if (this.canImport && transferHandler != null && this.actionSupported(n)) {
                dropTargetDropEvent.acceptDrop(n);
                try {
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    dropTargetDropEvent.dropComplete(transferHandler.importData((JComponent)((Object)jDNDAdapter), transferable));
                }
                catch (RuntimeException runtimeException) {
                    dropTargetDropEvent.dropComplete(false);
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            int n = dropTargetDragEvent.getDropAction();
            if (this.canImport && this.actionSupported(n)) {
                dropTargetDragEvent.acceptDrag(n);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }
    }

    public static class SwingDropTarget
    extends DropTarget
    implements UIResource {
        private EventListenerList listenerList;
        static /* synthetic */ Class class$java$awt$dnd$DropTargetListener;

        public SwingDropTarget(JComponent jComponent) {
            this.setComponent(jComponent);
            try {
                super.addDropTargetListener(TransferHandler.getDropTargetListener());
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }

        public void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(class$java$awt$dnd$DropTargetListener == null ? (class$java$awt$dnd$DropTargetListener = SwingDropTarget.class$("java.awt.dnd.DropTargetListener")) : class$java$awt$dnd$DropTargetListener, dropTargetListener);
        }

        public void removeDropTargetListener(DropTargetListener dropTargetListener) {
            if (this.listenerList != null) {
                this.listenerList.remove(class$java$awt$dnd$DropTargetListener == null ? (class$java$awt$dnd$DropTargetListener = SwingDropTarget.class$("java.awt.dnd.DropTargetListener")) : class$java$awt$dnd$DropTargetListener, dropTargetListener);
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            super.dragEnter(dropTargetDragEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                int n = objectArray.length - 2;
                while (n >= 0) {
                    if (objectArray[n] == (class$java$awt$dnd$DropTargetListener == null ? SwingDropTarget.class$("java.awt.dnd.DropTargetListener") : class$java$awt$dnd$DropTargetListener)) {
                        ((DropTargetListener)objectArray[n + 1]).dragEnter(dropTargetDragEvent);
                    }
                    n -= 2;
                }
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            super.dragOver(dropTargetDragEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                int n = objectArray.length - 2;
                while (n >= 0) {
                    if (objectArray[n] == (class$java$awt$dnd$DropTargetListener == null ? SwingDropTarget.class$("java.awt.dnd.DropTargetListener") : class$java$awt$dnd$DropTargetListener)) {
                        ((DropTargetListener)objectArray[n + 1]).dragOver(dropTargetDragEvent);
                    }
                    n -= 2;
                }
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            super.dragExit(dropTargetEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                int n = objectArray.length - 2;
                while (n >= 0) {
                    if (objectArray[n] == (class$java$awt$dnd$DropTargetListener == null ? SwingDropTarget.class$("java.awt.dnd.DropTargetListener") : class$java$awt$dnd$DropTargetListener)) {
                        ((DropTargetListener)objectArray[n + 1]).dragExit(dropTargetEvent);
                    }
                    n -= 2;
                }
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            super.drop(dropTargetDropEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                int n = objectArray.length - 2;
                while (n >= 0) {
                    if (objectArray[n] == (class$java$awt$dnd$DropTargetListener == null ? SwingDropTarget.class$("java.awt.dnd.DropTargetListener") : class$java$awt$dnd$DropTargetListener)) {
                        ((DropTargetListener)objectArray[n + 1]).drop(dropTargetDropEvent);
                    }
                    n -= 2;
                }
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            super.dropActionChanged(dropTargetDragEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                int n = objectArray.length - 2;
                while (n >= 0) {
                    if (objectArray[n] == (class$java$awt$dnd$DropTargetListener == null ? SwingDropTarget.class$("java.awt.dnd.DropTargetListener") : class$java$awt$dnd$DropTargetListener)) {
                        ((DropTargetListener)objectArray[n + 1]).dropActionChanged(dropTargetDragEvent);
                    }
                    n -= 2;
                }
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static class PropertyTransferable
    implements Transferable {
        JComponent component;
        PropertyDescriptor property;

        PropertyTransferable(PropertyDescriptor propertyDescriptor, JComponent jComponent) {
            this.property = propertyDescriptor;
            this.component = jComponent;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[1];
            Class<?> clazz = this.property.getPropertyType();
            String string = "application/x-java-jvm-local-objectref;class=" + clazz.getName();
            try {
                dataFlavorArray[0] = new DataFlavor(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                dataFlavorArray = new DataFlavor[]{};
            }
            return dataFlavorArray;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            Class<?> clazz = this.property.getPropertyType();
            return "application".equals(dataFlavor.getPrimaryType()) && "x-java-jvm-local-objectref".equals(dataFlavor.getSubType()) && dataFlavor.getRepresentationClass().isAssignableFrom(clazz);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            Method method = this.property.getReadMethod();
            Object object = null;
            try {
                object = method.invoke((Object)this.component, null);
            }
            catch (Exception exception) {
                throw new IOException("Property read failed: " + this.property.getName());
            }
            return object;
        }
    }

    public static class JAdapterComponent
    extends JComponent
    implements JDNDAdapter {
        protected TransferHandler transfer = null;

        public void setTransferHandler(TransferHandler transferHandler) {
            TransferHandler transferHandler2 = this.transfer;
            this.transfer = transferHandler;
            DropTarget dropTarget = this.getDropTarget();
            if (dropTarget == null || dropTarget instanceof UIResource) {
                if (transferHandler == null) {
                    this.setDropTarget(null);
                } else {
                    this.setDropTarget(new SwingDropTarget(this));
                }
            }
            this.firePropertyChange("transferHandler", transferHandler2, this.transfer);
        }

        public TransferHandler getTransferHandler() {
            return this.transfer;
        }
    }

    public static interface JDNDAdapter {
        public TransferHandler getTransferHandler();
    }
}

