/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.dynatype;

import java.io.PrintStream;
import java.math.BigInteger;
import org.jatha.Jatha;
import org.jatha.dynatype.LispInteger;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.StandardLispNumber;

public class StandardLispInteger
extends StandardLispNumber
implements LispInteger {
    private long f_value;

    public StandardLispInteger() {
    }

    public StandardLispInteger(Jatha lisp, long theValue) {
        super(lisp);
        this.f_value = theValue;
    }

    public StandardLispInteger(Jatha lisp) {
        super(lisp);
        this.f_value = 0L;
    }

    public long getValue() {
        return this.f_value;
    }

    public double getDoubleValue() {
        return this.f_value;
    }

    public BigInteger getBigIntegerValue() {
        return BigInteger.valueOf(this.f_value);
    }

    public long getLongValue() {
        return this.f_value;
    }

    public void internal_princ(PrintStream os) {
        os.print(this.f_value);
    }

    public void internal_prin1(PrintStream os) {
        os.print(this.f_value);
    }

    public void internal_print(PrintStream os) {
        os.print(this.f_value);
    }

    public boolean basic_integerp() {
        return true;
    }

    public Object toJava() {
        return new Long(this.f_value);
    }

    public Object toJava(String typeHint) {
        if (typeHint == null) {
            return this.toJava();
        }
        if (typeHint.equalsIgnoreCase("Double")) {
            return new Double(this.getDoubleValue());
        }
        if (typeHint.equalsIgnoreCase("Float")) {
            return new Float(this.f_value);
        }
        if (typeHint.equalsIgnoreCase("Integer")) {
            return new Integer((int)this.f_value);
        }
        return this.toJava();
    }

    public String toString() {
        return String.valueOf(this.f_value);
    }

    public LispValue abs() {
        if (this.getLongValue() > 0L) {
            return this;
        }
        return new StandardLispInteger(this.f_lisp, this.getLongValue() * -1L);
    }

    public LispValue eql(LispValue val) {
        if (val instanceof LispInteger) {
            if (this.f_value == ((LispInteger)val).getLongValue()) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        return super.eql(val);
    }

    public LispValue equal(LispValue val) {
        return this.eql(val);
    }

    public LispValue integerp() {
        return this.f_lisp.T;
    }

    public LispValue type_of() {
        return this.f_lisp.INTEGER_TYPE;
    }

    public LispValue typep(LispValue type) {
        LispValue result = super.typep(type);
        if (result == this.f_lisp.T || type == this.f_lisp.INTEGER_TYPE) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }

    public LispValue zerop() {
        if (this.f_value == 0L) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }
}

