/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.PerfExplorerConnection;
import client.PerfExplorerTreeCellRenderer;
import client.PerfExplorerTreeExpansionListener;
import client.PerfExplorerTreeNode;
import client.PerfExplorerTreeSelectionListener;
import common.RMIView;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.IntervalEvent;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class PerfExplorerJTree
extends JTree {
    private static PerfExplorerJTree theTree = null;
    private static List leafViews = null;

    private PerfExplorerJTree(DefaultTreeModel defaultTreeModel) {
        super(defaultTreeModel);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setShowsRootHandles(true);
        PerfExplorerTreeCellRenderer perfExplorerTreeCellRenderer = new PerfExplorerTreeCellRenderer();
        this.setCellRenderer(perfExplorerTreeCellRenderer);
        this.addTreeSelectionListener(new PerfExplorerTreeSelectionListener(this));
        this.addTreeWillExpandListener(new PerfExplorerTreeExpansionListener(this));
    }

    public static PerfExplorerJTree getTree() {
        if (theTree == null) {
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(PerfExplorerJTree.createNodes());
            defaultTreeModel.setAsksAllowsChildren(true);
            theTree = new PerfExplorerJTree(defaultTreeModel);
            PerfExplorerJTree.addTrialsForViews();
        }
        return theTree;
    }

    private static DefaultMutableTreeNode createNodes() {
        PerfExplorerTreeNode perfExplorerTreeNode = new PerfExplorerTreeNode("Performance Data");
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        PerfExplorerTreeNode perfExplorerTreeNode2 = new PerfExplorerTreeNode(perfExplorerConnection.getConnectionString());
        PerfExplorerTreeNode perfExplorerTreeNode3 = new PerfExplorerTreeNode("Views");
        leafViews = new ArrayList();
        perfExplorerTreeNode.add(perfExplorerTreeNode2);
        perfExplorerTreeNode.add(perfExplorerTreeNode3);
        return perfExplorerTreeNode;
    }

    public static void addViewNodes(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        List list = perfExplorerConnection.getViews(Integer.parseInt(string));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RMIView rMIView = (RMIView)iterator.next();
            PerfExplorerTreeNode perfExplorerTreeNode = new PerfExplorerTreeNode(rMIView);
            PerfExplorerJTree.addViewNodes(perfExplorerTreeNode, rMIView.getField("ID"));
            defaultMutableTreeNode.add(perfExplorerTreeNode);
        }
        if (list.size() == 0) {
            leafViews.add(defaultMutableTreeNode);
            PerfExplorerJTree.addTrialsForView(defaultMutableTreeNode);
        }
    }

    public static void addApplicationNodes(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        ListIterator listIterator;
        PerfExplorerTreeNode perfExplorerTreeNode = null;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        if (perfExplorerConnection != null && (listIterator = perfExplorerConnection.getApplicationList()) != null) {
            Application application = null;
            while (listIterator.hasNext()) {
                application = (Application)listIterator.next();
                perfExplorerTreeNode = new PerfExplorerTreeNode(application);
                defaultMutableTreeNode.add(perfExplorerTreeNode);
            }
        }
    }

    public static void addExperimentNodes(DefaultMutableTreeNode defaultMutableTreeNode, Application application, boolean bl) {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        ListIterator listIterator = perfExplorerConnection.getExperimentList(application.getID());
        Experiment experiment = null;
        PerfExplorerTreeNode perfExplorerTreeNode = null;
        while (listIterator.hasNext()) {
            experiment = (Experiment)listIterator.next();
            perfExplorerTreeNode = new PerfExplorerTreeNode(experiment);
            defaultMutableTreeNode.add(perfExplorerTreeNode);
        }
    }

    public static void addTrialNodes(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment) {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        ListIterator listIterator = perfExplorerConnection.getTrialList(experiment.getID());
        Trial trial = null;
        PerfExplorerTreeNode perfExplorerTreeNode = null;
        while (listIterator.hasNext()) {
            trial = (Trial)listIterator.next();
            perfExplorerTreeNode = new PerfExplorerTreeNode(trial);
            defaultMutableTreeNode.add(perfExplorerTreeNode);
        }
    }

    public static void addTrialsForViews() {
        Iterator iterator = leafViews.iterator();
        while (iterator.hasNext()) {
            PerfExplorerTreeNode perfExplorerTreeNode = (PerfExplorerTreeNode)iterator.next();
            PerfExplorerJTree.addTrialsForView(perfExplorerTreeNode);
        }
    }

    public static void addTrialsForView(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object[] objectArray = defaultMutableTreeNode.getUserObjectPath();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof RMIView)) continue;
            arrayList.add(objectArray[i]);
        }
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        if (arrayList.size() > 0) {
            ListIterator listIterator = perfExplorerConnection.getTrialsForView(arrayList);
            Trial trial = null;
            PerfExplorerTreeNode perfExplorerTreeNode = null;
            while (listIterator.hasNext()) {
                trial = (Trial)listIterator.next();
                perfExplorerTreeNode = new PerfExplorerTreeNode(trial);
                defaultMutableTreeNode.add(perfExplorerTreeNode);
            }
        }
    }

    public static void addMetricNodes(DefaultMutableTreeNode defaultMutableTreeNode, Trial trial) {
        Vector vector = trial.getMetrics();
        boolean bl = false;
        if (vector != null) {
            ListIterator listIterator = vector.listIterator();
            Metric metric = null;
            PerfExplorerTreeNode perfExplorerTreeNode = null;
            while (listIterator.hasNext()) {
                metric = (Metric)listIterator.next();
                perfExplorerTreeNode = new PerfExplorerTreeNode(metric, true);
                defaultMutableTreeNode.add(perfExplorerTreeNode);
            }
        }
    }

    public static void addEventNodes(DefaultMutableTreeNode defaultMutableTreeNode, Trial trial, int n) {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        ListIterator listIterator = perfExplorerConnection.getEventList(trial.getID(), n);
        IntervalEvent intervalEvent = null;
        PerfExplorerTreeNode perfExplorerTreeNode = null;
        while (listIterator.hasNext()) {
            intervalEvent = (IntervalEvent)listIterator.next();
            perfExplorerTreeNode = new PerfExplorerTreeNode(intervalEvent, false);
            defaultMutableTreeNode.add(perfExplorerTreeNode);
        }
    }
}

