/*
 * Decompiled with CFR 0.152.
 */
package server;

import clustering.AnalysisFactory;
import clustering.ClusterException;
import clustering.KMeansClusterInterface;
import clustering.RawDataInterface;
import clustering.weka.WekaAnalysisFactory;
import common.PerfExplorerException;
import common.RMIPerfExplorerModel;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.database.DB;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.TimerTask;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DefaultXYItemRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.function.Function2D;
import org.jfree.data.function.LineFunction2D;
import org.jfree.data.function.PowerFunction2D;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.statistics.Regression;
import org.jfree.data.xy.XYDataset;
import server.DendrogramTree;
import server.PCAPlotDataset;
import server.PerfExplorerServer;
import server.ScatterPlotDataset;
import server.Thumbnail;
import server.VirtualTopology;

public class AnalysisTaskWrapper
extends TimerTask {
    public static final int RPROJECT_ENGINE = 0;
    public static final int WEKA_ENGINE = 1;
    public static final int OCTAVE_ENGINE = 2;
    public static final int DENDROGRAM = 0;
    public static final int HISTOGRAM = 1;
    public static final int VIRTUAL_TOPOLOGY = 2;
    public static final int CLUSTER_AVERAGES = 3;
    public static final int CLUSTER_MAXIMUMS = 4;
    public static final int CLUSTER_MINIMUMS = 5;
    public static final int PCA_SCATTERPLOT = 6;
    public static final int CORRELATION_SCATTERPLOT = 7;
    private int chartType = 0;
    private AnalysisFactory factory = null;
    private RMIPerfExplorerModel modelData = null;
    private PerfExplorerServer server = null;
    private int analysisID = 0;
    private int numRows = 0;
    private int numCenterRows = 0;
    private int numTotalThreads = 0;
    private int numEvents = 0;
    private int nodes = 0;
    private int contexts = 0;
    private int threads = 0;
    private RawDataInterface rawData = null;
    private double maximum = 0.0;
    private List eventIDs = null;
    private double rCorrelation = 0.0;
    private boolean correlateToMain = false;

    public AnalysisTaskWrapper(PerfExplorerServer perfExplorerServer, int n) {
        this.server = perfExplorerServer;
        switch (n) {
            case 1: {
                this.factory = WekaAnalysisFactory.getFactory();
                break;
            }
            default: {
                System.out.println("Undefined analysis engine type.");
                System.exit(1);
            }
        }
    }

    public void saveAnalysisResult(String string, String string2, String string3, boolean bl) throws PerfExplorerException {
        Thumbnail.createThumbnail(string2, string3, bl);
        try {
            PerfExplorerServer.getServer().getControl().WAIT("saveAnalysisResult");
            DB dB = PerfExplorerServer.getServer().getDB();
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("insert into analysis_result (analysis_settings, description, thumbnail_size, image_size, thumbnail, image, result_type) values (?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setInt(1, this.analysisID);
            preparedStatement.setString(2, string2);
            File file = new File(string2);
            FileInputStream fileInputStream = new FileInputStream(file);
            File file2 = new File(string3);
            FileInputStream fileInputStream2 = new FileInputStream(file2);
            preparedStatement.setInt(3, (int)file2.length());
            preparedStatement.setInt(4, (int)file.length());
            preparedStatement.setBinaryStream(5, (InputStream)fileInputStream2, (int)file2.length());
            preparedStatement.setBinaryStream(6, (InputStream)fileInputStream, (int)file.length());
            preparedStatement.setInt(7, this.chartType);
            preparedStatement.executeUpdate();
            fileInputStream.close();
            preparedStatement.close();
            file.delete();
            file2.delete();
            PerfExplorerServer.getServer().getControl().SIGNAL("saveAnalysisResult");
        }
        catch (Exception exception) {
            String string4 = "ERROR: Couldn't insert the analysis results into the database!";
            System.out.println(string4);
            exception.printStackTrace();
            PerfExplorerServer.getServer().getControl().SIGNAL("saveAnalysisResult");
            throw new PerfExplorerException(string4, exception);
        }
    }

    public void saveAnalysisResult(RawDataInterface rawDataInterface, RawDataInterface rawDataInterface2, File file, File file2) throws PerfExplorerException {
        try {
            PerfExplorerServer.getServer().getControl().WAIT("saveAnalysisResult");
            DB dB = PerfExplorerServer.getServer().getDB();
            dB.setAutoCommit(false);
            PreparedStatement preparedStatement = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("insert into analysis_result ");
            stringBuffer.append(" (analysis_settings, description, thumbnail_size, thumbnail, image_size, image, result_type) values (?, ?, ?, ?, ?, ?, ?)");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.analysisID);
            preparedStatement.setString(2, new String("analysis_result"));
            FileInputStream fileInputStream = new FileInputStream(file);
            preparedStatement.setInt(3, (int)file2.length());
            preparedStatement.setBinaryStream(4, (InputStream)fileInputStream, (int)file.length());
            FileInputStream fileInputStream2 = new FileInputStream(file2);
            preparedStatement.setInt(5, (int)file2.length());
            preparedStatement.setBinaryStream(6, (InputStream)fileInputStream2, (int)file2.length());
            preparedStatement.setInt(7, this.chartType);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement.close();
            dB.commit();
            PerfExplorerServer.getServer().getControl().SIGNAL("saveAnalysisResult");
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't insert the analysis results into the database!";
            System.out.println(string);
            exception.printStackTrace();
            PerfExplorerServer.getServer().getControl().SIGNAL("saveAnalysisResult");
            throw new PerfExplorerException(string, exception);
        }
    }

    private void getConstants() throws PerfExplorerException {
        System.out.print("Getting constants...");
        try {
            ResultSet resultSet;
            DB dB = PerfExplorerServer.getServer().getDB();
            PreparedStatement preparedStatement = null;
            StringBuffer stringBuffer = new StringBuffer();
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append("select count(p.excl) ");
            } else {
                stringBuffer.append("select count(p.exclusive) ");
            }
            stringBuffer.append("from interval_event e ");
            stringBuffer.append("left outer join interval_location_profile p ");
            stringBuffer.append("on e.id = p.interval_event ");
            if (this.modelData.getDimensionReduction().equals("Over X Percent")) {
                stringBuffer.append("inner join interval_mean_summary s ");
                stringBuffer.append("on e.id = s.interval_event and s.metric = p.metric ");
                stringBuffer.append("and s.exclusive_percentage > ");
                stringBuffer.append("" + this.modelData.getXPercent() + "");
            }
            stringBuffer.append(" where e.trial = ?");
            stringBuffer.append(" and e.group_name not like '%TAU_CALLPATH%' ");
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                stringBuffer.append(" and p.metric = ?");
            }
            PerfExplorerServer.getServer().getControl().WAIT("getConstants");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.modelData.getTrial().getID());
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(2, ((Metric)this.modelData.getCurrentSelection()).getID());
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                this.numRows = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
            PerfExplorerServer.getServer().getControl().SIGNAL("getConstants");
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("select e.id, e.name from interval_event e ");
                if (this.modelData.getDimensionReduction().equals("Over X Percent")) {
                    stringBuffer.append("inner join interval_mean_summary s on ");
                    stringBuffer.append("e.id = s.interval_event ");
                    stringBuffer.append("and s.exclusive_percentage > ");
                    stringBuffer.append("" + this.modelData.getXPercent() + "");
                    stringBuffer.append(" where e.trial = ? ");
                    if (this.modelData.getCurrentSelection() instanceof Metric) {
                        stringBuffer.append(" and s.metric = ? ");
                    }
                } else {
                    stringBuffer.append("where e.trial = ?");
                }
                stringBuffer.append(" and e.group_name not like '%TAU_CALLPATH%' ");
                stringBuffer.append(" order by 1");
                PerfExplorerServer.getServer().getControl().WAIT("getConstants");
                preparedStatement = dB.prepareStatement(stringBuffer.toString());
                preparedStatement.setInt(1, this.modelData.getTrial().getID());
                if (this.modelData.getDimensionReduction().equals("Over X Percent") && this.modelData.getCurrentSelection() instanceof Metric) {
                    preparedStatement.setInt(2, ((Metric)this.modelData.getCurrentSelection()).getID());
                }
                resultSet = preparedStatement.executeQuery();
                this.numEvents = 0;
                this.eventIDs = new ArrayList();
                while (resultSet.next()) {
                    ++this.numEvents;
                    this.eventIDs.add(resultSet.getString(2));
                }
                resultSet.close();
                preparedStatement.close();
                PerfExplorerServer.getServer().getControl().SIGNAL("getConstants");
            } else {
                stringBuffer = new StringBuffer();
                stringBuffer.append("select m.id, m.name from metric m ");
                stringBuffer.append("where m.trial = ?");
                stringBuffer.append(" order by 1");
                PerfExplorerServer.getServer().getControl().WAIT("getConstants");
                preparedStatement = dB.prepareStatement(stringBuffer.toString());
                preparedStatement.setInt(1, this.modelData.getTrial().getID());
                resultSet = preparedStatement.executeQuery();
                this.numEvents = 0;
                this.eventIDs = new ArrayList();
                while (resultSet.next()) {
                    ++this.numEvents;
                    this.eventIDs.add(resultSet.getString(2));
                }
                resultSet.close();
                preparedStatement.close();
                PerfExplorerServer.getServer().getControl().SIGNAL("getConstants");
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append("select max(node), max(context), max(thread) ");
            stringBuffer.append("from interval_location_profile ");
            stringBuffer.append("inner join interval_event ");
            stringBuffer.append("on id = interval_event where trial = ? ");
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                stringBuffer.append(" and metric = ? ");
            }
            PerfExplorerServer.getServer().getControl().WAIT("getConstants");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.modelData.getTrial().getID());
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(2, ((Metric)this.modelData.getCurrentSelection()).getID());
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                this.nodes = resultSet.getInt(1) + 1;
                this.contexts = resultSet.getInt(2) + 1;
                this.threads = resultSet.getInt(3) + 1;
                this.numTotalThreads = this.nodes * this.contexts * this.threads;
            }
            resultSet.close();
            preparedStatement.close();
            PerfExplorerServer.getServer().getControl().SIGNAL("getConstants");
        }
        catch (SQLException sQLException) {
            String string = "ERROR: Couldn't the constant settings from the database!";
            System.out.println(string);
            sQLException.printStackTrace();
            PerfExplorerServer.getServer().getControl().SIGNAL("getConstants");
            throw new PerfExplorerException(string, sQLException);
        }
    }

    private void getRawData() throws PerfExplorerException {
        System.out.print("Getting raw data...");
        this.rawData = this.factory.createRawData("Cluster Test", this.eventIDs, this.numTotalThreads, this.numEvents);
        ResultSet resultSet = null;
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        this.maximum = 0.0;
        try {
            int n5;
            PerfExplorerServer.getServer().getControl().WAIT("getRawData");
            DB dB = PerfExplorerServer.getServer().getDB();
            PreparedStatement preparedStatement = null;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.modelData.getDimensionReduction().equals("Over X Percent")) {
                stringBuffer.append("select e.id, (p.node*");
                stringBuffer.append(this.contexts * this.threads);
                stringBuffer.append(") + (p.context*");
                stringBuffer.append(this.threads);
                if (dB.getDBType().compareTo("oracle") == 0) {
                    stringBuffer.append(") + p.thread as thread, p.metric as metric, p.excl/1000000, ");
                } else {
                    stringBuffer.append(") + p.thread as thread, p.metric as metric, p.exclusive/1000000, ");
                }
                stringBuffer.append("p.inclusive/1000000, s.inclusive_percentage, s.exclusive_percentage ");
                stringBuffer.append("from interval_event e ");
                stringBuffer.append("inner join interval_mean_summary s ");
                stringBuffer.append("on e.id = s.interval_event and (s.exclusive_percentage > ");
                stringBuffer.append(this.modelData.getXPercent());
                stringBuffer.append(" or s.inclusive_percentage = 100.0) ");
                stringBuffer.append(" left outer join interval_location_profile p ");
                stringBuffer.append("on e.id = p.interval_event ");
                stringBuffer.append("and p.metric = s.metric where e.trial = ? ");
            } else {
                stringBuffer.append("select e.id, (p.node*" + this.contexts * this.threads + "");
                stringBuffer.append(") + (p.context*" + this.threads + "");
                if (dB.getDBType().compareTo("oracle") == 0) {
                    stringBuffer.append(") + p.thread as thread, p.metric as metric, p.excl, ");
                } else {
                    stringBuffer.append(") + p.thread as thread, p.metric as metric, p.exclusive, ");
                }
                stringBuffer.append("p.inclusive/1000000, p.inclusive_percentage ");
                stringBuffer.append("from interval_event e ");
                stringBuffer.append("left outer join interval_location_profile p ");
                stringBuffer.append("on e.id = p.interval_event where e.trial = ? ");
            }
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                stringBuffer.append(" and p.metric = ? ");
            }
            stringBuffer.append(" and e.group_name not like '%TAU_CALLPATH%' ");
            stringBuffer.append(" order by 3,1,2 ");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.modelData.getTrial().getID());
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(2, ((Metric)this.modelData.getCurrentSelection()).getID());
            }
            resultSet = preparedStatement.executeQuery();
            int n6 = n5 = this.modelData.getCurrentSelection() instanceof Metric ? 1 : 3;
            while (resultSet.next()) {
                if (!this.modelData.getDimensionReduction().equals("Over X Percent") || resultSet.getDouble(7) > this.modelData.getXPercent()) {
                    if (n != resultSet.getInt(n5)) {
                        ++n2;
                    }
                    n = resultSet.getInt(n5);
                    n4 = resultSet.getInt(2);
                    this.rawData.addValue(n4, n2, resultSet.getDouble(4));
                    if (this.maximum < resultSet.getDouble(4)) {
                        this.maximum = resultSet.getDouble(4);
                    }
                }
                if (resultSet.getDouble(6) == 100.0) {
                    this.rawData.addMainValue(n4, n2, resultSet.getDouble(5));
                }
                ++n3;
            }
            resultSet.close();
            preparedStatement.close();
            PerfExplorerServer.getServer().getControl().SIGNAL("getRawData");
        }
        catch (SQLException sQLException) {
            String string = "ERROR: Couldn't the raw data from the database!";
            System.out.println(string);
            sQLException.printStackTrace();
            PerfExplorerServer.getServer().getControl().SIGNAL("getRawData");
            throw new PerfExplorerException(string, sQLException);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            System.out.println("\ncurrentFunction: " + n);
            System.out.println("functionIndex: " + n2);
            System.out.println("rowIndex: " + n3);
            System.out.println("threadIndex: " + n4);
            PerfExplorerServer.getServer().getControl().SIGNAL("getRawData");
            System.exit(1);
        }
        System.out.println(" Done!");
    }

    public DendrogramTree createDendrogramTree(int[] nArray, double[] dArray) {
        DendrogramTree dendrogramTree = null;
        DendrogramTree dendrogramTree2 = null;
        DendrogramTree dendrogramTree3 = null;
        Hashtable<Integer, DendrogramTree> hashtable = new Hashtable<Integer, DendrogramTree>(nArray.length);
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            dendrogramTree = nArray[n] < 0 ? new DendrogramTree(nArray[n], 0.0) : (DendrogramTree)hashtable.get(new Integer(nArray[n]));
            dendrogramTree2 = nArray[++n] < 0 ? new DendrogramTree(nArray[n], 0.0) : (DendrogramTree)hashtable.get(new Integer(nArray[n]));
            ++n;
            dendrogramTree3 = new DendrogramTree(i + 1, dArray[i]);
            dendrogramTree3.setLeftAndRight(dendrogramTree, dendrogramTree2);
            hashtable.put(new Integer(i + 1), dendrogramTree3);
        }
        return dendrogramTree3;
    }

    public RawDataInterface doDimensionReduction() {
        return this.rawData;
    }

    public void run() {
        this.modelData = this.server.getNextRequest();
        if (this.modelData != null) {
            this.analysisID = this.modelData.getAnalysisID();
            try {
                System.out.println("Processing " + this.modelData.toString());
                this.getConstants();
                this.getRawData();
                RawDataInterface rawDataInterface = this.doDimensionReduction();
                if (this.modelData.getClusterMethod().equals("K Means")) {
                    int n = this.numTotalThreads <= this.modelData.getNumberOfClusters() ? this.numTotalThreads - 1 : this.modelData.getNumberOfClusters();
                    for (int i = 2; i <= n; ++i) {
                        RawDataInterface[] rawDataInterfaceArray;
                        Object object;
                        Object object2;
                        System.out.println("Doing " + i + " clusters:" + this.modelData.toString());
                        KMeansClusterInterface kMeansClusterInterface = this.factory.createKMeansEngine();
                        kMeansClusterInterface.setInputData(rawDataInterface);
                        kMeansClusterInterface.setK(i);
                        kMeansClusterInterface.findClusters();
                        RawDataInterface rawDataInterface2 = kMeansClusterInterface.getClusterCentroids();
                        RawDataInterface rawDataInterface3 = kMeansClusterInterface.getClusterStandardDeviations();
                        int[] nArray = kMeansClusterInterface.getClusterSizes();
                        File file = this.generateThumbnail(nArray, this.eventIDs);
                        File file2 = this.generateImage(nArray, this.eventIDs);
                        this.chartType = 1;
                        this.saveAnalysisResult(rawDataInterface2, rawDataInterface3, file, file2);
                        if (this.modelData.getCurrentSelection() instanceof Metric) {
                            object2 = this.factory.createPCAEngine(this.server.getCubeData(this.modelData));
                            object2.setInputData(rawDataInterface);
                            object2.doPCA();
                            object = object2.getResults();
                            object2.setClusterer(kMeansClusterInterface);
                            rawDataInterfaceArray = object2.getClusters();
                            this.rCorrelation = 0.0;
                            this.chartType = 6;
                            file = this.generateThumbnail(rawDataInterfaceArray);
                            file2 = this.generateImage((RawDataInterface)object, rawDataInterfaceArray);
                            this.saveAnalysisResult((RawDataInterface)object, (RawDataInterface)object, file, file2);
                        }
                        object2 = new VirtualTopology(this.modelData, kMeansClusterInterface);
                        object = ((VirtualTopology)object2).getImage();
                        rawDataInterfaceArray = ((VirtualTopology)object2).getThumbnail();
                        this.saveAnalysisResult("Virtual Topology", (String)object, (String)rawDataInterfaceArray, false);
                        this.chartType = 5;
                        file = this.generateThumbnail(kMeansClusterInterface.getClusterMinimums(), rawDataInterface3, this.eventIDs);
                        file2 = this.generateImage(kMeansClusterInterface.getClusterMinimums(), rawDataInterface3, this.eventIDs);
                        this.saveAnalysisResult(kMeansClusterInterface.getClusterMinimums(), rawDataInterface3, file, file2);
                        this.chartType = 3;
                        file = this.generateThumbnail(rawDataInterface2, rawDataInterface3, this.eventIDs);
                        file2 = this.generateImage(rawDataInterface2, rawDataInterface3, this.eventIDs);
                        this.saveAnalysisResult(rawDataInterface2, rawDataInterface3, file, file2);
                        this.chartType = 4;
                        file = this.generateThumbnail(kMeansClusterInterface.getClusterMaximums(), rawDataInterface3, this.eventIDs);
                        file2 = this.generateImage(kMeansClusterInterface.getClusterMaximums(), rawDataInterface3, this.eventIDs);
                        this.saveAnalysisResult(kMeansClusterInterface.getClusterMaximums(), rawDataInterface3, file, file2);
                    }
                } else {
                    System.out.println("Doing Correlation Analysis...");
                    this.chartType = 7;
                    for (int i = 0; i < rawDataInterface.numDimensions(); ++i) {
                        for (int j = 0; j < rawDataInterface.numDimensions(); ++j) {
                            this.rCorrelation = rawDataInterface.getCorrelation(i, j);
                            File file = this.generateThumbnail(rawDataInterface, i, j);
                            File file3 = this.generateImage(rawDataInterface, i, j);
                            this.saveAnalysisResult(rawDataInterface, rawDataInterface, file, file3);
                        }
                    }
                }
            }
            catch (PerfExplorerException perfExplorerException) {
            }
            catch (ClusterException clusterException) {
                // empty catch block
            }
            this.server.taskFinished();
            this.modelData = null;
        }
    }

    public File generateThumbnail(RawDataInterface rawDataInterface, RawDataInterface rawDataInterface2, List list) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < rawDataInterface.numVectors(); ++i) {
            for (int j = 0; j < rawDataInterface.numDimensions(); ++j) {
                defaultCategoryDataset.addValue(rawDataInterface.getValue(i, j), (Comparable)((Object)((String)list.get(j))), (Comparable)((Object)new String(Integer.toString(i))));
            }
        }
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)true, (boolean)false);
        File file = new File("/tmp/thumbnail." + this.modelData.toShortString() + ".png");
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)100, (int)100);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public File generateThumbnail(int[] nArray, List list) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < nArray.length; ++i) {
            defaultCategoryDataset.addValue((double)nArray[i], (Comparable)((Object)"Threads in cluster"), (Comparable)((Object)new String(Integer.toString(i))));
        }
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)true, (boolean)false);
        File file = new File("/tmp/thumbnail." + this.modelData.toShortString() + ".png");
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)100, (int)100);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public File generateThumbnail(RawDataInterface[] rawDataInterfaceArray) {
        File file = null;
        if (this.chartType == 6) {
            PCAPlotDataset pCAPlotDataset = new PCAPlotDataset(rawDataInterfaceArray);
            JFreeChart jFreeChart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)pCAPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            file = new File("/tmp/thumbnail." + this.modelData.toShortString() + ".png");
            try {
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)100, (int)100);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    public File generateImage(RawDataInterface rawDataInterface, RawDataInterface[] rawDataInterfaceArray) {
        File file = null;
        if (this.chartType == 6) {
            PCAPlotDataset pCAPlotDataset = new PCAPlotDataset(rawDataInterfaceArray);
            JFreeChart jFreeChart = ChartFactory.createScatterPlot((String)"Correlation Results", (String)((String)rawDataInterface.getEventNames().get(0)), (String)((String)rawDataInterface.getEventNames().get(1)), (XYDataset)pCAPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            file = new File("/tmp/image." + this.modelData.toShortString() + ".png");
            try {
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)500, (int)500);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    public File generateThumbnail(RawDataInterface rawDataInterface, int n, int n2) {
        File file = null;
        if (this.chartType == 7) {
            rawDataInterface.normalizeData(true);
            ScatterPlotDataset scatterPlotDataset = new ScatterPlotDataset(rawDataInterface, this.modelData.toString(), n, n2, this.correlateToMain);
            JFreeChart jFreeChart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)scatterPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            file = new File("/tmp/thumbnail." + this.modelData.toShortString() + ".png");
            try {
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)100, (int)100);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    public File generateImage(RawDataInterface rawDataInterface, int n, int n2) {
        File file = null;
        if (this.chartType == 7) {
            rawDataInterface.normalizeData(true);
            ScatterPlotDataset scatterPlotDataset = new ScatterPlotDataset(rawDataInterface, this.modelData.toString(), n, n2, this.correlateToMain);
            NumberAxis numberAxis = new NumberAxis((String)rawDataInterface.getEventNames().get(n));
            numberAxis.setAutoRangeIncludesZero(false);
            NumberAxis numberAxis2 = null;
            numberAxis2 = this.correlateToMain ? new NumberAxis(rawDataInterface.getMainEventName()) : new NumberAxis((String)rawDataInterface.getEventNames().get(n2));
            numberAxis2.setAutoRangeIncludesZero(false);
            StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(1);
            standardXYItemRenderer.setShapesFilled(true);
            if (this.correlateToMain) {
                standardXYItemRenderer.setSeriesPaint(0, (Paint)Color.green);
            }
            XYPlot xYPlot = new XYPlot((XYDataset)scatterPlotDataset, (ValueAxis)numberAxis, (ValueAxis)numberAxis2, (XYItemRenderer)standardXYItemRenderer);
            double[] dArray = Regression.getOLSRegression((XYDataset)scatterPlotDataset, (int)0);
            LineFunction2D lineFunction2D = new LineFunction2D(dArray[0], dArray[1]);
            Range range = DatasetUtilities.findDomainExtent((XYDataset)scatterPlotDataset);
            XYDataset xYDataset = DatasetUtilities.sampleFunction2D((Function2D)lineFunction2D, (double)range.getLowerBound(), (double)range.getUpperBound(), (int)100, (String)"Fitted Linear Regression Line");
            xYPlot.setDataset(1, xYDataset);
            DefaultXYItemRenderer defaultXYItemRenderer = new DefaultXYItemRenderer();
            defaultXYItemRenderer.setSeriesPaint(0, (Paint)Color.blue);
            xYPlot.setRenderer(1, (XYItemRenderer)defaultXYItemRenderer);
            double[] dArray2 = Regression.getPowerRegression((XYDataset)scatterPlotDataset, (int)0);
            PowerFunction2D powerFunction2D = new PowerFunction2D(dArray2[0], dArray2[1]);
            XYDataset xYDataset2 = DatasetUtilities.sampleFunction2D((Function2D)powerFunction2D, (double)range.getLowerBound(), (double)range.getUpperBound(), (int)100, (String)"Fitted Power Regression Line");
            xYPlot.setDataset(2, xYDataset2);
            DefaultXYItemRenderer defaultXYItemRenderer2 = new DefaultXYItemRenderer();
            defaultXYItemRenderer2.setSeriesPaint(0, (Paint)Color.black);
            xYPlot.setRenderer(2, (XYItemRenderer)defaultXYItemRenderer2);
            xYPlot.getDomainAxis().setRange(range);
            xYPlot.getRangeAxis().setRange(range);
            JFreeChart jFreeChart = new JFreeChart("Correlation Results: r = " + this.rCorrelation, JFreeChart.DEFAULT_TITLE_FONT, (Plot)xYPlot, true);
            file = new File("/tmp/image." + this.modelData.toShortString() + ".png");
            try {
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)500, (int)500);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    public File generateImage(int[] nArray, List list) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < nArray.length; ++i) {
            defaultCategoryDataset.addValue((double)nArray[i], (Comparable)((Object)"Threads in cluster"), (Comparable)((Object)new String(Integer.toString(i))));
        }
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart((String)this.modelData.toString(), (String)"Cluster Number", (String)"Threads in cluster", (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        File file = new File("/tmp/image." + this.modelData.toShortString() + ".png");
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)500, (int)500);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public File generateImage(RawDataInterface rawDataInterface, RawDataInterface rawDataInterface2, List list) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < rawDataInterface.numVectors(); ++i) {
            for (int j = 0; j < rawDataInterface.numDimensions(); ++j) {
                defaultCategoryDataset.addValue(rawDataInterface.getValue(i, j), (Comparable)((Object)((String)list.get(j))), (Comparable)((Object)new String(Integer.toString(i))));
            }
        }
        String string = this.modelData.toString();
        if (this.chartType == 3) {
            string = string + " Average Values";
        }
        if (this.chartType == 4) {
            string = string + " Maximum Values";
        }
        if (this.chartType == 5) {
            string = string + " Minimum Values";
        }
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart((String)string, (String)"Cluster Number", (String)"Total Runtime", (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        File file = new File("/tmp/image." + this.modelData.toShortString() + ".png");
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)500, (int)500);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }
}

