/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import net.java.games.jogl.impl.GLContext;

public class GLContextShareSet {
    private static Map shareMap = new WeakHashMap();
    private static Object dummyValue = new Object();
    static /* synthetic */ Class class$net$java$games$jogl$impl$GLContextShareSet;

    public static synchronized void registerSharing(GLContext gLContext, GLContext gLContext2) {
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet == null) {
            shareSet = GLContextShareSet.entryFor(gLContext2);
        }
        if (shareSet == null) {
            shareSet = new ShareSet();
        }
        shareSet.add(gLContext);
        shareSet.add(gLContext2);
        GLContextShareSet.addEntry(gLContext, shareSet);
        GLContextShareSet.addEntry(gLContext2, shareSet);
    }

    public static synchronized GLContext getShareContext(GLContext gLContext) {
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet == null) {
            return null;
        }
        return shareSet.getCreatedShare(gLContext);
    }

    public static synchronized void contextCreated(GLContext gLContext) {
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet != null) {
            shareSet.contextCreated(gLContext);
        }
    }

    public static synchronized void contextDestroyed(GLContext gLContext) {
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet != null) {
            shareSet.contextDestroyed(gLContext);
        }
    }

    private static ShareSet entryFor(GLContext gLContext) {
        return (ShareSet)shareMap.get(gLContext);
    }

    private static void addEntry(GLContext gLContext, ShareSet shareSet) {
        if (shareMap.get(gLContext) == null) {
            shareMap.put(gLContext, shareSet);
        }
    }

    private static class ShareSet {
        private Map allShares = new WeakHashMap();
        private Map createdShares = new WeakHashMap();
        private Map destroyedShares = new WeakHashMap();
        static final /* synthetic */ boolean $assertionsDisabled;

        private ShareSet() {
        }

        public void add(GLContext gLContext) {
            if (this.allShares.put(gLContext, dummyValue) == null) {
                if (gLContext.isCreated()) {
                    this.createdShares.put(gLContext, dummyValue);
                } else {
                    this.destroyedShares.put(gLContext, dummyValue);
                }
            }
        }

        public GLContext getCreatedShare(GLContext gLContext) {
            Iterator iterator = this.createdShares.keySet().iterator();
            while (iterator.hasNext()) {
                GLContext gLContext2 = (GLContext)iterator.next();
                if (gLContext2 == gLContext) continue;
                return gLContext2;
            }
            return null;
        }

        public void contextCreated(GLContext gLContext) {
            Object object = this.destroyedShares.remove(gLContext);
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError((Object)("State of ShareSet corrupted; thought context " + gLContext + " should have been in destroyed set but wasn't"));
            }
            object = this.createdShares.put(gLContext, dummyValue);
            if (!$assertionsDisabled && object != null) {
                throw new AssertionError((Object)("State of ShareSet corrupted; thought context " + gLContext + " shouldn't have been in created set but was"));
            }
        }

        public void contextDestroyed(GLContext gLContext) {
            Object object = this.createdShares.remove(gLContext);
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError((Object)("State of ShareSet corrupted; thought context " + gLContext + " should have been in created set but wasn't"));
            }
            object = this.destroyedShares.put(gLContext, dummyValue);
            if (!$assertionsDisabled && object != null) {
                throw new AssertionError((Object)("State of ShareSet corrupted; thought context " + gLContext + " shouldn't have been in destroyed set but was"));
            }
        }

        static {
            $assertionsDisabled = !(class$net$java$games$jogl$impl$GLContextShareSet == null ? (class$net$java$games$jogl$impl$GLContextShareSet = GLContextShareSet.class$("net.java.games.jogl.impl.GLContextShareSet")) : class$net$java$games$jogl$impl$GLContextShareSet).desiredAssertionStatus();
        }
    }
}

