/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.util;

import edu.uoregon.tau.paraprof.util.FileMonitorListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public class FileMonitor {
    private Timer timer;
    private HashMap fileMap = new HashMap();
    private Collection listeners = new ArrayList();

    public FileMonitor(long l) {
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new FileMonitorNotifier(), 0L, l);
    }

    public void stop() {
        this.timer.cancel();
    }

    public void addFile(File file) {
        if (!this.fileMap.containsKey(file = new File(file.getAbsolutePath()))) {
            long l = file.exists() ? file.lastModified() : -1L;
            this.fileMap.put(file, new Long(l));
        }
    }

    public void removeFile(File file) {
        this.fileMap.remove(file);
    }

    public void addListener(FileMonitorListener fileMonitorListener) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            FileMonitorListener fileMonitorListener2 = (FileMonitorListener)weakReference.get();
            if (fileMonitorListener2 != fileMonitorListener) continue;
            return;
        }
        this.listeners.add(new WeakReference<FileMonitorListener>(fileMonitorListener));
    }

    public void removeListener(FileMonitorListener fileMonitorListener) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            FileMonitorListener fileMonitorListener2 = (FileMonitorListener)weakReference.get();
            if (fileMonitorListener2 != fileMonitorListener) continue;
            iterator.remove();
            break;
        }
    }

    private class FileMonitorNotifier
    extends TimerTask {
        private FileMonitorNotifier() {
        }

        public void run() {
            ArrayList arrayList = new ArrayList(FileMonitor.this.fileMap.keySet());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                long l;
                File file = (File)iterator.next();
                long l2 = (Long)FileMonitor.this.fileMap.get(file);
                long l3 = l = file.exists() ? file.lastModified() : -1L;
                if (l == l2) continue;
                FileMonitor.this.fileMap.put(file, new Long(l));
                Iterator iterator2 = FileMonitor.this.listeners.iterator();
                while (iterator2.hasNext()) {
                    WeakReference weakReference = (WeakReference)iterator2.next();
                    FileMonitorListener fileMonitorListener = (FileMonitorListener)weakReference.get();
                    if (fileMonitorListener == null) {
                        iterator2.remove();
                        continue;
                    }
                    fileMonitorListener.fileChanged(file);
                }
            }
        }
    }
}

