/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ColorChooser;
import edu.uoregon.tau.paraprof.CustomCellRenderer;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.colorchooser.ColorSelectionModel;

public class ColorDefaultsWindow
extends JFrame
implements ActionListener,
MouseListener {
    private ColorChooser colorChooser;
    private ColorSelectionModel clrModel;
    private JColorChooser clrChooser;
    private DefaultListModel listModel;
    private JList colorList;
    private JButton addColorButton;
    private JButton addGroupColorButton;
    private JButton deleteColorButton;
    private JButton updateColorButton;
    private JButton restoreDefaultsButton;

    public ColorDefaultsWindow(ColorChooser colorChooser, Component component) {
        this.colorChooser = colorChooser;
        this.setSize(new Dimension(855, 450));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        this.setTitle("ParaProf: Edit Default Colors");
        this.setupMenus();
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.clrChooser = new JColorChooser();
        this.clrModel = this.clrChooser.getSelectionModel();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel("Default Color Set");
        jLabel.setFont(new Font("SansSerif", 0, 14));
        this.addCompItem(jLabel, gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.listModel = new DefaultListModel();
        this.colorList = new JList(this.listModel);
        this.colorList.setSelectionMode(0);
        this.colorList.setCellRenderer(new CustomCellRenderer());
        this.colorList.setSize(500, 300);
        this.colorList.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.colorList);
        this.addCompItem(jScrollPane, gridBagConstraints, 0, 1, 1, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addColorButton = new JButton("Add Function Color");
        this.addColorButton.addActionListener(this);
        this.addCompItem(this.addColorButton, gridBagConstraints, 1, 1, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addGroupColorButton = new JButton("Add Group Color");
        this.addGroupColorButton.addActionListener(this);
        this.addCompItem(this.addGroupColorButton, gridBagConstraints, 1, 2, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.deleteColorButton = new JButton("Delete Selected Color");
        this.deleteColorButton.addActionListener(this);
        this.addCompItem(this.deleteColorButton, gridBagConstraints, 1, 3, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.updateColorButton = new JButton("Update Selected Color");
        this.updateColorButton.addActionListener(this);
        this.addCompItem(this.updateColorButton, gridBagConstraints, 1, 4, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.restoreDefaultsButton = new JButton("Restore Defaults");
        this.restoreDefaultsButton.addActionListener(this);
        this.addCompItem(this.restoreDefaultsButton, gridBagConstraints, 1, 5, 1, 1);
        this.addCompItem(this.clrChooser, gridBagConstraints, 2, 0, 1, 6);
        this.populateColorList();
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Close This Window");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Exit ParaProf!");
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
    }

    private void updateTrials() {
        Vector vector = ParaProf.paraProfManagerWindow.getLoadedTrials();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ParaProfTrial paraProfTrial = (ParaProfTrial)iterator.next();
            this.colorChooser.setColors(paraProfTrial, -1);
            paraProfTrial.updateRegisteredObjects("colorEvent");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (object instanceof JMenuItem) {
                if (string.equals("Exit ParaProf!")) {
                    this.setVisible(false);
                    this.dispose();
                    ParaProf.exitParaProf(0);
                } else if (string.equals("Close This Window")) {
                    this.setVisible(false);
                }
            } else if (object instanceof JButton) {
                if (string.equals("Add Function Color")) {
                    Color color = this.clrModel.getSelectedColor();
                    this.colorChooser.getColors().add(color);
                    this.listModel.clear();
                    this.populateColorList();
                    this.updateTrials();
                } else if (string.equals("Add Group Color")) {
                    Color color = this.clrModel.getSelectedColor();
                    this.colorChooser.getGroupColors().add(color);
                    this.listModel.clear();
                    this.populateColorList();
                    this.updateTrials();
                } else if (string.equals("Delete Selected Color")) {
                    int[] nArray = this.colorList.getSelectedIndices();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] < ParaProf.colorChooser.getNumberOfColors()) {
                            if (ParaProf.colorChooser.getNumberOfColors() <= 2) continue;
                            this.listModel.removeElementAt(nArray[i]);
                            this.colorChooser.getColors().removeElementAt(nArray[i]);
                            this.updateTrials();
                            continue;
                        }
                        if (nArray[i] >= ParaProf.colorChooser.getNumberOfColors() + ParaProf.colorChooser.getNumberOfGroupColors() || ParaProf.colorChooser.getNumberOfGroupColors() <= 2) continue;
                        this.listModel.removeElementAt(nArray[i]);
                        this.colorChooser.getGroupColors().removeElementAt(nArray[i] - ParaProf.colorChooser.getNumberOfColors());
                        this.updateTrials();
                    }
                    this.updateTrials();
                } else if (string.equals("Update Selected Color")) {
                    Color color = this.clrModel.getSelectedColor();
                    int[] nArray = this.colorList.getSelectedIndices();
                    for (int i = 0; i < nArray.length; ++i) {
                        this.listModel.setElementAt(color, nArray[i]);
                        int n = this.colorChooser.getNumberOfColors() + this.colorChooser.getNumberOfGroupColors();
                        if (nArray[i] == n) {
                            this.colorChooser.setHighlightColor(color);
                            continue;
                        }
                        if (nArray[i] == n + 1) {
                            this.colorChooser.setGroupHighlightColor(color);
                            continue;
                        }
                        if (nArray[i] == n + 2) {
                            this.colorChooser.setUserEventHighlightColor(color);
                            continue;
                        }
                        if (nArray[i] == n + 3) {
                            this.colorChooser.setMiscFunctionColor(color);
                            continue;
                        }
                        if (nArray[i] < this.colorChooser.getNumberOfColors()) {
                            this.colorChooser.setColor(color, nArray[i]);
                            this.updateTrials();
                            continue;
                        }
                        this.colorChooser.setGroupColor(color, nArray[i] - this.colorChooser.getNumberOfColors());
                        this.updateTrials();
                    }
                    this.updateTrials();
                } else if (string.equals("Restore Defaults")) {
                    this.colorChooser.setDefaultColors();
                    this.colorChooser.setDefaultGroupColors();
                    this.colorChooser.setHighlightColor(Color.red);
                    this.colorChooser.setGroupHighlightColor(new Color(0, 255, 255));
                    this.colorChooser.setUserEventHighlightColor(new Color(255, 255, 0));
                    this.colorChooser.setMiscFunctionColor(Color.black);
                    this.listModel.clear();
                    this.populateColorList();
                    this.updateTrials();
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            JList jList = (JList)mouseEvent.getSource();
            int n = jList.locationToIndex(mouseEvent.getPoint());
            Color color = (Color)this.listModel.getElementAt(n);
            this.clrModel.setSelectedColor(color);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void populateColorList() {
        Color color;
        Enumeration enumeration = this.colorChooser.getColors().elements();
        while (enumeration.hasMoreElements()) {
            color = (Color)enumeration.nextElement();
            this.listModel.addElement(color);
        }
        enumeration = this.colorChooser.getGroupColors().elements();
        while (enumeration.hasMoreElements()) {
            color = (Color)enumeration.nextElement();
            this.listModel.addElement(color);
        }
        color = this.colorChooser.getHighlightColor();
        this.listModel.addElement(color);
        color = this.colorChooser.getGroupHighlightColor();
        this.listModel.addElement(color);
        color = this.colorChooser.getUserEventHighlightColor();
        this.listModel.addElement(color);
        color = this.colorChooser.getMiscFunctionColor();
        this.listModel.addElement(color);
    }
}

