/************************************************************************/
/*									*/
/*  Layout of a table row in the document.				*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   define	y0	math_y0
#   define	y1	math_y1
#   include	<math.h>
#   undef	y0
#   undef	y1

#   include	"docLayout.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Push the bottom of the row down.					*/
/*									*/
/************************************************************************/

void docPsLayoutPushBottomDown(		LayoutPosition *	lpRowBottom,
					const LayoutPosition *	lpColBottom )
    {
    if  ( lpRowBottom->lpPage < lpColBottom->lpPage )
	{
	lpRowBottom->lpPage= lpColBottom->lpPage;
	lpRowBottom->lpPageYTwips= lpColBottom->lpPageYTwips;
	lpRowBottom->lpAtTopOfColumn= lpColBottom->lpAtTopOfColumn;
	}
    else{
	if  ( lpRowBottom->lpPage == lpColBottom->lpPage )
	    {
	    if  ( lpRowBottom->lpPageYTwips < lpColBottom->lpPageYTwips )
		{
		lpRowBottom->lpPageYTwips= lpColBottom->lpPageYTwips;
		lpRowBottom->lpAtTopOfColumn= lpColBottom->lpAtTopOfColumn;
		}
	    }
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Layout as much of a table row as fits on the current page.		*/
/*									*/
/************************************************************************/

static int docLayoutRowPageStrip( BufferItem *			rowBi,
				int *				pToNextPage,
				int *				pRowHeight,
				const ParagraphLayoutContext *	plc,
				ParagraphLayoutJob *		plj,
				BlockFrame *			bf,
				LayoutJob *			lj )
    {
    int				col;

    int				toNextPage= 0;

    LayoutPosition		lpBottom;
    int				bottomTwips= -1;
    int				stripHigh= -1;
    const CellProperties *	cp;

    const ScreenLayout *	sl= &(plc->plcScreenLayout);

    lpBottom= lj->ljPosition;

    toNextPage= 0;

    if  ( rowBi->biRowHeightTwips < 0 )
	{
	bottomTwips= lj->ljPosition.lpPageYTwips-
				    rowBi->biRowHeightTwips- *pRowHeight;
	stripHigh= -rowBi->biRowHeightTwips;
	}

    cp= rowBi->biRowCells;
    for ( col= 0; col < rowBi->biChildCount; cp++, plj++, col++ )
	{
	BufferItem *			cellBi= rowBi->biChildren[col];
	ParagraphLayoutPosition *	plp= &(plj->pljPos);

	if  ( cp->cpMergedWithLeft )
	    { continue;	}

	if  ( plp->plpProgress.pspPara >= cellBi->biChildCount )
	    { continue;	}

	plp->plpPos= lj->ljPosition;

	docParagraphStripFrame( sl, cellBi, plc->plcAdd,
				    bottomTwips, stripHigh, bf, plj );

	if  ( docLayoutParagraphsInStrip( plj, bf, plc, cellBi,
			    plj->pljParaUpto, bottomTwips, stripHigh ) )
	    { LDEB(1); return -1;	}

	docPsLayoutPushBottomDown( &lpBottom, &(plp->plpPos) );

	if  ( cellBi->biInExternalItem == DOCinBODY		&&
	      plp->plpProgress.pspPara < plj->pljParaUpto  	&&
	      ( bottomTwips < 0				||
	        plp->plpPos.lpPageYTwips < bottomTwips	)	)
	    { toNextPage= 1;	}
	}

    *pRowHeight += lpBottom.lpPageYTwips- lj->ljPosition.lpPageYTwips;

    lj->ljPosition= lpBottom;

    *pToNextPage= toNextPage;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Calculate the layout of a row in the document.			*/
/*									*/
/************************************************************************/

static void docPsInitRowLayout(	BufferItem *			rowBi,
				const LayoutPosition *		lp,
				ParagraphLayoutJob *		plj )
    {
    CellProperties *		cp;
    int				col;

    cp= rowBi->biRowCells;
    for ( col= 0; col < rowBi->biChildCount; cp++, plj++, col++ )
	{
	BufferItem *	cellBi= rowBi->biChildren[col];

	docPsInitParagraphLayoutJob( plj );

	plj->pljParaUpto= cellBi->biChildCount;

	docPsBeginParagraphLayoutProgress( plj, 0, 0, 0,
						cellBi->biChildCount, lp );

	cellBi->biTopPosition= *lp;
	}

    return;
    }

static int docRowToNextPage(	BufferItem *			rowBi,
				LayoutJob *			lj,
				int				bottomTwips,
				int				stripHigh,
				BlockFrame *			bf,
				ParagraphLayoutJob *		rowPlj,
				const ParagraphLayoutContext *	plc )
    {
    CellProperties *		cp;
    int				col;

    ParagraphLayoutJob *	plj;

    LayoutPosition		lpBefore;

    lpBefore= lj->ljPosition;

    if  ( BF_HAS_FOOTNOTES( bf )					&&
	  docLayoutFootnotesForColumn( bf, &(lj->ljPosition), lj )	)
	{ LDEB(1); return -1;	}

    docLayoutToNextColumn( rowBi, lj->ljBd, &(lj->ljPosition), bf );

    cp= rowBi->biRowCells;
    plj= rowPlj;
    for ( col= 0; col < rowBi->biChildCount; cp++, plj++, col++ )
	{
	BufferItem *		cellBi= rowBi->biChildren[col];
	ParagraphStripPosition	psp0;
	int			advanced;

	if  ( plj->pljPos.plpProgress.pspPara >= cellBi->biChildCount )
	    { continue;	}

	psp0= plj->pljPos0.plpProgress;

	docPsAdvanceParagraphLayout( &advanced,
					    &psp0,
					    &(plj->pljPos0.plpProgress),
					    &(plj->pljPos.plpProgress),
					    lpBefore.lpPage, cellBi );

	if  ( advanced )
	    {
	    plj->pljPos0.plpProgress= psp0;
	    plj->pljPos.plpProgress= psp0;
	    }
	else{ plj->pljPos0.plpProgress= plj->pljPos.plpProgress;	}
	}

    return 0;
    }

static void docPsLayoutFinishRow(	BufferItem *		rowBi,
					LayoutJob *		lj,
					ParagraphLayoutJob *	plj )
    {
    int				col;
    CellProperties *		cp;

    cp= rowBi->biRowCells;
    for ( col= 0; col < rowBi->biChildCount; cp++, plj++, col++ )
	{
	BufferItem *			cellBi= rowBi->biChildren[col];
	ParagraphLayoutPosition *	plp= &(plj->pljPos);

	if  ( cp->cpMergedWithLeft )
	    { continue;	}

	if  ( cp->cpBottomBorder.bpStyle != DOCbsNONE )
	    {
	    AppDrawingData *		add= lj->ljAdd;
	    double			xfac= add->addMagnifiedPixelsPerTwip;

	    int				twips;
	    int				pixels;

	    twips= cp->cpBottomBorder.bpSpacingTwips;
	    /*  Word seems not to allocate this
	    twips += cp->cpBottomBorder.bpWidthTwips;
	    */
	    pixels= TWIPStoPIXELS( xfac, twips );

	    if  ( pixels == 0 )
		{ pixels= 1;	}

	    plp->plpPos.lpPageYTwips += twips;
	    plp->plpPos.lpAtTopOfColumn= 0;
	    }

	cellBi->biBelowPosition= plp->plpPos;

	docPsLayoutPushBottomDown( &(lj->ljPosition), &(plp->plpPos) );
	}

    return;
    }

int docLayoutRowItem(		BufferItem *			rowBi,
				BlockFrame *			bf,
				LayoutJob *			lj,
				const ParagraphLayoutContext *	plc )
    {
    int				rowHeightTwips;
    int				toNextPage;

    static ParagraphLayoutJob *	staticPlj;
    ParagraphLayoutJob *	fresh;

    int				bottomTwips= -1;

    const ScreenLayout *	sl= &(plc->plcScreenLayout);

    if  ( rowBi->biRowCellCount < rowBi->biChildCount )
	{
	LLDEB(rowBi->biRowCellCount,rowBi->biChildCount);
	docListItem( 0, rowBi );
	rowBi->biChildCount= rowBi->biRowCellCount;
	}

    fresh= (ParagraphLayoutJob *)realloc( staticPlj,
		    rowBi->biRowCellCount* sizeof(ParagraphLayoutJob) );
    if  ( ! fresh )
	{ LXDEB(rowBi->biRowCellCount,fresh); return -1;	}
    staticPlj= fresh;

    if  ( sl && sl->slStartRow					&&
	  (*sl->slStartRow)( rowBi, lj->ljAdd, lj->ljBd )	)
	{ LDEB(1); return -1;	}

    toNextPage= 0;
    rowHeightTwips= 0;
    if  ( rowBi->biRowHeightTwips < 0 )
	{ bottomTwips= lj->ljPosition.lpPageYTwips- rowBi->biRowHeightTwips; }

    docPsInitRowLayout( rowBi, &(lj->ljPosition), staticPlj );

    if  ( docLayoutRowPageStrip( rowBi, &toNextPage,
				    &rowHeightTwips, plc, staticPlj, bf, lj ) )
	{ LDEB(1); return -1;	}

    if  ( toNextPage && ! rowBi->biTopPosition.lpAtTopOfColumn )
	{
	int				someAtTop= 0;
	int				col;
	const ParagraphLayoutJob *	plj;

	plj= staticPlj;
	for ( col= 0; col < rowBi->biChildCount; plj++, col++ )
	    {
	    const ParagraphLayoutPosition *	plp= &(plj->pljPos);
	    const ParagraphStripPosition *	psp= &(plp->plpProgress);

	    if  ( psp->pspPara == 0 && psp->pspPart == 0 )
		{
		const BufferItem *	cellBi= rowBi->biChildren[col];

		if  ( cellBi->biChildCount > 0 )
		    {
		    const BufferItem *	paraBi;

		    paraBi= cellBi->biChildren[psp->pspPara];

		    if  ( psp->pspPart < paraBi->biParaParticuleCount )
			{ someAtTop= 1; break; }
		    }
		}
	    }

	if  ( docRowToNextPage( rowBi, lj, bottomTwips, rowHeightTwips,
							bf, staticPlj, plc ) )
	    { LDEB(toNextPage); return -1;	}

	if  ( rowBi->biRowKeepOnOnePage || someAtTop )
	    {
	    docPsInitRowLayout( rowBi, &(lj->ljPosition), staticPlj );

	    rowHeightTwips= 0;
	    if  ( rowBi->biRowHeightTwips < 0 )
		{
		bottomTwips=
			lj->ljPosition.lpPageYTwips- rowBi->biRowHeightTwips;
		}

	    rowBi->biTopPosition= lj->ljPosition;
	    }

	if  ( docLayoutRowPageStrip( rowBi, &toNextPage,
				&rowHeightTwips, plc, staticPlj, bf, lj ) )
	    { LDEB(1); return -1;	}
	}

    while( toNextPage )
	{
	if  ( docRowToNextPage( rowBi, lj, bottomTwips, rowHeightTwips,
							bf, staticPlj, plc ) )
	    { LDEB(toNextPage); return -1;	}

	if  ( docLayoutRowPageStrip( rowBi, &toNextPage,
				&rowHeightTwips, plc, staticPlj, bf, lj ) )
	    { LDEB(1); return -1;	}
	}

    docPsLayoutFinishRow( rowBi, lj, staticPlj );

    if  ( rowHeightTwips < rowBi->biRowHeightTwips )
	{
	lj->ljPosition.lpPageYTwips +=
				rowBi->biRowHeightTwips- rowHeightTwips;
	lj->ljPosition.lpAtTopOfColumn= 0;
	}

    if  ( rowHeightTwips < -rowBi->biRowHeightTwips )
	{
	lj->ljPosition.lpPageYTwips +=
				-rowBi->biRowHeightTwips- rowHeightTwips;
	lj->ljPosition.lpAtTopOfColumn= 0;
	}

    return 0;
    }

