/************************************************************************/
/*									*/
/*  Row Properties.							*/
/*									*/
/************************************************************************/

#   ifndef	DOC_ROW_PROPS_H
#   define	DOC_ROW_PROPS_H

typedef struct CellProperties
    {
    int			cpRightBoundaryTwips;
    int			cpRightBoundaryPixels;

    int			cpForegroundColor;
    int			cpBackgroundColor;

    BorderProperties	cpTopBorder;
    BorderProperties	cpBottomBorder;
    BorderProperties	cpLeftBorder;
    BorderProperties	cpRightBorder;

    unsigned int	cpShadingLevel:10;
    unsigned int	cpShadingPattern:4;		/*  (enum)	*/

    unsigned int	cpLeftInMergedRow:1;
    unsigned int	cpMergedWithLeft:1;
    unsigned int	cpTopInMergedColumn:1;
    unsigned int	cpMergedWithAbove:1;

    unsigned int	cpVerticalTextAlignment:3;	/*  (enum)	*/
    } CellProperties;

#   define	docCopyCellProperties( cp1, cp2 ) \
					    ( ( *(cp1)= *(cp2) ), 0 )

#   define	docCleanCellProperties( cp ) ( ( *(cp)= *(cp) ), 0 )

typedef struct RowProperties
    {
    int			rpCellCount;
    CellProperties *	rpCells;

    int			rpHalfGapWidthTwips;
    int			rpHalfGapWidthPixels;

    int			rpHeightTwips;

    int			rpLeftIndentTwips;
    int			rpLeftIndentPixels;

			/************************************************/
			/*  Row borders are not stored in the word	*/
			/*  binary format, and seem to be irrelevant:	*/
			/************************************************/
    BorderProperties	rpTopBorder;
    BorderProperties	rpBottomBorder;
    BorderProperties	rpLeftBorder;
    BorderProperties	rpRightBorder;
    BorderProperties	rpHorizontalBorder;
    BorderProperties	rpVerticalBorder;

    ItemAlignment	rpAlignment:3;
    unsigned int	rpHasTableParagraphs:1;

    unsigned int	rpHasHorizontalBorders:1;
    unsigned int	rpHasVerticalBorders:1;

    unsigned int	rpIsTableHeader:1;
    unsigned int	rpKeepOnOnePage:1;
    } RowProperties;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitRowProperties(	RowProperties *		rp );
extern void docCleanRowProperties(	RowProperties *		rp );
extern void docCleanInitRowProperties(	RowProperties *		rp );

extern int docCopyRowProperties(	RowProperties *		to,
					const RowProperties *	from );

extern int docInsertRowColumn(	RowProperties *			rp,
				int				n,
				const CellProperties *		cp );

extern int docAlignedColumns(	const RowProperties *	rp1,
				const RowProperties *	rp2 );

extern int docEqualRows(	const RowProperties *	rp1,
				const RowProperties *	rp2 );

#   endif	/*  DOC_ROW_PROPS_H  */
