
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : maple.scm
;; DESCRIPTION : Special support for maple
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;                 modifi par Christian Even 
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Specific conversion routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (maple-input-var-row r)
  (if (not (null? r))
      (begin
	(display ", ")
	(cas-input (car r))
	(maple-input-var-row (cdr r)))))

(define (maple-input-row r)
  (display "[")
  (cas-input (car r))
  (maple-input-var-row (cdr r))
  (display "]"))

(define (maple-input-var-rows t)
  (if (not (null? t))
      (begin
	(display ", ")
	(maple-input-row (car t))
	(maple-input-var-rows (cdr t)))))

(define (maple-input-rows t)
  (display "matrix([")
  (maple-input-row (car t))
  (maple-input-var-rows (cdr t))
  (display "])"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Initialization
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(connection-declare "maple" "tm_maple")
(connection-format "maple" "verbatim" "generic")
(set! session-menu (menu-merge session-menu
  '(("maple" (make-session "maple" "default")))))
(define (in-maple?) (equal? (get-env "prog language") "maple"))

(set! cas-input-current-cas "maple")
(cas-input-set! 'rows maple-input-rows)
(display "")
