
/******************************************************************************
* MODULE     : construct.gen.h
* DESCRIPTION: the exported box construction routines
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <boxes.gen.h>
#include <array.gen.h>
#include <font.gen.h>
#include <command.gen.h>

#module construct_boxes
#import boxes
#import array (box)
#import array (int)
#import array (string)
#import font
#import command

typedef array<int> array<SI>;
typedef array<int> array<color>;

/******************************************************************************
* Construction routines for boxes
******************************************************************************/

box empty_box (path ip, int x1=0, int y1=0, int x2=0, int y2=0);
box test_box (path ip);
box line_box (path ip, SI x1, SI y1, SI x2, SI y2, SI w, color c);
box arc_box (path ip, SI x1, SI y1, SI x2, SI y2,
	     int a1, int a2, SI w, color c);
box postscript_box (path ip, string image, string type, SI w, SI h,
		    int x1, int y1, int x2, int y2);
box text_box (path ip, int pos, string s, font fn, color col);
box delimiter_box (path ip, string s, font fn, color col, SI y1, SI y2);
box big_operator_box (path ip, string s, font fn, color col, int n);
box bracket_box (path ip, int br_type, SI penw, color col, SI y1, SI y2);
box wide_hat_box (path ip, SI x1, SI x2, SI penw, color col);
box wide_tilda_box (path ip, SI x1, SI x2, SI penw, color col);
box wide_bar_box (path ip, SI x1, SI x2, SI penw, color col);
box wide_vect_box (path ip, SI x1, SI x2, SI penw, color col);
box wide_check_box (path ip, SI x1, SI x2, SI penw, color col);
box wide_breve_box (path ip, SI x1, SI x2, SI penw, color col);
box image_box (path ip, string fname, SI w, SI h, double mw, double mh,
	       int x1, int y1, int x2, int y2);
box control_box (path ip, tree t, font fn);
box control_box (path ip, lazy lz, font fn);

box concat_box (path ip, array<box> bs, array<SI> spc);
box phrase_box (path ip, array<box> bs, array<SI> spc);
box stack_box (path ip, array<box> bs, array<SI> spc);
box composite_box (path ip, array<box> bs, array<SI> x, array<SI> y,
		   bool bfl= TRUE);
box scatter_box (path ip, array<box> bs, array<SI> x, array<SI> y);
box cell_box (path ip, box b, SI x0, SI y0, SI x1, SI y1, SI x2, SI y2,
	      SI bl, SI br, SI bb, SI bt, int corr,
	      color fg, color bg, bool transp);

box frac_box (path ip, box b1, box b2, font fn, font sfn, color c);
box sqrt_box (path ip, box b1, box b2, box sqrtb, font fn, color c);
box neg_box (path ip, box b, font fn, color c);
box tree_box (path ip, array<box> bs, font fn, color line_c);
box wide_box (path ip, box ref, box hi, font fn, SI sep, bool above);
box repeat_box (path ip, box ref, box repeat, SI xoff=0);
box limit_box (path ip, box ref, box lo, box hi, font fn, bool glued);
box script_box (path ip, box b1, box b2, font fn);
box left_script_box (path ip, box ref, box b1, box b2, font fn, int level);
box right_script_box (path ip, box ref, box b1, box b2, font fn, int level);
box side_box (path ip, box ref, box l1, box l2, box r1, box r2, font f, int l);

box symbol_box (path ip, box b, int n);
box shorter_box (path ip, box b, int n);
box move_box (path ip, box b, SI x, SI y, bool chf= FALSE, bool bigf= FALSE);
box resize_box (path ip, box b, SI x1, SI y1, SI x2, SI y2,
		bool chf= FALSE, bool adjust= FALSE);
box vcorrect_box (path ip, box b, SI top_cor, SI bot_cor);
box page_box (path ip, tree page, SI w, SI h,
	      array<box> bs  , array<SI> bs_x  , array<SI> bs_y,
	      array<box> decs, array<SI> decs_x, array<SI> decs_y);
box action_box (path ip, box b, command cmd, bool child_flag);
box macro_box (path ip, box b, font big_fn= font ());
box tag_box (path ip, box b, string name);

box graphics_box (path ip, array<box> bs, SI x1, SI y1, SI x2, SI y2);

#endmodule // construct_boxes
