
/******************************************************************************
* MODULE     : basic_event.gen.h
* DESCRIPTION: The most common events
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <event.gen.h>
#include <Event/event_codes.gen.h>
#include <widget.gen.h>

#module basic_event
#import event
#import event_codes
#import widget

/******************************************************************************
* Attribute events
******************************************************************************/

struct get_size_event_rep: public event_rep {
  SI& w; SI& h; int mode;
  get_size_event_rep (SI& w, SI& h, int mode);
  operator tree ();
};
#import event (get_size_event, get_size_event_rep)

struct get_widget_event_rep: public event_rep {
  string which; widget& w;
  get_widget_event_rep (string which, widget& w);
  operator tree ();
};
#import event (get_widget_event, get_widget_event_rep)

struct set_widget_event_rep: public event_rep {
  string which; widget w;
  set_widget_event_rep (string which, widget w);
  operator tree ();
};
#import event (set_widget_event, set_widget_event_rep)

struct set_language_event_rep: public event_rep {
  string which; bool& resize;
  set_language_event_rep (string which, bool& resize);
  operator tree ();
};
#import event (set_language_event, set_language_event_rep)

/******************************************************************************
* Structure events
******************************************************************************/

struct attach_window_event_rep: public event_rep {
  window win;
  attach_window_event_rep (window win);
  operator tree ();
};
#import event (attach_window_event, attach_window_event_rep)

struct position_event_rep: public event_rep {
  bool flag; SI ox, oy, w, h; gravity grav;
  position_event_rep ();
  position_event_rep (SI ox, SI oy, SI w, SI h, gravity grav);
  operator tree ();
};
tree as_tree (gravity grav);
ostream& operator << (ostream& out, gravity grav);
#import event (position_event, position_event_rep)

struct move_event_rep: public event_rep {
  move_event_rep ();
  operator tree ();
};
#import event (move_event, move_event_rep)

struct resize_event_rep: public event_rep {
  resize_event_rep ();
  operator tree ();
};
#import event (resize_event, resize_event_rep)

struct destroy_event_rep: public event_rep {
  destroy_event_rep ();
  operator tree ();
};
#import event (destroy_event, destroy_event_rep)

/******************************************************************************
* Input events
******************************************************************************/

struct keypress_event_rep: public event_rep {
  string key; time_t t;
  keypress_event_rep (string key, time_t t);
  operator tree ();
};
#import event (keypress_event, keypress_event_rep)

struct keyboard_focus_event_rep: public event_rep {
  bool flag; time_t t;
  keyboard_focus_event_rep (bool in_out_flag, time_t t);
  operator tree ();
};
#import event (keyboard_focus_event, keyboard_focus_event_rep)

struct mouse_event_rep: public event_rep {
  string type; SI x, y; time_t t; int status;
  mouse_event_rep (string type, SI x, SI y, time_t t, int status);
  bool pressed (string which);
  operator tree ();
};
#import event (mouse_event, mouse_event_rep)

struct alarm_event_rep: public event_rep {
  string message; time_t t;
  alarm_event_rep (string message, time_t t);
  operator tree ();
};
#import event (alarm_event, alarm_event_rep)

/******************************************************************************
* Output events
******************************************************************************/

struct clear_event_rep: public event_rep {
  SI x1, y1, x2, y2;
  clear_event_rep (SI x1, SI y1, SI x2, SI y2);
  operator tree ();
};
#import event (clear_event, clear_event_rep)

struct repaint_event_rep: public event_rep {
  SI x1, y1, x2, y2; bool& stop;
  repaint_event_rep (SI x1, SI y1, SI x2, SI y2, bool& stop);
  operator tree ();
};
#import event (repaint_event, repaint_event_rep)

/******************************************************************************
* Request some action
******************************************************************************/

struct update_event_rep: public event_rep {
  update_event_rep ();
  operator tree ();
};
#import event (update_event, update_event_rep)

struct invalidate_event_rep: public event_rep {
  bool all_flag;
  SI x1, y1, x2, y2;
  invalidate_event_rep ();
  invalidate_event_rep (SI x1, SI y1, SI x2, SI y2);
  operator tree ();
};
#import event (invalidate_event, invalidate_event_rep)

struct keyboard_grab_event_rep: public event_rep {
  bool flag; time_t t;
  keyboard_grab_event_rep (bool in_out_flag, time_t t);
  operator tree ();
};
#import event (keyboard_grab_event, keyboard_grab_event_rep)

struct mouse_grab_event_rep: public event_rep {
  bool flag; time_t t;
  mouse_grab_event_rep (bool in_out_flag, time_t t);
  operator tree ();
};
#import event (mouse_grab_event, mouse_grab_event_rep)

struct request_alarm_event_rep: public event_rep {
  event ev; time_t delay;
  request_alarm_event_rep (event ev, time_t delay);
  operator tree ();
};
#import event (request_alarm_event, request_alarm_event_rep)

/******************************************************************************
* Miscellaneous events
******************************************************************************/

struct find_child_event_rep: public event_rep {
  SI x, y; int& which;
  find_child_event_rep (SI x, SI y, int& which);
  operator tree ();
};
#import event (find_child_event, find_child_event_rep)

/******************************************************************************
* Modification of events
******************************************************************************/

event emit_keypress (keypress_event ev, string key);
event emit_mouse (mouse_event ev, string type, SI x, SI y);

#endmodule // basic_event
