void DumpPacket(uchar *pkt, int len)
{
	uchar ascBuffer[17];
	uchar ch, *pasc;
	int   idxAddr, idx;

	// Display Ethernet Head Information
	printf("Ethernet %02X:%02X:%02X:%02X:%02X:%02X to %02X:%02X:%02X:%02X:%02X:%02X, type %04X\n",
		pkt[6], pkt[7], pkt[8], pkt[9], pkt[10], pkt[11], // Source
		pkt[0], pkt[1], pkt[2], pkt[3], pkt[4], pkt[5],   // Destination
		(pkt[12] << 8) | pkt[13]);                        // Type

	// Display Ethernet Data Information
	for (idxAddr = 14; idxAddr < len;) {
		printf("%04X: ", idxAddr - 14);

		pasc = ascBuffer;
		for (idx = 0; (idx < 16) && (idxAddr < len); idx++) {
			ch = pkt[idxAddr++];
			printf("%c%02X", (idx == 8) ? '-' : ' ', ch);
			*pasc++ = ((ch >= 32) && (ch < 127)) ? ch : '.';
		}

		for (; idx < 16; idx++)
			printf("   ");
		*pasc = '\0';
		printf(" |%-16s|\n", ascBuffer);
	}
}
