<?php 

$pagetitle = $TWIGphrase["TWIG [Mail]"];
$section = $ns;

// Mailbox Sort Defs
$sortbyint = array( "date"=>1, "from"=>2, "subject"=>3, "to"=>4 );

Function mboxSelect( $stream = "yourmom", $first = "", $last = "") 
	{
  	global $mbox, $session, $config, $TWIGphrase;

  	if( $stream == "yourmom" ) { $stream = $mbox; }

  	$str = "<form action=\"" . $config["baseurl"] . "\" METHOD=POST>\n";
  	$str .= TWIGSession( "put" );
  	$str .= TWIGContext( "put", "mail", "main" );
  	$str .= "<input type=hidden name=startmsg value=\"1\">\n";
  	$str .= "<input type=hidden name=ts value=\"". mktime() . "\">\n";
  	$str .= $first;
  	$str .= "<select name=newmailbox>\n";

	$str .= TWIGmboxOptions( $mbox, $session["mailbox"] );

  	$str .= "</select>\n<input type=submit value=\"" . $TWIGphrase["Go"] . "\">\n";
  	$str .= "$last</form>\n";
  	
	return $str;
 	}

Function TWIGmboxOptions( $mbox, $sfolder = "" )
	{
  	global $config;

    	$subscribed = TWIGMailSubscribedFolders( $mbox, TWIGMailGetFolderString( $config["imap_server"], $config["imap_port"], "", "" ), "*" );
  
	if( !$subscribed ) { $subscribed = array(); }

	$inboxfold=TWIGMailGetFolderString($config["imap_server"], $config["imap_port"], "", "INBOX");
	$sentfold=TWIGMailGetFolderString($config["imap_server"], $config["imap_port"], "", $config["imap_path"] . GetPref( "sentfold", $dbconfig["prefs_table"], $config["defaults"]["mail"]["sentfold"]));
	$draftfold=TWIGMailGetFolderString( $config["imap_server"], $config["imap_port"], "", $config["imap_path"] . GetPref("draftfold", $dbconfig["prefs_table"], $config["defaults"]["mail"]["draftfold"]));

	for( $i = 0, $j = count( $subscribed ); $i < $j; $i++ )
		{
		if($subscribed[$i]==$inboxfold) {$foundinbox=1;}
		if($subscribed[$i]==$sentfold) {$foundsentbox=1;}
		if($subscribed[$i]==$draftfold) {$founddrafts=1;}
  		}

   	if(!$foundinbox) {$subscribed[]=$inboxfold;}
   	if(!$foundsentbox && $sentfold) {$subscribed[]=$sentfold;}
   	if(!$founddrafts && $draftfold) {$subscribed[]=$draftfold;}
  	@usort($subscribed, strcasecmp);

	for ($i=0, $j=count($subscribed); $i<$j; $i++)
		{
 		list( $mbserver, $mbport, $mbtype, $mb, $mbuser, $mbpass ) = TWIGMailParseFolderString( $subscribed[$i] );

   		if( $mb == $sfolder ) { $mbselected = " selected"; } else { $mbselected = ""; }

		$mbdisplay = TWIGMailGetDisplayName( $mb );

   		$str .= "<option$mbselected value=\"$mb\">";
   		$str .= $mbdisplay . "</option>\n";
  		}

	return $str;
	}

Function TWIGGetMailDisplayName( $name )
	{
	$nlist = TWIGMailParseAddresssList( $name, $config["fromdomain"] );

	$j = count( $nlist );

	for( $i = 0; $i < $j; $i++ )
		{
		if( $nlist[$i]->personal )
			{
			$ret .= $nlist[$i]->personal;
			}
		else
			{
			$ret .= $nlist[$i]->mailbox . "@" . $nlist[$i]->host;
			}

		if( $i + 1 < $j )
			{
			$ret .= ", ";
			}
		}

	return $ret;
	}

// this function is copyright allan noah <anoah@pfeiffer.edu> and licensed under the GPL.
Function TWIGDumpStructure($structure) 
	{
  	echo "<li>";
  	echo "Structure:<br>\n";

  	while( list( $key, $val ) = each( $structure ) ) 
		{
   		echo $key . " = " . $val . "<br>\n";
  		}

  	if( $structure->ifparameters )
		{
   		echo "<br>";
   		echo "Parameters:<br>\n";

   		while( list( $key, $val ) = each( $structure->parameters ) ) 
			{
    			echo $key . " = " . $val . "<br>\n";
	
	    		while( list( $key2, $val2 ) = each( $structure->parameters[$key] ) ) 
				{
     				echo $key2 . " = " . $val2 . "<br>\n";
    				}
   			}
  		}

  	if( $structure->ifdparameters )
		{
   		echo "<br>";
   		echo "DParameters:<br>\n";

   		while( list( $key, $val ) = each( $structure->dparameters ) ) 
			{
    			echo $key . " = " . $val . "<br>\n";

    			while( list( $key2, $val2 ) = each( $structure->dparameters[$key] ) ) 
				{
     				echo $key2 . " = " . $val2 . "<br>\n";
    				}
   			}
  		}

  	if( $structure->parts )
		{
   		echo "<ol>";

   		for( $pi = 0, $pj = count( $structure->parts ); $pi < $pj; $pi++ )
    			{
    			TWIGDumpStructure( $structure->parts[$pi] );
    			}

   		echo "</ol>";
  		}

  	echo "</li>";
	}

// Creates the $msginfo multi dimensional array, by looping through the message,
// calling itself, and TWIGGetSectionInfo. this big array is then used by 
// TWIGAttached*() functions to print stuff on the screen.
// this function is copyright allan noah <anoah@pfeiffer.edu> and licensed under the GPL.

Function TWIGGetMsgInfo( $structure, $section = "" )
	{
  	GLOBAL $tmpinfo;

  	$fooinfo = TWIGGetSectionInfo( $structure, 0 );

  	if( $structure->parts )
		{
    		for( $pi = 0, $pj = count( $structure->parts ); $pi < $pj; $pi++ ) 
			{
      			$pii = $pi + 1;

      			if( !$section )
				{
        			$sectiontmp = $pii;
      				}
      			elseif( $fooinfo["mimetype"] == "MULTIPART" )
				{
        			$sectiontmp = ereg_replace( "\.[0-9]*$", "", $section );
        			$sectiontmp = $sectiontmp . "." . $pii;
      				}
      			else 
				{
        			$sectiontmp = $section . "." . $pii;
      				}

      			TWIGGetMsgInfo($structure->parts[$pi],$sectiontmp);
    			}
  		}
  	else
		{
    		if( !$section )
			{
      			$section = 1;
    			}

    		$tmpinfo["$section"] = $fooinfo;
  		}

  	return $tmpinfo;
	}

// Called by TWIGGetMsgInfo()
// takes a structure generated by imap_fetchstructure, or a part[]
// of such a structure, and returns an array of what it finds.
// this function is needed because different mailers put the info in diff.
// places. function includes logic to determine if file should/can be inline
// this function is copyright allan noah <anoah@pfeiffer.edu> and licensed under the GPL.
Function TWIGGetSectionInfo( $structure, $nullok = 0 )
	{
	// Names of the primary Mime Types;
	// returned by php's imap functions
	$mime[0] = "TEXT";
	$mime[1] = "MULTIPART";
	$mime[2] = "MESSAGE";
	$mime[3] = "APPLICATION";
	$mime[4] = "AUDIO";
	$mime[5] = "IMAGE";
	$mime[6] = "VIDEO";
	$mime[7] = "OTHER";

 	// Names of Encoding Types;
 	$encoding[0]		= "7bit";
 	$encoding[1]		= "8bit";
 	$encoding[2]		= "binary";
 	$encoding[3]		= "base64";
 	$encoding[4]		= "quoted-printable";
 	$encoding[5]		= "unknown";

   	if( isset( $structure->encoding ) ) 
		{
     		$enctype = $encoding["$structure->encoding"];
     		$encnumber = $structure->encoding;
   		}
   	else
		{
     		if( $nullok ) { $enctype = FALSE; }
     		else{ $enctype="unknown"; }
   		}

   	if( isset( $structure->type ) ) 
		{ 
		$mimetype = $mime[($structure->type)]; 
		}
   	else
		{
     		if( $nullok ) { $mimetype = FALSE; }
     		else{ $mimetype = "TEXT"; }
   		}

   	if( isset( $structure->subtype ) ) 
		{ 
		$mimesubtype = strtoupper( $structure->subtype ); 
		}
   	else
		{
     		if( $nullok ){ $mimesubtype = FALSE; }
     		else{ $mimesubtype = "unknown"; }
   		}

   	if( isset( $structure->bytes ) ) 
		{ 
		$bytes = $structure->bytes; 
		}
   	else
		{
     		if( $nullok ) { $bytes = FALSE; }
     		else{ $bytes = "unknown"; }
   		}

   	if( isset( $structure->description ) ) 
		{ 
		$description = $structure->description;
		}
   	else
		{
     		if( $nullok ) { $description = FALSE; }
     		else{ $description = "unknown"; }
   	}

   	if( isset( $structure->disposition ) )
		{
		$disposition = $structure->disposition;
		}
   	else
		{
     		if( $nullok ) { $disposition = FALSE; }
     		else{ $disposition = "unknown"; }
   		}

   	if( $structure->ifparameters )
		{
       		while( list( $key, $val ) = each( $structure->parameters ) ) 
			{
        		if( strtoupper( $val->attribute ) == "NAME" || strtoupper( $val->attribute ) == "FILENAME" )
				{
         			$filename = $val->value;
        			}

        		if( strtoupper( $val->attribute ) == "CHARSET" )
				{
         			$charset = $val->value;
        			}
       			}
   		}

   	if( $structure->ifdparameters )
		{
       		while( list( $key, $val ) = each( $structure->dparameters ) ) 
			{
        		if( empty( $filename ) && ( strtoupper( $val->attribute ) == "NAME" || strtoupper( $val->attribute ) == "FILENAME" ) )
				{
         			$filename = $val->value;
        			}

        		if( empty( $charset ) && strtoupper( $val->attribute ) == "CHARSET" )
				{
         			$charset = $val->value;
        			}
       			}
   		}

   	$inline = 0;
   	$caninline = 0;
   	$graphic = 0;
   	$html = 0;
   	$downloadbar = 1;

   	if( $mimesubtype == "HTML" )
		{
     		$html = 1;
   		}
   	elseif( $mimesubtype == "PLAIN" )
		{
     		if( !$filename ) { $inline = 1; $caninline = 1; }
     		else{ $caninline = 1; }
   		}
   	
	if( !$filename )
		{
     		if( $nullok ) { $filename = FALSE; }
     		else{ $filename = "noname"; }
   		}

   	if( $mimesubtype == "PNG" || $mimesubtype == "JPEG" || $mimesubtype == "GIF" ) { $graphic = 1; $caninline = 1; }

   	$boo = array( "enctype"=>$enctype, "mimetype"=>$mimetype, "mimesubtype"=>$mimesubtype, "filename"=>$filename, "charset"=>$charset, "bytes"=>$bytes, "description"=>$description, "disposition"=>$disposition, "inline"=>$inline, "graphic"=>$graphic, "downloadbar"=>$downloadbar, "caninline"=>$caninline, "encoding"=>$encnumber, "html"=>$html );

   	return $boo;
	}

Function TWIGCleanHTML( $body = "" )
	{
	$abody = explode( "\n", str_replace( "\r\n", "\n", $body ) );

	while( list( $key, $value ) = each( $abody ) )
		{
		$aline = explode( ">", $value );

		while( list( $lkey, $lvalue ) = each( $aline ) )
			{
			$aline[$lkey] = eregi_replace( "<(.?)form", "<\\1twig_cleaned_form_tag", $aline[$lkey] );
			$aline[$lkey] = eregi_replace( "<(.?)embed", "<\\1twig_cleaned_embed_tag", $aline[$lkey] );
			$aline[$lkey] = eregi_replace( "<(.?)java", "<\\1twig_cleaned_java_tag", $aline[$lkey] );
			$aline[$lkey] = eregi_replace( "<(.?)object", "<\\1twig_cleaned_object_tag", $aline[$lkey] );
			$aline[$lkey] = eregi_replace( "<(.?)style", "<\\1twig_cleaned_style_tag", $aline[$lkey] );
			$aline[$lkey] = eregi_replace( "<(.*)on(.*)=(.*)([:space:]*)(.*)", "<\\1twig_cleaned_on\\2_tag\\5", $aline[$lkey] );
			$aline[$lkey] = eregi_replace( "<(.*)=(.*)script:(.*)([:space:]*)(.*)", "<\\1=twig_cleaned_\\2script_tag\\5", $aline[$lkey] );
			}

		$abody[$key] = implode( ">", $aline );
		}

	$newbody = implode( "\n", $abody );
    
    	return $newbody;
	}

Function TWIGView( $type = "get" )
	{
    	GLOBAL $view;
    
    	if( $type == "get" ) { $str = "twig_view=" . URLEncode( serialize( $view ) ); }
    	else { $str = "<input type=hidden name=twig_viewvalue=\"" . URLEncode( serialize( $view ) ) . "\">\n"; }
    
    	return $str;
	}

Function TWIGGetView()
	{
    	GLOBAL $twig_view;
    
    	$view = unserialize( URLDecode( stripslashes( $twig_view ) ) );
    
    	return $view;
	}

Function TWIGAttachMDNLine( $msginfo )
	{
     	GLOBAL $config, $path, $mbox, $session, $TWIGphrase, $login;

	if( !TWIGCheckACL( $login["username"], 4013, TWIGConvertAccess( "read" ) ) )
		{
		return;
		}	

	$headerobject = @TWIGMailHeader( $mbox, $path, 0, 0, $config["fromdomain"] );

	$mdnpref = GetPref( "mdn_mode", $dbconfig["prefs_table"], $config["defaults"]["mail"]["mdn_mode"] );

	$domdn = 0;

	if( $mdnpref > 0 )
		{
		if( is_object( $headerobject ) ) 
			{
			if( $headerobject->Unseen == "U" ) 
				{ 
			       	$headers = TWIGMailFetchHeader( $mbox, $path );

				if( strstr( $headers, "Disposition-Notification-To" ) )
					{
					$foo = explode( "\n", $headers );
	
					while( list( $k, $v ) = each( $foo ) ) 
						{
						$header = explode( ": ", $v );
	
						if( count( $header ) > 1 && $header[0] == "Disposition-Notification-To" ) 
							{
							$domdn = 1;
							$mdnto = $header[1];
							}
						}
					}
				}
			}
		}

	if( $domdn )
		{
		switch( $mdnpref )
			{
			case 0:
				break;
			case 1:
				$str = "<form action=\"" . $config["baseurl"] . "\" METHOD=POST>";
			  	$str .= TWIGSession( "put" );
			  	$str .= TWIGContext( "put", "mail", "mdn" );
				$str .= "<input type=hidden name=path value=\"" . $path . "\">";
		  		$str .= "<input type=hidden name=ts value=\"". mktime() . "\">";
				$str .= HTMLSpecialChars( $mdnto );
				$str .= "<input type=submit name=submitbutton[readreceipt] value=\"" . $TWIGphrase["Send RR now"] . "\">";
				$str .= "</form>";
				echo TWIGPrintMailHeaderLine( $TWIGphrase["Read Receipt"], $str );

				break;
			case 2:
				echo TWIGPrintMailHeaderLine( $TWIGphrase["Read Receipt"], $TWIGphrase["A Read Reciept has been automatically returned to the sender"] );

				$InMsgView = 1;

				include( "features/mail/mail.mdn.inc.php3" );
							
				break;
			}
		}
	}

Function TWIGAttachMailHeaders( $msginfo, $printview = FALSE ) 
	{
    	GLOBAL $config, $path, $mbox, $session, $TWIGphrase, $img, $login;

    	if( $session["showheaders"] ) 
		{
        	$headers = TWIGMailFetchHeader( $mbox, $path );

        	if( $config["debug"] < 10 ) 
			{
			$foo = explode( "\n", $headers );

			while( list( $k, $v ) = each( $foo ) ) 
				{
				$header = explode( ": ", $v );

				if( count( $header ) > 1 ) 
					{
                                	$bigString = "";

                                	for( $k = 1; $k < count( $header ); $k++ )
						{
                                    		$bigString .= $header[$k] . ": ";
                                		}

                                	$bigString = ereg_replace( ": $","",$bigString);
        				echo TWIGPrintMailHeaderLine( HTMLSpecialChars($header[0]), HTMLSpecialChars($bigString) );
					}
				elseif( trim( $v ) ) 
					{
        				echo TWIGPrintMailHeaderLine( "&nbsp;", HTMLSpecialChars($v) );
					}
				}
			}
		else 
			{ // show a simple, unformatted set of headers
			echo "<tr><td colspan=2 bgcolor=\"" . $config["cellcolor"] . "\" NOWRAP><pre>";
			echo HTMLSpecialChars($headers);
			echo "</pre></td></tr>";
			}

		if( !$printview ) 
			{
			echo TWIGPrintMailHeaderLine( $TWIGphrase["Full Headers"], TWIGLink( $TWIGphrase["Hide Headers"], "mail", "msgview", "path=" . $path, "", array( array( "item"=>"showheaders", "value"=>"0" ) ) ) . "</font></td>" );
       			}

    		}
    	else 
		{ // we are asked to show only the regular headers...
        	$headers = TWIGMailHeader( $mbox, $path, 0, 0, $config["fromdomain"] );

        	echo TWIGPrintMailHeaderLine( $TWIGphrase["Date"], TWIGdate($config["longdateformat"] . " " . TWIGGetTimeFormat(), $headers->udate ) );
        
        	$adi = 0;
        	while( $adi < count( $headers->from ) ) 
			{
            		$from = $headers->from;
            		$addr = $from[$adi]->mailbox . "@" . $from[$adi]->host;

            		$temp .= TWIGDecodeMimeString( $from[$adi]->personal ) . " &lt;" . TWIGFindHTML($addr) ."&gt; ";

            		if( TWIGCheckACL( $login["username"], 2003, TWIGConvertAccess("read") ) ) 
				{
                		$temp .= twigLink( "<img src=$img[address] alt=\"" . $TWIGphrase["add to contacts"] . "\" border=0>", "contacts", "new", "data[fullname]=" . URLEncode( $from[$adi]->personal ) . "&data[email]=" . URLEncode( $addr ) );
            			}

            		$temp .= "<br>";
            		$adi++;
        		}

        	echo TWIGPrintMailHeaderLine( $TWIGphrase[From], $temp );

	       	echo TWIGPrintMailHeaderLine( $TWIGphrase["To"], TWIGFindHTML( HTMLSpecialChars( str_replace( ",", ", ", TWIGDecodeMimeString( $headers->toaddress ) ) ) ) );

        	if( $headers->ccaddress )
			{
           		echo TWIGPrintMailHeaderLine( $TWIGphrase["CC"], TWIGFindHTML( HTMLSpecialChars( str_replace( ",", ", ", TWIGDecodeMimeString( $headers->ccaddress ) ) ) ) );
        		}

        	if( $headers->reply_toaddress && $headers->reply_toaddress != $headers->from ) 
			{
            		echo TWIGPrintMailHeaderLine( $TWIGphrase["Reply-To"], TWIGFindHTML( HTMLSpecialChars( TWIGDecodeMimeString($headers->reply_toaddress) ) ) );
        		}

        	if( $headers->Subject ) 
			{
            		echo TWIGPrintMailHeaderLine( $TWIGphrase["Subject"], HTMLSpecialChars( TWIGDecodeMimeString($headers->Subject) ) );
        		}
        	else
			{
            		echo TWIGPrintMailHeaderLine( $TWIGphrase["Subject"], $TWIGphrase["[no subject]"] );
        		}

		if( !$printview ) 
			{
			echo TWIGPrintMailHeaderLine( $TWIGphrase["Full Headers"], TWIGLink( $TWIGphrase["Display Headers"], "mail", "msgview", "path=" . $path, "", array( array( "item"=>"showheaders", "value"=>"1" ) ) ) . "</font></td>" );
			}
    		}
	}

Function TWIGPrintMailHeaderLine( $left = "", $right = "" )
	{
    	GLOBAL $config;

	if( !$left ) { $left = "&nbsp;"; }
	if( !$right ) { $right = "&nbsp;"; }

    	echo "<tr><td align=right valign=top bgcolor='" . $config["cellheadcolor"] . "' NOWRAP>";
   	echo "<font face='" . $config["cellfont"] . "' color='" . $config["cellheadtext"] . "' size='" . $config["textfontsize"] . "'>";

    	if( eregi( "^\&nbsp;$", $left ) )
		{
        	echo "$left";
    		}
    	else
		{
        	echo "<b>$left</b>: ";
    		}

    	echo "</font></td>";

    	echo "<td valign=top bgcolor='" . $config["cellcolor"] . "' width=100%>";
   	echo "<font face='" . $config["cellfont"] . "' color='" . $config["celltext"] . "' size='" . $config["textfontsize"] . "'>";
    	echo $right;
    	echo "</font></td></tr>\n";
	}

Function TWIGAttachedDLBar( $msginfo ) 
	{
    	GLOBAL $config, $path, $view, $TWIGphrase;
   
    	$dlbarcount = 0;

    	while( list( $section, $info ) = each( $msginfo ) )
		{
        	if( $info["downloadbar"] ) { $dlbarcount++; }
    		}

    	reset( $msginfo );
   
    	if( $dlbarcount == 0 )
		{
        	return;
    		}
    	elseif( $dlbarcount == 1 && $msginfo[1]["inline"] == 1 )
		{
        	return;
    		}
   
    	if( $dlbarcount > 1 ) { $word = $TWIGphrase["Attachments"]; }
    	else { $word = $TWIGphrase["Attachment"]; }
   
    	echo "\n<tr><td rowspan=" . $dlbarcount . " align=right valign=top bgcolor=\"" . $config["cellheadcolor"] . "\" NOWRAP>";
    	echo "<font face=\"" . $config["cellfont"] . "\" size=" . $config["textfontsize"] . " color=\"" . $config["cellheadtext"] . "\">";
    	echo "<b>" . $word . "</b>: </font></td>\n";
   
    	while( list( $section, $info ) = each( $msginfo ) ) 
		{
        	if( $info["downloadbar"] ) 
			{
            		echo  "<td bgcolor=\"" . $config["cellcolor"] . "\">";
            		echo "<font face=\"" . $config["cellfont"] . "\" size=" . $config["textfontsize"] . " color=\"" . $config["celltext"] . "\">";
            		echo "Part " . $section . " " . TWIGLink ($info["filename"], "mail","msgview","attachment=1&inline=0&path=" . $path . "&ns=" . $section);
            		echo " (" . $info["mimetype"] . "/" . $info["mimesubtype"] . " " . $info["enctype"] . " " . $info["bytes"] ." bytes) ";
       
            		if( $info["html"] )
				{
                		echo " <a href=\"" . $config["baseurl"] . "?attachment=1&inline=1&path=" . $path . "&ns=" . $section . twigsession() . twigcontext("get","mail","msgview") . "\" target=_blank>" . $TWIGphrase["View"] . "</a> ";
            			}
            		elseif( $info["caninline"] )
				{
                		if( isset( $view[$section] ) )
					{
                    			if( $view[$section] == 1 )
						{
                        			$view[$section] = 0;
                        			echo TWIGLink( $TWIGphrase["Hide"], "mail", "msgview", twigview() . "&path=" . $path . "&ns=" . $section );
                        			$view[$section] = 1;
                    				}
                    			else
						{
                        			$view[$section] = 1;
                        			echo TWIGLink( $TWIGphrase["View"], "mail", "msgview", twigview() . "&path=" . $path . "&ns=" . $section );
                        			$view[$section] = 0;
                    				}
                			}
                		elseif( $info["inline"] == 1 )
					{
                    			$view[$section] = 0;
                    			echo TWIGLink( $TWIGphrase["Hide"], "mail", "msgview", twigview() . "&path=" . $path . "&ns=" . $section );
                    			$view[$section] = 1;
                			}
                		else
					{
                    			$view[$section] = 1;
                    			echo TWIGLink( $TWIGphrase["View"], "mail", "msgview", twigview() . "&path=" . $path . "&ns=" . $section );
                    			$view[$section] = 0;
                			}
            			}

            		echo "</font></td>\n</tr>\n";
        		}
    		}
	}

// loops on the $msginfo 2-d array, and if the section can/should
// be shown inline, it decodes+prints or links into the body.
Function TWIGAttachedBody( $msginfo )
	{
  	GLOBAL $linewrap, $config, $path, $view, $mbox;

  	while( list( $section, $info ) = each( $msginfo ) )
		{
      		if( $info["graphic"] && $view[$section] ) 
			{
          		echo "<tr><td colspan=2 bgcolor=\"" . $config["cellcolor"] . "\">" . $config["hr"] . "</TD></TR>\n";
		        echo "<tr><td colspan=2 bgcolor=\"" . $config["cellcolor"] . "\">";
		        echo "<font color=\"" . $config["celltext"] . "\">";
		        echo "<img src=\"" . $config["baseurl"] . "/" . $info["filename"] . "?attachment=1&inline=1";
		        echo "&path=" . $path . "&ns=" . $section . twigsession() . twigcontext() . "\">";
		        echo "</font></td></tr>\n";
      			}
      		elseif( !$info["graphic"] && $info["caninline"] )
			{
          		if( $view[$section] || ( !isset( $view[$section] ) && $info["inline"] ) ) 
				{
              			echo "<tr><td colspan=2 bgcolor=\"" . $config["cellcolor"] . "\">" . $config["hr"] . "</TD></TR>\n";
        
              			$prebody = TWIGMailFetchBody( $mbox, $path, $section );
              			$body = TWIGDecodeBody( $prebody, $info );

              			if( strtoupper( $info["mimesubtype"] ) == "PLAIN" ) 
					{
                  			echo "<tr><td colspan=2 bgcolor=\"" . $config["cellcolor"] . "\">";
                  			echo "<font color=\"" . $config["celltext"] . "\"><tt><pre>";
        
                  			$alllines = explode( "\n", $body );
    
                  			$li=0;

                  			while( $li < count( $alllines ) ) 
						{
                 				if( $linewrap ) { $thisline = textwrap( $alllines[$li], $linewrap, "\n" ); }
                      				else { $thisline = $alllines[$li]; }  

                      				$thisline = TWIGFindHTML( HTMLSpecialChars( $thisline ) );

                      				echo $thisline . "\n";

                      				$li++;
                  				}
     
                  			echo "</pre></tt></font></td></tr>\n";
              				}
          			}
      			}
  		}
	}

Function TWIGPrintMsgInfo( $msginfo )
	{
  	while( list( $key5, $val5 ) = each( $msginfo ) )
		{
    		while( list( $key6, $val6 ) = each( $val5 ) ) 
			{
      			echo $key5 .",". $key6 ."=" .$val6 ."<br>";
    			}
  		}
	}

Function TWIGDecodeBody( $prebody, $info="" )
	{
  	GLOBAL $config;

	switch( $info["encoding"] )
		{
		case 3:
			$body = TWIGMailDecodeBase64( $prebody );

			break;
		case 4:
			$body = quoted_printable_decode( $prebody );
	
			break;
		default:
			$body = $prebody;
		}

	if( $config["globalcharset"] ) 
		{ 
 		$charset = strtolower($info["charset"]);
 		if( $config["globalcharset"] != $charset ) 
			{
 			$from = $config["charactersets"][$charset];
			$to =  $config["charactersets"][$config["globalcharset"]];

			if( $from && $to ) { $body = convert_cyr_string( $body, $from, $to ); }	
			}
		}

	return $body;
	}

Function TWIGGenerateMailDate( $time = 0 )
	{
	if( $time == 0 ) { $time = mktime(); }

	$ret = gmdate( "D, j M Y H:i:s", $time ) . " -0000";

	return $ret;
	}

Function TWIGMailExpandFolderStructure( $folder )
	{
	GLOBAL $config;

	$hiarch = explode( $config["mail_folder_delimiter"], $folder );

	$i = count( $hiarch ) - 1;

	return array( $i, $hiarch );
	}

Function TreeLoadMailBoxList( $mailboxlist, $varname, $varvalue )
	{
	GLOBAL $config;

	$maxlevel = 0;

	$tree[0][0] = 1;
	$tree[0][1] = "MailBox";
	$tree[0][2] = "";
	$tree[0][3] = "";
	$tree[0][4] = 0;

	$mblist = $mailboxlist;

	@sort($mblist);

	$first = $config["baseurl"]. "?ts=" . mktime();
	$last = TWIGContext( "get", "mail", "main" ) . "&" . $varname . "=" . $varvalue;

 	$treecnt = 1;
 	for( $i = 1, $j = count( $mblist ) + 1; $i < $j; $i++ )
  		{
  		$data = TWIGMailParseFolderString( $mblist[$i-1] );

  		list( $depth, $hiarch ) = TWIGMailExpandFolderStructure( $data[3] );

  		$others[0] = array( "item"=>"mailbox", "value"=>$data[3]);

  		for( $i2 = 0; $i2 <= $depth; $i2++ )
   			{
   			if( $nodecheck ) 
				{ 
				$nodecheck .= $config["mail_folder_delimiter"] . $hiarch[$i2]; 
				}
    			else 
				{ 
				$nodecheck .= $hiarch[$i2]; 
				}

   			if( ( !$storedlevels[$hiarch[$i2] ] ) || ( !ereg( "^" . $nodecheck, $storedlevels[$hiarch[$i2]] ) ) )
    				{
    				$storedlevels[$hiarch[$i2]] = $data[3];
    				$tree[$treecnt][0] = $i2 + 2;
    				$tree[$treecnt][1] = "<font size=-1>" . $hiarch[$i2] . "</font>";

    				if( $depth == $i2 ) { $tree[$treecnt][2] = $first . TWIGSession( "get", $others ) . $last; }
				$tree[$treecnt][3] = "";
    				$tree[$treecnt][4] = 0;
    				$treecnt ++;
    				}
   			}

   		$nodecheck = "";
   		if( $maxlevel < ( $depth + 3 ) ) { $maxlevel = $depth + 3; }
  		}

	return array( $maxlevel, $tree );
	}

if( $attachment ) { include("features/mail/mail.attachment.inc.php3"); }

if( !$session["mailtree"] ) { $session["mailtree"] = "0|"; }
if( $mailtree ) { $session["mailtree"] = $mailtree; }

$included["mail/mail.inc.php3"] = 1;
?>
