<?php	// TWIG		Search Feature Module for ToDo ?>
<?php 
 TWIGLoadLanguageFile( "features/todo/strings/", "", $config["language"] );

 if( !$global )
 	{
	echo "<form action=" . $config["baseurl"] . " method=\"post\">\n";
	echo TWIGSession( "put" );
	echo TWIGContext( "put" );

	$entry = 0;

	$tableheaders = array( TWIGPhrase( "Item" ), "&nbsp", TWIGPhrase( "Criteria" ) );

 	if( !isset( $search_groups ) )
 		{
		$search_groups = GetPref( "dgroup", $dbconfig["todo_prefs_table"], $config["defaults"]["todo"]["dgroup"] );
		}
 	$temp = "<select name=\"search_groups\">\n";
 	$temp .= TWIGGroupsSelect( $login["username"], $search_groups, 1 );
 	$temp .= "</select>\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . TWIGPhrase( "Group" ) . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

	$temp = "<input type=\"text\" name=\"search_name\" value=" . stripslashes( $search_name ) . ">\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . TWIGPhrase( "Name" ) . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

	$temp = "<input type=\"text\" name=\"search_description\" value=" . stripslashes( $search_description ) . ">\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . TWIGPhrase( "Description" ) . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

 	$temp = "<select name=\"search_priority\">\n";
	if( !$search_priority ) { $search_priority = GetPref( "priority", $dbconfig["todo_prefs_table"], $config["defaults"]["todo"]["priority"] ); }
	for ($p=0; $p<=10; $p++)
		{
		if( $p == $search_priority ) { $selected = "selected"; } else { $selected = ""; }
 		$temp .= " <option $selected>$p</option>\n";
		}
  	$temp .= "</select>\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . TWIGPhrase( "Priority" ) . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

	$checked_completed[$search_completed] = "SELECTED";

	$temp = "<select name=search_completed>\n";
	$temp .= " <option value=0 $checked_completed[0]>" . TWIGPhrase( "New" ) . "</option>";
 	$temp .= " <option value=1 $checked_completed[1]>" . TWIGPhrase( "Complete" ) . "</option>";
 	$temp .= " <option value=2 $checked_completed[2]>" . TWIGPhrase( "Working" ) . "</option>";
 	$temp .= " <option value=3 $checked_completed[3]>" . TWIGPhrase( "Pending" ) . "</option>";
 	$temp .= " <option value=4 $checked_completed[4]>" . TWIGPhrase( "Canceled" ) . "</option>";
  	$temp .= "</select>\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . TWIGPhrase( "Status" ) . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

 	list( $search_afterHour, $search_afterMinute, $extra_afterDays ) = TWIGTimeCleanup( $search_afterHour, $search_afterMinute, $search_afterAMPM );
 	list( $search_afterYear, $search_afterMonth, $search_afterDay )  = TWIGDateCleanup( $search_afterYear, $search_afterMonth, $search_afterDay, $extra_afterDays );
 	$temp = TWIGTimeSelector( "search_after", $search_afterHour, $search_afterMinute );
 	$temp .= TWIGDateSelector( "search_after", $search_afterYear, $search_afterMonth, $search_afterDay );
 	$tablecontents[$entry] = array( array( "contents"=>"<b>" . TWIGPhrase( "Due after" ) . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

 	list( $search_beforeHour, $search_beforeMinute, $extra_beforeDays ) = TWIGTimeCleanup( $search_beforeHour, $search_beforeMinute, $search_beforeAMPM );
 	list( $search_beforeYear, $search_beforeMonth, $search_beforeDay )  = TWIGDateCleanup( $search_beforeYear, $search_beforeMonth, $search_beforeDay, $extra_beforeDays);
 	$temp = TWIGTimeSelector( "search_before", $search_beforeHour, $search_beforeMinute );
 	$temp .= TWIGDateSelector( "search_before", $search_beforeYear, $search_beforeMonth, $search_beforeDay );
 	$tablecontents[$entry] = array( array( "contents"=>"<b>" . TWIGPhrase( "Due before" ) . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

	echo "<table><tr><td>\n";
	echo TWIGGenerateTable( $tableheaders, $tablecontents );
	echo "</td></tr>";
	echo "<tr><td align=\"center\"><input type=\"submit\" name=\"search\" value=\"" . TWIGPhrase( "Search" ) . "\">";

	echo "</td></tr></table>\n";
	echo "</form>\n";
	}

 unset( $tableheaders );
 unset( $tablecontents );

 if( $search ) 
	{
	// Yeah, do the search

	// Build a WHERE clause
	$searchquery = "";
	if( $search_name )
		{
		$searchquery .= "AND item LIKE '%$search_name%' ";
		}
	if( $search_description )
		{
		$searchquery .= "AND description LIKE '%$search_description%' ";
		}
	if( isset( $search_groups ) )
		{
		$searchquery .= "AND " . TWIGGroupsCreateSQLGroupQuery( $login["username"], array( $search_groups ) );
		}
	if( $searchquery )
		{
		// If there is no $searchquery (ie we failed all the above) then why bother searching?

		// Strip the first four characters because we know they are 'AND '
		$searchquery = substr( $searchquery, 4 );

		$sortorder = array( "item"=>"item", "group"=>"groupid" );
		$sortordernum = array( "item"=>0, "groupid"=>1 );
		if( !$session["nsortby"] ) { $session["nsortby"] = $sortorder[GetPref( "sortby", $dbconfig["todo_prefs_table"], $config["defaults"]["todo"]["sortby"] )]; }
		if( !$session["nsortby"] ) { $session["nsortby"] = "item"; }
		$sortway = array( "", " DESC" );
		if( !$session["nsortbyway"] ) { $session["nsortbyway"] = $sortway[GetPref( "sortorder", $dbconfig["todo_prefs_table"], $config["defaults"]["todo"]["sortorder"] )]; }

		$hilights = array( array( "", "" ), array( "", "" ) );
		$hilights[$sortordernum[$session["nsortby"]]] = array( "[", "]" );

		if( $session["nsortbyway"] ) { $tmpsortbyway = ""; } else { $tmpsortbyway = " DESC"; }

		$soitem = array( array( "item"=>"nsortby", "value"=>"item" ), array( "item"=>"nsortbyway", "value"=>$tmpsortbyway ) );
		$sogroup = array( array( "item"=>"nsortby", "value"=>"groupid" ), array( "item"=>"nsortbyway", "value"=>$tmpsortbyway ) );

		$tableheaders = array( 	twigLink( $hilights[0][0] . TWIGPhrase( "item" ) . $hilights[0][1], "todo", "", "", "", $soitem ),
					"&nbsp;",
					twigLink( $hilights[1][0] . TWIGPhrase( "group" ) . $hilights[1][1], "todo", "", "", "", $sogroup ),
					);

		$query = "SELECT * FROM " . $dbconfig["todo_table"] . " WHERE (" . $searchquery . ") ORDER BY " . $session["nsortby"] . $session["nsortbyway"];
		$result = dbQuery( $query );
		TWIGDebug( $query );

		if( !$startmsg ) { $startmsg = 1; }
		$pagesize = GetPref( "pagesize", $dbconfig["todo_prefs_table"], $config["defaults"]["todo"]["pagesize"] );

		if( $submitbutton["selectall"] ) { $marked = " CHECKED"; } else { $marked = ""; }

		$total = dbNumRows( $result );
		if( ( $pagesize == 0 ) || ( $startmsg + $pagesize > $total ) ) { $highitem = $total; } else { $highitem = $startmsg + $pagesize - 1; }

		for( $i = $startmsg - 1; $i < $highitem; $i++ ) 
			{
			$data = dbResultArray( $result, $i );


			$tablecontents[$i] = array(	twigLink( TWIGImage( $img["project"], TWIGPhrase( "View Note" ) ) . $data["item"], "todo", "view", "ItemID=" . $data["id"] ), 
							"&nbsp;",
							twigLink( TWIGGroupsGetName( $data["groupid"] ), "todo", "", "session[$featureGroup]=" . $data["groupid"] ),
							);
			}
?>
<table width="100%" border=0 cellspacing=0 cellpadding=0 class="formbody">
 <tr>
  <td valign="top" class="tabletitle">
   <b>
    <?php echo TWIGLink( TWIGPhrase( "ToDo" ), "todo" ); ?>
   </b>
  </td>
 </tr>
 <tr>
  <td>
   &nbsp;
  </td>
 </tr>
 <tr>
  <td valign="top">
   <?php
   if( $tablecontents )
	{
	echo TWIGGenerateTable( $tableheaders, $tablecontents, "", "95%", "center" );
	}
   else
	{
	echo "<b><i>" . TWIGPhrase( "No matches" ) . "</i></b>\n";
	}
   ?>
  </td>
 </tr>
 <tr>
  <td>
   &nbsp;
  </td>
 </tr>
</table>
<?php
		}
	}

?>
