//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// uContext.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Thu Jul  7 13:08:01 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Aug  8 08:53:23 2004
// Update Count     : 11
// 

#include <uC++.h>
#include <cstdio>

// WARNING: Do not use uCout or uCerr in uSave or uRestore as they cause a
// recursive context switch (BAD!).

class uCoProcessorCxt1 : public uContext {
    static int uUniqueKey;
  public:
    uCoProcessorCxt1() : uContext( &uUniqueKey ) {};
    void uSave() {
	printf( "uCoProcessorCxt1::uSave\n" );
    }
    void uRestore() {
	printf( "uCoProcessorCxt1::uRestore\n" );
    }
}; // uCoProcessorCxt1

int uCoProcessorCxt1::uUniqueKey = 0;

class uCoProcessorCxt2 : public uContext {
  public:
    void uSave() {
	printf( "uCoProcessorCxt2::uSave\n" );
    }
    void uRestore() {
	printf( "uCoProcessorCxt2::uRestore\n" );
    }
}; // uCoProcessorCxt2

void uMain::main() {
    uCoProcessorCxt1 cpCxt11, cpCxt12;
    uCoProcessorCxt2 cpCxt21, cpCxt22;

    for ( int i = 0; i < 5; i += 1 ) {
	uYield();
    } // for
} // uMain::main
    
// Local Variables: //
// compile-command: "u++ -O uContext.cc" //
// End: //
