//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr and Nikita Borisov 1995
// 
// u++.cc -- 
// 
// Author           : Nikita Borisov
// Created On       : Tue Apr 28 15:26:27 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug 12 08:24:29 2004
// Update Count     : 764
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#include <iostream>
#include <fstream>					// ifstream
#include <cstdio>					// perror
#include <cstdlib>					// getenv, putenv
#include <string>					// STL version
#include <unistd.h>					// execvp

using std::ifstream;
using std::cerr;
using std::endl;
using std::string;


//#define __U_DEBUG_H__


void shuffle( const char *args[], int S, int E, int N ) {
    // S & E index 1 passed the end so adjust with -1
#ifdef __U_DEBUG_H__
    cerr << "shuffle:" << S << " " << E << " " << N << endl;
#endif // __U_DEBUG_H__
    for ( int j = E-1 + N; j > S-1 + N; j -=1 ) {
#ifdef __U_DEBUG_H__
	cerr << "\t" << j << " " << j-N << endl;
#endif // __U_DEBUG_H__
	args[j] = args[j-N];
    } // for
} // shuffle


int main( int argc, char *argv[] ) {
    string Version( VERSION );				// current version number from CONFIG
    string Major( "0" ), Minor( "0" ), Patch( "0" );	// default version numbers
    int posn1 = Version.find( "." );			// find the divider between major and minor version numbers
    if ( posn1 == -1 ) {				// not there ?
	Major = Version;
    } else {
	Major = Version.substr( 0, posn1 );
	int posn2 = Version.find( ".", posn1 + 1 );	// find the divider between minor and patch numbers
	if ( posn2 == -1 ) {				// not there ?
	    Minor = Version.substr( posn1 );
	} else {
	    Minor = Version.substr( posn1 + 1, posn2 - posn1 - 1 );
	    Patch = Version.substr( posn2 + 1 );
	} // if
    } // if

    string installlibdir( INSTALLLIBDIR );		// fixed location of the cpp and cfa-cpp commands
    string installincdir( INSTALLINCDIR );		// fixed location of include files

    string tvendor( TVENDOR );
    string tos( TOS );
    string tcpu( TCPU );

    string Multi( MULTI );

    string heading;					// banner printed at start of cfa compilation
    string arg;						// current command-line argument during command-line parsing
    string Bprefix;					// path where g++ looks for compiler command steps

    string compiler_path( CCAPP );			// path/name of C compiler
    string compiler_name;				// name of C compiler

    bool link = true;					// linking as well as compiling
    bool verbose = false;				// -v flag
    bool quiet = false;					// -quiet flag
    bool debug = true;					// -debug flag
    bool multi = false;					// -multi flag
    bool upp_flag = false;				// -U++ flag
    bool cpp_flag = false;				// -E or -M flag, preprocessor only
    bool Yield = false;					// -yield flag (name "yield" already taken)
    bool verify = false;				// -verify flag
    bool profile = false;				// -profile flag
    bool debugging = false;				// -g flag

    const char *args[argc + 100];			// u++ command line values, plus some space for additional flags
#if __GNUC__==3 && __GNUC_MINOR__==2
    int sargs = 2;					// starting location for arguments in args list
    int nargs = sargs;					// number of arguments in args list; 0 => command name, 1 => CPP_FLAG
#else
    int sargs = 1;					// starting location for arguments in args list
    int nargs = sargs;					// number of arguments in args list; 0 => command name
#endif

    const char *libs[argc + 20];			// non-user libraries must come separately, plus some added libraries and flags
    int nlibs = 0;

    string tmppath;
    string mvdpath;
    string bfdincdir;
    string motifincdir;
    string motiflibdir;
    string uxincdir;
    string uxlibdir;
    string mvdincdir;
    string mvdlibdir;
    string perfctrincdir;
    string perfctrlibdir;
    string token;
    int executable = 0;

#ifdef __U_DEBUG_H__
    cerr << "u++:" << endl;
#endif // __U_DEBUG_H__

#if __GNUC__==3 && __GNUC_MINOR__==2
    args[1] = "-D__U_CPP_FLAGS__";			// indicate start of user cpp flags
#endif

    // process command-line arguments

    for ( int i = 1; i < argc; i += 1 ) {
#ifdef __U_DEBUG_H__
	cerr << "argv[" << i << "]:\"" << argv[i] << "\"" << endl;
#endif // __U_DEBUG_H__
	arg = argv[i];					// convert to string value
#ifdef __U_DEBUG_H__
	cerr << "arg:\"" << arg << "\"" << endl;
#endif // __U_DEBUG_H__
	if ( arg.substr(0,1) == "-" ) {
	    // pass through arguments

	    if ( arg == "-Xlinker" ) {			// GNU linker pass through
		args[nargs] = argv[i];			// pass the argument along
		nargs += 1;
		i += 1;
		args[nargs] = argv[i];			// pass the argument along
		nargs += 1;

	    // uC++ specific arguments

	    } else if ( arg == "-U++" ) {
		upp_flag = true;			// strip the -U++ flag
		link = false;
		args[nargs] = "-E";			// replace the argument with -E
		nargs += 1;
	    } else if ( arg == "-multi" ) {
		multi = true;				// strip the multi flag
	    } else if ( arg == "-nomulti" ) {
		multi = false;				// strip the nomulti flag
	    } else if ( arg == "-debug" ) {
		debug = true;				// strip the debug flag
	    } else if ( arg == "-nodebug" ) {
		debug = false;				// strip the nodebug flag
	    } else if ( arg == "-quiet" ) {
		quiet = true;				// strip the quiet flag
	    } else if ( arg == "-noquiet" ) {
		quiet = false;				// strip the noquiet flag
	    } else if ( arg == "-yield" ) {
		Yield = true;				// strip the yield flag
	    } else if ( arg == "-noyield" ) {
		Yield = false;				// strip the noyield flag
	    } else if ( arg == "-verify" ) {
		verify = true;				// strip the verify flag
	    } else if ( arg == "-noverify" ) {
		verify = false;				// strip the noverify flag
	    } else if ( arg == "-profile" ) {
                profile = true;                         // strip the profile flag
            } else if ( arg == "-noprofile" ) {
                profile = false;                        // strip the noprofile flag
	    } else if ( arg == "-compiler" ) {
		// use the user specified compiler
		i += 1;
		compiler_path = argv[i];
#if __GNUC__==3 && __GNUC_MINOR__==2
		args[nargs] = ( *new string( string("-D__U_COMPILER__=") + compiler_path ) ).c_str();
		nargs += 1;
#else
		if ( putenv( (char *)( *new string( string( "__U_COMPILER__=" ) + argv[i]) ).c_str() ) != 0 ) {
		    cerr << argv[0] << " Error cannot set environment variable." << endl;
		    exit( -1 );
		} // if
#endif

	    // C++ specific arguments

	    } else if ( arg == "-v" ) {
		verbose = true;				// verbosity required
		args[nargs] = argv[i];			// pass the argument along
		nargs += 1;
	    } else if ( arg == "-g" ) {
		debugging = true;			// symbolic debugging required
		args[nargs] = argv[i];			// pass the argument along
		nargs += 1;
	    } else if ( arg.substr(0,2) == "-B" ) {
		Bprefix = arg.substr(2);		// strip the -B flag
		args[nargs] = ( *new string( string("-D__U_GCC_BPREFIX__=") + Bprefix ) ).c_str();
		nargs += 1;
	    } else if ( arg.substr(0,2) == "-b" ) {
		if ( arg.length() == 2 ) {		// separate argument ?
		    i += 1;
		    arg += argv[i];			// concatenate argument
		} // if
#if __GNUC__==3 && __GNUC_MINOR__==2
		args[nargs] = ( *new string( arg ) ).c_str(); // pass the argument along
		nargs += 1;
		args[nargs] = ( *new string( string("-D__U_GCC_MACHINE__=") + arg ) ).c_str();
#else
		shuffle( args, sargs, nargs, 1 );	// make room at front of argument list
		args[sargs] = ( *new string( arg ) ).c_str(); // pass the argument along
		if ( putenv( (char *)( *new string( string( "__U_GCC_MACHINE__=" ) + arg ) ).c_str() ) != 0 ) {
		    cerr << argv[0] << " Error cannot set environment variable." << endl;
		    exit( -1 );
		} // if
		sargs += 1;
#endif
		nargs += 1;
	    } else if ( arg.substr(0,2) == "-V" ) {
		if ( arg.length() == 2 ) {		// separate argument ?
		    i += 1;
		    arg += argv[i];			// concatenate argument
		} // if
#if __GNUC__==3 && __GNUC_MINOR__==2
		args[nargs] = ( *new string( arg ) ).c_str(); // pass the argument along
		nargs += 1;
		args[nargs] = ( *new string( string("-D__U_GCC_VERSION__=") + arg ) ).c_str();
#else
		shuffle( args, sargs, nargs, 1 );	// make room at front of argument list
		args[sargs] = ( *new string( arg ) ).c_str(); // pass the argument along
		if ( putenv( (char *)( *new string( string( "__U_GCC_VERSION__=" ) + arg ) ).c_str() ) != 0 ) {
		    cerr << argv[0] << " Error cannot set environment variable." << endl;
		    exit( -1 );
		} // if
		sargs += 1;
#endif
		nargs += 1;
	    } else if ( arg == "-c" || arg == "-S" || arg == "-E" || arg == "-M" || arg == "-MM" ) {
		args[nargs] = argv[i];			// pass the argument along
		nargs += 1;
		if ( arg == "-E" || arg == "-M" || arg == "-MM" ) {
		    cpp_flag = true;			// cpp only
		} // if
		link = false;                           // no linkage required
	    } else if ( arg.substr(1,1) == "l" ) {
		// if the user specifies a library, load it after user code
		libs[nlibs] = argv[i];
		nlibs += 1;
	    } else if ( arg == "-o" ) {			// TEMPORARY: should be a way to find this name in the application
		args[nargs] = argv[i];
		nargs += 1;
		i += 1;
		args[nargs] = argv[i];
		nargs += 1;
		executable = i;
	    } else {
		// concatenate any other arguments
		args[nargs] = argv[i];
		nargs += 1;
	    } // if
	} else {
	    // concatenate other arguments
	    args[nargs] = argv[i];
	    nargs += 1;
	} // if
    } // for

#ifdef __U_DEBUG_H__
    cerr << "args:";
    for ( int i = 1; i < nargs; i += 1 ) {
	cerr << " " << args[i];
    } // for
    cerr << endl;
#endif // __U_DEBUG_H__

    if ( cpp_flag && upp_flag ) {
	cerr << argv[0] << " Error cannot use -E and -U++ flags together." << endl;
	exit( -1 );
    } // if

    string d;
    if ( debug ) {
	d = "-d";
    } // if

    string m;
    if ( multi ) {
	if ( Multi == "FALSE" ) {			// system support multiprocessor ?
	    cerr << argv[0] << ": Warning -multi flag not support on this system." << endl;
	} else {
	    m = "-m";
	} // if
    } // if

    // profiling
    
    if ( profile ) {					// read MVD configuration information needed for compilation and/or linking.
	char *mvdpathname = getenv( "MVDPATH" );	// get MVDPATH environment variable
	
	if ( mvdpathname == NULL ) {
	    cerr << argv[0] << ": Warning environment variable MVDPATH not set. Profiling disabled." << endl;
	    profile = false;
	} else {
	    mvdpath = mvdpathname;			// make string
	    if ( mvdpathname[strlen( mvdpathname ) - 1] != '/' ) { // trailing slash ?
		mvdpath += "/";				// add slash
	    } // if

	    // Define lib and include directories 
	    uxincdir = mvdpath + "X11R6/include";
	    uxlibdir = mvdpath + "X11R6/lib";
	
	    // Read Motif and MVD lib and include directories from the MVD CONFIG file
	
	    string configFilename = mvdpath + "CONFIG";
	    ifstream configFile( configFilename.c_str() );

	    if ( ! configFile.good() ) {
		cerr << argv[0] << ": Warning could not open file \"" << configFilename << "\". Profiling disabled." << endl;
		profile = false;
	    } else {
		const int dirnum = 8;
		struct {
		    char *dirkind;
		    int used;
		    string *dirname;
		} dirs[dirnum] = {
		    { "INSTALLINCDIR", 1, &mvdincdir },
		    { "INSTALLLIBDIR", 1, &mvdlibdir },
		    { "BFDINCLUDEDIR", 1, &bfdincdir },
		    { "MOTIFINCLUDEDIR", 1, &motifincdir },
		    { "MOTIFLIBDIR", 1, &motiflibdir },
		    { "PERFCTRINCLUDEDIR", 1, &perfctrincdir },
		    { "PERFCTRLIBDIR", 1, &perfctrlibdir },
		    { "TMPDIR", 1, &tmppath },
		};
		string dirkind, equal, dirname;
		int cnt, i;
		int numOfDir = 0;

		for ( cnt = 0 ; cnt < dirnum; cnt += 1 ) { // names can appear in any order
		    for ( ;; ) {
			configFile >> dirkind;
		  if ( configFile.eof() || configFile.fail() ) goto fini;
			for ( i = 0; i < dirnum && dirkind != dirs[i].dirkind; i += 1 ); // linear search
		      if ( i < dirnum ) break;		// found a line to be parsed
		    } // for
		    configFile >> equal;
		  if ( configFile.eof() || configFile.fail() || equal != "=" ) break;
		    getline( configFile, dirname );	// could be empty
		  if ( configFile.eof() || ! configFile.good() ) break;
		    int p = dirname.find_first_not_of( " " ); // find position of 1st blank character
		    if ( p == -1 ) p = dirname.length(); // any characters left ?
		    dirname = dirname.substr( p );	// remove leading blanks

		    numOfDir += dirs[i].used;		// handle repeats
		    dirs[i].used = 0;
		    *dirs[i].dirname = dirname;
#ifdef __U_DEBUG_H__
		    cerr << dirkind << equal << dirname << endl;
#endif // __U_DEBUG_H__
		} // for
	      fini:
		if ( numOfDir != dirnum ) {
		    profile = false;
		    cerr << argv[0] << ": Warning file \"" << configFilename << "\" corrupt.  Profiling disabled." << endl;
		} // if
	    } // if
	} // if
    } // if

    if ( link ) {
	// shift arguments to make room for special libraries

	int pargs = 0;
	if ( profile ) {
	    pargs += 11;				// N profiler arguments added at beginning
	    if ( ! debugging ) pargs += 1;		// no -g flag ? make room for one
	} // if
	shuffle( args, sargs, nargs, pargs );
	nargs += pargs;

	if ( profile ) {
	    // link the profiling library before the user code
	    args[sargs] = "-u";
	    sargs += 1;
	    args[sargs] = "__cyg_profile_func_enter";	// force profiler library to be loaded from archive
	    sargs += 1;
	    args[sargs] = "-u";
	    sargs += 1;
	    args[sargs] = "U_EXACTPROFILINGSW";		// force profiler start-up widgets to be loaded from archive
	    sargs += 1;
	    args[sargs] = "-u";
	    sargs += 1;
	    args[sargs] = "U_STATSPROFILINGSW";		// force profiler start-up widgets to be loaded from archive
	    sargs += 1;
	    args[sargs] = "-u";
	    sargs += 1;
	    args[sargs] = "U_OTHERPROFILINGSW";		// force profiler start-up widgets to be loaded from archive
	    sargs += 1;
	    args[sargs] = "-u";
	    sargs += 1;
	    args[sargs] = "U_HARDWAREPROFILINGSW";	// force profiler start-up widgets to be loaded from archive
	    sargs += 1;
	    args[sargs] = ( *new string( mvdlibdir + "/uProfile"  + m + d + ".a" ) ).c_str();
	    sargs += 1;
	    if ( ! debugging ) {			// add -g if not specified
		args[sargs] = "-g";
		sargs += 1;
	    } // if
	} // if    

	// link with the correct version of the kernel module

	if ( tos == "irix" ) {
	    args[nargs] = "-Xlinker";			// g++ trick to pass through next flag to linker
	    nargs += 1;
	    args[nargs] = "-dont_warn_unused";		// library not used for resolving any symbol
	    nargs += 1;
	    args[nargs] = "-u";
	    nargs += 1;
	    args[nargs] = "_uspsema";			// force semaphore library to be loaded from archive
	    nargs += 1;
	} // if

	// link with the correct version of the kernel module

	args[nargs] = ( *new string( installlibdir + "/uKernel" + m + d + ".a" ) ).c_str();
	nargs += 1;
	args[nargs] = ( *new string( installlibdir + "/uScheduler" + m + d + ".a" ) ).c_str();
	nargs += 1;

	// link with the correct version of the local debugger module

	args[nargs] = ( *new string( installlibdir + "/uLocalDebugger" + m + "-d.a" ) ).c_str();
	nargs += 1;

	// link with the correct version of the library module

	args[nargs] = ( *new string( installlibdir + "/uLibrary" + m + d + ".a" ) ).c_str();
	nargs += 1;

	// link with the correct version of the profiler module

	args[nargs] = ( *new string( installlibdir + "/uProfilerFunctionPointers" + ".o" ) ).c_str();
	nargs += 1;
#if 0
	if ( tvendor == "ibm" ) {
	    // Prevent linker from reordering code in memory.  This is
	    // necessary for the correct implementation of time slicing and
	    // shared memory management.

	    args[nargs] = "-Xlinker";			// g++ trick to pass through next flag to linker
	    nargs += 1;
	    args[nargs] = "-bnoobjreorder";
	    nargs += 1;
	} // if
#endif // 0

	// any machine specific libraries

	libs[nlibs] = "-ldl";				// calls to dlsym/dlerror
	nlibs += 1;

	if ( profile ) {
	    args[nargs] = ( *new string( string("-L") + mvdlibdir ) ).c_str();
	    nargs += 1;
	    args[nargs] = ( *new string( string("-L") + uxlibdir ) ).c_str();
	    nargs += 1;
	    if ( motiflibdir.length() != 0 ) {
		args[nargs] = ( *new string( string("-L") + motiflibdir ) ).c_str();
		nargs += 1;
	    } // if
	    args[nargs] = "-L/usr/X11R6/lib";
	    nargs += 1;
	    args[nargs] = ( *new string( string("-Wl,-R,") + uxlibdir + ( motiflibdir.length() != 0 ? string(":") + motiflibdir : "" ) ) ).c_str();
	    nargs += 1;
	    libs[nlibs] = "-lXm";
	    nlibs += 1;
	    libs[nlibs] = "-lX11";
	    nlibs += 1;
	    libs[nlibs] = "-lXt";
	    nlibs += 1;
	    libs[nlibs] = "-lSM";
	    nlibs += 1;
	    libs[nlibs] = "-lICE";
	    nlibs += 1;
	    libs[nlibs] = "-lXpm";
	    nlibs += 1;
	    libs[nlibs] = "-lXext";
	    nlibs += 1;
	    libs[nlibs] = ( *new string( string( "-luX" ) + m + d ) ).c_str();
	    nlibs += 1;
	    libs[nlibs] = "-lm";
	    nlibs += 1;
	    libs[nlibs] = "-lbfd";
	    nlibs += 1;
	    libs[nlibs] = "-liberty";
	    nlibs += 1;

	    if ( tos == "solaris" ) {			// link in performance counter
                libs[nlibs] = "-lcpc";
                nlibs += 1;
	    } // if
	    if ( tos == "linux" && tcpu == "i386" ) {	// link in performance counter
		if ( perfctrlibdir.length() != 0 ) {
		    args[nargs] = ( *new string( string( "-L" ) + perfctrlibdir ) ).c_str();
		    nargs += 1;
		    args[nargs] = ( *new string( string("-Wl,-R,") + perfctrlibdir ) ).c_str();
		    nargs += 1;
		} // if 
                libs[nlibs] = "-lperfctr";
                nlibs += 1;
	    } // if
	    if ( tos == "linux" && tcpu == "ia64" ) {	// link in libunwind for backtraces
                libs[nlibs] = "-lunwind";
                nlibs += 1;
	    } // if
	} // if

	if ( tos == "solaris" ) {
	    libs[nlibs] = "-lnsl";
	    nlibs += 1;
	    libs[nlibs] = "-lsocket";
	    nlibs += 1;
	} // if
    } // if

    // add the directory that contains the include files to the list of
    // arguments after any user specified include directives

    args[nargs] = ( *new string( string("-I") + installincdir ) ).c_str();
    nargs += 1;

    if ( profile ) {
	args[nargs] = ( *new string( string( "-I" ) + mvdincdir ) ).c_str();
	nargs += 1;
	args[nargs] = ( *new string( string( "-I" ) + uxincdir ) ).c_str();
	nargs += 1;
	if ( motifincdir.length() != 0 ) {
	    args[nargs] = ( *new string( string( "-I" ) + motifincdir ) ).c_str();
	    nargs += 1;
	} // if 
	if ( bfdincdir.length() != 0 ) {
	    args[nargs] = ( *new string( string( "-I" ) + bfdincdir ) ).c_str();
	    nargs += 1;
	} // if 
    } // if

    // add the correct set of flags based on the type of compile this is

    args[nargs] = ( *new string( string("-D__U_CPLUSPLUS__=") + Major ) ).c_str();
    nargs += 1;
    args[nargs] = ( *new string( string("-D__U_CPLUSPLUS_MINOR__=") + Minor ) ).c_str();
    nargs += 1;
    args[nargs] = ( *new string( string("-D__U_CPLUSPLUS_PATCH__=") + Patch ) ).c_str();
    nargs += 1;

    if ( cpp_flag ) {
	args[nargs] = "-D__U_CPP__";
	nargs += 1;
    } // if

    if ( upp_flag ) {
	args[nargs] = "-D__U_UPP__";
	nargs += 1;
    } // if

    if ( multi ) {
	args[nargs] = "-D__U_MULTI__";
	nargs += 1;
	heading += " (multiple processor)";
    } else {
	heading += " (single processor)";
    } // if

    if ( debug ) {
	heading += " (debug)";
	args[nargs] = "-D__U_DEBUG__";
	nargs += 1;
    } else {
	heading += " (no debug)";
    } // if

    if ( Yield ) {
	heading += " (yield)";
	args[nargs] = "-D__U_YIELD__";
	nargs += 1;
    } else {
	heading += " (no yield)";
    } // if

    if ( verify ) {
	heading += " (verify)";
	args[nargs] = "-D__U_VERIFY__";
	nargs += 1;
    } else {
	heading += " (no verify)";
    } // if

    if ( profile ) {
        heading += " (profile)";
	args[nargs] = ( *new string( "-finstrument-functions" ) ).c_str();
	nargs += 1;
        args[nargs] = "-D__U_PROFILE__";
        nargs += 1;
	if ( executable && link ) {
	    args[nargs] = ( *new string( string("-D__U_EXECUTABLE_FILENAME__=\"") + argv[executable] + string("\"") ) ).c_str();
	    nargs += 1;
	} // if
    } else {
        heading += " (no profile)";
    } // if

#if defined( TLS )					// Thread Local Storage ?
    args[nargs] = "-D__U_TLS__";
    nargs += 1;
#endif // U_TLS

    if ( Bprefix.length() == 0 ) {
	Bprefix = installlibdir;
	args[nargs] = ( *new string( string("-D__U_GCC_BPREFIX__=") + Bprefix ) ).c_str();
	nargs += 1;
    } // if

    // execute the compilation command

    args[0] = compiler_path.c_str();			// set compiler command for exec
    // find actual name of the compiler independent of the path to it
    int p = compiler_path.find_last_of( '/' );		// scan r -> l for first '/'
    if ( p == -1 ) {
	compiler_name = compiler_path;
    } else {
	compiler_name = *new string( compiler_path.substr( p + 1 ) );
    } // if

    if ( compiler_name.substr(0,3) == "g++" ) {		// allow suffix on g++ name
        // TEMPORARY: gcc 3.2.3 code gen problem
	args[nargs] = "-fno-optimize-sibling-calls"; 
	nargs += 1;
	args[nargs] = "-no-integrated-cpp"; 
	nargs += 1;
	args[nargs] = ( *new string( string("-B") + Bprefix + "/" ) ).c_str();
	nargs += 1;
    } else {
	cerr << argv[0] << ": Error compiler " << compiler_name << " not supported." << endl;
	exit( -1 );
    } // if

    // Add the uC++ definitions of vendor, cpu and os names to the compilation
    // command.

    args[nargs] = ( *new string( string("-D__") + TVENDOR + "__" ) ).c_str();
    nargs += 1;
    args[nargs] = ( *new string( string("-D__") + TCPU + "__" ) ).c_str();
    nargs += 1;
    args[nargs] = ( *new string( string("-D__") + TOS + "__" ) ).c_str();
    nargs += 1;

    for ( int i = 0; i < nlibs; i += 1 ) {		// copy non-user libraries after all user libraries
	args[nargs] = libs[i];
	nargs += 1;
    } // for

    args[nargs] = NULL;					// terminate with NULL

#ifdef __U_DEBUG_H__
    cerr << "nargs: " << nargs << endl;
    cerr << "args:" << endl;
    for ( int i = 0; args[i] != NULL; i += 1 ) {
	cerr << " \"" << args[i] << "\"" << endl;
    } // for
#endif // __U_DEBUG_H__

    if ( ! quiet ) {
	cerr << "uC++ " << "Version " << Version << heading << endl;
    } // if

    if ( verbose ) {
	if ( argc == 2 ) exit( 0 );			// if only the -v flag is specified, do not invoke g++

	for ( int i = 0; args[i] != NULL; i += 1 ) {
	    cerr << args[i] << " ";
	} // for
	cerr << endl;
    } // if

    // execute the command and return the result

    execvp( args[0], (char *const *)args );		// should not return
    perror( "uC++ Translator error: u++ level, execvp" );
    exit( -1 );
} // main

// Local Variables: //
// compile-command: "gmake install" //
// End: //
