function [L,U,p,q] = cs_lu (A,tol)
%CS_LU sparse LU factorization, with fill-reducing ordering.
%   [L,U,p] = cs_lu(A) factorizes A(p,:) into L*U using no fill-reducing
%   ordering.
%
%   [L,U,p] = cs_lu(A,tol) factorizes A(p,:) into L*U using no fill-reducing
%   ordering.  Entries on the diagonal are given preference in partial pivoting.
%
%   [L,U,p,q] = cs_lu(A) factorizes A(p,q) into L*U using a fill-reducing
%   ordering q = cs_amd(A,1).
%
%   [L,U,p,q] = cs_lu(A,tol) factorizes A(p,q) into L*U, using a fill-reducing
%   ordering q = cs_amd(A,0).  Entries on the diagonal are given preference in
%   partial pivoting.
%
%   With a pivot tolerance tol, the entries in L have magnitude 1/tol or less.
%   tol = 1 is the default (normal partial pivoting).  tol = 0 ensures p = q.
%   0<tol<1 is relaxed partial pivoting; the diagonal is selected if it is
%   >= tol * max(abs(A(:,k))).
%
%   See also CS_AMD, LU, UMFPACK, AMD, COLAMD.

%   Copyright 2006, Timothy A. Davis.
%   http://www.cise.ufl.edu/research/sparse

error ('cs_lu mexFunction not found') ;
