/* umockdev-run.c generated by valac 0.34.2, the Vala compiler
 * generated from umockdev-run.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <stdio.h>
#include <errno.h>
#include "config.h"
#include <umockdev.h>
#include <glib/gstdio.h>
#include <sys/socket.h>
#include <sys/wait.h>

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);


extern gchar** opt_device;
gchar** opt_device = NULL;
extern gchar** opt_ioctl;
gchar** opt_ioctl = NULL;
extern gchar** opt_script;
gchar** opt_script = NULL;
extern gchar** opt_unix_stream;
gchar** opt_unix_stream = NULL;
extern gchar** opt_evemu_events;
gchar** opt_evemu_events = NULL;
extern gchar** opt_program;
gchar** opt_program = NULL;
extern gboolean opt_version;
gboolean opt_version = FALSE;
extern GPid child_pid;
GPid child_pid = 0;

void child_sig_handler (gint sig);
gint _vala_main (gchar** args, int args_length1);
static void _child_sig_handler_sighandler_t (gint signal);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[8] = {{"device", 'd', 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_device, "Load an umockdev-record device description into the testbed. Can be sp" \
"ecified multiple times.", "filename"}, {"ioctl", 'i', 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_ioctl, "Load an umockdev-record ioctl dump into the testbed. Can be specified " \
"multiple times.", "devname=ioctlfilename"}, {"script", 's', 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_script, "Load an umockdev-record script into the testbed. Can be specified mult" \
"iple times.", "devname=scriptfilename"}, {"unix-stream", 'u', 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_unix_stream, "Load an umockdev-record script for a mocked Unix stream socket. Can be" \
" specified multiple times.", "socket_path=scriptfilename"}, {"evemu-events", 'e', 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_evemu_events, "Load an evemu .events file into the testbed. Can be specified multiple" \
" times.", "devname=eventsfilename"}, {"", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &opt_program, "", ""}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &opt_version, "Output version information and exit"}, {NULL}};

void child_sig_handler (gint sig) {
	gint _tmp0_ = 0;
	GPid _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	_tmp0_ = sig;
	g_debug ("umockdev-run.vala:61: umockdev-run: caught signal %i, propagating to c" \
"hild\n", _tmp0_);
	_tmp1_ = child_pid;
	_tmp2_ = sig;
	_tmp3_ = kill ((pid_t) _tmp1_, _tmp2_);
	if (_tmp3_ != 0) {
		FILE* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		GPid _tmp6_ = 0;
		gint _tmp7_ = 0;
		const gchar* _tmp8_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = sig;
		_tmp6_ = child_pid;
		_tmp7_ = errno;
		_tmp8_ = g_strerror (_tmp7_);
		fprintf (_tmp4_, "umockdev-run: unable to propagate signal %i to child %i: %s\n", _tmp5_, (gint) _tmp6_, _tmp8_);
	}
}


static void _child_sig_handler_sighandler_t (gint signal) {
	child_sig_handler (signal);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* oc = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	gboolean _tmp9_ = FALSE;
	gchar* preload = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	UMockdevTestbed* testbed = NULL;
	UMockdevTestbed* _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gchar** _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	gchar** _tmp54_ = NULL;
	gint _tmp54__length1 = 0;
	gchar** _tmp73_ = NULL;
	gint _tmp73__length1 = 0;
	gchar** _tmp92_ = NULL;
	gint _tmp92__length1 = 0;
	gchar** _tmp111_ = NULL;
	gint _tmp111__length1 = 0;
	gint status = 0;
	struct sigaction act = {0};
	struct sigaction _tmp119_ = {0};
	struct sigaction _tmp120_ = {0};
	sigset_t _tmp121_ = {0};
	struct sigaction _tmp122_ = {0};
	gint _tmp123_ = 0;
	struct sigaction _tmp124_ = {0};
	gint _tmp125_ = 0;
	struct sigaction _tmp126_ = {0};
	gint _tmp127_ = 0;
	struct sigaction _tmp128_ = {0};
	gint _tmp129_ = 0;
	struct sigaction _tmp130_ = {0};
	gint _tmp131_ = 0;
	GPid _tmp132_ = 0;
	gint _tmp133_ = 0;
	GPid _tmp134_ = 0;
	gint _tmp135_ = 0;
	gboolean _tmp136_ = FALSE;
	gint _tmp139_ = 0;
	gboolean _tmp140_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new ("-- program [args..]");
	oc = _tmp0_;
	_tmp1_ = oc;
	g_option_context_set_summary (_tmp1_, "Run a program under an umockdev testbed.");
	_tmp2_ = oc;
	g_option_context_add_main_entries (_tmp2_, options, NULL);
	{
		GOptionContext* _tmp3_ = NULL;
		_tmp3_ = oc;
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = args;
		_tmp7__length1 = args_length1;
		_tmp8_ = _tmp7_[0];
		fprintf (_tmp4_, "Error: %s\nRun %s --help for how to use this program\n", _tmp6_, _tmp8_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (oc);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (oc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp9_ = opt_version;
	if (_tmp9_) {
		FILE* _tmp10_ = NULL;
		_tmp10_ = stdout;
		fprintf (_tmp10_, "%s\n", VERSION);
		result = 0;
		_g_option_context_free0 (oc);
		return result;
	}
	_tmp11_ = g_getenv ("LD_PRELOAD");
	_tmp12_ = g_strdup (_tmp11_);
	preload = _tmp12_;
	_tmp13_ = preload;
	if (_tmp13_ == NULL) {
		gchar* _tmp14_ = NULL;
		_tmp14_ = g_strdup ("");
		_g_free0 (preload);
		preload = _tmp14_;
	} else {
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		_tmp15_ = preload;
		_tmp16_ = g_strconcat (_tmp15_, ":", NULL);
		_g_free0 (preload);
		preload = _tmp16_;
	}
	_tmp17_ = preload;
	_tmp18_ = g_strconcat (_tmp17_, "libumockdev-preload.so.0", NULL);
	_tmp19_ = _tmp18_;
	g_setenv ("LD_PRELOAD", _tmp19_, TRUE);
	_g_free0 (_tmp19_);
	_tmp20_ = umockdev_testbed_new ();
	testbed = _tmp20_;
	_tmp21_ = opt_device;
	_tmp21__length1 = _vala_array_length (opt_device);
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp21_;
		path_collection_length1 = _tmp21__length1;
		for (path_it = 0; path_it < _tmp21__length1; path_it = path_it + 1) {
			gchar* _tmp22_ = NULL;
			gchar* path = NULL;
			_tmp22_ = g_strdup (path_collection[path_it]);
			path = _tmp22_;
			{
				gchar* record = NULL;
				{
					const gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					_tmp23_ = path;
					g_file_get_contents (_tmp23_, &_tmp24_, NULL, &_inner_error_);
					_g_free0 (record);
					record = _tmp24_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					FILE* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					GError* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp25_ = stderr;
					_tmp26_ = path;
					_tmp27_ = e;
					_tmp28_ = _tmp27_->message;
					fprintf (_tmp25_, "Error: Cannot open %s: %s\n", _tmp26_, _tmp28_);
					result = 1;
					_g_error_free0 (e);
					_g_free0 (record);
					_g_free0 (path);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				__finally1:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_free0 (record);
					_g_free0 (path);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
				{
					UMockdevTestbed* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					_tmp29_ = testbed;
					_tmp30_ = record;
					umockdev_testbed_add_from_string (_tmp29_, _tmp30_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch2_g_error;
					}
				}
				goto __finally2;
				__catch2_g_error:
				{
					GError* e = NULL;
					FILE* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					GError* _tmp33_ = NULL;
					const gchar* _tmp34_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp31_ = stderr;
					_tmp32_ = path;
					_tmp33_ = e;
					_tmp34_ = _tmp33_->message;
					fprintf (_tmp31_, "Error: Invalid record file %s: %s\n", _tmp32_, _tmp34_);
					result = 1;
					_g_error_free0 (e);
					_g_free0 (record);
					_g_free0 (path);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				__finally2:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_free0 (record);
					_g_free0 (path);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
				_g_free0 (record);
				_g_free0 (path);
			}
		}
	}
	_tmp35_ = opt_ioctl;
	_tmp35__length1 = _vala_array_length (opt_ioctl);
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp35_;
		i_collection_length1 = _tmp35__length1;
		for (i_it = 0; i_it < _tmp35__length1; i_it = i_it + 1) {
			gchar* _tmp36_ = NULL;
			gchar* i = NULL;
			_tmp36_ = g_strdup (i_collection[i_it]);
			i = _tmp36_;
			{
				gchar** parts = NULL;
				const gchar* _tmp37_ = NULL;
				gchar** _tmp38_ = NULL;
				gchar** _tmp39_ = NULL;
				gint parts_length1 = 0;
				gint _parts_size_ = 0;
				gchar** _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				_tmp37_ = i;
				_tmp39_ = _tmp38_ = g_strsplit (_tmp37_, "=", 2);
				parts = _tmp39_;
				parts_length1 = _vala_array_length (_tmp38_);
				_parts_size_ = parts_length1;
				_tmp40_ = parts;
				_tmp40__length1 = parts_length1;
				if (_tmp40__length1 != 2) {
					FILE* _tmp41_ = NULL;
					_tmp41_ = stderr;
					fprintf (_tmp41_, "Error: --ioctl argument must be devname=filename\n");
					result = 1;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				{
					UMockdevTestbed* _tmp42_ = NULL;
					gchar** _tmp43_ = NULL;
					gint _tmp43__length1 = 0;
					const gchar* _tmp44_ = NULL;
					gchar** _tmp45_ = NULL;
					gint _tmp45__length1 = 0;
					const gchar* _tmp46_ = NULL;
					_tmp42_ = testbed;
					_tmp43_ = parts;
					_tmp43__length1 = parts_length1;
					_tmp44_ = _tmp43_[0];
					_tmp45_ = parts;
					_tmp45__length1 = parts_length1;
					_tmp46_ = _tmp45_[1];
					umockdev_testbed_load_ioctl (_tmp42_, _tmp44_, _tmp46_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch3_g_error;
					}
				}
				goto __finally3;
				__catch3_g_error:
				{
					GError* e = NULL;
					FILE* _tmp47_ = NULL;
					gchar** _tmp48_ = NULL;
					gint _tmp48__length1 = 0;
					const gchar* _tmp49_ = NULL;
					gchar** _tmp50_ = NULL;
					gint _tmp50__length1 = 0;
					const gchar* _tmp51_ = NULL;
					GError* _tmp52_ = NULL;
					const gchar* _tmp53_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp47_ = stderr;
					_tmp48_ = parts;
					_tmp48__length1 = parts_length1;
					_tmp49_ = _tmp48_[1];
					_tmp50_ = parts;
					_tmp50__length1 = parts_length1;
					_tmp51_ = _tmp50_[0];
					_tmp52_ = e;
					_tmp53_ = _tmp52_->message;
					fprintf (_tmp47_, "Error: Cannot install %s for device %s: %s\n", _tmp49_, _tmp51_, _tmp53_);
					result = 1;
					_g_error_free0 (e);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				__finally3:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (i);
			}
		}
	}
	_tmp54_ = opt_script;
	_tmp54__length1 = _vala_array_length (opt_script);
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp54_;
		i_collection_length1 = _tmp54__length1;
		for (i_it = 0; i_it < _tmp54__length1; i_it = i_it + 1) {
			gchar* _tmp55_ = NULL;
			gchar* i = NULL;
			_tmp55_ = g_strdup (i_collection[i_it]);
			i = _tmp55_;
			{
				gchar** parts = NULL;
				const gchar* _tmp56_ = NULL;
				gchar** _tmp57_ = NULL;
				gchar** _tmp58_ = NULL;
				gint parts_length1 = 0;
				gint _parts_size_ = 0;
				gchar** _tmp59_ = NULL;
				gint _tmp59__length1 = 0;
				_tmp56_ = i;
				_tmp58_ = _tmp57_ = g_strsplit (_tmp56_, "=", 2);
				parts = _tmp58_;
				parts_length1 = _vala_array_length (_tmp57_);
				_parts_size_ = parts_length1;
				_tmp59_ = parts;
				_tmp59__length1 = parts_length1;
				if (_tmp59__length1 != 2) {
					FILE* _tmp60_ = NULL;
					_tmp60_ = stderr;
					fprintf (_tmp60_, "Error: --script argument must be devname=filename\n");
					result = 1;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				{
					UMockdevTestbed* _tmp61_ = NULL;
					gchar** _tmp62_ = NULL;
					gint _tmp62__length1 = 0;
					const gchar* _tmp63_ = NULL;
					gchar** _tmp64_ = NULL;
					gint _tmp64__length1 = 0;
					const gchar* _tmp65_ = NULL;
					_tmp61_ = testbed;
					_tmp62_ = parts;
					_tmp62__length1 = parts_length1;
					_tmp63_ = _tmp62_[0];
					_tmp64_ = parts;
					_tmp64__length1 = parts_length1;
					_tmp65_ = _tmp64_[1];
					umockdev_testbed_load_script (_tmp61_, _tmp63_, _tmp65_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch4_g_error;
					}
				}
				goto __finally4;
				__catch4_g_error:
				{
					GError* e = NULL;
					FILE* _tmp66_ = NULL;
					gchar** _tmp67_ = NULL;
					gint _tmp67__length1 = 0;
					const gchar* _tmp68_ = NULL;
					gchar** _tmp69_ = NULL;
					gint _tmp69__length1 = 0;
					const gchar* _tmp70_ = NULL;
					GError* _tmp71_ = NULL;
					const gchar* _tmp72_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp66_ = stderr;
					_tmp67_ = parts;
					_tmp67__length1 = parts_length1;
					_tmp68_ = _tmp67_[1];
					_tmp69_ = parts;
					_tmp69__length1 = parts_length1;
					_tmp70_ = _tmp69_[0];
					_tmp71_ = e;
					_tmp72_ = _tmp71_->message;
					fprintf (_tmp66_, "Error: Cannot install %s for device %s: %s\n", _tmp68_, _tmp70_, _tmp72_);
					result = 1;
					_g_error_free0 (e);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				__finally4:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (i);
			}
		}
	}
	_tmp73_ = opt_unix_stream;
	_tmp73__length1 = _vala_array_length (opt_unix_stream);
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp73_;
		i_collection_length1 = _tmp73__length1;
		for (i_it = 0; i_it < _tmp73__length1; i_it = i_it + 1) {
			gchar* _tmp74_ = NULL;
			gchar* i = NULL;
			_tmp74_ = g_strdup (i_collection[i_it]);
			i = _tmp74_;
			{
				gchar** parts = NULL;
				const gchar* _tmp75_ = NULL;
				gchar** _tmp76_ = NULL;
				gchar** _tmp77_ = NULL;
				gint parts_length1 = 0;
				gint _parts_size_ = 0;
				gchar** _tmp78_ = NULL;
				gint _tmp78__length1 = 0;
				_tmp75_ = i;
				_tmp77_ = _tmp76_ = g_strsplit (_tmp75_, "=", 2);
				parts = _tmp77_;
				parts_length1 = _vala_array_length (_tmp76_);
				_parts_size_ = parts_length1;
				_tmp78_ = parts;
				_tmp78__length1 = parts_length1;
				if (_tmp78__length1 != 2) {
					FILE* _tmp79_ = NULL;
					_tmp79_ = stderr;
					fprintf (_tmp79_, "Error: --unix-stream argument must be socket_path=filename\n");
					result = 1;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				{
					UMockdevTestbed* _tmp80_ = NULL;
					gchar** _tmp81_ = NULL;
					gint _tmp81__length1 = 0;
					const gchar* _tmp82_ = NULL;
					gchar** _tmp83_ = NULL;
					gint _tmp83__length1 = 0;
					const gchar* _tmp84_ = NULL;
					_tmp80_ = testbed;
					_tmp81_ = parts;
					_tmp81__length1 = parts_length1;
					_tmp82_ = _tmp81_[0];
					_tmp83_ = parts;
					_tmp83__length1 = parts_length1;
					_tmp84_ = _tmp83_[1];
					umockdev_testbed_load_socket_script (_tmp80_, _tmp82_, SOCK_STREAM, _tmp84_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch5_g_error;
					}
				}
				goto __finally5;
				__catch5_g_error:
				{
					GError* e = NULL;
					FILE* _tmp85_ = NULL;
					gchar** _tmp86_ = NULL;
					gint _tmp86__length1 = 0;
					const gchar* _tmp87_ = NULL;
					gchar** _tmp88_ = NULL;
					gint _tmp88__length1 = 0;
					const gchar* _tmp89_ = NULL;
					GError* _tmp90_ = NULL;
					const gchar* _tmp91_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp85_ = stderr;
					_tmp86_ = parts;
					_tmp86__length1 = parts_length1;
					_tmp87_ = _tmp86_[1];
					_tmp88_ = parts;
					_tmp88__length1 = parts_length1;
					_tmp89_ = _tmp88_[0];
					_tmp90_ = e;
					_tmp91_ = _tmp90_->message;
					fprintf (_tmp85_, "Error: Cannot install %s for stream socket %s: %s\n", _tmp87_, _tmp89_, _tmp91_);
					result = 1;
					_g_error_free0 (e);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				__finally5:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (i);
			}
		}
	}
	_tmp92_ = opt_evemu_events;
	_tmp92__length1 = _vala_array_length (opt_evemu_events);
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp92_;
		i_collection_length1 = _tmp92__length1;
		for (i_it = 0; i_it < _tmp92__length1; i_it = i_it + 1) {
			gchar* _tmp93_ = NULL;
			gchar* i = NULL;
			_tmp93_ = g_strdup (i_collection[i_it]);
			i = _tmp93_;
			{
				gchar** parts = NULL;
				const gchar* _tmp94_ = NULL;
				gchar** _tmp95_ = NULL;
				gchar** _tmp96_ = NULL;
				gint parts_length1 = 0;
				gint _parts_size_ = 0;
				gchar** _tmp97_ = NULL;
				gint _tmp97__length1 = 0;
				_tmp94_ = i;
				_tmp96_ = _tmp95_ = g_strsplit (_tmp94_, "=", 2);
				parts = _tmp96_;
				parts_length1 = _vala_array_length (_tmp95_);
				_parts_size_ = parts_length1;
				_tmp97_ = parts;
				_tmp97__length1 = parts_length1;
				if (_tmp97__length1 != 2) {
					FILE* _tmp98_ = NULL;
					_tmp98_ = stderr;
					fprintf (_tmp98_, "Error: --evemu-events argument must be devname=filename\n");
					result = 1;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				{
					UMockdevTestbed* _tmp99_ = NULL;
					gchar** _tmp100_ = NULL;
					gint _tmp100__length1 = 0;
					const gchar* _tmp101_ = NULL;
					gchar** _tmp102_ = NULL;
					gint _tmp102__length1 = 0;
					const gchar* _tmp103_ = NULL;
					_tmp99_ = testbed;
					_tmp100_ = parts;
					_tmp100__length1 = parts_length1;
					_tmp101_ = _tmp100_[0];
					_tmp102_ = parts;
					_tmp102__length1 = parts_length1;
					_tmp103_ = _tmp102_[1];
					umockdev_testbed_load_evemu_events (_tmp99_, _tmp101_, _tmp103_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch6_g_error;
					}
				}
				goto __finally6;
				__catch6_g_error:
				{
					GError* e = NULL;
					FILE* _tmp104_ = NULL;
					gchar** _tmp105_ = NULL;
					gint _tmp105__length1 = 0;
					const gchar* _tmp106_ = NULL;
					gchar** _tmp107_ = NULL;
					gint _tmp107__length1 = 0;
					const gchar* _tmp108_ = NULL;
					GError* _tmp109_ = NULL;
					const gchar* _tmp110_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp104_ = stderr;
					_tmp105_ = parts;
					_tmp105__length1 = parts_length1;
					_tmp106_ = _tmp105_[1];
					_tmp107_ = parts;
					_tmp107__length1 = parts_length1;
					_tmp108_ = _tmp107_[0];
					_tmp109_ = e;
					_tmp110_ = _tmp109_->message;
					fprintf (_tmp104_, "Error: Cannot install %s for device %s: %s\n", _tmp106_, _tmp108_, _tmp110_);
					result = 1;
					_g_error_free0 (e);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					return result;
				}
				__finally6:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (i);
					_g_object_unref0 (testbed);
					_g_free0 (preload);
					_g_option_context_free0 (oc);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (i);
			}
		}
	}
	_tmp111_ = opt_program;
	_tmp111__length1 = _vala_array_length (opt_program);
	if (_tmp111__length1 == 0) {
		FILE* _tmp112_ = NULL;
		_tmp112_ = stderr;
		fprintf (_tmp112_, "No program specified. See --help for how to use umockdev-run\n");
		result = 1;
		_g_object_unref0 (testbed);
		_g_free0 (preload);
		_g_option_context_free0 (oc);
		return result;
	}
	{
		gchar** _tmp113_ = NULL;
		gint _tmp113__length1 = 0;
		GPid _tmp114_ = 0;
		_tmp113_ = opt_program;
		_tmp113__length1 = _vala_array_length (opt_program);
		g_spawn_async (NULL, _tmp113_, NULL, (G_SPAWN_SEARCH_PATH | G_SPAWN_CHILD_INHERITS_STDIN) | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp114_, &_inner_error_);
		child_pid = _tmp114_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FILE* _tmp115_ = NULL;
		gchar** _tmp116_ = NULL;
		gint _tmp116__length1 = 0;
		const gchar* _tmp117_ = NULL;
		const gchar* _tmp118_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp115_ = stderr;
		_tmp116_ = opt_program;
		_tmp116__length1 = _vala_array_length (opt_program);
		_tmp117_ = _tmp116_[0];
		_tmp118_ = e->message;
		fprintf (_tmp115_, "Cannot run %s: %s\n", _tmp117_, _tmp118_);
		exit (1);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (testbed);
		_g_free0 (preload);
		_g_option_context_free0 (oc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	memset (&_tmp119_, 0, sizeof (struct sigaction));
	_tmp119_.sa_handler = _child_sig_handler_sighandler_t;
	_tmp119_.sa_flags = SA_RESETHAND;
	act = _tmp119_;
	_tmp120_ = act;
	_tmp121_ = _tmp120_.sa_mask;
	sigemptyset (&_tmp121_);
	_tmp122_ = act;
	_tmp123_ = sigaction (SIGTERM, &_tmp122_, NULL);
	_vala_assert (_tmp123_ == 0, "Posix.sigaction (Posix.SIGTERM, act, null) == 0");
	_tmp124_ = act;
	_tmp125_ = sigaction (SIGHUP, &_tmp124_, NULL);
	_vala_assert (_tmp125_ == 0, "Posix.sigaction (Posix.SIGHUP, act, null) == 0");
	_tmp126_ = act;
	_tmp127_ = sigaction (SIGINT, &_tmp126_, NULL);
	_vala_assert (_tmp127_ == 0, "Posix.sigaction (Posix.SIGINT, act, null) == 0");
	_tmp128_ = act;
	_tmp129_ = sigaction (SIGQUIT, &_tmp128_, NULL);
	_vala_assert (_tmp129_ == 0, "Posix.sigaction (Posix.SIGQUIT, act, null) == 0");
	_tmp130_ = act;
	_tmp131_ = sigaction (SIGABRT, &_tmp130_, NULL);
	_vala_assert (_tmp131_ == 0, "Posix.sigaction (Posix.SIGABRT, act, null) == 0");
	_tmp132_ = child_pid;
	waitpid ((pid_t) _tmp132_, &_tmp133_, 0);
	status = _tmp133_;
	_tmp134_ = child_pid;
	g_spawn_close_pid (_tmp134_);
	_g_object_unref0 (testbed);
	testbed = NULL;
	_tmp135_ = status;
	_tmp136_ = WIFEXITED (_tmp135_);
	if (_tmp136_) {
		gint _tmp137_ = 0;
		gint _tmp138_ = 0;
		_tmp137_ = status;
		_tmp138_ = WEXITSTATUS (_tmp137_);
		result = _tmp138_;
		_g_object_unref0 (testbed);
		_g_free0 (preload);
		_g_option_context_free0 (oc);
		return result;
	}
	_tmp139_ = status;
	_tmp140_ = WIFSIGNALED (_tmp139_);
	if (_tmp140_) {
		gint _tmp141_ = 0;
		int _tmp142_ = 0;
		_tmp141_ = status;
		_tmp142_ = WTERMSIG (_tmp141_);
		raise (_tmp142_);
	}
	result = status;
	_g_object_unref0 (testbed);
	_g_free0 (preload);
	_g_option_context_free0 (oc);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



