
/*
 * GLX Server Extension
 * Copyright (C) 1996  Steven G. Parker  (sparker@cs.utah.edu)
 * Copyright (C) 1998, 1999  Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * STEPHEN PARKER, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR 
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/*
 * GL Rendering Commands that may be Large
 * modified July 14, 1998 by Terence Ripperda (ripperda@engr.sgi.com)
 *
 * to help clean up some of the code and files I am splitting them 
 * up along more distinguished lines. This file corresponds to 
 * section 9.3.6 of the GLX Extension for OpenGL Protocol Specification
 * Version 1.2. This section describes the protocol for OpenGL calls
 * that Render and are generally large.
 */

#include "glxlib.h"
#include "buffer_macros.h"
#include "large_render.h"
#include <stdio.h>


void __glx_CallLists(GLsizei n, GLenum type, const GLvoid* lists)
{
    int _size=GLX_list_size(n, type)+GLX_list_pad(n, type);
    char* buffer = NULL;
    __GLX_GET_RENDER_BUFFER(buffer, 2, 12, _size);
    __GLX_PUT_int(buffer, n);
    __GLX_PUT_enum(buffer, type);
    PUT_buffer( buffer, lists, _size);
}


void __glx_PixelMapfv( GLenum map,  GLint mapsize, const  GLfloat* values)
{
    int _size = sizeof(GLfloat)*mapsize;
    char* buffer = NULL;
    __GLX_GET_RENDER_BUFFER(buffer, 168, 12, _size);
    __GLX_PUT_enum(buffer, map);
    __GLX_PUT_int(buffer, mapsize);
    PUT_buffer( buffer, (const unsigned char *) values, _size);
}


 
void __glx_PixelMapuiv( GLenum map,  GLint mapsize, const  GLuint* values)
{
    int _size = sizeof(GLint)*mapsize;
    char* buffer = NULL;
    __GLX_GET_RENDER_BUFFER(buffer, 169, 12, _size);
    __GLX_PUT_enum(buffer, map);
    __GLX_PUT_int(buffer, mapsize);
    PUT_buffer( buffer, (const unsigned char*)values, _size);
 }


 
void __glx_PixelMapusv( GLenum map,  GLint mapsize, const  GLushort* values)
{
    int _size= sizeof(GLushort)*mapsize;
    char* buffer = NULL;
    __GLX_GET_RENDER_BUFFER(buffer, 170, 12, _size);
    __GLX_PUT_enum(buffer, map);
    __GLX_PUT_int(buffer, mapsize);
    PUT_buffer( buffer, (const unsigned char*)values, _size);
}

void __glx_PrioritizeTextures( GLint n, const  GLuint* textures, const  
               GLfloat* priorities)
{
	int n_textures = 4 * n;
	int _cnt = 0;
	int n_priorities = 4 * n;
	int _size = n_textures + n_priorities;
	char* buffer=NULL;
        __GLX_GET_RENDER_BUFFER(buffer, 4118, 12, _size);
	__GLX_PUT_int(buffer, n);
	for(_cnt=0;_cnt<n_textures;_cnt++){
		__GLX_PUT_uint(buffer, textures[_cnt]);
	}
	for(_cnt=0;_cnt<n_priorities;_cnt++){
		__GLX_PUT_float(buffer, priorities[_cnt]);
	}
}


