
/* these functions allow properly configured computers and
 * memory ranges to use Memmory Type Range Registers to
 * set write combining mode, which allows writes from the
 * cpu to bypass the cache and be combined very efficiently.
 * There are restrictions on memory block size and alignment,
 * but a failure has no adverse effects other than not improving
 * the speed.
 */
 
 
/*
 * SetWriteCombining
 *
 * tries to cover a range with MTRR if possible, but has no
 * harmfull effects if it fails for any reason.
 */
void SetWriteCombining( long physical, int bytes );

/*
 * FlushWriteCombining
 * Make sure all writes have actually completed before 
 * starting a DMA operation.  This only matters in rare cases
 * of very small buffers, because write combining buffers are
 * automatically flushed some number of cycles after they idle (I think)
 * The case of not having USE_X86_ASM on might cause a problem in those cases.
 */
void FlushWriteCombining( void );

/*
 * Print the speed that a memory buffer is filled at
 * can be used on any buffer, with or without write combining
 */
void MemoryBenchmark( void *buffer, int dwords );
