/*
 * i18n.c: Internationalization
 *
 * See the main source file 'vdr.c' for copyright information and
 * how to reach the author.
 *
 * $Id: i18n.c 1.134 2003/09/11 13:51:56 kls Exp $
 *
 * Translations provided by:
 *
 * Slovenian   Miha Setina <mihasetina@softhome.net> and Matjaz Thaler <matjaz.thaler@guest.arnes.si>
 * Italian     Alberto Carraro <bertocar@tin.it> and Antonio Ospite <ospite@studenti.unina.it>
 * Dutch       Arnold Niessen <niessen@iae.nl> <arnold.niessen@philips.com> and Hans Dingemans <hans.dingemans@tacticalops.nl>
 * Portuguese  Paulo Lopes <pmml@netvita.pt>
 * French      Jean-Claude Repetto <jc@repetto.org>, Olivier Jacques <jacquesolivier@hotmail.com> and Gregoire Favre <greg@magma.unil.ch>
 * Norwegian   Jrgen Tvedt <pjtvedt@online.no> and Truls Slevigen <truls@slevigen.no>
 * Finnish     Hannu Savolainen <hannu@opensound.com>, Jaakko Hyvtti <jaakko@hyvatti.iki.fi>, Niko Tarnanen <niko.tarnanen@hut.fi> and Rolf Ahrenberg <rahrenbe@cc.hut.fi>
 * Polish      Michael Rakowski <mrak@gmx.de>
 * Spanish     Ruben Nunez Francisco <ruben.nunez@tang-it.com>
 * Greek       Dimitrios Dimitrakos <mail@dimitrios.de>
 * Swedish     Tomas Prybil <tomas@prybil.se> and Jan Ekholm <chakie@infa.abo.fi>
 * Romanian    Paul Lacatus <paul@campina.iiruc.ro>
 * Hungarian   Istvan Koenigsberger <istvnko@hotmail.com> and Guido Josten <guido.josten@t-online.de>
 * Catalanian  Marc Rovira Vall <tm05462@salleURL.edu>, Ramon Roca <ramon.roca@xcombo.com> and Jordi Vil <jvila@tinet.org>
 *
 */

/*
 * How to add a new language:
 *
 * 1. Announce your translation action on the VDR mailing
 *    list to avoid duplicate work.
 * 2. Increase the value of 'I18nNumLanguages' in 'i18n.h'.
 * 3. Insert a new line in every member of the 'Phrases[]' array,
 *    containing the translated text for the new language.
 *    For example, assuming you want to add the Italian language,
 *
 *       { "English",
 *         "Deutsch",
 *       },
 *
 *    would become
 *
 *       { "English",
 *         "Deutsch",
 *         "Italiano",
 *       },
 *
 *    and so on. Append your language after the last existing language
 *    and write the name of your language in your language (not in English,
 *    which means that it should be 'Italiano', not 'Italian').
 *    Note that only the characters defined in 'fontosd.c' will
 *    be available!
 * 4. Compile VDR and test the new language by switching to it
 *    in the "Setup/OSD" menu.
 * 5. Send the modified 'i18n.c' file to <kls@cadsoft.de> to have
 *    it included in the next version of VDR.
 *
 * In case an English phrase is used in more than one context (and might need
 * different translations in other languages) it can be preceeded with an
 * arbitrary string to describe its context, separated from the actual phrase
 * by a '$' character (see for instance "Button$Stop" vs. "Stop").
 * Of course this means that no English phrase may contain the '$' character!
 * If this should ever become necessary, the existing '$' would have to be
 * replaced with something different...
 */

#include "i18n.h"
#include "config.h"
#include "tools.h"

const tI18nPhrase Phrases[] = {
  // The name of the language (this MUST be the first phrase!):
  { "English",
    "Deutsch",
    "Slovenski",
    "Italiano",
    "Nederlands",
    "Portugus",
    "Franais",
    "Norsk",
    "suomi", // this is not a typo - it's really lowercase!
    "Polski",
    "Espaol",
    "Ellinika",
    "Svenska",
    "Romaneste",
    "Magyar",
    "Catal",
  },
  // Menu titles:
  { "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
  },
  { "Schedule",
    "Programm",
    "Program",
    "Programmi",
    "Gids",
    "Programao",
    "Programmes",
    "Programmer",
    "Ohjelmisto",
    "Program",
    "Gua de Programacin",
    "Programma",
    "Program",
    "Program",
    "Program",
    "Guia de Programaci",
  },
  { "Channels",
    "Kanle",
    "Kanali",
    "Canali",
    "Kanalen",
    "Canais",
    "Chanes",
    "Kanaler",
    "Kanavat",
    "Kanaly",
    "Canales",
    "Kanalia",
    "Kanaler",
    "Canale",
    "Csatornk",
    "Canals",
  },
  { "Timers",
    "Timer",
    "Termini",
    "Timer",
    "Timers",
    "Timers",
    "Programmation",
    "Timere",
    "Ajastin",
    "Timery",
    "Timer",
    "Programmatismos",
    "Timers",
    "Timere",
    "Felvtel beprogramozsa",
    "Temporitzadors",
  },
  { "Recordings",
    "Aufzeichnungen",
    "Posnetki",
    "Registrazioni",
    "Opnames",
    "Gravaes",
    "Enregistrements",
    "Opptak",
    "Tallenteet",
    "Nagrania",
    "Grabaciones",
    "Egrafes",
    "Inspelningar",
    "Inregistrari",
    "Felvett adsok",
    "Veure programes gravats",
  },
  { "Setup",
    "Einstellungen",
    "Nastavitve",
    "Opzioni",
    "Instellingen",
    "Configurar",
    "Configuration",
    "Konfigurasjon",
    "Asetukset",
    "Nastawy",
    "Configuracin",
    "Rithmisis",
    "Instllningar",
    "Setari",
    "Belltsok",
    "Configuraci",
  },
  { "Commands",
    "Befehle",
    "Ukazi",
    "Comandi",
    "Commando's",
    "Comandos",
    "Commandes",
    "Kommandoer",
    "Komennot",
    "Rozkazy",
    "rdenes",
    "Entoles",
    "Kommandon",
    "Comenzi",
    "Parancsok",
    "Ordres",
  },
  { "Recording commands",
    "Befehle fr Aufzeichnungen",
    "Ukazi za snemanje",
    "Comandi di Registrazione",
    "Opname commando's",
    "",// TODO
    "Commandes d'enregistrement",
    "",// TODO
    "Tallennuskomennot",
    "Rozkazy Nagran",
    "rdenes de grabacin",
    "Entoles gia egrafes",
    "Inspelningskommandon",
    "",// TODO
    "Parancsok a felvett filmekhez",
    "Ordres de gravaci",
  },
  { "Edit channel",
    "Kanal editieren",
    "Uredi kanal",
    "Modifica canale",
    "Kanaal aanpassen",
    "Modificar canal",
    "Modifier une chane",
    "Editer kanal",
    "Muokkaa kanavaa",
    "Ustawienie kanalu",
    "Modificar canal",
    "Prosarmogi kanaliou",
    "ndra kanal",
    "Editare canale",
    "Csatornk belltsa",
    "Editar canal",
  },
  { "Edit timer",
    "Timer editieren",
    "Uredi termin",
    "Modifica timer",
    "Timer veranderen",
    "Modificar timer",
    "Changer la programmation",
    "Editer timer",
    "Muokkaa ajastinta",
    "Ustawienie timerow",
    "Modificar timer",
    "Prosarmogi Programmatismou",
    "ndra timer",
    "Editare timere",
    "Felvtel beprogramozsnak megvltoztatsa",
    "Editar temporitzador",
  },
  { "Event",
    "Sendung",
    "Oddaja",
    "Eventi",
    "Uitzending",
    "Evento",
    "Evnement",
    "Hendelse",
    "Tapahtuma",
    "Audycja",
    "Evento",
    "Ekpompi",
    "Sndning",
    "Evenimente",
    "Ads",
    "Esdeveniment",
  },
  { "Summary",
    "Inhalt",
    "Vsebina",
    "Sommario",
    "Inhoud",
    "Resumo",
    "Rsum",
    "Sammendrag",
    "Tiedot",
    "Zawartosc",
    "Resmen",
    "Periexomeno",
    "Sammanfattning",
    "Cuprins",
    "Tartalom",
    "Sinopsi",
  },
  { "Schedule - %s",
    "Programm - %s",
    "Program - %s",
    "Programma - %s",
    "Programma - %s",
    "Programa - %s",
    "Programmes - %s",
    "Program Guide - %s",
    "Ohjelmisto - %s",
    "Program - %s",
    "Programa - %s",
    "Programma - %s",
    "Program - %s",
    "Program - %s",
    "Program - %s",
    "Guia de Programaci - %s",
  },
  { "What's on now?",
    "Was luft jetzt?",
    "Kaj je na sporedu?",
    "In programmazione",
    "Wat is er nu?",
    "Programa actual?",
    "Programmes en cours",
    "Hvilket program sendes n?",
    "Menossa nyt",
    "Program biezacy",
    "Qu hay ahora?",
    "Trexon Programma",
    "Vilket program snds nu?",
    "Programul actual?",
    "Mi megy most?",
    "Qu fan ara?",
  },
  { "What's on next?",
    "Was luft als nchstes?",
    "Kaj sledi?",
    "Prossimi programmi",
    "Wat komt er hierna?",
    "Prximo Programa?",
    "Prochains programmes",
    "Hvilket program er neste?",
    "Tulossa seuraavaksi",
    "Program nastepny",
    "Qu hay proximo?",
    "Epomeno Programma",
    "Vilket r nsta program?",
    "Programul urmator?",
    "Mi kvetkezik?",
    "Qu fan desprs?",
  },
  // Button texts (should not be more than 10 characters!):
  { "Edit",
    "Editieren",
    "Uredi",
    "Modifica",
    "Verander",
    "Modificar",
    "Modifier",
    "Editer",
    "Muokkaa",
    "Edycja",
    "Modificar",
    "Prosarmogi",
    "ndra",
    "Modificare",
    "Belltani",
    "Editar",
  },
  { "New",
    "Neu",
    "Novo",
    "Nuovo",
    "Nieuw",
    "Novo",
    "Nouveau",
    "Ny",
    "Uusi",
    "Nowy",
    "Nuevo",
    "Neo",
    "Ny",
    "Nou",
    "j",
    "Nou",
  },
  { "Delete",
    "Lschen",
    "Izbrisi",
    "Cancella",
    "Verwijder",
    "Apagar",
    "Supprimer",
    "Slett",
    "Poista",
    "Usunac",
    "Borrar",
    "Diagrafi",
    "Ta bort",
    "Sterge",
    "Trlni",
    "Esborrar",
  },
  { "Mark",
    "Markieren",
    "Oznaci",
    "Marca",
    "Verplaats",
    "Marcar",
    "Marquer",
    "Marker",
    "Siirr",
    "Zaznaczyc",
    "Marcar",
    "Epilogi",
    "Mrk",
    "Marcheaza",
    "Megjellni",
    "Marcar",
  },
  { "On/Off",
    "Ein/Aus",
    "Vklop/Izklop",
    "On/Off",
    "Aan/Uit",
    "On/Off",
    "Marche/Arr",
    "Av/P",
    "Pll/Pois",
    "Zal./ Wyl.",
    "On/Off",
    "Anoixto/Kleisto",
    "P/Av",
    "Pornit/Oprit",
    "Be/Ki",
    "On/Off",
  },
  { "Record",
    "Aufnehmen",
    "Posnemi",
    "Registra",
    "Opnemen",
    "Gravar",
    "Enregistre",
    "Ta opp",
    "Tallenna",
    "Nagrywac",
    "Grabar",
    "Egrafi",
    "Inspelning",
    "Inregistrare",
    "Felvenni",
    "Gravar",
  },
  { "Play",
    "Wiedergabe",
    "Predvajaj",
    "Riproduci",
    "Afspelen",
    "Play",
    "Lire",
    "Spill av",
    "Toista",
    "Odtwarzac",
    "Play",
    "Anaparagogi",
    "Spela upp",
    "Redare",
    "Lejtszani",
    "Reproduir",
  },
  { "Rewind",
    "Anfang",
    "Na zacetek",
    "Da inizio",
    "Naar begin",
    "Rebobinar",
    "Retour",
    "Spol tilbake",
    "Alkuun",
    "Poczatek",
    "Rebobinar",
    "Arxi",
    "terspolning",
    "Inapoi",
    "Vissza az elejre",
    "Enrera",
  },
  { "Button$Stop",
    "Beenden",
    "Ustavi",
    "Stop",
    "Eindigen",
    "Parar",
    "Arrt",
    "Stopp",
    "Lopeta",
    "Zakonczyc",
    "Parar",
    "Terma",
    "Stopp",
    "Stop",
    "Stop",
    "Aturar",
  },
  { "Resume",
    "Weiter",
    "Nadaljuj",
    "Riprendi",
    "Verder",
    "Continuar",
    "Reprendre",
    "Fortsett",
    "Jatka",
    "Dalej",
    "Continuar",
    "Sinexia",
    "Fortstt",
    "Reia",
    "Tovbb",
    "Continuar",
  },
  { "Summary",
    "Inhalt",
    "Vsebina",
    "Sommario",
    "Inhoud",
    "Resumo",
    "Rsum",
    "Sammendrag",
    "Yhteenveto",
    "Zawartosc",
    "Resumen",
    "Periexomeno",
    "Sammanfattning",
    "Cuprins",
    "Tartalom",
    "Resum",
  },
  { "Open",
    "ffnen",
    "Odpri",
    "Apri",
    "Openen",
    "Abrir",
    "Ouvrir",
    "pne",
    "Avaa",
    "Otworzyc",
    "Abrir",
    "Anigma",
    "ppna",
    "Deschide",
    "Kinyitni",
    "Obrir",
  },
  { "Switch",
    "Umschalten",
    "Preklopi",
    "Cambia",
    "Selecteer",
    "Seleccionar",
    "Regarder",
    "Skift til",
    "Valitse",
    "Przelaczyc",
    "Cambiar",
    "Alagi",
    "Byt",
    "Schimba",
    "tkapcsolni",
    "Canviar",
  },
  { "Now",
    "Jetzt",
    "Sedaj",
    "Adesso",
    "Nu",
    "Agora",
    "Maintenant",
    "N",
    "Nyt",
    "Teraz",
    "Ahora",
    "Tora",
    "Nu",
    "Acum",
    "Most",
    "Ara",
  },
  { "Next",
    "Nchste",
    "Sledi",
    "Prossimo",
    "Hierna",
    "Proximo",
    "Aprs",
    "Neste",
    "Seuraavaksi",
    "Nastepny",
    "Siguiente",
    "Epomeno",
    "Nsta",
    "Urmator",
    "Kvetkez",
    "Segent",
  },
  { "Button$Schedule",
    "Programm",
    "Program",
    "Programma",
    "Programma",
    "Programao",
    "Programme",
    "Programmer",
    "Ohjelmisto",
    "Program",
    "Programa",
    "Programma",
    "Program",
    "Program",
    "Program",
    "Programar",
  },
  { "Language",
    "Sprache",
    "Jezik",
    "Linguaggio",
    "Taal",
    "Linguagem",
    "Langue",
    "Sprk",
    "Kieli",
    "Jezyk",
    "Idioma",
    "Glosa",
    "Sprk",
    "Limba",
    "Nyelv",
    "Idioma",
  },
  { "Eject",
    "Auswerfen",
    "Izvrzi",
    "Eject",
    "Eject",
    "Ejectar",
    "Ejection",
    "Eject",
    "Avaa",
    "Wyrzucenie",
    "Expulsar",
    "Exsagogi",
    "Mata ut",
    "Ejecteaza",
    "Kidobni",
    "Expulsar",
  },
  { "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
  },
  { "Insert",
    "Einfgen",
    "Vstavi",
    "Inserisci",
    "Invoegen",
    "",// TODO
    "Insrt",
    "",// TODO
    "Lis",
    "Wstawiac",
    "Insertar",
    "Isodos",
    "Infoga",
    "Insereaza",
    "Beilleszteni",
    "Inserir",
  },
  { "Overwrite",
    "berschreiben",
    "Prepisi",
    "Sovrascrivi",
    "Overschrijven",
    "",// TODO
    "craser",
    "",// TODO
    "Korvaa",
    "Przepisac",
    "Sobreescribir",
    "Epanagrafi",
    "Skriv ver",
    "Suprascrie",
    "trni",
    "Sobrescriure",
  },
  { "Menu",
    "Men",
    "Meni",
    "Menu",
    "Menu",
    "Menu",
    "Menu",
    "Meny",
    "Valikko",
    "Menu",
    "Men",
    "Menou",
    "Meny",
    "Meniu",
    "Men",
    "Men",
  },
  { "Reset",
    "Reset",
    "Reset",
    "Reset",
    "Herstart",
    "",//TODO
    "Rinitialisation",
    "",//TODO
    "Alusta",
    "Reset",
    "Reiniciar",
    "Epanafora",
    "terstll",
    "",//TODO
    "Reset",
    "Reiniciar",
  },
  // Confirmations:
  { "Delete channel?",
    "Kanal lschen?",
    "Izbrisi kanal?",
    "Cancello il canale?",
    "Kanaal verwijderen?",
    "Apagar o canal?",
    "Supprimer la chane?",
    "Slette kanal?",
    "Poistetaanko kanava?",
    "Usunac kanal?",
    "Eliminar canal?",
    "Diagrafi Kanaliou?",
    "Ta bort kanalen?",
    "Sterg canalul?",
    "Csatorna trlse?",
    "Esborrar el canal?",
  },
  { "Delete timer?",
    "Timer lschen?",
    "Izbrisi termin?",
    "Cancello il timer?",
    "Timer verwijderen?",
    "Apagar o timer?",
    "Supprimer la programmation?",
    "Slette timer?",
    "Poistetaanko ajastin?",
    "Usunac timer?",
    "Eliminar timer?",
    "Diagrafi programmatismou?",
    "Ta bort timern?",
    "Sterg timer-ul?",
    "Felvtel beprogramozsnak trlse?",
    "Esborrar el temporitzador?",
  },
  { "Delete recording?",
    "Aufzeichnung lschen?",
    "Izbrisi posnetek?",
    "Cancello la registrazione?",
    "Opname verwijderen?",
    "Apagar a gravao?",
    "Supprimer l'enregistrement?",
    "Slette opptak?",
    "Poistetaanko tallenne?",
    "Usunac nagranie?",
    "Eliminar grabacion?",
    "Svisimo egrafis?",
    "Ta bort inspelningen?",
    "Sterg inregistrarea?",
    "Felvtel trlse?",
    "Esborrar gravaci?",
  },
  { "Timer still recording - really delete?",
    "Timer zeichnet auf - trotzdem lschen?",
    "Snemanje po terminu - zares izbrisi?",
    "Timer in registrazione - cancello?",
    "Timer neemt nog op - toch verwijderen?",
    "Timer activo - tm a certeza que quer apagar?",
    "Enregistrement en cours - confirmez la suppression",
    "Timer gjr opptak - vil du slette likevel?",
    "Ajastettu tallennus kynniss - keskeytetnk?",
    "Nagrywanie w trakcie - napewno usunac?",
    "Timer activo - de verdad eliminarlo?",
    "Programmatismos se exselixsi - Diagrafi sigoura?",
    "Timerstyrd inspelning pgr - Avbryta nd?",
    "Timer-ul in inregistrare - sterg?",
    "Felvtel folyamatban van - mgis trlni?",
    "Temporitzador activat - Esborrar de totes maneres?",
  },
  { "Stop recording?",
    "Aufzeichnung beenden?",
    "Koncaj snemanje?",
    "Fermo la registrazione?",
    "Opname stoppen?",
    "Parar Gravao?",
    "Arrter l'enregistrement?",
    "Stoppe opptak?",
    "Lopetetaanko tallennus?",
    "Zakonczyc nagranie?",
    "Parar grabacin?",
    "Akirosi egrafis?",
    "Stanna inspelning?",
    "Opresc inregistrarea?",
    "Felvtel befejezni?",
    "Aturar la gravaci?",
  },
  { "on primary interface",
    "auf dem primren Interface",
    "na primarni napravi",
    "su interfaccia primaria",
    "op eerste interface",
    "no interface primrio",
    "sur la carte primaire",
    "p frste enhet",
    "pvastaanottimella",
    "na pierwszym interfejsie",
    "en interface primario",
    "stin protevon karta",
    "frn den frsta enheten?",
    "pe prima interfata",
    "az els krtyn",
    "a la interfcie primria",
  },
  { "Cancel editing?",
    "Schneiden abbrechen?",
    "Zelite prekiniti urejanje?",
    "Annullo la modifica?",
    "Bewerken afbreken?",
    "Cancelar Modificaes?",
    "Annuler les modifications?",
    "Avbryte redigering?",
    "Perutaanko muokkaus?",
    "Zakonczyc montaz?",
    "Cancelar modificacin?",
    "Akirosi epexsergasias?",
    "Avbryta redigeringen?",
    "Opresc editarea?",
    "Vgst befejezni?",
    "Cancellar l'edici?",
  },
  { "Really restart?",
    "Wirklich neu starten?",
    "Zares ponoven zagon?",
    "Eseguo un restart?",
    "Werkelijk opnieuw starten?",
    "Tem a certeza que quer reiniciar?",
    "Redmarrer?",
    "Vil du virkelig starte p nytt?",
    "Kynnistetnk uudelleen?",
    "Rzeczywiscie nowy start?",
    "De verdad reiniciar?",
    "Na gini sigoura epanekinisi?",
    "Vill du verkligen starta om?",
    "Esti sigur de repornire?",
    "Tnyleg jraindtani?",
    "Segur que voleu reiniciar?",
  },
  { "Recording - restart anyway?",
    "Aufnahme luft - trotzdem neu starten?",
    "Snemanje - zares ponoven zagon?",
    "In registrazione - restart comunque?",
    "Opname loopt - toch opnieuw starten?",
    "Em gravao - quer mesmo reiniciar?",
    "Enregistrement en cours - redmarrer?",
    "Gjr opptak - starte p nytt likevel?",
    "Tallennus kesken - kynnistetnk uudelleen?",
    "Nagrywanie w trakcie - rzeczywiscie nowy start?",
    "Grabando - reiniciar?",
    "Ginete egrafi - Telika na ginei epanekinisi?",
    "Inspelning pgr, vill du nd starta om?",
    "In inregistrare - repornesc?",
    "Felvtel folyamatban van - mgis jraindtani?",
    "Gravant - Reiniciar de totes maneres?",
  },
  { "Recording - shut down anyway?",
    "Aufnahme luft - trotzdem ausschalten?",
    "Snemanje - zares izklopi?",
    "In registrazione - spengo comunque?",
    "Opname loopt - toch uitschakelen?",
    "Em gravao - quer mesmo desligar?",
    "Enregistrement en cours - confirmez l'arrt",
    "Gjr opptak - sl av likevel?",
    "Tallennus kesken - sammutetaanko?",
    "Nagrywanie w trakcie - mimo to wylaczyc?",
    "Grabando - apagar?",
    "Ginete egrafi - Telika na ginei termatismos?",
    "Inspelning pgr, vill du nd avbryta?",
    "In inregistrare - opresc?",
    "Felvtel folyamatban van - mgis kikapcsolni?",
    "Gravant - Apagar de totes maneres?",
  },
  { "Recording in %d minutes, shut down anyway?",
    "Aufnahme in %d Minuten - trotzdem ausschalten?",
    "Snemanje cez %d minut, zares izklopi?",
    "Registrazione fra %d minuti - spengo comunque?",
    "Opname in %d minuten - toch uitschakelen?",
    "Em gravao dentro de %d minutos - quer mesmo desligar?",
    "Enregistrement dans %d minutes - confirmez l'arrt",
    "Skal gjre opptak om %d minutter - sl av likevel?",
    "Tallennus alkaa %d min kuluttua - sammutetaanko?",
    "Nagrywanie za %d minut - mimo to wylaczyc?",
    "Grabando en %d minutos, de verdad apagar?",
    "Anamenete egrafi se %d lepta - Telika na termatistei?",
    "Inspelning startar om %d minuter, vill du avsluta?",
    "Inregistrez in %d minute, opresc?",
    "Felvtel %d perc mulva kezddik - mgis kikapcsolni?",
    "Hi ha una gravaci en %d minuts - Apagar de totes maneres?",
  },
  { "Press any key to cancel shutdown",
    "Taste drcken um Shutdown abzubrechen",
    "Pritisni katerikoli gumb za preklic izklopa",
    "Un tasto per annullare lo spegnimento",
    "Druk een toets om shutdown af te breken",
    "Pressione qualquer tecla para cancelar",
    "Appuyez sur une touche pour annuler l'arrt",
    "Trykk en tast for ikke  sl av",
    "Peru sammutus painamalla mit tahansa nppint",
    "Dowolny przycisk zatrzyma wylaczanie",
    "Pulse una tecla para interrumpir apagar",
    "Piese ena pliktro na akirothei o termatismos",
    "Tryck valfri knapp fr att terkalla avstngningen",
    "Apasa orice tasta pentru a anula inchiderea",
    "Nyomj egy gombot a lells meglltshoz",
    "Prem qualsevol tecla per cancellar l'aturada",
  },
  // Channel parameters:
  { "Name",
    "Name",
    "Naziv",
    "Nome",
    "Naam",
    "Nome",
    "Nom",
    "Navn",
    "Nimi",
    "Nazwa",
    "Nombre",
    "Onoma",
    "Namn",
    "Nume",
    "Nv",
    "Nom",
  },
  { "Frequency",
    "Frequenz",
    "Frekvenca",
    "Frequenza",
    "Frequentie",
    "Frequncia",
    "Frquence",
    "Frekvens",
    "Taajuus",
    "Czestotliwosc",
    "Frecuencia",
    "Sixnotita",
    "Frekvens",
    "Frecventa",
    "Frekvencia",
    "Freqncia",
  },
  { "Polarization",
    "Polarisation",
    "Polarizacija",
    "Polarizzazione",
    "Polarisatie",
    "Polarizao",
    "Polarisation",
    "Polarisasjon",
    "Polarisaatio",
    "Polaryzacja",
    "Polarizacin",
    "Polosi",
    "Polarisation",
    "Polarizare",
    "Polarizci",
    "Polaritzaci",
  },
  { "Source",
    "Quelle",
    "Pozicija",
    "Sorgente",
    "Bron",
    "",//TODO
    "Source",
    "",//TODO
    "Lhde",
    "Zrodlo",
    "",//TODO
    "Pigi",
    "Klla",
    "",//TODO
    "Forrs",
    "Origen",
  },
  { "Srate",
    "Srate",
    "Srate",
    "Srate",
    "Srate",
    "Srate",
    "Frq. Symbole",
    "Srate",
    "Symbolinopeus",
    "Srate",
    "Srate",
    "Srate",
    "Symbolrate",
    "Rata simboluri",
    "Srate",
    "Srate",
  },
  { "Vpid",
    "Vpid",
    "Vpid",
    "Vpid",
    "Vpid",
    "PID de Vdeo",
    "PID Vido",
    "Vpid",
    "Kuva PID",
    "Vpid",
    "Vpid",
    "Vpid",
    "Video PID",
    "PID Video",
    "Vpid",
    "PID Vdeo",
  },
  { "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Aikatieto PID",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
  },
  { "Apid1",
    "Apid1",
    "Apid1",
    "Apid1",
    "Apid1",
    "PID udio (1)",
    "PID Audio (1)",
    "Apid1",
    "ni PID1",
    "Apid1",
    "Apid1",
    "Apid1",
    "Audio PID1",
    "PID Audio (1)",
    "Apid1",
    "PID udio (1)",
  },
  { "Apid2",
    "Apid2",
    "Apid2",
    "Apid2",
    "Apid2",
    "Apid2",
    "PID Audio (2)",
    "Apid2",
    "ni PID2",
    "Apid2",
    "Apid2",
    "Apid2",
    "Audio PID2",
    "PID Audio (2)",
    "Apid2",
    "PID udio (2)",
  },
  { "Dpid1",
    "Dpid1",
    "Dpid1",
    "Dpid1",
    "Dpid1",
    "PID AC3 (1)",
    "PID AC3 (1)",
    "AC3pid1",
    "Dolby PID1",
    "Dpid1",
    "Dpid1",
    "Dpid1",
    "Dpid1",
    "PID AC3 (1)",
    "Dpid1",
    "PID AC3 (1)",
  },
  { "Dpid2",
    "Dpid2",
    "Dpid2",
    "Dpid2",
    "Dpid2",
    "PID AC3 (2)",
    "PID AC3 (2)",
    "AC3pid2",
    "Dolby PID2",
    "Dpid2",
    "Dpid2",
    "Dpid2",
    "Dpid2",
    "PID AC3 (2)",
    "Dpid2",
    "PID AC3 (2)",
  },
  { "Tpid",
    "Tpid",
    "Tpid",
    "Tpid",
    "Tpid",
    "PID Teletexto",
    "PID Tltexte",
    "Tekst-TV pid",
    "Teksti-TV PID",
    "Tpid",
    "Tpid",
    "Tpid",
    "Teletext PID",
    "PID Teletext",
    "Tpid",
    "PID Teletext",
  },
  { "CA",
    "CA",
    "CA",
    "CA",
    "CA",
    "Encriptao",
    "Cryptage",
    "Kortleser",
    "Salaus",
    "CA",
    "CA",
    "CA",
    "Kortlsare",
    "Criptare",
    "CA",
    "Accs Condicional",
  },
  { "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Palvelu ID",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
  },
  { "Inversion",
    "Inversion",
    "Inverzija",
    "Inversion",
    "Inversion",
    "Inversion",
    "Inversion",
    "Inversion",
    "Inversio",
    "Inversion",
    "Inversion",
    "Inversion",
    "Inversion",
    "Inversion",
    "Inversion",
    "Inversi",
  },
  { "Bandwidth",
    "Bandwidth",
    "Pasovna sirina",
    "Bandwidth",
    "Bandwidth",
    "Bandwidth",
    "Bande passante",
    "Bandwidth",
    "Kaistanleveys",
    "Szerokosc pasma",
    "Bandwidth",
    "Bandwidth",
    "Bandbredd",
    "Bandwidth",
    "Bandwidth",
    "Amplada de banda",
  },
  { "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "Ylsuojaustaso",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
  },
  { "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "Alasuojaustaso",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
  },
  { "Modulation",
    "Modulation",
    "Modulacija",
    "Modulation",
    "Modulation",
    "Modulation",
    "Modulation",
    "Modulation",
    "Modulaatio",
    "Modulacja",
    "Modulation",
    "Modulation",
    "Modulation",
    "Modulation",
    "Modulation",
    "Modulaci",
  },
  { "Transmission",
    "Transmission",
    "Prenos",
    "Transmission",
    "Transmission",
    "Transmission",
    "Transmission",
    "Transmission",
    "Lhetystila",
    "Transmisja",
    "Transmission",
    "Transmission",
    "Transmission",
    "Transmission",
    "Transmission",
    "Transmissi",
  },
  { "Guard",
    "Guard",
    "Zascita",
    "Guard",
    "Guard",
    "Guard",
    "Guard",
    "Guard",
    "Suojavli",
    "Guard",
    "Guard",
    "Guard",
    "Guard",
    "Guard",
    "Guard",
    "Protegir",
  },
  { "Hierarchy",
    "Hierarchy",
    "Hierarhija",
    "Hierarchy",
    "Hierarchy",
    "Hierarchy",
    "Hierarchie",
    "Hierarchy",
    "Hierarkia",
    "Hierachia",
    "Hierarchy",
    "Hierarchy",
    "Hierarchy",
    "Hierarchy",
    "Hierarchy",
    "Jerarquia",
  },
  // Timer parameters:
  { "Active",
    "Aktiv",
    "Aktivno",
    "Attivo",
    "Actief",
    "Activo",
    "Actif",
    "Aktiv",
    "Aktiivinen",
    "Aktywny",
    "Activo",
    "Energo",
    "Aktiv",
    "Activ",
    "Aktiv",
    "Actiu",
  },
  { "Channel",
    "Kanal",
    "Kanal",
    "Canale",
    "Kanaal",
    "Canal",
    "Chane",
    "Kanal",
    "Kanava",
    "Kanal",
    "Canal",
    "Kanali",
    "Kanal",
    "Canal",
    "Csatorna",
    "Canal",
  },
  { "Day",
    "Tag",
    "Dan",
    "Giorno",
    "Dag",
    "Dia",
    "Jour",
    "Dag",
    "Piv",
    "Dzien",
    "Da",
    "Imera",
    "Dag",
    "Ziua",
    "Nap",
    "Dia",
  },
  { "Start",
    "Anfang",
    "Zacetek",
    "Inizio",
    "Begin",
    "Inicio",
    "Dbut",
    "Start",
    "Aloitus",
    "Poczatek",
    "Comienzo",
    "Arxi",
    "Brjar",
    "Start",
    "Kezdet",
    "Inici",
  },
  { "Stop",
    "Ende",
    "Konec",
    "Fine",
    "Einde",
    "Fim",
    "Fin",
    "Slutt",
    "Lopetus",
    "Koniec",
    "Fin",
    "Telos",
    "Slutar",
    "Stop",
    "Vge",
    "Fi",
  },
  { "Priority",
    "Prioritt",
    "Prioriteta",
    "Priorita'",
    "Prioriteit",
    "Prioridade",
    "Priorit",
    "Prioritet",
    "Prioriteetti",
    "Priorytet",
    "Prioridad",
    "Protereotita",
    "Prioritet",
    "Prioritate",
    "Priorits",
    "Prioritat",
  },
  { "Lifetime",
    "Lebensdauer",
    "Veljavnost",
    "Durata",
    "Bewaarduur",
    "Durao",
    "Dure de vie",
    "Levetid",
    "Elinik",
    "Trwalosc dni",
    "Durabilidad",
    "Xronos Zois",
    "Livstid",
    "Durata",
    "lettartam",
    "Durada",
  },
  { "File",
    "Datei",
    "Datoteka",
    "Nome",
    "Filenaam",
    "Ficheiro",
    "Fichier",
    "Filnavn",
    "Tiedosto",
    "Plik",
    "Fichero",
    "Arxeio",
    "Filnamn",
    "Fisier",
    "File",
    "Arxiu",
  },
  { "First day",
    "Erster Tag",
    "Prvi dan",
    "Primo giorno",
    "Eerste dag",
    "Primeiro dia",
    "Premier jour",
    "Frste dag",
    "1. piv",
    "Pierwszy dzien",
    "Primer da",
    "Proti mera",
    "Frsta dag",
    "Prima zi",
    "Els nap",
    "Primer dia",
  },
  // Error messages:
  { "Channel is being used by a timer!",
    "Kanal wird von einem Timer benutzt!",
    "Kanal uporablja termin za snemanje!",
    "Canale occupato da un timer!",
    "Kanaal wordt gebruikt door een timer!",
    "Canal a ser utilizador por um timer!",
    "Cette chane est en cours d'utilisation!",
    "Kanalen er i bruk av en timer!",
    "Kanava on ajastimen kytss!",
    "Kanal jest zajety przez timer nagran",
    "Canal est ocupado por un timer!",
    "To kanali xrisimopiite apo kapoion programmatismo!",
    "Kanalen anvnds av en timer!",
    "Canalul este utilizat de un timer!",
    "Csatornt ms hasznlja!",
    "Canal en s per un temporitzador!",
  },
  { "Can't switch channel!",
    "Kanal kann nicht umgeschaltet werden!",
    "Ne morem preklopiti kanala!",
    "Impossibile cambiare canale!",
    "Kan geen kanaal wisselen!",
    "No pode mudar de canal!",
    "Impossible de changer de chane!",
    "Ikke mulig  skifte kanal!",
    "Kanavan vaihtaminen ei mahdollista!",
    "Kanal nie moze byc teraz przelaczony!",
    "No puedo cambiar canal!",
    "Adinati i allagi kanaliou!",
    "Omjligt att byta kanal!",
    "Nu pot comuta canalul!",
    "Csatornt nem lehet tkapcsolni!",
    "No puc canviar de canal!",
  },
  { "Timer is recording!",
    "Timer zeichnet gerade auf!",
    "Snemanje po terminu!",
    "Registrazione di un timer in corso!",
    "Timer is aan het opnemen!",
    "Timer a gravar!",
    "Enregistrement en cours!",
    "Timer gjr opptak!",
    "Ajastintallennus kynniss!",
    "Timer nagrywa!",
    "Timer esta grabando!",
    "Ginete progrmamatismeni egrafi!",
    "Timerstyrd inspelning pgr!",
    "Timer-ul este in inregistrare!",
    "Felvtel folyamatban van!",
    "El temporitzador est gravant!",
  },
  { "Error while accessing recording!",
    "Fehler beim Ansprechen der Aufzeichnung!",
    "Napaka pri dostopu do posnetka!",
    "Errore nell'accesso alla registrazione",
    "Fout bij lezen opname!",
    "Erro ao aceder  gravao",
    "Impossible d'accder  l'enregistrement",
    "Feil under lesing av opptak!",
    "Tallenteen toistaminen eponnistui!",
    "Blad - brak dostepu do nagrania!",
    "Error al acceder a la grabacin!",
    "Provlima stin prospelasi egrafis!",
    "Inspelningen gr inte att lsa!",
    "Eroare in timpul accesarii inregistrarii",
    "Hiba a felvtel hozzfrsnl",
    "Error a l'accedir a la gravaci!",
  },
  { "Error while deleting recording!",
    "Fehler beim Lschen der Aufzeichnung!",
    "Napaka pri brisanju posnetka!",
    "Errore nel cancellare la registrazione!",
    "Fout bij verwijderen opname!",
    "Erro enquanto apagava uma gravao!",
    "Erreur de suppression de l'enregistrement!",
    "Feil under sletting av opptak!",
    "Tallenteen poistaminen eponnistui!",
    "Blad przy usuwaniu nagrania!",
    "Error al borrar la grabacin!",
    "Provlima sto svisimo egrafis !",
    "Inspelningen gr inte att ta bort!",
    "Eroare in timpul stergerii inregistrarii!",
    "Hiba a felvtel trlsnl!",
    "Error a l'esborrar la gravaci!",
  },
  { "*** Invalid Channel ***",
    "*** Ungltiger Kanal ***",
    "*** Neznan kanal ***",
    "*** CANALE INVALIDO ***",
    "*** Ongeldig kanaal ***",
    "*** Canal Invlido! ***",
    "*** Chane invalide! ***",
    "*** Ugyldig Kanal! ***",
    "*** Virheellinen kanavavalinta! ***",
    "*** Niewazny kanal ***",
    "*** Canal invlido ***",
    "*** Akiro Kanali ***",
    "*** Felaktig kanal ***",
    "*** Canal invalid ***",
    "*** rvnytelen csatorna ***",
    "*** Canal incorrecte ***",
  },
  { "No free DVB device to record!",
    "Keine freie DVB-Karte zum Aufnehmen!",
    "Ni proste DVB naprave za snemanje!",
    "Nessuna periferica DVB disponibile per registrare!",
    "Geen vrije DVB kaart om op te nemen!",
    "Nenhuma placa DVB disponivel para gravar!",
    "Pas de carte DVB disponible pour l'enregistrement!",
    "Ingen ledige DVB enheter for opptak!",
    "Ei vapaata vastaanotinta tallennukselle!",
    "Brak wolnej karty DVB do nagrywania!",
    "No hay dispositivo DVB disponible para grabar!",
    "Den periseuei DVB Karta gia egrafi!",
    "Det finns ingen ledig DVB enhet fr inspelning!",
    "Nu mai sunt dispozitive DVB pentru inregistrare!",
    "Nincs szabad DVB krtya a felvtelhez!",
    "No hi ha cap dispositiu DVB lliure per gravar!",
  },
  { "Channel not available!",
    "Kanal nicht verfgbar!",
    "Kanal ni razpolozljiv!",
    "Canale non disponibile!",
    "Kanaal niet beschikbaar",
    "",//TODO
    "Chane non disponible!",
    "",//TODO
    "Kanava ei ole kytettviss!",
    "Kanal jest niedostepny!",
    "!Canal no disponible!",
    "To kanali den ine diathesimo",
    "Kanalen ej tillgnglig!",
    "",//TODO
    "A csatorna nem elrhet",
    "Canal no disponible!",
  },
  { "Channel settings are not unique!",
    "Kanaleinstellungen sind nicht eindeutig!",
    "Nastavitve kanala niso edinstvene!",
    "Paramentri Canale non unici!",
    "Kanaalinstellingen zijn niet uniek!",
    "",//TODO
    "Caractristiques des chanes ne sont pas uniques",
    "",//TODO
    "Kanava-asetukset eivt ole yksillliset!",
    "Nastawy kanalu sa niejednoznaczne!",
    "!Propiedades de canal duplicadas!",
    "Oi rithmiseis tou kanaliou simpiptoun me allo!",
    "Kanalinstllningarna r ej unika!",
    "",//TODO
    "A csatornabelltsok nem egyrtelmek",
    "Propietats del canal duplicades!",
  },
  { "Channel locked (recording)!",
    "Kanal blockiert (zeichnet auf)!",
    "Zaklenjen kanal (snemanje)!",
    "Canale bloccato (in registrazione)!",
    "Kanaal geblokkeerd (neemt op)!",
    "Canal bloqueado (a gravar)!",
    "Chane verrouille (enregistrement en cours)!",
    "Kanalen er lst (opptak)!",
    "Kanava lukittu (tallennus kynniss)!",
    "Kanal zablokowany (nagrywanie w toku)!",
    "Canal bloqueado (grabando)!",
    "To kanali ine apasxolimeno (Ginete egrafi)!",
    "Kanalen r lst (inspelning pgr)!",
    "Canal blocat (inregistrare)!",
    "Csatorna hozzfrhetetlen (felvtel)!",
    "Canal bloquejat (gravant)!",
  },
  { "Can't start Transfer Mode!",
    "Transfer-Mode kann nicht gestartet werden!",
    "Ne morem zaceti z prenosnim nacinom",
    "Impossibile iniziare la modalita' di trasferimento!",
    "Kan Transfer-Mode niet starten",
    "Impossvel iniciar modo de transferncia!",
    "Impossible d'utiliser le mode transfert!",
    "Kan ikke starte transfer modus!",
    "Siirtotilan aloitus eponnistui!",
    "Tryb transferowy jest niemozliwy!",
    "No puedo iniciar modo de transferencia!",
    "Adinamia ekinisis katastasis metaforas!",
    "Kan inte starta Transfer Mode!",
    "Nu pot porni Modul de Transfer!",
    "Transfer-Mode nem indthat!",
    "No puc iniciar el mode de transferncia!",
  },
  { "No editing marks defined!",
    "Keine Schnittmarken gesetzt!",
    "Nobena tocka ni definirana!",
    "Nessun marcatore di modifica definito!",
    "Geen bewerkingsmarkeringen gedefinieerd!",
    "",//TODO
    "Pas de marques d'dition dfinies!",
    "",//TODO
    "",//TODO
    "Brak znakow montazowych!",
    "Muokkausmerkinnt puuttuvat",
    "Den exoun oristei simeia gia epexsergasia",
    "Det finns inga redigeringsmrken",//TODO
    "",//TODO
    "A vgpont nincs kijellve",//TODO
    "No hi ha marques d'edici definides",
  },
  { "Can't start editing process!",
    "Schnitt kann nicht gestartet werden!",
    "Ne morem zaceti urejanja!",
    "Impossibile iniziare processo di modifica!",
    "Kan niet beginnen met bewerken!",
    "No pode iniciar a modificao!",
    "Impossible de commencer le montage!",
    "Kan ikke starte redigeringsprosessen!",
    "Muokkauksen aloitus eponnistui!",
    "Uruchamianie montazu jest niemozliwe!",
    "No puedo iniciar proceso de modificacin!",
    "Adinamia ekinisis tis epexsergasias!",
    "Kan inte starta redigering!",
    "Nu pot porni procesul de editare!",
    "A vgs nem indthat!",
    "No puc iniciar el procs d'edici!",
  },
  { "Editing process already active!",
    "Schnitt bereits aktiv!",
    "Urejanje je ze aktivno!",
    "Processo di modifica gia` attivo!",
    "Bewerken is al actief!",
    "Processo de modificao j activo!",
    "Montage dj en cours!",
    "Redigeringsprosessen er allerede aktiv!",
    "Muokkaus on jo kynniss!",
    "Montaz w toku!",
    "Proceso de modificacin ya fue iniciado!",
    "Epexsergasia vriskete se exselixsi!",
    "Redigeringen r redan aktiv!",
    "Procesul de editare este activ!",
    "A vgs mr aktivlt!",
    "Procs d'edici iniciat anteriorment!",
  },
  { "Can't shutdown - option '-s' not given!",
    "Shutdown unmglich - Option '-s' fehlt!",
    "Zaustavitev ni izvedljiva - opcija '-s' ni podana!",
    "Impossibile spegnere - parametro '-s' non passato!",
    "Shutdown onmogelijk - Optie '-s' ontbreekt!",
    "Impossvel desligar - falta a opo '-s'!",
    "Arrt impossible - option '-s' absente!",
    "Kan ikke sl av - startet uten parameteret '-s'!",
    "Sammutus ei onnistu - '-s' parametri puuttuu!",
    "Wylaczenie niemozliwe - brak opcji '-s'!",
    "No puedo apagar - opcin '-s' ausente!",
    "Adinaton na ginei termatismos. Aniparkti i parametros '-s'!",
    "Kan inte avsluta, mste anvnda parameter '-s'",
    "Nu pot opri calculatorul - vezi optiunea '-s'",
    "A lellts nem lehetsges - Opci '-s' hinyzik!",
    "No puc apagar, falta la opci -s !",
  },
  { "Low disk space!",
    "Platte beinahe voll!",
    "Zmanjkuje prostora na disku",
    "Poco spazio su disco!",
    "Disk bijna vol!",
    "Espao em disco reduzido!",
    "Disque presque plein!",
    "Lite ledig diskplass!",
    "Kovalevy lhes tynn!",
    "Dysk wkrotce pelny!",
    "Disco casi lleno",
    "O Skliros kontevi na gemisi!",
    "Lgt diskutrymme!",
    "Spatiu scazut pe disc!",
    "A merev lemez majdnem tele!",
    "Disc gaireb ple!",
  },
  { "Can't open CAM menu!",
    "CAM-Men kann nicht geffnet werden!",
    "Ne morem odpreti CAM menija!",
    "Impossibile aprire il menu CAM!",
    "Kan CAM-menu niet openen!",
    "",//TODO
    "Impossible d'ouvrir le menu CAM!",
    "",//TODO
    "Salausmoduulin valikko ei saatavilla",
    "CAM-Menu niedostepne!",
    "No pudeo acceder al men de la CAM!",
    "Den mpori na aniksi to CAM menou!",
    "Det gr inte att ppna CAM menyn!",
    "",//TODO
    "A CAM-Men nem nyithat",
    "No puc obrir el men de la CAM!",
  },
  { "Can't reset CAM!",
    "CAM-Reset fehlgeschlagen!",
    "Ne morem resetirati CAM-a",
    "Impossibile reimpostare il modulo CAM!",
    "Kan CAM niet herstarten!",
    "",//TODO
    "Impossible de rinitialiser la CAM!",
    "",//TODO
    "Salausmoduulin alustus eponnistui!",
    "Nieudany CAM-Reset!",
    "No puedo reiniciar la CAM!",
    "Adinato na gini epanafora sto CAM",
    "Kan inte terstlla CAM!",
    "",//TODO
    "A CAM-Reset nem sikerlt",
    "No puc reiniciar la CAM!",
  },
  { "CAM has been reset",
    "CAM wurde zurckgesetzt!",
    "CAM je resetiran!",
    "Modulo CAM reimpostato!",
    "CAM is herstart!",
    "",//TODO
    "La CAM a t rinitialise",
    "",//TODO
    "Salausmoduuli alustettu",
    "CAM-Reset wykonany!",
    "CAM reiniciada",
    "Sto CAM egine apanafora",
    "CA modulen har terstllts",
    "",//TODO
    "A CAM vissza lett lltva",
    "CAM reiniciada",
  },
  // Setup pages:
  { "OSD",
    "OSD",
    "OSD",
    "OSD",
    "OSD",
    "OSD",
    "Affichage des menus",
    "OSD",
    "Kuvaruutunytt",
    "OSD",
    "Mens en pantalla",
    "OSD",
    "OSD",
    "OSD",
    "OSD",
    "Informaci en pantalla",
  },
  { "EPG",
    "EPG",
    "Programski vodnik",
    "EPG",
    "EPG",
    "EPG",
    "Guide des programmes",
    "Programoversikt",
    "Ohjelmaopas",
    "EPG",
    "Gua de Programacin",
    "EPG",
    "Elektronisk programguide",
    "EPG",
    "EPG",
    "Guia de Programes",
  },
  { "DVB",
    "DVB",
    "DVB",
    "Scheda DVB",
    "DVB",
    "DVB",
    "Cartes DVB",
    "DVB-enheter",
    "DVB",
    "DVB",
    "DVB",
    "DVB",
    "DVB",
    "Placa DVB",
    "DVB",
    "Tarja DVB",
  },
  { "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "Configuraci de l'LNB",
  },
  { "CICAM",
    "CICAM",
    "CICAM",
    "CICAM",
    "CICAM",
    "CICAM",
    "Accs conditionnel",
    "CICAM",
    "CI-moduuli",
    "CICAM",
    "CICAM",
    "CICAM",
    "CICAM",
    "Acces conditionat",
    "CICAM",
    "CI Accs condicional",
  },
  { "Recording",
    "Aufnahme",
    "Snemanje",
    "Registrazione",
    "Opname",
    "A gravar",
    "Enregistrement",
    "Opptak",
    "Tallennus",
    "Nagranie",
    "Opciones de Grabacin",
    "Egrafi",
    "Inspelning",
    "Inregistrare",
    "Felvtel",
    "Opcions de Gravaci",
  },
  { "Replay",
    "Wiedergabe",
    "Predvajanje",
    "Replay",
    "Afspelen",
    "Replay",
    "Lecture",
    "Spill av",
    "Toisto",
    "Odtwarzanie",
    "Opciones de Reproduccin",
    "Anametadosi",
    "Uppspelning",
    "Redare",
    "Lejtszs",
    "Opcions de Reproducci",
  },
  { "Miscellaneous",
    "Sonstiges",
    "Ostalo",
    "Generici",
    "Overig",
    "Outros",
    "Divers",
    "Forskjellig",
    "Sekalaiset",
    "Pozostale",
    "Varios",
    "Diafora",
    "Diverse",
    "Diverse",
    "Egyb",
    "Miscellnia",
  },
  { "Plugins",
    "Plugins",
    "Plugins",
    "Plugins",
    "Plugins",
    "Plugins",
    "Plugins",
    "Plugins",
    "Laajennokset",
    "Plugins",
    "Plugins",
    "Plugins",
    "Moduler",
    "Plugins",
    "Plugins",
    "Plugins",
  },
  { "Plugin",
    "Plugin",
    "Plugin",
    "Plugin",
    "Plugin",
    "Plugin",
    "Plugin",
    "Plugin",
    "Laajennos",
    "Plugin",
    "Plugin",
    "Plugin",
    "Modul",
    "Plugin",
    "Plugin",
    "Plugin",
  },
  { "Restart",
    "Neustart",
    "Ponoven zagon",
    "Riavvio",
    "Herstart",
    "Reiniciar",
    "Redmarrer",
    "Start p nytt",
    "Kynnist uudelleen",
    "Zastartowac",
    "Reiniciar",
    "Epanekinisi",
    "Omstart",
    "Restart",
    "jraindts",
    "Reiniciar",
  },
  // Setup parameters:
  { "Setup.OSD$Language",
    "Sprache",
    "Jezik",
    "Linguaggio",
    "Taal",
    "Linguagem",
    "Langue",
    "Sprk",
    "Kieli",
    "Jezyk",
    "Idioma",
    "Glosa",
    "Sprk",
    "Limba OSD",
    "Nyelv",
    "Idioma",
  },
  { "Setup.OSD$Width",
    "Breite",
    "Sirina",
    "Larghezza OSD",
    "Breedte",
    "Largura",
    "Largeur",
    "Bredde",
    "Leveys",
    "Szerokosc",
    "Anchura",
    "Makros",
    "Bredd",
    "Latime OSD",
    "Szlessg",
    "Amplada",
  },
  { "Setup.OSD$Height",
    "Hhe",
    "Visina",
    "Altezza OSD",
    "Hoogte",
    "Altura",
    "Hauteur",
    "Hyde",
    "Korkeus",
    "Wysokosc",
    "Altura",
    "Ipsos",
    "Hjd",
    "Inaltime OSD",
    "Magassg",
    "Alada",
  },
  { "Setup.OSD$Message time (s)",
    "Anzeigedauer fr Nachrichten (s)",
    "Cas sporocila (s)",
    "Tempo del messaggio (s)",
    "Weergave duur van berichten (s)",
    "Mostrar contador (s)",
    "Dure affichage cran (s)",
    "Tid meldinger skal vises (s)",
    "Viestien esitysaika (s)",
    "Czas wyswietlania wiadomosci (s)",
    "Duracin muestra mensajes (s)",
    "Xronos endiksis minimaton (d)",
    "Tid fr meddelanden (sek)",
    "Timp afisare mesaj (sec)",
    "Informci feltntetsnek idtartama",
    "Durada dels missatges (s)",
  },
  { "Setup.OSD$Channel info position",
    "Kanal-Info Position",
    "Pozicija informacije o kanalu",
    "Posizione informazioni canale",
    "Kanaal info positie",
    "Posio de info dos canais",
    "Position infos chanes",
    "Posisjon p kanalinformasjon",
    "Kanavatiedon sijainti",
    "Lokalizacja informacji o kanale",
    "Posicin para informacin canal",
    "Thesi Pliroforias kanalion",
    "Placering av kanalinformation",
    "Pozitie info canal",
    "Csatorna-Inf pozicija",
    "Posici de la informaci del canal",
  },
  { "Setup.OSD$Info on channel switch",
    "Info beim Kanalwechsel",
    "Pokazi naziv kanala",
    "Mostra info al cambio canale",
    "Kanaal info tonen",
    "Mostrar info ao mudar de Canal",
    "Affichage progr. en cours",
    "Info ved kanalskifte",
    "Nyt kanavatieto",
    "Informacja przy zmianie kanalu",
    "Informacin para cambio de canal",
    "Plirofories stin alagi kanaliou",
    "Information vid kanalbyte",
    "Info despre comutare canal",
    "Inf a csatorna vltsnl",
    "Informaci del canvi de canal",
  },
  { "Setup.OSD$Scroll pages",
    "Seitenweise scrollen",
    "Drsni meni",
    "Scorri pagina nel menu",
    "Scrollen per pagina",
    "Scroll da pgina no menu",
    "Scrolling par pages",
    "Rask rulling i menyer",
    "Valikkojen sivutus",
    "Przesuwac stronami",
    "Desplazar pgina entera",
    "Kilisi selidas",
    "Blddra sidor",
    "Deruleaza pagini",
    "Oldalanknt lptetmi",
    "Desplaar pgina sencera",
  },
  { "Setup.OSD$Sort timers",
    "Timer sortieren",
    "Sortiraj termine",
    "Ordinamento timer",
    "Timers sorteren",
    "Ordenar os timers",
    "Trier les programmations",
    "Sorter timere",
    "Jrjest ajastimet",
    "Sortowanie timerow",
    "Ordenar timers",
    "Organosi programmatismenon",
    "Sortera timers",
    "Sortare timere",
    "A beprogramozott felvtelek elrendezse",
    "Ordenar gravacions programades",
  },
  { "Setup.OSD$Recording directories",
    "Aufnahmeverzeichnisse",
    "Direktoriji za posnetke",
    "Directory di registrazione",
    "Opname directories",
    "Directorias de gravao",
    "Dossiers d'enregistrements",
    "Kataloger til opptak",
    "Tallennehakemistot",
    "Wykaz nagran",
    "Gracaciones en directorios",
    "Fakeloi egrafon",
    "Kataloger fr inspelningar",
    "Directoare inregistrari",
    "Felvtelek listja",
    "Gravacions en subcarpetes",
  },
  { "Setup.EPG$EPG scan timeout (h)",
    "Zeit bis EPG Scan (h)",
    "Cas do EPG pregleda (h)",
    "Timeout scansione EPG (h)",
    "EPG-scan Timeout (h)",
    "Expirou o EPG (h)",
    "Inactivit avant rech. EPG (h)",
    "Ledig tid fr EPG-sk (h)",
    "Ohjelmaoppaan taustapivitys (h)",
    "Czas do skanu EPG (h)",
    "Tiempo hasta exploracin EPG (h)",
    "Xronos mexri eksetasi EPG se Ores",
    "EPG skning timeout",
    "Timeout EPG",
    "Fennmaradt id az EPG-g (h)",
    "Mxim d'Hores a cercar per la Guia",
  },
  { "Setup.EPG$EPG bugfix level",
    "EPG Fehlerbereinigung",
    "Nivo za popravilo EPG napak",
    "Livello correzione EPG",
    "EPG foutcorrectieniveau",
    "Nvel de correcto EPG",
    "Niveau de correction EPG",
    "Niv for EPG-feilretting",
    "Ohjelmaoppaan korjaustaso",
    "Poziom bledow EPG",
    "Nivel para arreglar EPG",
    "EPG Bugfix Vathmos",
    "Niv fr EPG bugfix",
    "Nivel corectie EPG",
    "EPG hibaelhrts",
    "Nivell de correcci de la Guia",
  },
  { "Setup.EPG$Set system time",
    "Systemzeit stellen",
    "Nastavi sistemski cas",
    "Settaggio orario automatico",
    "Systeem klok instellen",
    "Ajustar relgio do sistema",
    "Ajuster l'heure du systme",
    "Juster system-klokken",
    "Aseta kellonaika",
    "Ustawianie czasu",
    "Ajustar reloj de sistema",
    "Sintonismos Oras ipologosti",
    "Stll in systemtid",
    "Seteaza ceasul sistem",
    "Az id belltsa",
    "Ajustar l'hora del sistema",
  },
  { "Setup.EPG$Use time from transponder",
    "Transponder fr Systemzeit",
    "Transponder za nastavitev casa",
    "Utilizza orario da transponder",
    "Gebruik transponder tijd voor systeem",
    "Usar relgio do transponder",
    "Utiliser l'heure de la chane",
    "Bruk klokke fra transponder",
    "Vastaanota kellonaika lhettimelt",
    "Transponder do ustawiania czasu",
    "Transponder para reloj de sistema",
    "Anametadotis gia sintonismo tis oras",
    "Anvnd klockan frn transponder",
    "Preia ceasul din transponder",
    "Idhz tartoz Transponder",
    "Usar el temps del mltiplex",
  },
  { "Setup.DVB$Primary DVB interface",
    "Primres DVB Interface",
    "Primarna naprava",
    "Scheda DVB primaria",
    "Eerste DVB kaart",
    "Interface DVB primrio",
    "Carte DVB primaire",
    "Hoved DVB-enhet",
    "Pvastaanotin",
    "Pierwotny interfejs DVB",
    "Primer interface DVB",
    "Protevon DVB karta",
    "Primr DVB enhet",
    "Placa DVB primara",
    "Els DVB interface",
    "Tarja DVB primria",
  },
  { "Setup.DVB$Video format",
    "Video Format",
    "Video format",
    "Formato video",
    "Videoformaat",
    "Formato vdeo",
    "Format vido",
    "TV-Format",
    "Kuvasuhde",
    "Format telewizyjny",
    "Formato Vdeo",
    "Video Format",
    "Video format",
    "Format Video",
    "Video formtum",
    "Format del vdeo",
  },
  { "Setup.LNB$SLOF (MHz)",
    "SLOF (MHz)",
    "Frekvenca preklopa (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "Limite de bandas LNB (MHz)",
    "Limite de bandes LNB (MHz)",
    "LO-grensefrekvens (MHz)",
    "LNB rajataajuus (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
  },
  { "Setup.LNB$Low LNB frequency (MHz)",
    "Untere LNB-Frequenz (MHz)",
    "Spodnja LNB-frek. (MHz)",
    "Freq LO LNB (MHz)",
    "Laagste LNB frequentie (MHz)",
    "Frequncia base LNB (MHz)",
    "Frquence basse LNB (MHz)",
    "LO-frekvens i lavbndet (MHz)",
    "LNB alempi taajuus (MHz)",
    "Dolna czestotliwosc LNB (MHz)",
    "Frecuencia baja LNB (MHz)",
    "Kato LNB-Sixnotita (MHz)",
    "Undre LNB frekvens (MHz)",
    "Frecvnta LO LNB (Mhz)",
    "Als LNB-frekvencia (MHZ)",
    "Freqncia LNB baixa (MHz)",
  },
  { "Setup.LNB$High LNB frequency (MHz)",
    "Obere LNB-Frequenz (MHz)",
    "Zgornja LNB-frek. (MHz)",
    "Freq HI LNB (MHz)",
    "Hoogste LNB frequentie (MHz)",
    "Frequncia alta LNB (MHz)",
    "Frquence haute LNB (MHz)",
    "LO-frekvens i hybndet (MHz)",
    "LNB ylempi taajuus (MHz)",
    "Gorna czestotliwosc LNB (MHz)",
    "Frecuencia alta LNB (MHz)",
    "Ano LNB-Sixnotita (MHz)",
    "vre LNB frekvens (MHz)",
    "Feecventa HI LNB (MHz)",
    "Fels LNB-frekvencia (MHZ)",
    "Freqncia LNB alta (MHz)",
  },
  { "Setup.LNB$Use DiSEqC",
    "DiSEqC benutzen",
    "Uporabi DiSEqC",
    "Utilizza DiSEqC",
    "DiSEqC gebruiken",
    "Utilizar DiSEqC",
    "Utiliser le DiSEqC",
    "Bruk DiSEqC",
    "DiSEqC kytss",
    "Uzywac DiSEqC",
    "Utilizar DiSEqC",
    "Energopiisi DiSEqC",
    "Anvnd DiSEqC",
    "Utilizez DiSEqC",
    "DiSEqC hasznlata",
    "Utilitzar DiSEqC",
  },
  { "Setup.CICAM$CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "Accs conditionnel",
    "CICAM DVB",
    "CI-moduuli DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "Setare acces conditional",
    "CICAM DVB",
    "Accs condicional CICAM",
  },
  { "Setup.Recording$Margin at start (min)",
    "Zeitpuffer bei Anfang (min)",
    "Premor pred zacetkom (min)",
    "Margine iniziale (min)",
    "Tijd marge begin (min)",
    "Margem inicial (min)",
    "Marge antrieure (min)",
    "Opptaksmargin start (min)",
    "Aloitusmarginaali (min)",
    "Poczatkowy czas buforowy (min)",
    "Comenzar grabacin antes (min)",
    "Prosthetos xronos prin arxi (lepta)",
    "Marginal fr start (min)",
    "Margine la pornire (min)",
    "Ideltolds a kezdsnl (min)",
    "Marge d'inici de gravaci (min)",
  },
  { "Setup.Recording$Margin at stop (min)",
    "Zeitpuffer bei Ende (min)",
    "Premor za koncem (min)",
    "Margine finale (min)",
    "Tijd marge eind (min)",
    "Margem final (min)",
    "Marge postrieure (min)",
    "Opptaksmargin slutt (min)",
    "Lopetusmarginaali (min)",
    "Koncowy czas buforowy (min)",
    "Cortar grabacin despus (min)",
    "Prosthetos xronos sto telos (lepta)",
    "Marginal fr stopp (min)",
    "Margine la oprire (min)",
    "Ideltolds a befejezsnl",
    "Marge de fi de gravaci (min)",
  },
  { "Setup.Recording$Primary limit",
    "Primr-Limit",
    "Osnovna meja",
    "Limite primario",
    "Eerste grens",
    "Limite Primrio",
    "Limite primaire",
    "Prioritetsgrense HovedDVB",
    "Pvastaanottimen prioriteetti",
    "Pierwotny limit",
    "Lmite primario",
    "Protevon orio",
    "Primr grns",
    "Limita Primara",
    "Primr-hatr",
    "Lmit primari",
  },
  { "Setup.Recording$Default priority",
    "Default Prioritt",
    "Osnovna prioriteta",
    "Priorita' predefinita",
    "Standaard prioriteit",
    "Prioridade por defeito",
    "Priorit par dfaut",
    "Normal prioritet (Timer)",
    "Tallenteen oletusprioriteetti",
    "Priorytet pierwotny",
    "Prioridad predefinida",
    "Protereotita",
    "Normal prioritet",
    "Prioritate implicita",
    "Default priority",
    "Prioritat per defecte",
  },
  { "Setup.Recording$Default lifetime (d)",
    "Default Lebensdauer (d)",
    "Osnovni zivljenski cas (d)",
    "Durata predefinita (gg)",
    "Standaard levensduur (d)",
    "Validade por defeito (d)",
    "Dure de vie par dfaut (j)",
    "Normal levetid timer (d)",
    "Tallenteen oletuselinik (d)",
    "Pierwotna trwalosc (d)",
    "Duracin predefinida",
    "Xronos zois",
    "Normal livstid (dagar)",
    "Durata predefinita",
    "Default lettartam",
    "Durada predefinida",
  },
  { "Setup.Recording$Pause priority",
    "Pause Prioritt",
    "Prioriteta pavze",
    "Priorita' di pausa",
    "Pauze prioriteit",
    "",// TODO
    "Priorit des pauses",
    "",// TODO
    "Keskeytyksen prioriteetti",
    "Priorytet przerwy",
    "",// TODO
    "",// TODO
    "Prioritet fr direktinspelning",
    "",// TODO
    "Sznet priorits",
    "Prioritat de la pausa",
  },
  { "Setup.Recording$Pause lifetime (d)",
    "Pause Lebensdauer (d)",
    "Cas pavze (d)",
    "Durata pausa (gg)",
    "Pauze levensduur (d)",
    "",// TODO
    "Dure de vie des pauses (j)",
    "",// TODO
    "Keskeytyksen elinik (d)",
    "Okres trwania przerwy (d)",
    "",// TODO
    "",// TODO
    "Livstid fr direktinspelning (dagar)",
    "",// TODO
    "Sznet lettartama",
    "Durada de la pausa (d)",
  },
  { "Setup.Recording$Use episode name",
    "Episodenname verwenden",
    "Uporabi ime epizode",
    "Utilizza il nome dell'episodio",
    "Gebruik episode naam",
    "Utilizar o nome do episdio",
    "Utiliser le nom de l'pisode",
    "Bruk episodenavn",
    "Kyt jakson nime",
    "Czy uzywac nazwe epizodu",
    "Utilizar nombre de episodo",
    "Xrisimopiisi onomatos episodiou",
    "Anvnd episodnamn",
    "Utilizeaza numele episodului",
    "Epizdnv felhasznlsa",
    "Utilitzar el nom de l'episodi",
  },
  { "Setup.Recording$Mark instant recording",
    "Direktaufzeichnung markieren",
    "Oznaci direktno snemanje",
    "Marca la registrazione",
    "Direkte opnamen markeren",
    "Marca de gravao rpida",
    "Marquage enregistr. immdiats",
    "Markere direkteopptak",
    "Merkitse pikatallenne",
    "Zaznaczyc natychm. nagranie",
    "Marcar grabaciones instantneas",
    "Epilogi trexon egrafis",
    "Mrk direktinspelning",
    "Inregistrare imediata",
    "Direktfelvtel megjellse",
    "Marcar gravaci instantnia",
  },
  { "Setup.Recording$Name instant recording",
    "Direktaufzeichnung benennen",
    "Ime za direktno snemanje",
    "Nome registrazione istantanea",
    "Naam direkt-opname",
    "Nome de gravao rpida",
    "Noms enregistr. immdiats",
    "Navngi direkteopptak",
    "Nime pikatallenne",
    "Nazwac natychm. nagranie",
    "Nombrar grabaciones instantneas",
    "eponomasi trexon egrafis",
    "Namnge direktinspelning",
    "Nume inregistrare imediata",
    "Direktfelvtel megnevezse",
    "Anomenar gravacions instantnies",
  },
  { "Setup.Recording$Instant rec. time (min)",
    "Dauer der Direktaufzeichnung (min)",
    "Cas direktnega snemanja (min)",
    "Tempo registrazione istantanea (min)",
    "Duur van de directe opname (min)",
    "",//TODO
    "Dure enregistr. immdiat (min)",
    "",//TODO
    "Pikatallennuksen kesto (min)",
    "Dlugosc bezposredniego nagrania (min)",
    "Tiempo de grabacin instantnea (min)",
    "Stigmiees egrafes xronos (lepta)",
    "Direktinspelning lngd (min)",
    "Timpul de inregistarea imediata (min)",
    "Felvtel idtartama",
    "Temps de gravaci instantnia (min)",
  },
  { "Setup.Recording$Record Dolby Digital",
    "Dolby Digital Ton aufzeichnen",
    "Posnemi dolby digital",
    "Registra Dolby Digital",
    "Dolby Digital geluid opnamen",
    "Gravar em Dolby Digital",
    "Enregistrer en Dolby Digital",
    "Ta opp Dolby Digital lyd",
    "Dolby Digital tallennus",
    "Nagrywac Dolby Digital",
    "Grabar sonido Dolby Digital",
    "Egrafi tou Dolby Digital ixou",
    "Spela in ljudet med Dolby Digital",
    "Inregistreaza Dolby Digital",
    "Dolby Digitl felvtel",
    "Gravar el so en Dolby Digital",
  },
  { "Setup.Recording$Max. video file size (MB)",
    "Max. Video Dateigre (MB)",
    "Najvecja velikost datoteke (MB)",
    "Dimensione massima file video (MB)",
    "Maximale omvang video file (MB)",
    "Tamanho mximo dos ficheiros (MB)",
    "Taille maxi des fichiers (MB)",
    "Maksimal strrelse p videofiler (MB)",
    "Suurin tiedostokoko (Mt)",
    "Maks. wielkosc pliku (MB)",
    "Tamao mx. de fichero (MB)",
    "Megisto megethos arxeiou (MB)",
    "Maximal filstorlek fr inspelning (MB)",
    "Dimensiune maxima a fisierului video (MB)",
    "Max. video File-terjedelem (MB)",
    "Mida mxima de l'arxiu (MB)",
  },
  { "Setup.Recording$Split edited files",
    "Editierte Dateien aufteilen",
    "Razdeli urejene datoteke",
    "Dividi i file modificati",
    "Bewerkte files opdelen",
    "Quebrar ficheiros",
    "Sparer les squences dites",
    "Splitt redigerte filer",
    "Jaottele muokatut tallenteet",
    "Dzielic montowane pliki",
    "Quebrar ficheros",
    "Diamelisma epeksergasmenon arxeion",
    "Dela upp redigerade filer",
    "Separare fisiere editate",
    "Feldolgozott File-k felosztsa",
    "Separar arxius",
  },
  { "Setup.Replay$Multi speed mode",
    "MultiSpeed Modus",
    "Rezim z vec hitrostmi",
    "Modalita' multispeed",
    "Multi-speed mode",
    "Modo de multi-speed",
    "Mode multi-vitesses",
    "Multispeed modus",
    "Moninopeustila",
    "Tryb wielopredkosciowy",
    "Modo multi-velocidad",
    "Multispeed mode",
    "Multispeed mode",
    "Mod multi-rata",
    "MultiSpeed funkci",
    "Mode de multivelocitat",
  },
  { "Setup.Replay$Show replay mode",
    "Wiedergabestatus anzeigen",
    "Prikazi rezim predvajanja",
    "Modalita' di visualizz su replay",
    "Weergave mode aangeven",
    "Mostrar modo de replay",
    "Affichage mode de lecture",
    "Vis avspillingsmodus",
    "Nyt toiston tila",
    "Wyswietlac status odtwarzania",
    "Mostrar modo de replay",
    "Endiksi katastasis anametadosis",
    "Visa uppspelnings lge",
    "Afiseaza modul de redare",
    "Lejtszs feltntetse",
    "Mostrar mode de reproducci",
  },
  { "Setup.Replay$Resume ID",
    "Wiedergabe ID",
    "Predvajalni ID",
    "Resume ID",// TODO
    "Hervattings ID",
    "Resume ID",// TODO
    "ID de reprise",
    "Resume ID",// TODO
    "Tallenteen paluutunniste",
    "ID odtwarzania",
    "Continuar ID",
    "Resume ID",// TODO
    "teruppta ID",
    "Resume ID",// TODO
    "Lejtszs ID",
    "ID de Continuar",
  },
  { "Setup.Miscellaneous$Min. event timeout (min)",
    "Mindest Event Pause (min)",
    "Najmanjsi cas dogodka (min)",
    "Tempo minimo di pausa (min)", // ??? i don't know...
    "Minimale event time-out (min)",
    "Perodo mnimo de pausa (min)",
    "MinEventTimeout (min)",
    "Minste hendelsespause (min)",
    "Tapahtuman odotusaika (min)",
    "Min. czas do nast. akcji (Event) (min)",
    "Tiempo mnimo pausa (min)",
    "Elaxistos Xronos paremvolis (lepta)",
    "Minsta hndelse-pause (min)",
    "MinEventTimeout (min)",
    "Min. esemny sznet (min)",
    "Temps mnim en pausa (min)",
  },
  { "Setup.Miscellaneous$Min. user inactivity (min)",
    "Mindest Benutzer-Inaktivitt (min)",
    "Najmanjsi cas neaktivnosti (min)",
    "Tempo minimo di inattivita' (min)",
    "Minimum gebruikers inactiviteit (min)",
    "Perodo mnimo de inactividade (min)",
    "Dure minimale d'inact. (min)",
    "Minimumstid med inaktivitet (min)",
    "Kyttjtoiminnon odotusaika (min)",
    "Min. brak aktywnosci uzytkownika (min)",
    "Tiempo mnimo inactividad (min)",
    "Elaxistos xronos mi xrisis (lepta)",
    "Minsta anndar-inaktivitet (min)",
    "Durata minima de inactivitate (min)",
    "Min. kezelsi aktivits (min)",
    "Temps mnim d'inactivitat (min)",
  },
  { "Setup.Miscellaneous$SVDRP timeout (s)",
    "SVDRP Timeout (s)",
    "SVDRP cas neaktivnosti (s)",
    "Timeout SVDRP (s)",
    "SVDRP Timeout (s)",
    "Timeout SVDRP (s)",
    "Temps maxi SVDRP (s)",
    "Ubrukt SVDRP-levetid (s)",
    "SVDRP odotusaika (s)",
    "Min. brak aktywnosci SVDRP (s)",
    "SVDRP Timeout (s)",
    "SVDRP Timeout (d)",
    "SVDRP Timeout (d)",
    "Timeout SVDRP (sec)",
    "SVDRP Timeout (s)",
    "SVDRP Timeout (s)",
  },
  { "Setup.Miscellaneous$Zap timeout (s)",
    "Zap Timeout (s)",
    "",// TODO
    "",// TODO
    "Zap timeout (s)",
    "",// TODO
    "",// TODO
    "",// TODO
    "Kanavavalinnan odotusaika (s)",
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
  },
  // The days of the week:
  { "MTWTFSS",
    "MDMDFSS",
    "PTSCPSN",
    "LMMGVSD",
    "MDWDVZZ",
    "STQQSSD",
    "LMMJVSD",
    "MTOTFLS",
    "MTKTPLS",
    "PWSCPSN",
    "LMMJVSD",
    "DTTPPSK",
    "MTOTFLS",
    "LMMJVSD",
    "HKSCPSV",
    "LMCJVSG",
  },
  { "MonTueWedThuFriSatSun", // must all be 3 letters!
    "MonDieMitDonFreSamSon",
    "PonTorSreCetPetSobNed",
    "LunMarMerGioVenSabDom",
    "MaaDinWoeDonVryZatZon",
    "SegTerQuaQuiSexSabDom",
    "LunMarMerJeuVenSamDim",
    "ManTirOnsTorFreLrSn",
    "Ma Ti Ke To Pe La Su ",
    "PonWtoSroCzwPiaSobNie",
    "LunMarMieJueVieSabDom",
    "DevTriTetPemParSavKir",
    "MnTisOnsTorFreLrSn",
    "LunMarMieJoiVinSimDum",
    "HtKedSzeCsPnSzoVas",
    "Dl Dm Dc Dj Dv Ds Dg ",
  },
  // The allowed characters in strings:
  { " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    "",// TODO
    "",// TODO
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    "",// TODO
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    "",// TODO
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.,#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.,#~_",
  },
  // Learning keys:
  { "Learning Remote Control Keys (%s)",
    "Fernbedienungs-Codes lernen (%s)",
    "Ucenje kod upravljalca (%s)",
    "Apprendimento tasti unita` remota (%s)",
    "Leren toetsen afstandsbediening (%s)",
    "Aprender as teclas do telecomando (%s)",
    "Apprentissage des codes de tlcommande (%s)",
    "Lre fjernkontrolltaster (%s)",
    "Kaukostimen opettaminen (%s)",
    "Nauka kodu pilota (%s)",
    "Aprendiendo teclas del telemando (%s)",
    "Ekmathisi pliktron tilexirismou (%s)",
    "Inlrning av fjrrkontrollsknappar (%s)",
    "Invatare taste telecomanda (%s)",
    "Tvirnyt betantsa (%s)",
    "Aprenent les tecles del comandament a distncia (%s)",
  },
  { "Phase 1: Detecting RC code type",
    "Phase 1: FB Code feststellen",
    "Faza 1: Sprejemanje IR kode",
    "Fase 1: tipo ricevitore RC",
    "Fase 1: detecteren type afstandsbediening",
    "Fase 1: detectar tipo de receptor",
    "Phase 1: Dtection du type de code",
    "Fase 1: Finne fjernkontroll-kodetype",
    "Vaihe 1: Koodauksen tunnistaminen",
    "Faza 1: Detekcja typu kodu",
    "Fase 1: Detectando tipo de receptor",
    "Phasi 1: Anixneusi kodika RC",
    "Steg1: identifiering av RC kod",
    "Faza 1: Detectie tip telecomanda",
    "Els lps: tvirnyt kdjnak meghatrozsa",
    "Fase 1: Detectant el tipus de receptor",
  },
  { "Press any key on the RC unit",
    "Eine Taste auf der FB drcken",
    "Pritisnite tipko na upravljalcu",
    "Premere un tasto dell'unita` RC",
    "Druk op een willekeurige knop",
    "Pressione qualquer tecla do telecomando",
    "Appuyer sur une touche de la tlcommande",
    "Trykk en av tastene p fjernkontrollen",
    "Paina mit tahansa kaukostimen nppint",
    "Nacisnac klawisz pilota",
    "Pulse una tecla en el telemando",
    "Piese ena pliktro sto tilexiristirio",
    "Tryck valfri tangent p fjrrkontrollen",
    "Apasati o tasta pe telecomanda",
    "Nyomjon meg egy gombot a tvirnytn",
    "Premeu qualsevol tecla del comandament",
  },
  { "RC code detected!",
    "FB Code erkannt!",
    "IR koda sprejeta!",
    "Codice RC rilevato!",
    "Afstandsbediening code herkend!",
    "Cdigo do telecomando detectado!",
    "Code de la tlcommande dtect!",
    "Fjernkontroll-kodetype funnet!",
    "Nppinpainallus vastaanotettu!",
    "Kod pilota zostal poznany!",
    "Cdigo detectado!",
    "Evrethike kodikas RC!",
    "RC koden detekterad!",
    "S-a detectat tipul telecomenzii!",
    "Tvirnyt kdja felismerve!",
    "Codi detectat!",
  },
  { "Do not press any key...",
    "Keine Taste drcken...",
    "Ne pritiskajte tipk...",
    "Non premere alcun tasto...",
    "Druk niet op een knop...",
    "No pressione nada...",
    "N'appuyer sur aucune touche ...",
    "Ikke trykk p noen av tastene...",
    "l paina kaukostimen nppimi...",
    "Nie naciskac klawiszy...",
    "No pulse ninguna tecla...",
    "Min piezeis pliktra...",
    "Tryck inte p ngon knapp...",
    "Nu apasati nicio tasta...",
    "Ne nyomjon meg gombot...",
    "No premeu cap tecla...",
  },
  { "Phase 2: Learning specific key codes",
    "Phase 2: Einzelne Tastencodes lernen",
    "Faza 2: Ucenje posebnih kod",
    "Fase 2: Codici specifici dei tasti",
    "Fase 2: Leren specifieke toets-codes",
    "Fase 2: A aprender cdigos especificos",
    "Phase 2: Apprentissage des codes des touches",
    "Fase 2: Lre spesifikke tastekoder",
    "Vaihe 2: Nppinkoodien opettelu",
    "Faza 2: Nauka pojedynczych klawiszy",
    "Fase 2: Aprendiendo cdigos especficos",
    "Fasi 2: Ekmathisi memonomenon kodikon pliktron",
    "Fas 2: Inlrning av specifika knapp koder",
    "Faza 2: Invatarea codurilor specifice tastelor",
    "Msodik lps: az egyes gombok betantsa",
    "Fase 2: Aprenentantge de les funcions",
  },
  { "Press key for '%s'",
    "Taste fr '%s' drcken",
    "Pritisnite tipko za '%s'",
    "Premere il tasto per '%s'",
    "Druk knop voor '%s'",
    "Pressione tecla para '%s'",
    "Appuyer sur la touche '%s'",
    "Trykk tasten for '%s'",
    "Paina nppint toiminnolle '%s'",
    "Nacisnac klawisz dla '%s'",
    "Pulsar tecla para '%s'",
    "Piese to pliktro gia '%s'",
    "Tryck p knappen fr '%s'",
    "Apasati tasta pentru '%s'",
    "'%s' gomb megnyomsa",
    "Premeu una tecla per '%s'",
  },
  { "Press 'Up' to confirm",
    "'Auf' drcken zum Besttigen",
    "Pritisnite tipko 'Gor' za potrditev",
    "Premere 'Su' per confermare",
    "Druk 'Omhoog' om te bevestigen",
    "Pressione 'Cima' para confirmar",
    "Appuyer sur 'Haut' pour confirmer",
    "Trykk 'Opp' for  bekrefte",
    "Hyvksy painamalla 'Yls'",
    "Nacisnac 'Gora' do potwierdzenia",
    "Pulse 'Arriba' para confirmar",
    "Piese 'pano' gia apodoxi",
    "Tryck 'Upp' fr att bekrfta",
    "Apsati 'Sus' pentru confirmare",
    "'Fel' megnyomsa az elfogadshoz",
    "Premeu 'Amunt' per confirmar",
  },
  { "Press 'Down' to continue",
    "'Ab' drcken zum Weitermachen",
    "Pritisnite tipko 'Dol' za nadaljevanje",
    "Premere 'Giu' per continuare",
    "Druk 'Omlaag' om verder te gaan",
    "Pressione 'Baixo' para continuar",
    "Appuyer sur 'Bas' pour continuer",
    "Trykk Ned' for  fortsette",
    "Jatka painamalla 'Alas'",
    "Nacisnac 'Dol' zeby kontynuowac",
    "Pulse 'Abajo' para confirmar",
    "Piese 'kato' gia sinexia",
    "Tryck 'Ner' fr att bekrfta",
    "Apasati jos pentru continuare",
    "'Le' megnyomsa a folytatshoz",
    "Premeu 'Avall' per continuar",
  },
  { "(press 'Up' to go back)",
    "('Auf' drcken um zurckzugehen)",
    "(pritisnite 'Gor' za nazaj)",
    "(premere 'Su' per tornare indietro)",
    "(druk 'Omhoog' om terug te gaan)",
    "(Pressione 'Cima' para voltar)",
    "(Appuyer sur 'Haut' pour revenir en arrire)",
    "(trykk 'Opp' for  g tilbake)",
    "(palaa takaisin painamalla 'Yls')",
    "(Nacisnac 'Gora' cofa)",
    "(Pulse 'Arriba' para retornar)",
    "(Piese 'pano' gia epistrofi",
    "(Tryck 'Upp' fr att backa)",
    "(Apsati 'Sus' pentru revenire)",
    "(Fel' megnyomsa a visszatrshez)",
    "(Premeu 'Amunt' per retornar)",
  },
  { "(press 'Down' to end key definition)",
    "('Ab' drcken zum Beenden)",
    "(pritisnite 'Dol' za konec)",
    "('Giu' per finire la definizione tasti)",
    "(Druk 'Omlaag' om te beeindigen)",
    "(Pressione 'Baixo' para terminar a definio)",
    "(Appuyer sur 'Bas' pour terminer)",
    "(trykk 'Ned' for  avslutte innlring)",
    "(lopeta opettaminen painamalla 'Alas')",
    "(Nacisnac 'Dol' by zakonczyc)",
    "(Pulse 'Abajo' para terminar programacin teclas)",
    "(Piese 'Kato' gia termatismo diloseon plktron)",
    "(Tryck 'Ner' fr att avsluta knapp definition)",
    "(Apasati 'Jos' pentru terminare)",
    "('Le' megnyomsa a befejezshez)",
    "(Premeu 'Avall' per finalitzar l'aprenentatge)",
  },
  { "(press 'Menu' to skip this key)",
    "('Men' drcken zum berspringen)",
    "pritisnite 'Meni' za preskok te tipke",
    "(premere 'Menu' per saltare questo tasto)",
    "Druk 'Menu' om deze toets over te slaan",
    "",// TODO
    "('Menu' pour passer cette touche)",
    "",// TODO
    "nppimen puuttuessa paina 'Valikko'",
    "(Nacisnac 'Menu' by ominac klawisz)",
    "Pulse 'Menu' para saltarse esta tecla",
    "Pata 'Menou' gia prosperasi aftou tou pliktrou",
    "Tryck 'Meny' fr att hoppa ver denna knapp.",
    "",// TODO
    "A Men gombot nyomni ennek a gombnak a kihagyshoz",
    "Premeu 'Men' per obviar aquesta tecla",
  },
  { "Phase 3: Saving key codes",
    "Phase 3: Codes abspeichern",
    "Faza 3: Shranjevanje kod tipk",
    "Fase 3: Salvataggio codici tasti",
    "Fase 3: Opslaan toets codes",
    "Fase 3: A salvar os cdigos das teclas",
    "Phase 3: Sauvegarde des codes des touches",
    "Fase 3: Lagre tastekoder",
    "Vaihe 3: Nppinkoodien tallentaminen",
    "Faza 3: Zapamietac Kod",
    "Fase 3: Guardar cdigos de teclas",
    "Fasi 3: Apothikevsi kodikon",
    "Fas 3: Spara knappkoder",
    "Faza 3: Salvarea codurilor de taste",
    "Harmadik lps: kd mentse",
    "Fase 3: Guardant els codis de les tecles",
  },
  { "Press 'Up' to save, 'Down' to cancel",
    "'Auf' speichert, 'Ab' bricht ab",
    "'Gor' za potrditev, 'Dol' za prekinitev",
    "'Su' per salvare, 'Giu' per annullare",
    "'Omhoog' te bewaren, 'Omlaag' voor annuleren",
    "'Cima' para Salvar, 'Baixo' para Cancelar",
    "Appuyer sur 'Haut' pour sauvegarder, 'Bas' pour annuler",
    "Trykk 'Opp' for  lagre, 'Ned' for  avbryte",
    "Paina 'Yls' tallentaaksesi ja 'Alas' peruuttaaksesi",
    "'Gora' zapamietuje, 'Dol' przerywa",
    "Pulse 'Arriba' para guardar, 'Abajo' para anular",
    "'Pano' apothikevsi, 'Kato' akirosi",
    "Tryck 'Upp' fr att spara, 'Ner' fr att avsluta",
    "Apsati 'Sus' pentru salvare, 'Jos' pentru anulare",
    "'Fel' ments, 'Le mgse",
    "Premeu 'Amunt' per guardar, 'Avall' per anullar",
  },
  // Key names:
  { "Up",
    "Auf",
    "Gor",
    "Su",
    "Omhoog",
    "Cima",
    "Haut",
    "Opp",
    "Yls",
    "Gora",
    "Arriba",
    "Pano",
    "Upp",
    "Sus",
    "Fel",
    "Amunt",
  },
  { "Down",
    "Ab",
    "Dol",
    "Giu",
    "Omlaag",
    "Baixo",
    "Bas",
    "Ned",
    "Alas",
    "Dol",
    "Abajo",
    "Kato",
    "Ner",
    "Jos",
    "Le",
    "Avall",
  },
  { "Menu",
    "Men",
    "Meni",
    "Menu",
    "Menu",
    "Menu",
    "Menu",
    "Meny",
    "Valikko",
    "Menu",
    "Menu",
    "Menou",
    "Meny",
    "Meniu",
    "Men",
    "Men",
  },
  { "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "D'acord",
  },
  { "Back",
    "Zurck",
    "Nazaj",
    "Indietro",
    "Terug",
    "Voltar",
    "Retour",
    "Tilbake",
    "Takaisin",
    "Wstecz",
    "Retornar",
    "Piso",
    "Tillbaka",
    "Inapoi",
    "Vissza",
    "Retornar",
  },
  { "Left",
    "Links",
    "Levo",
    "Sinistra",
    "Links",
    "Esquerda",
    "Gauche",
    "Venstre",
    "Vasemmalle",
    "Lewo",
    "Izquierda",
    "Aristera",
    "Vnster",
    "Stinga",
    "Balra",
    "Esquerra",
  },
  { "Right",
    "Rechts",
    "Desno",
    "Destra",
    "Rechts",
    "Direita",
    "Droite",
    "Hyre",
    "Oikealle",
    "Prawo",
    "Derecha",
    "Deksia",
    "Hger",
    "Dreapta",
    "Jobbra",
    "Dreta",
  },
  { "Red",
    "Rot",
    "Rdeca",
    "Rosso",
    "Rood",
    "Vermelho",
    "Rouge",
    "Rd",
    "Punainen",
    "Czerwony",
    "Rojo",
    "Kokino",
    "Rd",
    "Rosu",
    "Piros",
    "Vermell",
  },
  { "Green",
    "Grn",
    "Zelena",
    "Verde",
    "Groen",
    "Verde",
    "Vert",
    "Grnn",
    "Vihre",
    "Zielony",
    "Verde",
    "Prasino",
    "Grn",
    "Verde",
    "Zld",
    "Verd",
  },
  { "Yellow",
    "Gelb",
    "Rumena",
    "Giallo",
    "Geel",
    "Amarelo",
    "Jaune",
    "Gul",
    "Keltainen",
    "Zolty",
    "Amarillo",
    "Kitrino",
    "Gul",
    "Galben",
    "Srga",
    "Groc",
  },
  { "Blue",
    "Blau",
    "Modra",
    "Blu",
    "Blauw",
    "Azul",
    "Bleu",
    "Bl",
    "Sininen",
    "Niebieski",
    "Azul",
    "Mple",
    "Bl",
    "Albastru",
    "Kk",
    "Blau",
  },
  { "Play",
    "Wiedergabe",
    "Predvajaj",
    "Riproduci",
    "Weergeven",
    "",// TODO
    "Lecture",
    "",// TODO
    "Toista",
    "Odtworzenie",
    "Reproducir",
    "Anametadosi",
    "Spela upp",
    "",// TODO
    "Lejtszs",
    "Reproduir",
  },
  { "Pause",
    "Pause",
    "Pavza",
    "Pausa",
    "Pauze",
    "",// TODO
    "Pause",
    "",// TODO
    "Keskeyt",
    "Przerwa",
    "Pausa",
    "Dialima",
    "Pausa",
    "",// TODO
    "Sznet",
    "Pausa",
  },
  { "Stop",
    "Stop",
    "Ustavi",
    "Stop",
    "Stop",
    "Stop",
    "Stop",
    "",// TODO
    "Lopeta",
    "Stop",
    "Parar",
    "Terma",
    "Stoppa",
    "",// TODO
    "Stop",
    "Aturar",
  },
  { "Record",
    "Aufnehmen",
    "Snemaj",
    "Registra",
    "Opnemen",
    "",// TODO
    "Enregistrement",
    "",// TODO
    "Tallenna",
    "Nagrywac",
    "Grabar",
    "Egrafi",
    "Spela in",
    "",// TODO
    "Felvenni",
    "Gravar",
  },
  { "FastFwd",
    "Vorlauf",
    "Hitro naprej",
    "Avanti Veloce",
    "Vooruitspoelen",
    "",// TODO
    "Avance rapide",
    "",// TODO
    "Pikakelaus >>",
    "Naprzod",
    "Adelante rpido",
    "Girisma mprosta",
    "Snabbspolning framt",
    "",// TODO
    "Elre prgetni",
    "Endavant rpidament",
  },
  { "FastRew",
    "Rcklauf",
    "Hitro nazaj",
    "Indietro Veloce",
    "Terugspoelen",
    "",// TODO
    "Retour rapide",
    "",// TODO
    "Pikakelaus <<",
    "Wstecz",
    "Atrs rpido",
    "Girisma piso",
    "Snabbspolning bakt",
    "",// TODO
    "Vissza prgetni",
    "Enrera rpidament",
  },
  { "Power",
    "Ausschalten",
    "Izklop",
    "Power",
    "Uitschakelen",
    "Ligar",
    "Veille", // This one caused some bug reports ;)
    "Power",
    "Virtakytkin",
    "Wylaczyc",
    "Corriente",
    "Klisimo",
    "P/Av",
    "Pornit",
    "Kikapcsolni",
    "Aturar",
  },
  { "Channel+",
    "Kanal+",
    "Kanal+",
    "Canale +",
    "Kanaal+",
    "",// TODO
    "Chane+",
    "",// TODO
    "Kanava +",
    "Kanal+",
    "Canal +",
    "Kanali+",
    "Kanal+",
    "",// TODO
    "Csatorna+",
    "Canal +",
  },
  { "Channel-",
    "Kanal-",
    "Kanal-",
    "Canale -",
    "Kanaal-",
    "",// TODO
    "Chane-",
    "",// TODO
    "Kanava -",
    "Kanal-",
    "Canal -",
    "Kanali-",
    "Kanal-",
    "",// TODO
    "Csatorna-",
    "Canal -",
  },
  { "Volume+",
    "Lautstrke+",
    "Glasnost+",
    "Volume +",
    "Volume+",
    "Volume+",
    "Volume+",
    "Volum+",
    "nenvoimakkuus +",
    "Glosnej",
    "Volumen+",
    "Entasi+",
    "Volym+",
    "Volum+",
    "Hanger+",
    "Volum +",
  },
  { "Volume-",
    "Lautstrke-",
    "Glasnost-",
    "Volume -",
    "Volume-",
    "Volume-",
    "Volume-",
    "Volum-",
    "nenvoimakkuus -",
    "Ciszej",
    "Volumen-",
    "Entasi-",
    "Volym-",
    "Volum-",
    "Hanger-",
    "Volum -",
  },
  { "Mute",
    "Stumm",
    "Izklop zvoka",
    "Mute",
    "Geluid onderbreken",
    "Sem som",
    "Coupure du son",
    "Lyd av",
    "netn",
    "Cisza",
    "Mudo",
    "Siopilo",
    "Ljud Av",
    "Mut(e)",
    "Csend",
    "En silenci",
  },
  // Miscellaneous:
  { "yes",
    "ja",
    "da",
    "si",
    "ja",
    "sim",
    "oui",
    "ja",
    "kyll",
    "tak",
    "s",
    "nai",
    "ja",
    "da",
    "igen",
    "s",
  },
  { "no",
    "nein",
    "ne",
    "no",
    "nee",
    "no",
    "non",
    "nei",
    "ei",
    "nie",
    "no",
    "oxi",
    "nej",
    "nu",
    "nem",
    "no",
  },
  { "off",
    "aus",
    "izklop",
    "off",
    "uit",
    "off",
    "",// TODO
    "",// TODO
    "pois",
    "wyl.",
    "off",
    "klisto",
    "av",
    "",// TODO
    "ki",
    "off",
  },
  { "none",
    "keine",
    "nobeden",
    "nessuno",
    "geen",
    "",// TODO
    "aucun",
    "",// TODO
    "tyhj",
    "zaden",
    "ninguno",
    "kanena",
    "ingen",
    "",// TODO
    "semmi",
    "cap",
  },
  { "auto",
    "auto",
    "avtomatsko",
    "auto",
    "auto",
    "",// TODO
    "auto",
    "",// TODO
    "auto",
    "auto",
    "auto",
    "aftomato",
    "automatisk",
    "",// TODO
    "auto",
    "auto",
  },
  { "top",
    "oben",
    "zgoraj",
    "limite sup",
    "boven",
    "topo",
    "haut",
    "vre",
    "ylreuna",
    "gora",
    "parte superior",
    "pano",
    "vre",
    "sus",
    "Fent",
    "a dalt",
  },
  { "bottom",
    "unten",
    "spodaj",
    "limite inf",
    "onder",
    "fundo",
    "bas",
    "nedre",
    "alareuna",
    "dol",
    "parte inferior",
    "kato",
    "undre",
    "jos",
    "lent",
    "a baix",
  },
  { "Disk",
    "Disk",
    "Disk",
    "Disco",
    "Disk",
    "Disk",
    "Disque",
    "Disk",
    "Levy",
    "Disk",
    "Disco",
    "Disk",
    "Disk",
    "Disc",
    "Lemez",
    "Disc",
  },
  { "free",
    "frei",
    "prosto",
    "liberi",
    "vrij",
    "livre",
    "restant",
    "ledig",
    "vapaana",
    "pozostalo",
    "libre",
    "akoma",
    "ledigt",
    "liber",
    "szabad",
    "lliure",
  },
  { "Jump: ", // note the trailing blank
    "Springen: ",
    "Skoci: ",
    "Vai a: ",
    "Springen: ",
    "Saltar: ",
    "Accs direct: ",
    "Hopp: ",
    "Siirry: ",
    "Skok: ",
    "Salta a: ",
    "Pidima: ",
    "Hopp: ",
    "Salt: ",
    "Ugrs: ",
    "Salta a:",
  },
  { "Volume ", // note the trailing blank
    "Lautstrke ",
    "Glasnost ",
    "Volume ",
    "Volume ",
    "Volume ",
    "Volume ",
    "Volum ",
    "nenvoimakkuus ",
    "Glosnosc ",
    "Volumen ",
    "Entasi ",
    "Volym ",
    "Volum ",
    "Hanger ",
    "Volum ",
  },
  { " Stop replaying", // note the leading blank!
    " Wiedergabe beenden",
    " Prekini ponavljanje",
    " Interrompi riproduzione",
    " Stop afspelen",
    " Parar reproduo",
    " Arrter la lecture",
    " Stopp avspilling",
    " Lopeta toisto",
    " Zatrzymac odtwarzanie",
    " Parar reproducin",
    " Telos anametadosis",
    " Avsluta uppspelning",
    " Opreste redare",
    " Lejtszst befejzni",
    " Aturar la reproducci",
  },
  { " Stop recording ", // note the leading and trailing blanks!
    " Aufzeichnung beenden ",
    " Prekini snemanje ",
    " Interrompi registrazione ",
    " Stop opnemen ",
    " Parar gravao ",
    " Arrter l'enregistrement ",
    " Stopp opptak fra ",
    " Lopeta tallennus ",
    " Zatrzymac nagrywanie ",
    " Parar grabacin ",
    " Telos egrafis ",
    " Avsluta inspelning ",
    " Opreste inregistrarea ",
    " Felvtelt befejezni ",
    " Aturar la gravaci ",
  },
  { " Cancel editing", // note the leading blank!
    " Schneiden abbrechen",
    " Prekini urejanje",
    " Annulla modifiche",
    " Bewerken afbreken",
    " Anular modificao",
    " Annuler le montage",
    " Avbryt redigering",
    " Peru muokkaus",
    " Przerwac montaz",
    " Anular modificacin ",
    " Akirosi epexsergasias",
    " Avbryt redigering",
    " Opreste editare",
    " Vgst megszaktani",
    " Cancellar l'edici ",
  },
  { "Switching primary DVB...",
    "Primres Interface wird umgeschaltet...",
    "Preklapljanje primarne naprave...",
    "Cambio su card DVB primaria...",
    "Eerste DVB-kaart wordt omgeschakeld...",
    "A mudar interface DVB primrio...",
    "Changement de carte DVB primaire...",
    "Bytter frste DVB-enhet...",
    "Vaihdetaan pvastaanottimelle...",
    "Pierwszy interfejs DVB przelacza...",
    "Cambio al interface DVB primario...",
    "I protevon DVB Karta alazi...",
    "Byter primr DVB enhet...",
    "Comuta interfata primara DVB...",
    "Primr Interface tkapcsolva...",
    "Canviant a la interfcie DVB primria...",
  },
  { "Up/Dn for new location - OK to move",
    "Auf/Ab fr neue Position - dann OK",
    "Gor/Dol za novo poz. - Ok za premik",
    "Su/Giu per nuova posizione - OK per muovere",
    "Gebruik Omhoog/Omlaag - daarna Ok",
    "Cima/Baixo para nova localizao - Ok para mover",
    "Haut/Bas -> nouvelle place - OK -> dplacer",
    "Opp/Ned for ny plass - OK for  flytte",
    "'Yls/Alas' uusi paikka - 'OK' hyvksy",
    "Gora/Dol na nowa pozycje - Ok zmienia",
    "Arriba/Abajo para el nuevo lugar - OK para mover",
    "Pano/Kato gia nea thesi. meta OK",
    "Upp/Ner fr ny plats - OK fr att flytta",
    "Sus/Jos pentru noua locatie - OK pentru a muta",
    "Fel/Le egy uj opcirt - aztn OK",
    "Amunt/Avall per una nova localitzaci - OK per moure",
  },
  { "Editing process started",
    "Schnitt gestartet",
    "Urejanje se je zacelo",
    "Processo di modifica iniziato",
    "Bewerken is gestart",
    "Processo de modificao iniciado",
    "Opration de montage lance",
    "Redigeringsprosess startet",
    "Muokkaus aloitettu",
    "Uruchomiony proces montazu",
    "Proceso modificacin iniciado",
    "Arxi epexsergasias",
    "Redigering startad",
    "Procesul de editare a inceput",
    "Vgs elindtva",
    "Procs d'edici iniciat",
  },
  { "Editing process finished",
    "Schnitt beendet",
    "Proces urejanja je koncan",
    "Processo di modifica terminato",
    "Bewerken is klaar",
    "Processo de modificao terminado",
    "Montage termin",
    "Redigeringsprosess avsluttet",
    "Muokkaus lopetettu",
    "Proces montazu zakonczony",
    "Proceso de modificacin terminado",
    "I epexsergasia teliose",
    "Redigering avslutad",
    "Procesul de editare s-a terminat",
    "Vgs befejezve",
    "Procs d'edici finalitzat",
  },
  { "Editing process failed!",
    "Schnitt gescheitert!",
    "Napaka pri procesu urejenja!",
    "Processo di modifica fallito!",
    "Bewerken is mislukt!",
    "Falha no processo de modificao",
    "Echec du montage!",
    "Feil under redigering!",
    "Muokkaus eponnistui!",
    "Bledny proces montazu!",
    "Modificacin ha fallado!",
    "I epexsergasia apetixe!",
    "Redigeringsprocessen misslyckades",
    "Proces de editare nereusit",
    "Vgs sikertelen!",
    "Procs d'edici fallit!",
  },
  { "scanning recordings...",
    "Aufzeichnungen werden durchsucht...",
    "iskanje posnetkov...",
    "scansione registrazioni...",
    "Doorzoeken opnames...",
    "A pesquisar gravaes...",
    "Recherche des enregistrements...",
    "Gr igjennom opptakene...",
    "haetaan tallenteita...",
    "Skan nagran...",
    "buscando grabaciones...",
    "Eksetasi egrafon...",
    "Sker igenom inspelningarna...",
    "Caut inregistrari...",
    "Felvett adsok bngszse...",
    "cercant gravacions...",
  },
  { "Pausing live video...",
    "Live-Signal wird angehalten...",
    "Ustavljanje predvajanja v zivo...",
    "Pausa del canale in visione...",
    "Pauzeren live uitzending...",
    "",// TODO
    "Pause de l'mission en direct...",
    "",// TODO
    "Keskeytetn lhetys...",
    "Zatrzymany program biezacy...",
    "Emisin en directo parada...",
    "",// TODO
    "Pausar direktinspelningen",
    "",// TODO
    "Az l ads meglltva...",
    "Pausa d'emissi en directe...",
  },
  { "This plugin has no setup parameters!",
    "Dieses Plugin hat keine Setup-Parameter!",
    "Ta plugin nima nastavitvenih parametrov!",
    "Questo plugin non ha parametri di setup!",
    "Deze plugin heeft geen instelparameters",
    "",// TODO
    "Ce plugin n'a pas de paramtres!",
    "",// TODO
    "Tll laajennoksella ei ole asetuksia!",
    "Ten plugin niema parametrow!",
    "Este plugin no admite configuracin",
    "Afto to plugin den exi parametrous",
    "Den hr modulen har inga parametrar",
    "",// TODO
    "Ennek a plugin-nak nincs setup-parametere!",
    "Aquest plugin no admet configuraci!",
   },
  { NULL }
  };

// --- cI18nEntry ------------------------------------------------------------

class cI18nEntry : public cListObject {
private:
  const tI18nPhrase *phrases;
  const char *plugin;
public:
  cI18nEntry(const tI18nPhrase * const Phrases, const char *Plugin);
  const tI18nPhrase *Phrases(void) { return phrases; }
  const char *Plugin(void) { return plugin; }
  };

cI18nEntry::cI18nEntry(const tI18nPhrase * const Phrases, const char *Plugin)
{
  phrases = Phrases;
  plugin = Plugin;
}

// --- cI18nList -------------------------------------------------------------

class cI18nList : public cList<cI18nEntry> {
public:
  cI18nEntry *Get(const char *Plugin);
  const tI18nPhrase *GetPhrases(const char *Plugin);
  };

cI18nEntry *cI18nList::Get(const char *Plugin)
{
  if (Plugin) {
     for (cI18nEntry *p = First(); p; p = Next(p)) {
         if (strcmp(p->Plugin(), Plugin) == 0)
            return p;
         }
     }
  return NULL;
}

const tI18nPhrase *cI18nList::GetPhrases(const char *Plugin)
{
  cI18nEntry *p = Get(Plugin);
  return p ? p->Phrases() : NULL;
}

cI18nList I18nList;

// ---

void I18nRegister(const tI18nPhrase * const Phrases, const char *Plugin)
{
  cI18nEntry *p = I18nList.Get(Plugin);
  if (p)
     I18nList.Del(p);
  if (Phrases)
     I18nList.Add(new cI18nEntry(Phrases, Plugin));
}

const char *I18nTranslate(const char *s, const char *Plugin)
{
  if (Setup.OSDLanguage) {
     const tI18nPhrase *p = Plugin ? I18nList.GetPhrases(Plugin) : Phrases;
     if (!p)
        p = Phrases;
     for (int i = ((p == Phrases) ? 1 : 2); i--; ) {
         for (; **p; p++) {
             if (strcmp(s, **p) == 0) {
                const char *t = (*p)[Setup.OSDLanguage];
                if (t && *t)
                   return t;
                }
             }
         p = Phrases;
         }
     esyslog("%s%sno translation found for '%s' in language %d (%s)\n", Plugin ? Plugin : "", Plugin ? ": " : "", s, Setup.OSDLanguage, Phrases[0][Setup.OSDLanguage]);
     }
  const char *p = strchr(s, '$');
  return p ? p + 1 : s;
}

const char * const * I18nLanguages(void)
{
  return &Phrases[0][0];
}
