/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#ifndef _TFFMPEG_H_
#define _TFFMPEG_H_

#include <ffmpeg/avcodec.h>
#include <ffmpeg/avformat.h>

#include "../const.h"

class TFfmpeg
{
	public:
		TFfmpeg();
		int init(const char *mrl);
		void close();
		const char *videoCodec();
		const char *audioCodec();
		int getLength();
		const unsigned char *getCurrentFrame(int, int*, int*);
		//unsigned char *yv12ToRgb(uint8_t *src_y, uint8_t *src_u, uint8_t *src_v, int width, int height);
	
	private:
		//QString  videocodec, audiocodec;
		int length;
		AVFormatContext *pFormatCtx;
		AVCodecContext *pCodecCtx;
		AVCodec *pCodec;
		AVFrame *pFrame;
		AVFrame *pFrameRGB;
		int videoStream;
		uint8_t *buffer;
};

#endif
 
