(**
  A demo for the VOArray class. Shows all 256 keycodes in an array of buttons.
**)

MODULE AsciiTable;

(*
    Demo for VisualOberon. Shows the ascci-table.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This file is part of VisualOberon.

    VisualOberon is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.  

    VisualOberon is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details. 

    You should have received a copy of the GNU General Public License
    along with VisualOberon. If not, write to the Free Software
    Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT AR  := VOArray,
       B   := VOButton,
       D   := VODisplay,
       F   := VOFrame,
       FG  := VOFrameGroup,
       O   := VOGUIObject,
       Q   := VOQuickHelp,
       U   := VOUtil,
       T   := VOText,
              VOUsePrefs,
       W   := VOWindow,
       WG  := VOWindowGroup,
       
              Ascii,
       str := Strings,
       co  := IntStr,
              Err;

VAR
  d          : D.Display;
  w          : W.Window;

  array      : AR.Array;
  button     : B.Button;
  string     : U.Text;
  text       : T.Text;
  frame      : FG.FrameGroup;
  wGroup     : WG.WindowGroup;

  msg2Exit   : D.Msg2Exit;

  buff       : ARRAY 3 OF CHAR;
  buff2,
  buff3      : ARRAY 20 OF CHAR;
  i          : LONGINT;

BEGIN 
  NEW(d);
  IF ~d.InitDisplay("AsciiTable") THEN
    Err.String("Cannot open to display!"); Err.Ln;
    HALT(1);
  END;

  NEW(frame);
  frame.Init;
  frame.SetFlags({O.horizontalFlex,O.verticalFlex});
  frame.SetFrame(F.groupFrame);

    string:=U.EscapeString("\es\ecAscii-table");
    NEW(text);
    text.Init;
    text.SetText(string^);  
  
  frame.SetLabel(text);
  
    NEW(array);
    array.Init;
    array.Set(16,TRUE);
    array.SetFlags({O.horizontalFlex,O.verticalFlex});
  
      FOR i:=0 TO 255 DO
        CASE CHR(i) OF (* we filter some of them :-) *)
          Ascii.lf:
            buff[0]:=" ";
            buff[1]:=0X;
        | "\":
            buff[0]:="\";
            buff[1]:="\";
            buff[2]:=0X;
        ELSE
          buff[0]:=CHR(i);
          buff[1]:=0X;
        END;  

        COPY(buff,buff2);
        str.Insert("'",0,buff2);
        str.Append("'=",buff2);
        co.IntToStr(i,buff3);
        str.Append(buff3,buff2);
        
        NEW(button);
        button.Init;
        button.SetFlags({O.horizontalFlex,O.verticalFlex});
        button.SetText(buff);
        button.SetHelpObject(Q.InitHelp(d,T.MakeLeftText(buff2),button));
        array.Add(button);
      END;

  frame.Add(array);

  NEW(wGroup);
  wGroup.Init;
  wGroup.Set(NIL,frame,TRUE);

  NEW(w);
  w.Init;
  w.SetDisplay(d);
  w.SetTop(wGroup);
  w.SetTitle("Ascii-Table");
  NEW(msg2Exit);
  msg2Exit.destination:=d;
  w.AddHandler(msg2Exit,W.closeMsg);
  w.Open;
  
  d.Handler;

  d.Deinit;
END AsciiTable.
