(**
  VisualOberon preferences program for oo(2)c.
**)

MODULE VOOOCP;

(*
    VisualOberon preferences program for oo(2)c.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This file is part of VisualOberon.

    VisualOberon is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    VisualOberon is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with VisualOberon. If not, write to the Free Software
    Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT B   := VOBool,
       D   := VODisplay,
       G   := VOGUIObject,
       K   := VOKeyHandler,
       L   := VOLabel,
       LI  := VOList,
       LM  := VOListModel,
       P   := VOPanel,
       PB  := VOButton,
(*       Q   := VOQuickHelp,*)
       S   := VOString,
       SP  := VOSpace,
       T   := VOText,
       TA  := VOTab,
              VOUsePrefs,
       V   := VOValue,
       W   := VOWindow,
       WG  := VOWindowGroup,

              Err;


VAR
  d          : D.Display;
  w          : W.Window;
  wGroup     : WG.WindowGroup;
  label      : L.Label;
  text       : T.Text;
  tab1,tab2  : TA.Tab;
  keyHandler : K.KeyHandler;

  msg2Exit   : D.Msg2Exit;

  PROCEDURE AddBool(label : L.Label; handler : K.KeyHandler; text : ARRAY OF CHAR);

  VAR
    bool      : B.Bool;
    boolModel : V.BoolModel;

  BEGIN
    NEW(bool);
    bool.Init;
      NEW(boolModel);
      boolModel.Init;
      boolModel.SetBoolean(FALSE);
    bool.SetModel(boolModel);
    label.AddTextLabel(text,bool);
    keyHandler.AddFocusObject(bool);
  END AddBool;

  PROCEDURE AddString(label : L.Label; handler : K.KeyHandler; text : ARRAY OF CHAR);

  VAR
    string      : S.String;
    stringModel : V.StringModel;

  BEGIN
    NEW(string);
    string.Init;
    string.SetFlags({G.horizontalFlex});
      NEW(stringModel);
      stringModel.Init;
    string.SetModel(stringModel);
(*    string.SetLabel(label.AddTextLabelFull(text,bool));*)
    label.AddTextLabel(text,string);
    keyHandler.AddFocusObject(string);
  END AddString;

  PROCEDURE AddList(handler : K.KeyHandler):G.Object;

  VAR
    button     : PB.Button;
    list       : LI.List;
    listModel  : LM.ListModel;
    horiz,vert : P.Panel;
    space      : SP.Space;

  BEGIN
    NEW(horiz);
    horiz.Init;
    horiz.Set(P.horizontal);
    horiz.SetFlags({G.horizontalFlex,G.verticalFlex});
      NEW(list);
      list.Init;
      list.SetFlags({G.horizontalFlex,G.verticalFlex});
        NEW(listModel);
        listModel.Init;
      list.SetModel(listModel);
  (*    string.SetLabel(label.AddTextLabelFull(text,bool));*)
      keyHandler.AddFocusObject(list);
    horiz.Add(list);
      NEW(space);
      space.Init;
      space.Set(FALSE,SP.normal);
    horiz.Add(space);
      NEW(vert);
      vert.Init;
      vert.Set(P.vertical);
      vert.SetFlags({G.verticalFlex});
        NEW(button);
        button.Init;
        button.SetLabelText("_Up",handler);
        button.SetFlags({G.horizontalFlex});
      vert.Add(button);
        NEW(space);
        space.Init;
        space.Set(TRUE,SP.normal);
      vert.Add(space);
        NEW(button);
        button.Init;
        button.SetLabelText("_Down",handler);
        button.SetFlags({G.horizontalFlex});
      vert.Add(button);
        NEW(space);
        space.Init;
        space.Set(TRUE,SP.normal);
      vert.Add(space);
        NEW(button);
        button.Init;
        button.SetLabelText("_Add",handler);
        button.SetFlags({G.horizontalFlex});
      vert.Add(button);
        NEW(space);
        space.Init;
        space.Set(TRUE,SP.normal);
      vert.Add(space);
        NEW(button);
        button.Init;
        button.SetLabelText("_Remove",handler);
        button.SetFlags({G.horizontalFlex});
      vert.Add(button);
        NEW(space);
        space.Init;
        space.Set(TRUE,SP.normal);
        space.SetFlags({G.verticalFlex});
      vert.Add(space);
    horiz.Add(vert);

    RETURN horiz;
  END AddList;


BEGIN
  NEW(d);
  IF ~d.InitDisplay("VOOOCP") THEN
    Err.String("Cannot open to display!"); Err.Ln;
    HALT(1);
  END;

  NEW(keyHandler);
  keyHandler.Init;

  NEW(wGroup);
  wGroup.Init;

    NEW(tab1);
    tab1.Init;
    tab1.SetFlags({G.horizontalFlex,G.verticalFlex});
    keyHandler.AddFocusObject(tab1);

      NEW(label);
      label.Init;
      label.Set(TRUE);

        AddBool(label,keyHandler,"Verbose");
        AddBool(label,keyHandler,"Optimize");

        AddString(label,keyHandler,"Errormsgs.");
        AddString(label,keyHandler,"C compiler");
        AddString(label,keyHandler,"C compiler flags");
        AddString(label,keyHandler,"coptflags");
        AddString(label,keyHandler,"Linker flags");
        AddString(label,keyHandler,"GC flags");

    tab1.AddTab(T.MakeCenterText("Options"),label);

      NEW(label);
      label.Init;
      label.Set(TRUE);

        AddBool(label,keyHandler,"Warnings");
        AddBool(label,keyHandler,"Assertions");
        AddBool(label,keyHandler,"Initialize");
        AddBool(label,keyHandler,"Stack check");
        AddBool(label,keyHandler,"Conformant mode");
        AddBool(label,keyHandler,"case select check");
        AddBool(label,keyHandler,"Index check");
        AddBool(label,keyHandler,"Range check");
        AddBool(label,keyHandler,"Deref check");
        AddBool(label,keyHandler,"Funct result");
        AddBool(label,keyHandler,"Typegard");
        AddBool(label,keyHandler,"Int div check");
        AddBool(label,keyHandler,"Real div check");

    tab1.AddTab(T.MakeCenterText("Pragmas"),label);

      NEW(tab2);
      tab2.Init;
      tab2.SetFlags({G.horizontalFlex,G.verticalFlex});
      keyHandler.AddFocusObject(tab2);
        tab2.AddTab(T.MakeCenterText("Module"),AddList(keyHandler));
        tab2.AddTab(T.MakeCenterText("Symbols"),AddList(keyHandler));
        tab2.AddTab(T.MakeCenterText("C-tmp"),AddList(keyHandler));
        tab2.AddTab(T.MakeCenterText("Objects"),AddList(keyHandler));

    tab1.AddTab(T.MakeCenterText("Paths"),tab2);

      NEW(text);
      text.Init;
    tab1.AddTab(T.MakeCenterText("About..."),T.MakeLeftText("\e\c\e\s\e\9VOOOCP\e\p\n\en\e\c(functionless demo for \esVisualOberon\en)\n\nCopyright 1997\nTim Teulings\n(rael@edge.ping.de)"));
  wGroup.Set(NIL,tab1,TRUE);


  NEW(w);
  w.Init;
  w.SetDisplay(d);
  w.SetTop(wGroup);
  w.SetTitle("VOOOCP");
  w.AddKeyHandler(keyHandler);
  NEW(msg2Exit);
  msg2Exit.destination:=d;
  w.AddHandler(msg2Exit,W.closeMsg);
  w.Open;

  d.Handler;

  d.Deinit;

END VOOOCP.