MODULE VODisplayPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D   := VODisplay,
       G   := VOGUIObject,
       LA  := VOLabel,
       PG  := VOPrefsGUI,
       PP  := VOPrefsParser,
       ST  := VOString,
       T   := VOText,
       TA  := VOTab,
       V   := VOValue,

       str := Strings;

TYPE
  DisplayItem*     = POINTER TO DisplayItemDesc;
  DisplayItemDesc* = RECORD (PG.PrefsItemDesc)
                       prefs : D.DisplayPrefsDesc;
                     END;

VAR
  prefs : DisplayItem;

  PROCEDURE (d : DisplayItem) Init*;

  BEGIN
    d.Init^;
    d.name:="Display";
    PG.settings.AddItem(d);
  END Init;

  PROCEDURE (d : DisplayItem) GetObject*():G.Object;

  VAR
    tab    : TA.Tab;
    label  : LA.Label;
    string : ST.String;
    model  : V.ValueModel;
    x      : LONGINT;

  BEGIN
    NEW(tab);
    tab.Init;
    tab.SetFlags({G.horizontalFlex,G.verticalFlex});

      NEW(label);
      label.Init;
      label.SetFlags({G.horizontalFlex,G.verticalFlex});

      FOR x:=0 TO LEN(D.colorNames)-1 DO
        NEW(model);
        model.Init;
        model.SetString(D.prefs.colors[x]);

        NEW(string);
        string.Init;
        string.Disable(TRUE);
        string.SetFlags({G.horizontalFlex});
        string.SetModel(model);

        label.AddTextLabel(D.colorNames[x],string);
      END;

    tab.AddTab(T.MakeCenterText("Colors"),label);

      NEW(label);
      label.Init;
      label.SetFlags({G.horizontalFlex,G.verticalFlex});

      FOR x:=0 TO LEN(D.fontNames)-1 DO
        NEW(model);
        model.Init;
        model.SetString(D.prefs.fonts[x]);

        NEW(string);
        string.Init;
        string.Disable(TRUE);
        string.SetFlags({G.horizontalFlex});
        string.SetModel(model);

        label.AddTextLabel(D.fontNames[x],string);
      END;

    tab.AddTab(T.MakeCenterText("Fonts"),label);

    RETURN tab;
  END GetObject;

  PROCEDURE (p : DisplayItem) LoadPrefs*(appName : ARRAY OF CHAR);

  VAR
    fileName : ARRAY 256 OF CHAR;
    help     : ARRAY 256 OF CHAR;
    x        : LONGINT;
    top      : PP.Item;


  BEGIN
    p.LoadPrefs^(appName);

    fileName:="Display.";

    CASE p.display.colorMode OF
      D.monochromeMode:
        str.Append("mono",fileName);
    | D.greyScaleMode:
        str.Append("grey",fileName);
    | D.colorMode:
        str.Append("color", fileName);
    END;
    str.Append(".",fileName);
    str.Append(p.display.name,fileName);

    top:=p.LoadPrefsFile(fileName,appName);

    IF top#NIL THEN
      FOR x:=0 TO D.colorCount-1 DO
        help:="COLORS/";
        str.Append(D.colorNames[x],help);
        IF top.GetStringEntry(help,D.prefs.colors[x]) THEN END;
      END;
      FOR x:=0 TO D.fontCount-1 DO
        help:="FONTS/";
        str.Append(D.fontNames[x],help);
        IF top.GetStringEntry(help,D.prefs.fonts[x]) THEN END;
      END;
    END;
  END LoadPrefs;


  PROCEDURE (p : DisplayItem) Refresh*;

  BEGIN

  END Refresh;


  PROCEDURE (p : DisplayItem) Save*;

  VAR
    fileName : ARRAY 256 OF CHAR;
    block,
    block2   : PP.BlockItem;
    value    : PP.ValueItem;
    x        : LONGINT;

  BEGIN
    NEW(block);
    block.Init;
    block.SetName("COLORS");
    FOR x:=0 TO D.colorCount-1 DO
      NEW(value);
      value.Init;
      value.SetValue(D.colorNames[x],D.prefs.colors[x]);
      block.AddItem(value);
    END;

    NEW(block2);
    block2.Init;
    block2.SetName("FONTS");
    block.next:=block2;
    FOR x:=0 TO D.fontCount-1 DO
      NEW(value);
      value.Init;
      value.SetValue(D.fontNames[x],D.prefs.fonts[x]);
      block2.AddItem(value);
    END;

    fileName:="Display.";

    CASE p.display.colorMode OF
      D.monochromeMode:
        str.Append("mono",fileName);
    | D.greyScaleMode:
        str.Append("grey",fileName);
    | D.colorMode:
        str.Append("color", fileName);
    END;
    str.Append(".",fileName);
    str.Append(p.display.name,fileName);

    p.SaveItems(fileName,block);
  END Save;

BEGIN
  NEW(prefs);
  prefs.Init;

END VODisplayPrefs.