MODULE VOLabelPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT BG  := VOBackground,
       F   := VOFrameGroup,
       G   := VOGUIObject,
       L   := VOLabel,
       O   := VOObject,
       P   := VOPanel,
       PG  := VOPrefsGUI,
       PP  := VOPrefsParser,
       R   := VORadio,
       S   := VOSpace,
       V   := VOValue;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (PG.PrefsItemDesc)
                prefs       : L.PrefsDesc;
                labelPos    : V.IntModel;
                labelAlign  : V.IntModel;
                objectAlign : V.IntModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Label";
    PG.settings.AddItem(d);
  END Init;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.prefs:=L.prefs^;

    d.labelPos.SetLongint(d.prefs.labelPos);
    d.labelAlign.SetLongint(d.prefs.labelAlign);
    d.objectAlign.SetLongint(d.prefs.objectAlign);
  END Refresh;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    label : L.Label;
    radio : R.Radio;
    frame : F.FrameGroup;
    panel : P.Panel;
    space : S.Space;

  BEGIN
    NEW(panel);
    panel.Init;
    panel.Set(P.vertical);

      NEW(frame);
      frame.Init;
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Label position");

        NEW(label);
        label.Init;

          NEW(d.labelPos);
          d.labelPos.Init;
          d.labelPos.SetLongint(d.prefs.labelPos);

          NEW(radio);
          radio.Init;
          radio.SetModel(d.labelPos,L.left);
          d.window.keyHandler.AddFocusObject(radio);
          radio.Forward(R.clickedMsg,d);
        label.AddTextLabel("Left",radio);

          NEW(radio);
          radio.Init;
          radio.SetModel(d.labelPos,L.right);
          d.window.keyHandler.AddFocusObject(radio);
          radio.Forward(R.clickedMsg,d);
        label.AddTextLabel("Right",radio);
      frame.Add(label);
    panel.Add(frame);

      NEW(space);
      space.Init;
      space.Set(TRUE,S.normal);
    panel.Add(space);

      NEW(frame);
      frame.Init;
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Label alignment");

        NEW(label);
        label.Init;

          NEW(d.labelAlign);
          d.labelAlign.Init;
          d.labelAlign.SetLongint(d.prefs.labelAlign);

          NEW(radio);
          radio.Init;
          radio.SetModel(d.labelAlign,L.left);
          d.window.keyHandler.AddFocusObject(radio);
          radio.Forward(R.clickedMsg,d);
        label.AddTextLabel("Left",radio);

          NEW(radio);
          radio.Init;
          radio.SetModel(d.labelAlign,L.right);
          d.window.keyHandler.AddFocusObject(radio);
          radio.Forward(R.clickedMsg,d);
       label.AddTextLabel("Right",radio);
      frame.Add(label);
    panel.Add(frame);

      NEW(space);
      space.Init;
      space.Set(TRUE,S.normal);
    panel.Add(space);

      NEW(frame);
      frame.Init;
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Object alignment");

        NEW(label);
        label.Init;

          NEW(d.objectAlign);
          d.objectAlign.Init;
          d.objectAlign.SetLongint(d.prefs.objectAlign);

          NEW(radio);
          radio.Init;
          radio.SetModel(d.objectAlign,L.left);
          d.window.keyHandler.AddFocusObject(radio);
          radio.Forward(R.clickedMsg,d);
        label.AddTextLabel("Left",radio);

          NEW(radio);
          radio.Init;
          radio.SetModel(d.objectAlign,L.right);
          d.window.keyHandler.AddFocusObject(radio);
          radio.Forward(R.clickedMsg,d);
        label.AddTextLabel("Right",radio);
      frame.Add(label);
    panel.Add(frame);

    RETURN panel;
  END GetObject;

  PROCEDURE (p : Item) LoadPrefs*(appName : ARRAY OF CHAR);

  VAR
    top : PP.Item;


  BEGIN
    p.LoadPrefs^(appName);

    top:=p.LoadPrefsFile("Label",appName);
    IF top=NIL THEN
      RETURN;
    END;
    top:=top.GetEntry("LABEL");
    IF top=NIL THEN
      RETURN;
    END;

    L.prefs.labelAlign:=top.GetIntEntry("labelAlign",L.prefs.labelAlign);
    L.prefs.objectAlign:=top.GetIntEntry("objectAlign",L.prefs.objectAlign);
    L.prefs.labelPos:=top.GetIntEntry("lablePos",L.prefs.labelPos);
    L.prefs.background:=BG.LoadBackground(top);
  END LoadPrefs;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    L.prefs^:=p.prefs;
  END Apply;

  PROCEDURE (p : Item) Save*;

  VAR
    block    : PP.BlockItem;
    value    : PP.ValueItem;

  BEGIN
    NEW(block);
    block.Init;
    block.SetName("LABEL");

      NEW(value);
      value.Init;
      value.SetInt("labelPos",p.prefs.labelPos);
    block.AddItem(value);

      NEW(value);
      value.Init;
      value.SetInt("labelAlign",p.prefs.labelAlign);
    block.AddItem(value);

      NEW(value);
      value.Init;
      value.SetInt("objectAlign",p.prefs.objectAlign);
    block.AddItem(value);

    BG.SaveBackground(block,p.prefs.background);

    p.SaveItems("Label",block);
  END Save;

  PROCEDURE (p : Item) Receive*(message : O.Message);

  BEGIN
    WITH
      message : R.ClickedMsg DO
        p.prefs.labelAlign:=p.labelAlign.GetLongint();
        p.prefs.objectAlign:=p.objectAlign.GetLongint();
        p.prefs.labelPos:=p.labelPos.GetLongint();
    ELSE
      p.Receive^(message);
    END;
  END Receive;

BEGIN
  NEW(prefs);
  prefs.Init;

END VOLabelPrefs.