MODULE VOListPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT B   := VOButton,
       F   := VOFrame,
       FG  := VOFrameGroup,
       FSD := VOFrmSelDlg,
       G   := VOGUIObject,
       L   := VOLabel,
       LI  := VOList,
       O   := VOObject,
       PG  := VOPrefsGUI,
       PP  := VOPrefsParser;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (PG.PrefsItemDesc)
                prefs      : LI.PrefsDesc;
                rFrmSelDlg : FSD.FrmSelDlg;
                wFrmSelDlg : FSD.FrmSelDlg;
                rFrame     : F.Frame;
                wFrame     : F.Frame;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="List";
    PG.settings.AddItem(d);

    NEW(d.rFrmSelDlg);
    d.rFrmSelDlg.Init;

    NEW(d.wFrmSelDlg);
    d.wFrmSelDlg.Init;
  END Init;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.prefs:=LI.prefs^;

    d.rFrame.SetInternalFrame(d.prefs.rFrame);
    d.wFrame.SetInternalFrame(d.prefs.wFrame);
    d.rFrmSelDlg.SetFrame(d.prefs.rFrame);
    d.wFrmSelDlg.SetFrame(d.prefs.wFrame);
  END Refresh;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    button    : B.Button;
    frame     : FG.FrameGroup;
    label     : L.Label;

  BEGIN
    d.rFrmSelDlg.SetDisplay(d.display);
    d.rFrmSelDlg.Forward(FSD.setMsg,d);

    d.wFrmSelDlg.SetDisplay(d.display);
    d.wFrmSelDlg.Forward(FSD.setMsg,d);

    NEW(frame);
    frame.Init;
    frame.SetTextLabel("Frames");

      NEW(label);
      label.Init;

        button:=PG.CreateFrameButton(d.prefs.rFrame,d.rFrame,d.display,d.rFrmSelDlg,
                                     d.window.keyHandler,"Select readonly frame");
      label.AddTextLabel("Readonly",button);

      button:=PG.CreateFrameButton(d.prefs.wFrame,d.wFrame,d.display,d.wFrmSelDlg,
                                   d.window.keyHandler,"Select read/write frame");
      label.AddTextLabel("Read/write",button);
    frame.Add(label);

    RETURN frame;
  END GetObject;

  PROCEDURE (p : Item) LoadPrefs*(appName : ARRAY OF CHAR);

  VAR
    buffer   : ARRAY 256 OF CHAR;
    pos      : LONGINT;
    top      : PP.Item;


  BEGIN
    p.LoadPrefs^(appName);

    top:=p.LoadPrefsFile("List",appName);

    IF top#NIL THEN
      IF top.GetStringEntry("LIST/readonlyFrame",buffer) THEN
        pos:=F.GetFrameEntry(buffer);
        IF pos>=0 THEN
          LI.prefs.rFrame:=pos;
        ELSE
          p.ErrorWrongData("LIST/readonlyFrame",buffer);
        END;
      END;

      IF top.GetStringEntry("LIST/frame",buffer) THEN
        pos:=F.GetFrameEntry(buffer);
        IF pos>=0 THEN
          LI.prefs.wFrame:=pos;
        ELSE
          p.ErrorWrongData("LIST/frame",buffer);
        END;
      END;
    END;
  END LoadPrefs;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    LI.prefs^:=p.prefs;
  END Apply;

  PROCEDURE (p : Item) Save*;

  VAR
    block    : PP.BlockItem;
    value    : PP.ValueItem;

  BEGIN
    NEW(block);
    block.Init;
    block.SetName("LIST");
      NEW(value);
      value.Init;
      value.SetValue("readonlyFrame",F.internalFrames[p.prefs.rFrame]);
    block.AddItem(value);
      NEW(value);
      value.Init;
      value.SetValue("frame",F.internalFrames[p.prefs.wFrame]);
    block.AddItem(value);

    p.SaveItems("List",block);
  END Save;

  PROCEDURE (p : Item) Receive*(message : O.Message);

  BEGIN
    WITH
      message : FSD.SetMsg DO
        IF message.source=p.rFrmSelDlg THEN
          p.rFrame.SetInternalFrame(message.frame);
          p.prefs.rFrame:=message.frame;
        ELSE
          p.wFrame.SetInternalFrame(message.frame);
          p.prefs.wFrame:=message.frame;
        END;
    ELSE
      p.Receive^(message);
    END;
  END Receive;

BEGIN
  NEW(prefs);
  prefs.Init;

END VOListPrefs.