(*
    Generated scanner for VisualOberon preferences.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

MODULE VOPrefsScanner;

IMPORT
  VOUtil;

CONST
  EOL = 0AX;
  EOF = 0X;
  maxLexLen = 127;
  noSym = 9;

TYPE
  ErrorProc* = PROCEDURE (n: INTEGER; pos: LONGINT);
  StartTable = ARRAY 128 OF INTEGER;

VAR
  text*: VOUtil.Text;

  pos*: LONGINT;              (*position of current symbol*)
  line*, col*, len*: INTEGER; (*line, column, length of current symbol*)

  nextPos*: LONGINT;                      (*position of lookahead symbol*)
  nextLine*, nextCol*, nextLen*: INTEGER; (*line, column, length of lookahead symbol*)

  errors*: INTEGER; (*number of errors detected*)
  Error*: ErrorProc;

  ch: CHAR;            (*current input character*)
  chPos: LONGINT;      (*position of current character*)
  chLine: INTEGER;     (*current line number*)
  lineStart: LONGINT;  (*start position of current line*)
  apx: INTEGER;        (*length of appendix*)
  oldEols: INTEGER;    (*nr. of EOLs in a comment*)

  start: StartTable;   (*start state for every character*)

(* ==================================================================== *)

PROCEDURE NextCh (); (*return global variable ch*)
BEGIN
  IF chPos<LEN(text^) THEN
    ch:=text[chPos];
    INC(chPos);
    IF ch = EOL THEN
      INC(chLine); lineStart := chPos + 1;
    END;
  ELSE
    ch:=0X;
  END;
END NextCh;

PROCEDURE Comment (): BOOLEAN;
VAR
  level, startLine: INTEGER; oldLineStart: LONGINT;
BEGIN (*Comment*)
  level := 1; startLine := chLine; oldLineStart := lineStart;
  IF (ch ="#") THEN
    NextCh;
      LOOP
        IF (ch =CHR(10)) THEN
          DEC(level); oldEols := chLine - startLine; NextCh;
          IF level = 0 THEN RETURN TRUE END;
        ELSIF ch = EOF THEN RETURN FALSE
        ELSE NextCh END;
      END;
  END;
END Comment;

PROCEDURE Get* (VAR sym: INTEGER);
VAR
  state: INTEGER; lexeme: ARRAY maxLexLen+1 OF CHAR;

  PROCEDURE CheckLiteral ();
  BEGIN
    IF nextLen < maxLexLen THEN lexeme[nextLen] := 0X END;
    IF (lexeme[0] >= "B") & (lexeme[0] <= "E") THEN
      CASE lexeme[0] OF
      | "B": IF lexeme = "BEGIN" THEN sym := 4
        END;
      | "E": IF lexeme = "END" THEN sym := 6
        END;
      ELSE
      END;
    END;

  END CheckLiteral;

BEGIN
  WHILE (ch=20X) OR (ch>=CHR(9)) & (ch<=CHR(10)) OR (ch=CHR(13)) OR (ch=CHR(28)) DO NextCh END;
    IF ((ch ="#")) & Comment() THEN Get(sym); RETURN END;
  IF ch > 7FX THEN ch := " "; END;
  pos := nextPos; col := nextCol; line := nextLine; len := nextLen;
  nextPos := chPos; nextCol := SHORT(chPos - lineStart); nextLine := chLine; nextLen := 0;
  state := start[ORD(ch)]; apx := 0;
  LOOP
    IF nextLen < maxLexLen THEN lexeme[nextLen] := ch; END;
    INC(nextLen);
    NextCh ();
    IF state > 0 THEN
      CASE state OF
      | 1: IF (ch>="0") & (ch<="9") OR (ch>="A") & (ch<="Z") OR (ch>="a") & (ch<="z") THEN
          ELSE sym := 1; CheckLiteral; RETURN
          END;
    | 2: IF (ch<=CHR(9)) OR (ch>=CHR(11)) & (ch<="!") OR (ch>="#") THEN
          ELSIF (ch =CHR(34)) THEN state := 3;
          ELSE sym := noSym; RETURN
          END;
    | 3: sym := 2; RETURN
    | 4: IF (ch<=CHR(9)) OR (ch>=CHR(11)) & (ch<="&") OR (ch>="(") THEN
          ELSIF (ch ="'") THEN state := 3;
          ELSE sym := noSym; RETURN
          END;
    | 5: IF (ch>="0") & (ch<="9") THEN
          ELSE sym := 3; RETURN
          END;
    | 6: sym := 5; RETURN
    | 7: IF (ch ="=") THEN state := 8;
          ELSE sym := noSym; RETURN
          END;
    | 8: sym := 7; RETURN
    | 9: sym := 8; RETURN
    | 10: sym := 0; ch := 0X; RETURN

      END; (*CASE*)
    ELSE
      sym := noSym;
      RETURN; (*NextCh already done*)
    END; (*IF*)
  END; (*LOOP*)
END Get;

PROCEDURE GetName* (pos: LONGINT; len: INTEGER; VAR s: ARRAY OF CHAR);
VAR
  i   : INTEGER;

BEGIN
  IF len >= LEN(s) THEN len := SHORT(LEN(s)) - 1; END;
(*
   The following two lines of the scanner must *not* be changed.
   They are here to honor D.  E.  Knuth.

   "Premature optimization is the root of all evil."
*)
  i := 0; WHILE i < len DO s[i]:=text[pos-1+i]; INC(i); END;
  s[i] := 0X;
END GetName;

PROCEDURE StdErrorProc* (n: INTEGER; pos: LONGINT);
BEGIN
  INC(errors);
END StdErrorProc;

PROCEDURE Initialize* (t : VOUtil.Text; errProc: ErrorProc);
BEGIN
  text:=t;
  Error := errProc;
  chPos := 0; chLine := 1; lineStart := 0;
  oldEols := 0; apx := 0; errors := 0;
  NextCh ();
END Initialize;

BEGIN
  start[0]:=10; start[1]:=0; start[2]:=0; start[3]:=0;
  start[4]:=0; start[5]:=0; start[6]:=0; start[7]:=0;
  start[8]:=0; start[9]:=0; start[10]:=0; start[11]:=0;
  start[12]:=0; start[13]:=0; start[14]:=0; start[15]:=0;
  start[16]:=0; start[17]:=0; start[18]:=0; start[19]:=0;
  start[20]:=0; start[21]:=0; start[22]:=0; start[23]:=0;
  start[24]:=0; start[25]:=0; start[26]:=0; start[27]:=0;
  start[28]:=0; start[29]:=0; start[30]:=0; start[31]:=0;
  start[32]:=0; start[33]:=0; start[34]:=2; start[35]:=0;
  start[36]:=0; start[37]:=0; start[38]:=0; start[39]:=4;
  start[40]:=0; start[41]:=0; start[42]:=0; start[43]:=0;
  start[44]:=9; start[45]:=0; start[46]:=0; start[47]:=0;
  start[48]:=5; start[49]:=5; start[50]:=5; start[51]:=5;
  start[52]:=5; start[53]:=5; start[54]:=5; start[55]:=5;
  start[56]:=5; start[57]:=5; start[58]:=7; start[59]:=6;
  start[60]:=0; start[61]:=0; start[62]:=0; start[63]:=0;
  start[64]:=0; start[65]:=1; start[66]:=1; start[67]:=1;
  start[68]:=1; start[69]:=1; start[70]:=1; start[71]:=1;
  start[72]:=1; start[73]:=1; start[74]:=1; start[75]:=1;
  start[76]:=1; start[77]:=1; start[78]:=1; start[79]:=1;
  start[80]:=1; start[81]:=1; start[82]:=1; start[83]:=1;
  start[84]:=1; start[85]:=1; start[86]:=1; start[87]:=1;
  start[88]:=1; start[89]:=1; start[90]:=1; start[91]:=0;
  start[92]:=0; start[93]:=0; start[94]:=0; start[95]:=0;
  start[96]:=0; start[97]:=1; start[98]:=1; start[99]:=1;
  start[100]:=1; start[101]:=1; start[102]:=1; start[103]:=1;
  start[104]:=1; start[105]:=1; start[106]:=1; start[107]:=1;
  start[108]:=1; start[109]:=1; start[110]:=1; start[111]:=1;
  start[112]:=1; start[113]:=1; start[114]:=1; start[115]:=1;
  start[116]:=1; start[117]:=1; start[118]:=1; start[119]:=1;
  start[120]:=1; start[121]:=1; start[122]:=1; start[123]:=0;
  start[124]:=0; start[125]:=0; start[126]:=0; start[127]:=0;

END VOPrefsScanner.