MODULE VORadioPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT B   := VOButton,
       F   := VOFrameGroup,
       ISD := VOImgSelDlg,
       G   := VOGUIObject,
       O   := VOObject,
       PG  := VOPrefsGUI,
       PP  := VOPrefsParser,
       R   := VORadio,
       V   := VOVecImage;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (PG.PrefsItemDesc)
                prefs     : R.PrefsDesc;
                imgSelDlg : ISD.ImgSelDlg;
                image     : V.VecImage;
              END;

VAR
  prefs : Item;


  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Radio";
    PG.settings.AddItem(d);

    NEW(d.imgSelDlg);
    d.imgSelDlg.Init;
  END Init;


  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    frame    : F.FrameGroup;
    button   : B.Button;

  BEGIN
    d.imgSelDlg.SetDisplay(d.display);
    d.imgSelDlg.Forward(ISD.setMsg,d);

    NEW(frame);
    frame.Init;
    frame.SetTextLabel("Image");

      button:=PG.CreateImageButton(d.prefs.image,d.image,d.display,d.imgSelDlg,
                                   d.window.keyHandler,"Select image");
    frame.Add(button);

    RETURN frame;
  END GetObject;


  PROCEDURE (p : Item) Refresh*;

  BEGIN
    p.prefs:=R.prefs^;

    p.imgSelDlg.SetImage(p.prefs.image);
    p.image.Set(p.prefs.image);
  END Refresh;


  PROCEDURE (p : Item) LoadPrefs*(appName : ARRAY OF CHAR);

  VAR
    buffer : ARRAY 256 OF CHAR;
    pos    : LONGINT;
    top    : PP.Item;


  BEGIN
    p.LoadPrefs^(appName);

    top:=p.LoadPrefsFile("Radio",appName);
    IF top#NIL THEN
      IF top.GetStringEntry("RADIO/image",buffer) THEN
        pos:=V.GetImageEntry(buffer);
        IF pos>=0 THEN
          R.prefs.image:=pos;
        ELSE
          p.ErrorWrongData("RADIO/image",buffer);
        END;
      END;
    END;
  END LoadPrefs;


  PROCEDURE (p : Item) Apply*;

  BEGIN
    R.prefs^:=p.prefs;
  END Apply;


  PROCEDURE (p : Item) Save*;

  VAR
    block    : PP.BlockItem;
    value    : PP.ValueItem;

  BEGIN
    NEW(block);
    block.Init;
    block.SetName("RADIO");
      NEW(value);
      value.Init;
      value.SetValue("image",V.images[p.prefs.image]);
    block.AddItem(value);

    p.SaveItems("Radio",block);
  END Save;


  PROCEDURE (p : Item) Receive*(message : O.Message);

  BEGIN
    WITH message : ISD.SetMsg DO
        p.image.Set(message.image);
        p.prefs.image:=message.image;
    ELSE
      p.Receive^(message);
    END;
  END Receive;

BEGIN
  NEW(prefs);
  prefs.Init;

END VORadioPrefs.