(**
   Just some amount of invisible space hidden in the endless
   number of dimensions of the univers.
**)

MODULE VOSpace;

(*
    Implements a "space" object.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D := VODisplay,
       G := VOGUIObject;

CONST
  micro*  = 1;
  small*  = 2;
  normal* = 3;
  huge*   = 4;

TYPE
  Space*     = POINTER TO SpaceDesc;
  SpaceDesc* = RECORD (G.ImageDesc)
                 vert : BOOLEAN;
                 size : LONGINT;
               END;


  PROCEDURE (s : Space) Init*;

  BEGIN
    s.Init^;

    s.vert:=FALSE;
    s.size:=normal;
  END Init;


  PROCEDURE (s : Space) Set*(vert : BOOLEAN; size : LONGINT);

  BEGIN
    s.vert:=vert;
    s.size:=size;
  END Set;

  PROCEDURE (s : Space) CalcSize*(display : D.Display);

  BEGIN
    s.width:=0;
    s.height:=0;

    IF s.vert THEN
      CASE s.size OF
        micro:
          s.height:=2;
      | small:
          s.height:=display.spaceHeight DIV 2;
      | normal:
          s.height:=display.spaceHeight;
      | huge:
          s.height:=2*display.spaceHeight;
      END;
    ELSE
      CASE s.size OF
        micro:
          s.width:=2;
      | small:
          s.width:=display.spaceWidth DIV 2;
      | normal:
          s.width:=display.spaceWidth;
      | huge:
          s.width:=2*display.spaceWidth;
      END;
    END;

    s.minWidth:=s.width;
    s.minHeight:=s.height;

    s.CalcSize^(display);
  END CalcSize;

  PROCEDURE (s : Space) Draw*(x,y : LONGINT; draw : D.DrawInfo);

  BEGIN
    s.Draw^(x,y,draw);

(*    IF s.parent#NIL THEN
      Err.String("Drawing parent"); Err.Ln;
      s.parent.DrawBackground(s.x,s.y,s.width,s.height);
    ELSE
      Err.String("Drawing self"); Err.Ln;
      s.DrawBackground(s.x,s.y,s.width,s.height);
    END;*)
  END Draw;

  PROCEDURE (s : Space) Hide*;

  BEGIN
    IF s.visible  THEN
      s.DrawHide;
      s.Hide^;
    END;
  END Hide;

END VOSpace.