MODULE VOTabPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT BG  := VOBackground,
       G   := VOGUIObject,
       O   := VOObject,
       P   := VOPanel,
       PG  := VOPrefsGUI,
       PP  := VOPrefsParser,
       T   := VOTab;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (PG.PrefsItemDesc)
                prefs : T.PrefsDesc;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Tab";
    PG.settings.AddItem(d);
  END Init;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.prefs:=T.prefs^;
  END Refresh;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    panel : P.Panel;

  BEGIN

    NEW(panel);
    panel.Init;
    panel.Set(P.vertical);

    RETURN panel;
  END GetObject;

  PROCEDURE (p : Item) LoadPrefs*(appName : ARRAY OF CHAR);

  VAR
    top : PP.Item;


  BEGIN
    p.LoadPrefs^(appName);

    top:=p.LoadPrefsFile("Tab",appName);
    IF top=NIL THEN
      RETURN;
    END;
    top:=top.GetEntry("TAB");
    IF top=NIL THEN
      RETURN;
    END;

    T.prefs.background:=BG.LoadBackground(top);
  END LoadPrefs;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    T.prefs^:=p.prefs;
  END Apply;

  PROCEDURE (p : Item) Save*;

  VAR
    block : PP.BlockItem;

  BEGIN
    NEW(block);
    block.Init;
    block.SetName("TAB");

    BG.SaveBackground(block,p.prefs.background);

    p.SaveItems("Tab",block);
  END Save;

  PROCEDURE (p : Item) Receive*(message : O.Message);

  BEGIN
    p.Receive^(message);
  END Receive;

BEGIN
  NEW(prefs);
  prefs.Init;

END VOTabPrefs.