(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)

Require Import Why.

Parameter F : Z -> Z.
Axiom F_0 : F 0 = 1%Z.
Axiom F_1 : F 1 = 1%Z.
Axiom F_n : forall n:Z, (n >= 2)%Z -> F n = (F (n - 1) + F (n - 2))%Z.
Hint Resolve F_0 F_1 F_n .

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib1_po_1 : 
  forall (n: Z),
  forall (HW_1: n >= 0),
  forall (HW_2: n <= 1),
  1 = (F n).
Proof.
intuition.
assert (n=0 \/ n=1). omega. intuition; subst; auto.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib1_po_2 : 
  forall (n: Z),
  forall (HW_1: n >= 0),
  forall (HW_3: n > 1),
  (Zwf 0 (n - 1) n).
Proof.
intuition.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib1_po_3 : 
  forall (n: Z),
  forall (HW_1: n >= 0),
  forall (HW_3: n > 1),
  forall (HW_4: (Zwf 0 (n - 1) n)),
  (n - 1) >= 0.
Proof.
intuition.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib1_po_4 : 
  forall (n: Z),
  forall (HW_1: n >= 0),
  forall (HW_3: n > 1),
  forall (HW_4: (Zwf 0 (n - 1) n)),
  forall (HW_5: (n - 1) >= 0),
  forall (result: Z),
  forall (HW_6: result = (F (n - 1))),
  (Zwf 0 (n - 2) n).
Proof.
intuition.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib1_po_5 : 
  forall (n: Z),
  forall (HW_1: n >= 0),
  forall (HW_3: n > 1),
  forall (HW_4: (Zwf 0 (n - 1) n)),
  forall (HW_5: (n - 1) >= 0),
  forall (result: Z),
  forall (HW_6: result = (F (n - 1))),
  forall (HW_7: (Zwf 0 (n - 2) n)),
  (n - 2) >= 0.
Proof.
intuition.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib1_po_6 : 
  forall (n: Z),
  forall (HW_1: n >= 0),
  forall (HW_3: n > 1),
  forall (HW_4: (Zwf 0 (n - 1) n)),
  forall (HW_5: (n - 1) >= 0),
  forall (result: Z),
  forall (HW_6: result = (F (n - 1))),
  forall (HW_7: (Zwf 0 (n - 2) n)),
  forall (HW_8: (n - 2) >= 0),
  forall (result0: Z),
  forall (HW_9: result0 = (F (n - 2))),
  (result + result0) = (F n).
Proof.
intuition.
subst; symmetry; auto with *.
Save.

(*Why*) Parameter fib1_valid :
  forall (n: Z), forall (_: n >= 0),
  (sig_1 Z (fun (result: Z)  => (result = (F n)))).

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib2_aux_po_1 : 
  forall (n: Z),
  forall (x: Z),
  forall (fx: Z),
  forall (fx_1: Z),
  forall (HW_1: (1 <= x /\ x <= n) /\ fx = (F x) /\ fx_1 = (F (x - 1))),
  forall (HW_2: x = n),
  fx = (F n).
Proof.
intuition.
subst; auto.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib2_aux_po_2 : 
  forall (n: Z),
  forall (x: Z),
  forall (fx: Z),
  forall (fx_1: Z),
  forall (HW_1: (1 <= x /\ x <= n) /\ fx = (F x) /\ fx_1 = (F (x - 1))),
  forall (HW_3: x <> n),
  (Zwf 0 (n - (x + 1)) (n - x)).
Proof.
intuition.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib2_aux_po_3 : 
  forall (n: Z),
  forall (x: Z),
  forall (fx: Z),
  forall (fx_1: Z),
  forall (HW_1: (1 <= x /\ x <= n) /\ fx = (F x) /\ fx_1 = (F (x - 1))),
  forall (HW_3: x <> n),
  forall (HW_4: (Zwf 0 (n - (x + 1)) (n - x))),
  (1 <= (x + 1) /\ (x + 1) <= n) /\ (fx + fx_1) = (F (x + 1)) /\ fx =
  (F (x + 1 - 1)).
Proof.
intuition.
subst; symmetry.
cut (1 <= x).
 replace x with (x + 1 - 1)%Z.
 generalize (x + 1)%Z.
intros; ring (z - 1 + 1)%Z; replace (z - 1 - 1)%Z with (z - 2)%Z.
 auto with *.
omega.
omega.
assumption.
subst; ring (x + 1 - 1)%Z; trivial.
Save.

(*Why*) Parameter fib2_aux_valid :
  forall (n: Z), forall (x: Z), forall (fx: Z), forall (fx_1: Z),
  forall (_: (1 <= x /\ x <= n) /\ fx = (F x) /\ fx_1 = (F (x - 1))),
  (sig_1 Z (fun (result: Z)  => (result = (F n)))).

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib2_po_1 : 
  forall (n: Z),
  forall (HW_1: n >= 0),
  forall (HW_2: n <= 1),
  1 = (F n).
Proof.
intuition.
assert (n=0 \/ n=1). omega. intuition; subst; auto.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib2_po_2 : 
  forall (n: Z),
  forall (HW_1: n >= 0),
  forall (HW_3: n > 1),
  (1 <= 1 /\ 1 <= n) /\ 1 = (F 1) /\ 1 = (F (1 - 1)).
Proof.
intuition.
Save.

(*Why*) Parameter fib2_valid :
  forall (n: Z), forall (_: n >= 0),
  (sig_1 Z (fun (result: Z)  => (result = (F n)))).

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib3_po_1 : 
  forall (n: Z),
  forall (HW_1: n >= 0),
  forall (HW_2: n > 0),
  (1 <= 1 /\ 1 <= n) /\ 1 = (F 1) /\ 1 = (F (1 - 1)).
Proof.
intuition.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib3_po_2 : 
  forall (n: Z),
  forall (HW_1: n >= 0),
  forall (HW_2: n > 0),
  forall (HW_3: (1 <= 1 /\ 1 <= n) /\ 1 = (F 1) /\ 1 = (F (1 - 1))),
  forall (k: Z),
  forall (x: Z),
  forall (y: Z),
  forall (HW_4: (1 <= k /\ k <= n) /\ x = (F k) /\ y = (F (k - 1))),
  forall (HW_5: k < n),
  forall (y0: Z),
  forall (HW_6: y0 = x),
  forall (x0: Z),
  forall (HW_7: x0 = (x + y)),
  forall (k0: Z),
  forall (HW_8: k0 = (k + 1)),
  ((1 <= k0 /\ k0 <= n) /\ x0 = (F k0) /\ y0 = (F (k0 - 1))) /\
  (Zwf 0 (n - k0) (n - k)).
Proof.
intuition.
subst; symmetry.
cut (1 <= k).
 replace k with (k + 1 - 1)%Z.
 generalize (k + 1)%Z.
intros; ring (z - 1 + 1)%Z; replace (z - 1 - 1)%Z with (z - 2)%Z.
 auto with *.
omega.
omega.
assumption.
subst; ring (k + 1 - 1)%Z; trivial.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib3_po_3 : 
  forall (n: Z),
  forall (HW_1: n >= 0),
  forall (HW_2: n > 0),
  forall (HW_3: (1 <= 1 /\ 1 <= n) /\ 1 = (F 1) /\ 1 = (F (1 - 1))),
  forall (k: Z),
  forall (x: Z),
  forall (y: Z),
  forall (HW_4: (1 <= k /\ k <= n) /\ x = (F k) /\ y = (F (k - 1))),
  forall (HW_9: k >= n),
  x = (F n).
Proof.
intuition.
subst.
assert (k=n). omega. subst; auto.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib3_po_4 : 
  forall (n: Z),
  forall (HW_1: n >= 0),
  forall (HW_10: n <= 0),
  1 = (F n).
Proof.
intuition.
assert (n=0 \/ n=1). omega. intuition; subst; auto.
Save.

(*Why*) Parameter fib3_valid :
  forall (n: Z), forall (_: n >= 0),
  (sig_1 Z (fun (result: Z)  => (result = (F n)))).

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib4_po_1 : 
  forall (n: Z),
  forall (t: (array Z)),
  forall (HW_1: 0 <= n /\ n < (array_length t)),
  forall (HW_2: n <= 1),
  1 = (F n).
Proof.
intuition.
assert (n=0 \/ n=1). omega. intuition; subst; auto.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib4_po_2 : 
  forall (n: Z),
  forall (t: (array Z)),
  forall (HW_1: 0 <= n /\ n < (array_length t)),
  forall (HW_3: n > 1),
  0 <= 0 /\ 0 < (array_length t).
Proof.
intuition.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib4_po_3 : 
  forall (n: Z),
  forall (t: (array Z)),
  forall (HW_1: 0 <= n /\ n < (array_length t)),
  forall (HW_3: n > 1),
  forall (HW_4: 0 <= 0 /\ 0 < (array_length t)),
  forall (t0: (array Z)),
  forall (HW_5: t0 = (update t 0 1)),
  0 <= 1 /\ 1 < (array_length t0).
Proof.
intuition; ArraySubst t0.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib4_po_4 : 
  forall (n: Z),
  forall (t: (array Z)),
  forall (HW_1: 0 <= n /\ n < (array_length t)),
  forall (HW_3: n > 1),
  forall (HW_4: 0 <= 0 /\ 0 < (array_length t)),
  forall (t0: (array Z)),
  forall (HW_5: t0 = (update t 0 1)),
  forall (HW_6: 0 <= 1 /\ 1 < (array_length t0)),
  forall (t1: (array Z)),
  forall (HW_7: t1 = (update t0 1 1)),
  (2 <= 2 /\ 2 <= (n + 1)) /\ (array_length t1) = (array_length t) /\
  (forall (i:Z), (0 <= i /\ i < 2 -> (access t1 i) = (F i))).
Proof.
intuition.
subst; repeat rewrite array_length_update; trivial.
subst. assert (i=0 \/ i=1). omega. intuition; subst.
AccessOther; auto with *.
AccessSame; auto with *.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib4_po_5 : 
  forall (n: Z),
  forall (t: (array Z)),
  forall (HW_1: 0 <= n /\ n < (array_length t)),
  forall (HW_3: n > 1),
  forall (HW_4: 0 <= 0 /\ 0 < (array_length t)),
  forall (t0: (array Z)),
  forall (HW_5: t0 = (update t 0 1)),
  forall (HW_6: 0 <= 1 /\ 1 < (array_length t0)),
  forall (t1: (array Z)),
  forall (HW_7: t1 = (update t0 1 1)),
  forall (HW_8: (2 <= 2 /\ 2 <= (n + 1)) /\ (array_length t1) =
                (array_length t) /\
                (forall (i:Z), (0 <= i /\ i < 2 -> (access t1 i) = (F i)))),
  forall (k: Z),
  forall (t2: (array Z)),
  forall (HW_9: (2 <= k /\ k <= (n + 1)) /\ (array_length t2) =
                (array_length t) /\
                (forall (i:Z), (0 <= i /\ i < k -> (access t2 i) = (F i)))),
  forall (HW_10: k <= n),
  0 <= (k - 1) /\ (k - 1) < (array_length t2).
Proof.
intuition.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib4_po_6 : 
  forall (n: Z),
  forall (t: (array Z)),
  forall (HW_1: 0 <= n /\ n < (array_length t)),
  forall (HW_3: n > 1),
  forall (HW_4: 0 <= 0 /\ 0 < (array_length t)),
  forall (t0: (array Z)),
  forall (HW_5: t0 = (update t 0 1)),
  forall (HW_6: 0 <= 1 /\ 1 < (array_length t0)),
  forall (t1: (array Z)),
  forall (HW_7: t1 = (update t0 1 1)),
  forall (HW_8: (2 <= 2 /\ 2 <= (n + 1)) /\ (array_length t1) =
                (array_length t) /\
                (forall (i:Z), (0 <= i /\ i < 2 -> (access t1 i) = (F i)))),
  forall (k: Z),
  forall (t2: (array Z)),
  forall (HW_9: (2 <= k /\ k <= (n + 1)) /\ (array_length t2) =
                (array_length t) /\
                (forall (i:Z), (0 <= i /\ i < k -> (access t2 i) = (F i)))),
  forall (HW_10: k <= n),
  forall (HW_11: 0 <= (k - 1) /\ (k - 1) < (array_length t2)),
  forall (result: Z),
  forall (HW_12: result = (access t2 (k - 1))),
  0 <= (k - 2) /\ (k - 2) < (array_length t2).
Proof.
intuition.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib4_po_7 : 
  forall (n: Z),
  forall (t: (array Z)),
  forall (HW_1: 0 <= n /\ n < (array_length t)),
  forall (HW_3: n > 1),
  forall (HW_4: 0 <= 0 /\ 0 < (array_length t)),
  forall (t0: (array Z)),
  forall (HW_5: t0 = (update t 0 1)),
  forall (HW_6: 0 <= 1 /\ 1 < (array_length t0)),
  forall (t1: (array Z)),
  forall (HW_7: t1 = (update t0 1 1)),
  forall (HW_8: (2 <= 2 /\ 2 <= (n + 1)) /\ (array_length t1) =
                (array_length t) /\
                (forall (i:Z), (0 <= i /\ i < 2 -> (access t1 i) = (F i)))),
  forall (k: Z),
  forall (t2: (array Z)),
  forall (HW_9: (2 <= k /\ k <= (n + 1)) /\ (array_length t2) =
                (array_length t) /\
                (forall (i:Z), (0 <= i /\ i < k -> (access t2 i) = (F i)))),
  forall (HW_10: k <= n),
  forall (HW_11: 0 <= (k - 1) /\ (k - 1) < (array_length t2)),
  forall (result: Z),
  forall (HW_12: result = (access t2 (k - 1))),
  forall (HW_13: 0 <= (k - 2) /\ (k - 2) < (array_length t2)),
  forall (result0: Z),
  forall (HW_14: result0 = (access t2 (k - 2))),
  0 <= k /\ k < (array_length t2).
Proof.
intuition.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib4_po_8 : 
  forall (n: Z),
  forall (t: (array Z)),
  forall (HW_1: 0 <= n /\ n < (array_length t)),
  forall (HW_3: n > 1),
  forall (HW_4: 0 <= 0 /\ 0 < (array_length t)),
  forall (t0: (array Z)),
  forall (HW_5: t0 = (update t 0 1)),
  forall (HW_6: 0 <= 1 /\ 1 < (array_length t0)),
  forall (t1: (array Z)),
  forall (HW_7: t1 = (update t0 1 1)),
  forall (HW_8: (2 <= 2 /\ 2 <= (n + 1)) /\ (array_length t1) =
                (array_length t) /\
                (forall (i:Z), (0 <= i /\ i < 2 -> (access t1 i) = (F i)))),
  forall (k: Z),
  forall (t2: (array Z)),
  forall (HW_9: (2 <= k /\ k <= (n + 1)) /\ (array_length t2) =
                (array_length t) /\
                (forall (i:Z), (0 <= i /\ i < k -> (access t2 i) = (F i)))),
  forall (HW_10: k <= n),
  forall (HW_11: 0 <= (k - 1) /\ (k - 1) < (array_length t2)),
  forall (result: Z),
  forall (HW_12: result = (access t2 (k - 1))),
  forall (HW_13: 0 <= (k - 2) /\ (k - 2) < (array_length t2)),
  forall (result0: Z),
  forall (HW_14: result0 = (access t2 (k - 2))),
  forall (HW_15: 0 <= k /\ k < (array_length t2)),
  forall (t3: (array Z)),
  forall (HW_16: t3 = (update t2 k (result + result0))),
  forall (k0: Z),
  forall (HW_17: k0 = (k + 1)),
  ((2 <= k0 /\ k0 <= (n + 1)) /\ (array_length t3) = (array_length t) /\
  (forall (i:Z), (0 <= i /\ i < k0 -> (access t3 i) = (F i)))) /\
  (Zwf 0 (n + 1 - k0) (n + 1 - k)).
Proof.
intuition; subst.
repeat rewrite array_length_update; assumption.
assert (i<k \/ i=k). omega. intuition; subst.
AccessOther; auto.
AccessSame.
replace (access t2 (k-1)) with (F (k-1)); symmetry; auto with *.
replace (access t2 (k-2)) with (F (k-2)); symmetry; auto with *.
symmetry; auto with *.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib4_po_9 : 
  forall (n: Z),
  forall (t: (array Z)),
  forall (HW_1: 0 <= n /\ n < (array_length t)),
  forall (HW_3: n > 1),
  forall (HW_4: 0 <= 0 /\ 0 < (array_length t)),
  forall (t0: (array Z)),
  forall (HW_5: t0 = (update t 0 1)),
  forall (HW_6: 0 <= 1 /\ 1 < (array_length t0)),
  forall (t1: (array Z)),
  forall (HW_7: t1 = (update t0 1 1)),
  forall (HW_8: (2 <= 2 /\ 2 <= (n + 1)) /\ (array_length t1) =
                (array_length t) /\
                (forall (i:Z), (0 <= i /\ i < 2 -> (access t1 i) = (F i)))),
  forall (k: Z),
  forall (t2: (array Z)),
  forall (HW_9: (2 <= k /\ k <= (n + 1)) /\ (array_length t2) =
                (array_length t) /\
                (forall (i:Z), (0 <= i /\ i < k -> (access t2 i) = (F i)))),
  forall (HW_18: k > n),
  0 <= n /\ n < (array_length t2).
Proof.
intuition.
Save.

(* Why obligation from file "", line 0, characters 0-0: *)
(*Why goal*) Lemma fib4_po_10 : 
  forall (n: Z),
  forall (t: (array Z)),
  forall (HW_1: 0 <= n /\ n < (array_length t)),
  forall (HW_3: n > 1),
  forall (HW_4: 0 <= 0 /\ 0 < (array_length t)),
  forall (t0: (array Z)),
  forall (HW_5: t0 = (update t 0 1)),
  forall (HW_6: 0 <= 1 /\ 1 < (array_length t0)),
  forall (t1: (array Z)),
  forall (HW_7: t1 = (update t0 1 1)),
  forall (HW_8: (2 <= 2 /\ 2 <= (n + 1)) /\ (array_length t1) =
                (array_length t) /\
                (forall (i:Z), (0 <= i /\ i < 2 -> (access t1 i) = (F i)))),
  forall (k: Z),
  forall (t2: (array Z)),
  forall (HW_9: (2 <= k /\ k <= (n + 1)) /\ (array_length t2) =
                (array_length t) /\
                (forall (i:Z), (0 <= i /\ i < k -> (access t2 i) = (F i)))),
  forall (HW_18: k > n),
  forall (HW_19: 0 <= n /\ n < (array_length t2)),
  forall (result: Z),
  forall (HW_20: result = (access t2 n)),
  result = (F n).
Proof.
intuition; subst; intuition.
Save.

(*Why*) Parameter fib4_valid :
  forall (n: Z), forall (t: (array Z)), forall (_: 0 <= n /\ n <
  (array_length t)),
  (sig_2 (array Z) Z (fun (t0: (array Z)) (result: Z)  => (result = (F n)))).

