#! /bin/sh
# Rebuild the documentation and upload this to the web server.
#
# it does use the Marek's implementation of the pod2html converter.
# You can find it from the CPAN, and I have a debian package of it on my
# my web page.
#
# Mt.

set -e # we want to fail on any error instead of risking uploading broken stuff
#set -x

function percent_lang {
	STATS=`msgfmt -o /dev/null --statistics po/pod/$1.po 2>&1`
	YES=`echo $STATS | sed -n -e 's/^\([[:digit:]]*\).*$/\1/p'`
	NO=`echo $STATS | sed -n -e 's/^\([[:digit:]]\+\)[^[:digit:]]\+\([[:digit:]]\+\).*$/\2/p'`
	if [ ! $NO ]; then
		NO=0
	fi
	O3=`echo $STATS | sed -n -e 's/^\([[:digit:]]\+\)[^[:digit:]]\+\([[:digit:]]\+\)[^[:digit:]]\+\([[:digit:]]\+\).*$/\3/p'`
	if [ $O3 ]; then
		NO=$(($NO + $O3))
	fi
	TOTAL=$(($YES+$NO))
	echo $((($YES*100)/$TOTAL))
}

function get_name {
	cat po/pod/$1.po | sed -n -e /\"NAME\"/,+1p | sed -n -e "s/msgstr \"\(.*\)\"/\1/p"
}

POFILES=`cd po/pod; ls *.po`
LANGS=${POFILES//.po/}

FILES="doc/po4a.7.pod po4a po4a-gettextize po4a-normalize po4a-updatepo po4a-translate"

PO4A_OPTS="-k 0 -v -f pod -M utf-8 -L iso8859-1"

rm -rf html/
mkdir -p html/en/

mpod2html -dir=html/en -tocname index $FILES lib

echo "<html><head><title>po4a</title></head><body><center><h1>po4a</h1><p>The po4a (po for anything) project goal is to ease translations (and more interestingly, the maintenance of translations) using gettext tools on areas where they were not expected like documentation.</p><br>English documentation: <a href=\"en/po4a.7.html\">Introduction</a> <a href=\"en\">Index</a><br><br>Documentation translations:<br>" > html/index.html

for lang in $LANGS ; do
	mkdir -p html/$lang html/tmp

	#Translate $FILES
	for file in $FILES ; do
		newfile=${file##*/}
		PERL5LIB=lib perl po4a-translate $PO4A_OPTS -a doc/addendum.$lang -p po/pod/$lang.po -m $file -l html/tmp/$newfile
	done

	mkdir -p html/tmp/lib/Locale/Po4a
	#Translate modules
	for file in lib/Locale/Po4a/*.pm ; do
		newfile=${file##*/}
		PERL5LIB=lib perl po4a-translate $PO4A_OPTS -a doc/addendum.$lang -m $file -p po/pod/$lang.po -l html/tmp/lib/Locale/Po4a/$newfile
	done

	mpod2html -dir=html/$lang -strname `get_name $lang` -tocname index html/tmp/*
	rm -rf html/tmp

	PERC=`percent_lang $lang`
	echo "$lang ($PERC% translated): <a href=\"$lang/po4a.7.html\">Introduction</a> <a href=\"$lang/\">Index</a><br>" >> html/index.html
done

echo "<br><a href=\"http://alioth.debian.org/projects/po4a/\">Alioth project page</a>" >> html/index.html
echo "<br><a href=\"http://packages.qa.debian.org/po4a\">Debian developer information</a>" >> html/index.html
echo "<br><br>Last update: `LANG=C date`</center></body></html>" >> html/index.html

chmod -R g+rw html
scp -pr html/* po4a.alioth.debian.org:/var/lib/gforge/chroot/home/groups/po4a/htdocs/
