%%
%%  wpf_terminal.erl --
%%
%%     Fixed terminal font.
%%
%%  Copyright (c) 2004 Bjorn Gustavsson.
%%
%%  See the file "license.terms" for information on usage and redistribution
%%  of this file, and for a DISCLAIMER OF ALL WARRANTIES.
%%
%%     $Id: wpf_terminal8x12.erl 177 2007-12-21 18:56:58Z bjorng $
%%

-module(wpf_terminal8x12).
-export([desc/0,width/0,width_fun/0,height/0,draw/1,char/1,bold/1]).

desc() ->
    "Terminal (8x12)".

width_fun() -> fun cw/1.

width() -> 8.
height() -> 12.

draw([C|T]) ->
    char(C),
    draw(T);
draw([]) -> ok.

bold([C|T]) ->
    bold_char(C),
    bold(T);
bold([]) -> ok.

cw(_) -> 8.

bold_char(C) ->
    char(C),
    Cw = cw(C),
    gl:bitmap(1, 1, 0, 0, -Cw+1, 0, <<0>>),
    char(C).

char(32) ->
 B = <<>>,
 gl:bitmap(0, 0, 0, 0, 8, 0, B);

char(160) ->
 B = <<>>,
 gl:bitmap(0, 0, 0, 0, 8, 0, B);

% char: 0xff

char(255) ->
 B = <<16#60,16#90,16#10,16#28,16#28,16#44,16#44,16#c6,16#0,16#28,16#28>>,
 gl:bitmap(7, 11, -1, 2, 8, 0, B);

% char: 0xfe

char(254) ->
 B = <<16#e0,16#40,16#78,16#44,16#44,16#44,16#44,16#78,16#40,16#e0>>,
 gl:bitmap(6, 10, -1, 2, 8, 0, B);

% char: 0xfd

char(253) ->
 B = <<16#60,16#90,16#10,16#18,16#28,16#44,16#44,16#c6,16#0,16#10,16#8>>,
 gl:bitmap(7, 11, -1, 2, 8, 0, B);

% char: 0xfc

char(252) ->
 B = <<16#74,16#8c,16#84,16#84,16#84,16#84,16#0,16#48,16#48>>,
 gl:bitmap(6, 9, -1, 0, 8, 0, B);

% char: 0xfb

char(251) ->
 B = <<16#74,16#8c,16#84,16#84,16#84,16#84,16#0,16#48,16#30>>,
 gl:bitmap(6, 9, -1, 0, 8, 0, B);

% char: 0xfa

char(250) ->
 B = <<16#74,16#8c,16#84,16#84,16#84,16#84,16#0,16#20,16#10>>,
 gl:bitmap(6, 9, -1, 0, 8, 0, B);

% char: 0xf9

char(249) ->
 B = <<16#74,16#8c,16#84,16#84,16#84,16#84,16#0,16#10,16#20>>,
 gl:bitmap(6, 9, -1, 0, 8, 0, B);

% char: 0xf8

char(248) ->
 B = <<16#80,16#7c,16#62,16#52,16#4a,16#46,16#3e,16#1>>,
 gl:bitmap(8, 8, 0, 1, 8, 0, B);

% char: 0xf7

char(247) ->
 B = <<16#20,16#20,16#0,16#f8,16#0,16#20,16#20>>,
 gl:bitmap(5, 7, -2, 0, 8, 0, B);

% char: 0xf6

char(246) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#78,16#0,16#48,16#48>>,
 gl:bitmap(6, 9, -1, 0, 8, 0, B);

% char: 0xf5

char(245) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#78,16#0,16#58,16#34>>,
 gl:bitmap(6, 9, -1, 0, 8, 0, B);

% char: 0xf4

char(244) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#78,16#0,16#48,16#30>>,
 gl:bitmap(6, 9, -1, 0, 8, 0, B);

% char: 0xf3

char(243) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#78,16#0,16#20,16#10>>,
 gl:bitmap(6, 9, -1, 0, 8, 0, B);

% char: 0xf2

char(242) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#78,16#0,16#10,16#20>>,
 gl:bitmap(6, 9, -1, 0, 8, 0, B);

% char: 0xf1

char(241) ->
 B = <<16#84,16#84,16#84,16#84,16#c4,16#b8,16#0,16#58,16#34>>,
 gl:bitmap(6, 9, -1, 0, 8, 0, B);

% char: 0xf0

char(240) ->
 B = <<16#78,16#84,16#84,16#84,16#78,16#90,16#60,16#60,16#90>>,
 gl:bitmap(6, 9, -1, 0, 8, 0, B);

% char: 0xef

char(239) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#60,16#0,16#50,16#50>>,
 gl:bitmap(5, 9, -2, 0, 8, 0, B);

% char: 0xee

char(238) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#60,16#0,16#90,16#60>>,
 gl:bitmap(5, 9, -2, 0, 8, 0, B);

% char: 0xed

char(237) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#60,16#0,16#40,16#20>>,
 gl:bitmap(5, 9, -2, 0, 8, 0, B);

% char: 0xec

char(236) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#60,16#0,16#20,16#40>>,
 gl:bitmap(5, 9, -2, 0, 8, 0, B);

% char: 0xeb

char(235) ->
 B = <<16#78,16#84,16#80,16#fc,16#84,16#78,16#0,16#48,16#48>>,
 gl:bitmap(6, 9, -1, 0, 8, 0, B);

% char: 0xea

char(234) ->
 B = <<16#78,16#84,16#80,16#fc,16#84,16#78,16#0,16#48,16#30>>,
 gl:bitmap(6, 9, -1, 0, 8, 0, B);

% char: 0xe9

char(233) ->
 B = <<16#78,16#84,16#80,16#fc,16#84,16#78,16#0,16#10,16#8>>,
 gl:bitmap(6, 9, -1, 0, 8, 0, B);

% char: 0xe8

char(232) ->
 B = <<16#78,16#84,16#80,16#fc,16#84,16#78,16#0,16#10,16#20>>,
 gl:bitmap(6, 9, -1, 0, 8, 0, B);

% char: 0xe7

char(231) ->
 B = <<16#40,16#20,16#78,16#84,16#80,16#80,16#84,16#78>>,
 gl:bitmap(6, 8, -1, 2, 8, 0, B);

% char: 0xe6

char(230) ->
 B = <<16#6c,16#92,16#90,16#7e,16#12,16#ec>>,
 gl:bitmap(7, 6, -1, 0, 8, 0, B);

% char: 0xe5

char(229) ->
 B = <<16#7a,16#84,16#84,16#7c,16#4,16#78,16#0,16#38,16#44,16#38>>,
 gl:bitmap(7, 10, -1, 0, 8, 0, B);

% char: 0xe4

char(228) ->
 B = <<16#7a,16#84,16#84,16#7c,16#4,16#78,16#0,16#24,16#24>>,
 gl:bitmap(7, 9, -1, 0, 8, 0, B);

% char: 0xe3

char(227) ->
 B = <<16#7a,16#84,16#84,16#7c,16#4,16#78,16#0,16#58,16#34>>,
 gl:bitmap(7, 9, -1, 0, 8, 0, B);

% char: 0xe2

char(226) ->
 B = <<16#7a,16#84,16#84,16#7c,16#4,16#78,16#0,16#48,16#30>>,
 gl:bitmap(7, 9, -1, 0, 8, 0, B);

% char: 0xe1

char(225) ->
 B = <<16#7a,16#84,16#84,16#7c,16#4,16#78,16#0,16#10,16#8>>,
 gl:bitmap(7, 9, -1, 0, 8, 0, B);

% char: 0xe0

char(224) ->
 B = <<16#7a,16#84,16#84,16#7c,16#4,16#78,16#0,16#10,16#20>>,
 gl:bitmap(7, 9, -1, 0, 8, 0, B);

% char: 0xdf

char(223) ->
 B = <<16#d8,16#44,16#44,16#44,16#c8,16#44,16#44,16#38>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0xde

char(222) ->
 B = <<16#e0,16#40,16#78,16#44,16#44,16#78,16#40,16#e0>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0xdd

char(221) ->
 B = <<16#10,16#10,16#10,16#10,16#28,16#44,16#82,16#82,16#0,16#20,16#18>>,
 gl:bitmap(7, 11, -1, 0, 8, 0, B);

% char: 0xdc

char(220) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#0,16#48,16#48>>,
 gl:bitmap(6, 11, -1, 0, 8, 0, B);

% char: 0xdb

char(219) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#0,16#48,16#30>>,
 gl:bitmap(6, 11, -1, 0, 8, 0, B);

% char: 0xda

char(218) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#0,16#20,16#10>>,
 gl:bitmap(6, 11, -1, 0, 8, 0, B);

% char: 0xd9

char(217) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#84,16#0,16#10,16#20>>,
 gl:bitmap(6, 11, -1, 0, 8, 0, B);

% char: 0xd8

char(216) ->
 B = <<16#80,16#7c,16#62,16#52,16#4a,16#4a,16#46,16#42,16#3d>>,
 gl:bitmap(8, 9, 0, 1, 8, 0, B);

% char: 0xd7

char(215) ->
 B = <<16#88,16#50,16#20,16#50,16#88>>,
 gl:bitmap(5, 5, -2, -1, 8, 0, B);

% char: 0xd6

char(214) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#78,16#0,16#48,16#48>>,
 gl:bitmap(6, 11, -1, 0, 8, 0, B);

% char: 0xd5

char(213) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#78,16#0,16#98,16#64>>,
 gl:bitmap(6, 11, -1, 0, 8, 0, B);

% char: 0xd4

char(212) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#78,16#0,16#48,16#30>>,
 gl:bitmap(6, 11, -1, 0, 8, 0, B);

% char: 0xd3

char(211) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#78,16#0,16#20,16#10>>,
 gl:bitmap(6, 11, -1, 0, 8, 0, B);

% char: 0xd2

char(210) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#78,16#0,16#10,16#20>>,
 gl:bitmap(6, 11, -1, 0, 8, 0, B);

% char: 0xd1

char(209) ->
 B = <<16#84,16#8c,16#94,16#94,16#a4,16#a4,16#c4,16#84,16#0,16#98,16#64>>,
 gl:bitmap(6, 11, -1, 0, 8, 0, B);

% char: 0xd0

char(208) ->
 B = <<16#7c,16#42,16#42,16#42,16#f2,16#42,16#42,16#7c>>,
 gl:bitmap(7, 8, 0, 0, 8, 0, B);

% char: 0xcf

char(207) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#20,16#f8,16#0,16#50,16#50>>,
 gl:bitmap(5, 11, -2, 0, 8, 0, B);

% char: 0xce

char(206) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#20,16#f8,16#0,16#50,16#20>>,
 gl:bitmap(5, 11, -2, 0, 8, 0, B);

% char: 0xcd

char(205) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#20,16#f8,16#0,16#20,16#10>>,
 gl:bitmap(5, 11, -2, 0, 8, 0, B);

% char: 0xcc

char(204) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#20,16#f8,16#0,16#20,16#40>>,
 gl:bitmap(5, 11, -2, 0, 8, 0, B);

% char: 0xcb

char(203) ->
 B = <<16#f8,16#80,16#80,16#80,16#f0,16#80,16#80,16#f8,16#0,16#50,16#50>>,
 gl:bitmap(5, 11, -2, 0, 8, 0, B);

% char: 0xca

char(202) ->
 B = <<16#f8,16#80,16#80,16#80,16#f0,16#80,16#80,16#f8,16#0,16#48,16#30>>,
 gl:bitmap(5, 11, -2, 0, 8, 0, B);

% char: 0xc9

char(201) ->
 B = <<16#f8,16#80,16#80,16#80,16#f0,16#80,16#80,16#f8,16#0,16#20,16#10>>,
 gl:bitmap(5, 11, -2, 0, 8, 0, B);

% char: 0xc8

char(200) ->
 B = <<16#f8,16#80,16#80,16#80,16#f0,16#80,16#80,16#f8,16#0,16#20,16#40>>,
 gl:bitmap(5, 11, -2, 0, 8, 0, B);

% char: 0xc7

char(199) ->
 B = <<16#20,16#10,16#78,16#84,16#80,16#80,16#80,16#80,16#84,16#78>>,
 gl:bitmap(6, 10, -1, 2, 8, 0, B);

% char: 0xc6

char(198) ->
 B = <<16#9e,16#90,16#90,16#f0,16#9c,16#50,16#50,16#3e>>,
 gl:bitmap(7, 8, -1, 0, 8, 0, B);

% char: 0xc5

char(197) ->
 B = <<16#84,16#84,16#84,16#fc,16#84,16#84,16#48,16#30,16#30,16#48,16#30>>,
 gl:bitmap(6, 11, -1, 0, 8, 0, B);

% char: 0xc4

char(196) ->
 B = <<16#84,16#84,16#84,16#fc,16#84,16#84,16#48,16#30,16#0,16#48,16#48>>,
 gl:bitmap(6, 11, -1, 0, 8, 0, B);

% char: 0xc3

char(195) ->
 B = <<16#84,16#84,16#84,16#fc,16#84,16#84,16#48,16#30,16#0,16#98,16#64>>,
 gl:bitmap(6, 11, -1, 0, 8, 0, B);

% char: 0xc2

char(194) ->
 B = <<16#84,16#84,16#84,16#fc,16#84,16#84,16#48,16#30,16#0,16#48,16#30>>,
 gl:bitmap(6, 11, -1, 0, 8, 0, B);

% char: 0xc1

char(193) ->
 B = <<16#84,16#84,16#84,16#fc,16#84,16#84,16#48,16#30,16#0,16#20,16#10>>,
 gl:bitmap(6, 11, -1, 0, 8, 0, B);

% char: 0xc0

char(192) ->
 B = <<16#84,16#84,16#84,16#fc,16#84,16#84,16#48,16#30,16#0,16#10,16#20>>,
 gl:bitmap(6, 11, -1, 0, 8, 0, B);

% char: 0xbf

char(191) ->
 B = <<16#70,16#88,16#80,16#40,16#20,16#20,16#0,16#20,16#20>>,
 gl:bitmap(5, 9, -2, 1, 8, 0, B);

% char: 0xbe

char(190) ->
 B = <<16#4,16#be,16#54,16#2c,16#14,16#68,16#94,16#20,16#90,16#60>>,
 gl:bitmap(7, 10, -1, 1, 8, 0, B);

% char: 0xbd

char(189) ->
 B = <<16#1e,16#8,16#84,16#52,16#2c,16#f0,16#48,16#44,16#c0,16#40>>,
 gl:bitmap(7, 10, -1, 1, 8, 0, B);

% char: 0xbc

char(188) ->
 B = <<16#4,16#3e,16#94,16#4c,16#24,16#f0,16#48,16#44,16#c0,16#40>>,
 gl:bitmap(7, 10, -1, 1, 8, 0, B);

% char: 0xbb

char(187) ->
 B = <<16#90,16#48,16#24,16#48,16#90>>,
 gl:bitmap(6, 5, -1, -1, 8, 0, B);

% char: 0xba

char(186) ->
 B = <<16#f0,16#0,16#60,16#90,16#90,16#90,16#60>>,
 gl:bitmap(4, 7, -1, -1, 8, 0, B);

% char: 0xb9

char(185) ->
 B = <<16#e0,16#40,16#40,16#40,16#c0,16#40>>,
 gl:bitmap(3, 6, -2, -2, 8, 0, B);

% char: 0xb8

char(184) ->
 B = <<16#c0,16#40,16#40>>,
 gl:bitmap(2, 3, -3, 2, 8, 0, B);

% char: 0xb7

char(183) ->
 B = <<16#80,16#80>>,
 gl:bitmap(1, 2, -3, -4, 8, 0, B);

% char: 0xb6

char(182) ->
 B = <<16#28,16#28,16#28,16#28,16#68,16#e8,16#e8,16#e8,16#7c>>,
 gl:bitmap(6, 9, -1, 1, 8, 0, B);

% char: 0xb5

char(181) ->
 B = <<16#b6,16#48,16#48,16#24,16#24,16#12>>,
 gl:bitmap(7, 6, 0, 0, 8, 0, B);

% char: 0xb4

char(180) ->
 B = <<16#80,16#40,16#20>>,
 gl:bitmap(3, 3, -3, -6, 8, 0, B);

% char: 0xb3

char(179) ->
 B = <<16#60,16#90,16#10,16#20,16#90,16#60>>,
 gl:bitmap(4, 6, -2, -2, 8, 0, B);

% char: 0xb2

char(178) ->
 B = <<16#f0,16#80,16#40,16#20,16#90,16#60>>,
 gl:bitmap(4, 6, -2, -2, 8, 0, B);

% char: 0xb1

char(177) ->
 B = <<16#f8,16#0,16#20,16#20,16#f8,16#20,16#20>>,
 gl:bitmap(5, 7, -2, 0, 8, 0, B);

% char: 0xb0

char(176) ->
 B = <<16#40,16#a0,16#40>>,
 gl:bitmap(3, 3, -2, -6, 8, 0, B);

% char: 0xaf

char(175) ->
 B = <<16#fc>>,
 gl:bitmap(6, 1, -1, -8, 8, 0, B);

% char: 0xae

char(174) ->
 B = <<16#7c,16#82,16#aa,16#b2,16#aa,16#b2,16#82,16#7c>>,
 gl:bitmap(7, 8, -1, 0, 8, 0, B);

% char: 0xad

char(173) ->
 B = <<16#f0>>,
 gl:bitmap(4, 1, -2, -3, 8, 0, B);

% char: 0xac

char(172) ->
 B = <<16#4,16#fc>>,
 gl:bitmap(6, 2, -1, -3, 8, 0, B);

% char: 0xab

char(171) ->
 B = <<16#24,16#48,16#90,16#48,16#24>>,
 gl:bitmap(6, 5, -1, -1, 8, 0, B);

% char: 0xaa

char(170) ->
 B = <<16#f0,16#0,16#70,16#90,16#70,16#10,16#60>>,
 gl:bitmap(4, 7, -1, -1, 8, 0, B);

% char: 0xa9

char(169) ->
 B = <<16#7c,16#82,16#9a,16#a2,16#a2,16#9a,16#82,16#7c>>,
 gl:bitmap(7, 8, -1, 0, 8, 0, B);

% char: 0xa8

char(168) ->
 B = <<16#90,16#90>>,
 gl:bitmap(4, 2, -2, -7, 8, 0, B);

% char: 0xa7

char(167) ->
 B = <<16#70,16#88,16#8,16#70,16#88,16#88,16#70,16#80,16#88,16#70>>,
 gl:bitmap(5, 10, -2, 1, 8, 0, B);

% char: 0xa6

char(166) ->
 B = <<16#80,16#80,16#80,16#80,16#0,16#0,16#80,16#80,16#80,16#80>>,
 gl:bitmap(1, 10, -3, 1, 8, 0, B);

% char: 0xa5

char(165) ->
 B = <<16#20,16#20,16#f8,16#20,16#f8,16#50,16#88,16#88>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0xa4

char(164) ->
 B = <<16#88,16#70,16#88,16#88,16#88,16#70,16#88>>,
 gl:bitmap(5, 7, -2, -1, 8, 0, B);

% char: 0xa3

char(163) ->
 B = <<16#dc,16#62,16#20,16#78,16#20,16#24,16#24,16#18>>,
 gl:bitmap(7, 8, -1, 0, 8, 0, B);

% char: 0xa2

char(162) ->
 B = <<16#20,16#20,16#70,16#a8,16#a0,16#a8,16#70,16#20,16#20>>,
 gl:bitmap(5, 9, -2, 0, 8, 0, B);

% char: 0xa1

char(161) ->
 B = <<16#80,16#80,16#80,16#80,16#80,16#80,16#0,16#80,16#80>>,
 gl:bitmap(1, 9, -4, 1, 8, 0, B);

% char: 0x9f

char(159) ->
 B = <<16#10,16#10,16#0,16#0,16#10,16#10,16#30,16#60,16#c0,16#80,16#84,16#cc,16#78>>,
 gl:bitmap(6, 13, -1, 2, 8, 0, B);

% char: 0x82

char(130) ->
 B = <<16#10,16#10,16#10,16#10,16#28,16#44,16#82,16#82,16#0,16#48,16#48>>,
 gl:bitmap(7, 11, -1, 0, 8, 0, B);

% char: 0x81

char(129) ->
 B = <<16#6c,16#92,16#90,16#9e,16#92,16#6c>>,
 gl:bitmap(7, 6, -1, 0, 8, 0, B);

% char: 0x80

char(128) ->
 B = <<16#7e,16#90,16#90,16#90,16#9c,16#90,16#90,16#7e>>,
 gl:bitmap(7, 8, -1, 0, 8, 0, B);

% char: 0x7e '~' */

char(126) ->
 B = <<16#98,16#64>>,
 gl:bitmap(6, 2, -1, -4, 8, 0, B);

% char: 0x7d '}' */

char(125) ->
 B = <<16#c0,16#20,16#20,16#20,16#40,16#30,16#40,16#20,16#20,16#c0>>,
 gl:bitmap(4, 10, -2, 1, 8, 0, B);

% char: 0x7c '|' */

char(124) ->
 B = <<16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80>>,
 gl:bitmap(1, 10, -3, 1, 8, 0, B);

% char: 0x7b '{' */

char(123) ->
 B = <<16#30,16#40,16#40,16#40,16#20,16#c0,16#20,16#40,16#40,16#30>>,
 gl:bitmap(4, 10, -2, 1, 8, 0, B);

% char: 0x7a 'z' */

char(122) ->
 B = <<16#fc,16#40,16#20,16#10,16#8,16#fc>>,
 gl:bitmap(6, 6, -1, 0, 8, 0, B);

% char: 0x79 'y' */

char(121) ->
 B = <<16#60,16#90,16#10,16#18,16#28,16#44,16#44,16#c6>>,
 gl:bitmap(7, 8, -1, 2, 8, 0, B);

% char: 0x78 'x' */

char(120) ->
 B = <<16#cc,16#48,16#30,16#30,16#48,16#cc>>,
 gl:bitmap(6, 6, -1, 0, 8, 0, B);

% char: 0x77 'w' */

char(119) ->
 B = <<16#6c,16#92,16#92,16#92,16#82,16#82>>,
 gl:bitmap(7, 6, -1, 0, 8, 0, B);

% char: 0x76 'v' */

char(118) ->
 B = <<16#20,16#20,16#50,16#50,16#88,16#88>>,
 gl:bitmap(5, 6, -2, 0, 8, 0, B);

% char: 0x75 'u' */

char(117) ->
 B = <<16#74,16#8c,16#84,16#84,16#84,16#84>>,
 gl:bitmap(6, 6, -1, 0, 8, 0, B);

% char: 0x74 't' */

char(116) ->
 B = <<16#30,16#48,16#40,16#40,16#40,16#f0,16#40,16#40>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x73 's' */

char(115) ->
 B = <<16#78,16#84,16#4,16#78,16#84,16#78>>,
 gl:bitmap(6, 6, -1, 0, 8, 0, B);

% char: 0x72 'r' */

char(114) ->
 B = <<16#40,16#40,16#40,16#40,16#64,16#dc>>,
 gl:bitmap(6, 6, -1, 0, 8, 0, B);

% char: 0x71 'q' */

char(113) ->
 B = <<16#4,16#4,16#74,16#8c,16#84,16#84,16#84,16#7c>>,
 gl:bitmap(6, 8, -1, 2, 8, 0, B);

% char: 0x70 'p' */

char(112) ->
 B = <<16#80,16#80,16#f8,16#84,16#84,16#84,16#c4,16#b8>>,
 gl:bitmap(6, 8, -1, 2, 8, 0, B);

% char: 0x6f 'o' */

char(111) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#78>>,
 gl:bitmap(6, 6, -1, 0, 8, 0, B);

% char: 0x6e 'n' */

char(110) ->
 B = <<16#84,16#84,16#84,16#84,16#c4,16#b8>>,
 gl:bitmap(6, 6, -1, 0, 8, 0, B);

% char: 0x6d 'm' */

char(109) ->
 B = <<16#82,16#82,16#92,16#92,16#92,16#ec>>,
 gl:bitmap(7, 6, -1, 0, 8, 0, B);

% char: 0x6c 'l' */

char(108) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#20,16#e0>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x6b 'k' */

char(107) ->
 B = <<16#84,16#88,16#90,16#e0,16#90,16#88,16#80,16#80>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x6a 'j' */

char(106) ->
 B = <<16#70,16#88,16#8,16#8,16#8,16#8,16#8,16#38,16#0,16#8,16#8>>,
 gl:bitmap(5, 11, -1, 2, 8, 0, B);

% char: 0x69 'i' */

char(105) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#e0,16#0,16#20,16#20>>,
 gl:bitmap(5, 9, -2, 0, 8, 0, B);

% char: 0x68 'h' */

char(104) ->
 B = <<16#84,16#84,16#84,16#84,16#c4,16#b8,16#80,16#80>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x67 'g' */

char(103) ->
 B = <<16#78,16#84,16#78,16#80,16#70,16#88,16#88,16#70,16#8>>,
 gl:bitmap(6, 9, -1, 2, 8, 0, B);

% char: 0x66 'f' */

char(102) ->
 B = <<16#40,16#40,16#40,16#40,16#f0,16#40,16#40,16#38>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x65 'e' */

char(101) ->
 B = <<16#78,16#84,16#80,16#fc,16#84,16#78>>,
 gl:bitmap(6, 6, -1, 0, 8, 0, B);

% char: 0x64 'd' */

char(100) ->
 B = <<16#7c,16#84,16#84,16#84,16#8c,16#74,16#4,16#4>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x63 'c' */

char(99) ->
 B = <<16#78,16#84,16#80,16#80,16#84,16#78>>,
 gl:bitmap(6, 6, -1, 0, 8, 0, B);

% char: 0x62 'b' */

char(98) ->
 B = <<16#f8,16#84,16#84,16#84,16#c4,16#b8,16#80,16#80>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x61 'a' */

char(97) ->
 B = <<16#7a,16#84,16#84,16#7c,16#4,16#78>>,
 gl:bitmap(7, 6, -1, 0, 8, 0, B);

% char: 0x60 '`' */

char(96) ->
 B = <<16#40,16#80,16#80>>,
 gl:bitmap(2, 3, -4, -6, 8, 0, B);

% char: 0x5f '_' */

char(95) ->
 B = <<16#fc>>,
 gl:bitmap(6, 1, -1, 0, 8, 0, B);

% char: 0x5e '^' */

char(94) ->
 B = <<16#88,16#50,16#20>>,
 gl:bitmap(5, 3, -2, -3, 8, 0, B);

% char: 0x5d ']' */

char(93) ->
 B = <<16#e0,16#20,16#20,16#20,16#20,16#20,16#20,16#20,16#20,16#e0>>,
 gl:bitmap(3, 10, -2, 1, 8, 0, B);

% char: 0x5c '\' */

char(92) ->
 B = <<16#10,16#10,16#20,16#20,16#20,16#40,16#40,16#40,16#80,16#80>>,
 gl:bitmap(4, 10, -2, 1, 8, 0, B);

% char: 0x5b '[' */

char(91) ->
 B = <<16#e0,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#e0>>,
 gl:bitmap(3, 10, -3, 1, 8, 0, B);

% char: 0x5a 'Z' */

char(90) ->
 B = <<16#fc,16#80,16#40,16#20,16#10,16#8,16#4,16#fc>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x59 'Y' */

char(89) ->
 B = <<16#10,16#10,16#10,16#10,16#28,16#44,16#82,16#82>>,
 gl:bitmap(7, 8, -1, 0, 8, 0, B);

% char: 0x58 'X' */

char(88) ->
 B = <<16#c6,16#44,16#28,16#10,16#10,16#28,16#44,16#c6>>,
 gl:bitmap(7, 8, -1, 0, 8, 0, B);

% char: 0x57 'W' */

char(87) ->
 B = <<16#6c,16#92,16#92,16#92,16#92,16#82,16#82,16#82>>,
 gl:bitmap(7, 8, -1, 0, 8, 0, B);

% char: 0x56 'V' */

char(86) ->
 B = <<16#10,16#10,16#28,16#28,16#44,16#44,16#82,16#82>>,
 gl:bitmap(7, 8, -1, 0, 8, 0, B);

% char: 0x55 'U' */

char(85) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#84>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x54 'T' */

char(84) ->
 B = <<16#20,16#20,16#20,16#20,16#20,16#20,16#20,16#f8>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x53 'S' */

char(83) ->
 B = <<16#78,16#84,16#4,16#4,16#78,16#80,16#84,16#78>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x52 'R' */

char(82) ->
 B = <<16#84,16#88,16#90,16#f8,16#84,16#84,16#84,16#f8>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x51 'Q' */

char(81) ->
 B = <<16#4,16#78,16#94,16#a4,16#84,16#84,16#84,16#84,16#78>>,
 gl:bitmap(6, 9, -1, 1, 8, 0, B);

% char: 0x50 'P' */

char(80) ->
 B = <<16#80,16#80,16#80,16#f8,16#84,16#84,16#84,16#f8>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x4f 'O' */

char(79) ->
 B = <<16#78,16#84,16#84,16#84,16#84,16#84,16#84,16#78>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x4e 'N' */

char(78) ->
 B = <<16#84,16#8c,16#94,16#94,16#a4,16#a4,16#c4,16#84>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x4d 'M' */

char(77) ->
 B = <<16#82,16#82,16#92,16#92,16#aa,16#aa,16#c6,16#82>>,
 gl:bitmap(7, 8, -1, 0, 8, 0, B);

% char: 0x4c 'L' */

char(76) ->
 B = <<16#f8,16#80,16#80,16#80,16#80,16#80,16#80,16#80>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x4b 'K' */

char(75) ->
 B = <<16#88,16#90,16#a0,16#c0,16#c0,16#a0,16#90,16#88>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x4a 'J' */

char(74) ->
 B = <<16#70,16#88,16#8,16#8,16#8,16#8,16#8,16#3c>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x49 'I' */

char(73) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#20,16#f8>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x48 'H' */

char(72) ->
 B = <<16#84,16#84,16#84,16#84,16#fc,16#84,16#84,16#84>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x47 'G' */

char(71) ->
 B = <<16#78,16#84,16#84,16#84,16#9c,16#80,16#84,16#78>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x46 'F' */

char(70) ->
 B = <<16#80,16#80,16#80,16#f0,16#80,16#80,16#80,16#f8>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x45 'E' */

char(69) ->
 B = <<16#f8,16#80,16#80,16#80,16#f0,16#80,16#80,16#f8>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x44 'D' */

char(68) ->
 B = <<16#f8,16#84,16#84,16#84,16#84,16#84,16#84,16#f8>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x43 'C' */

char(67) ->
 B = <<16#78,16#84,16#80,16#80,16#80,16#80,16#84,16#78>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x42 'B' */

char(66) ->
 B = <<16#f8,16#84,16#84,16#84,16#f8,16#84,16#84,16#f8>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x41 'A' */

char(65) ->
 B = <<16#84,16#84,16#84,16#fc,16#84,16#84,16#48,16#30>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x40 '@' */

char(64) ->
 B = <<16#78,16#80,16#9c,16#a4,16#a4,16#9c,16#84,16#78>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x3f '?' */

char(63) ->
 B = <<16#20,16#20,16#0,16#20,16#20,16#10,16#88,16#70>>,
 gl:bitmap(5, 8, -1, 0, 8, 0, B);

% char: 0x3e '>' */

char(62) ->
 B = <<16#80,16#40,16#20,16#10,16#20,16#40,16#80>>,
 gl:bitmap(4, 7, -2, 0, 8, 0, B);

% char: 0x3d '=' */

char(61) ->
 B = <<16#fc,16#0,16#fc>>,
 gl:bitmap(6, 3, -1, -2, 8, 0, B);

% char: 0x3c '<' */

char(60) ->
 B = <<16#10,16#20,16#40,16#80,16#40,16#20,16#10>>,
 gl:bitmap(4, 7, -2, 0, 8, 0, B);

% char: 0x3b ';' */

char(59) ->
 B = <<16#80,16#40,16#40,16#0,16#0,16#40,16#40>>,
 gl:bitmap(2, 7, -2, 1, 8, 0, B);

% char: 0x3a ':' */

char(58) ->
 B = <<16#80,16#80,16#0,16#0,16#80,16#80>>,
 gl:bitmap(1, 6, -3, 0, 8, 0, B);

% char: 0x39 '9' */

char(57) ->
 B = <<16#60,16#10,16#8,16#78,16#88,16#88,16#88,16#70>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x38 '8' */

char(56) ->
 B = <<16#70,16#88,16#88,16#88,16#70,16#88,16#88,16#70>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x37 '7' */

char(55) ->
 B = <<16#40,16#40,16#40,16#20,16#20,16#10,16#8,16#f8>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x36 '6' */

char(54) ->
 B = <<16#70,16#88,16#88,16#88,16#f0,16#80,16#40,16#30>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x35 '5' */

char(53) ->
 B = <<16#70,16#88,16#8,16#88,16#f0,16#80,16#80,16#f8>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x34 '4' */

char(52) ->
 B = <<16#10,16#10,16#f8,16#90,16#50,16#50,16#30,16#10>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x33 '3' */

char(51) ->
 B = <<16#70,16#88,16#8,16#8,16#30,16#8,16#88,16#70>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x32 '2' */

char(50) ->
 B = <<16#f8,16#80,16#40,16#20,16#10,16#8,16#88,16#70>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x31 '1' */

char(49) ->
 B = <<16#f8,16#20,16#20,16#20,16#20,16#a0,16#60,16#20>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x30 '0' */

char(48) ->
 B = <<16#70,16#88,16#88,16#88,16#88,16#88,16#88,16#70>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x2f '/' */

char(47) ->
 B = <<16#80,16#80,16#40,16#40,16#40,16#20,16#20,16#20,16#10,16#10>>,
 gl:bitmap(4, 10, -2, 1, 8, 0, B);

% char: 0x2e '.' */

char(46) ->
 B = <<16#80,16#80>>,
 gl:bitmap(1, 2, -3, 0, 8, 0, B);

% char: 0x2d '-' */

char(45) ->
 B = <<16#fc>>,
 gl:bitmap(6, 1, -1, -3, 8, 0, B);

% char: 0x2c ',' */

char(44) ->
 B = <<16#80,16#40,16#40>>,
 gl:bitmap(2, 3, -3, 1, 8, 0, B);

% char: 0x2b '+' */

char(43) ->
 B = <<16#20,16#20,16#f8,16#20,16#20>>,
 gl:bitmap(5, 5, -2, -1, 8, 0, B);

% char: 0x2a '*' */

char(42) ->
 B = <<16#20,16#a8,16#70,16#70,16#a8,16#20>>,
 gl:bitmap(5, 6, -2, -2, 8, 0, B);

% char: 0x29 ')' */

char(41) ->
 B = <<16#80,16#40,16#40,16#20,16#20,16#20,16#20,16#40,16#40,16#80>>,
 gl:bitmap(3, 10, -2, 1, 8, 0, B);

% char: 0x28 '(' */

char(40) ->
 B = <<16#20,16#40,16#40,16#80,16#80,16#80,16#80,16#40,16#40,16#20>>,
 gl:bitmap(3, 10, -3, 1, 8, 0, B);

% char: 0x27 ''' */

char(39) ->
 B = <<16#80,16#40,16#40>>,
 gl:bitmap(2, 3, -3, -6, 8, 0, B);

% char: 0x26 '&' */

char(38) ->
 B = <<16#74,16#88,16#88,16#54,16#20,16#50,16#50,16#20>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x25 '%' */

char(37) ->
 B = <<16#48,16#54,16#28,16#20,16#10,16#50,16#b8,16#48>>,
 gl:bitmap(6, 8, -1, 0, 8, 0, B);

% char: 0x24 '$' */

char(36) ->
 B = <<16#20,16#70,16#a8,16#30,16#60,16#a8,16#70,16#20>>,
 gl:bitmap(5, 8, -2, 0, 8, 0, B);

% char: 0x23 '#' */

char(35) ->
 B = <<16#48,16#48,16#fc,16#48,16#fc,16#48,16#48>>,
 gl:bitmap(6, 7, -1, -1, 8, 0, B);

% char: 0x22 '"' */

char(34) ->
 B = <<16#90,16#90,16#90>>,
 gl:bitmap(4, 3, -2, -6, 8, 0, B);

% char: 0x21 '!' */

char(33) ->
 B = <<16#80,16#80,16#0,16#80,16#80,16#80,16#80,16#80>>,
 gl:bitmap(1, 8, -3, 0, 8, 0, B);

char(_) -> exit(bad_char_in_string).
