// $Id: harmonics.vs 130 2007-09-08 18:53:44Z antoneos $
//
// Vertex shader for spherical harmonics lighting
// Author: Randi Rost
// Copyright (C) 2005 3Dlabs, Inc.
// See 3Dlabs-License.txt for license information

varying vec3  DiffuseColor;
uniform float ScaleFactor;
uniform int   Type;

const float C1 = 0.429043;
const float C2 = 0.511664;
const float C3 = 0.743125;
const float C4 = 0.886227;
const float C5 = 0.247708;

vec3 L00, L1m1, L10, L11, L2m2, L2m1, L20, L21, L22 = vec3(0);

void main(void) {

	// if (Type==1) {
	//	   // Constants for Grace Cathedral lighting
	//	   L00	= vec3( 0.78908,  0.43710,	0.54161);
	//	   L1m1 = vec3( 0.39499,  0.34989,	0.60488);
	//	   L10	= vec3(-0.33974, -0.18236, -0.26940);
	//	   L11	= vec3(-0.29213, -0.05562,	0.00944);
	//	   L2m2 = vec3(-0.11141, -0.05090, -0.12231);
	//	   L2m1 = vec3(-0.26240, -0.22401, -0.47479);
	//	   L20	= vec3(-0.15570, -0.09471, -0.14733);
	//	   L21	= vec3( 0.56014,  0.21444,	0.13915);
	//	   L22	= vec3( 0.21205, -0.05432, -0.30374);
	// }
	// if (Type==2) {
	//	   // Constants for Eucalyptus Grove lighting
	//	   L00	= vec3( 0.3783264,	0.4260425,	0.4504587);
	//	   L1m1 = vec3( 0.2887813,	0.3586803,	0.4147053);
	//	   L10	= vec3( 0.0379030,	0.0295216,	0.0098567);
	//	   L11	= vec3(-0.1033028, -0.1031690, -0.0884924);
	//	   L2m2 = vec3(-0.0621750, -0.0554432, -0.0396779);
	//	   L2m1 = vec3( 0.0077820, -0.0148312, -0.0471301);
	//	   L20	= vec3(-0.0935561, -0.1254260, -0.1525629);
	//	   L21	= vec3(-0.0572703, -0.0502192, -0.0363410);
	//	   L22	= vec3( 0.0203348, -0.0044201, -0.0452180);
	// }
	// if (Type==3) {
	//	   // Constants for St. Peter's Basilica lighting
	//	   L00	= vec3( 0.3623915,	0.2624130,	0.2326261);
	//	   L1m1 = vec3( 0.1759130,	0.1436267,	0.1260569);
	//	   L10	= vec3(-0.0247311, -0.0101253, -0.0010745);
	//	   L11	= vec3( 0.0346500,	0.0223184,	0.0101350);
	//	   L2m2 = vec3( 0.0198140,	0.0144073,	0.0043987);
	//	   L2m1 = vec3(-0.0469596, -0.0254485, -0.0117786);
	//	   L20	= vec3(-0.0898667, -0.0760911, -0.0740964);
	//	   L21	= vec3( 0.0050194,	0.0038841,	0.0001374);
	//	   L22	= vec3(-0.0818750, -0.0321501,	0.0033399);
	// }
	// if (Type==4) {
	//	   // Constants for Uffizi Gallery lighting
	//	   L00	= vec3(  0.3168843,  0.3073441,  0.3495361);
	//	   L1m1 = vec3(  0.3711289,  0.3682168,  0.4292092);
	//	   L10	= vec3( -0.0034406, -0.0031891, -0.0039797);
	//	   L11	= vec3( -0.0084237, -0.0087049, -0.0116718);
	//	   L2m2 = vec3( -0.0190313, -0.0192164, -0.0250836);
	//	   L2m1 = vec3( -0.0110002, -0.0102972, -0.0119522);
	//	   L20	= vec3( -0.2787319, -0.2752035, -0.3184335);
	//	   L21	= vec3(  0.0011448,  0.0009613,  0.0008975);
	//	   L22	= vec3( -0.2419374, -0.2410955, -0.2842899);
	// }
    if (Type==5) {
        // Constants for Galileo's tomb lighting
        L00  = vec3( 1.0351604,  0.7603549,  0.7074635);
        L1m1 = vec3( 0.4442150,  0.3430402,  0.3403777);
        L10  = vec3(-0.2247797, -0.1828517, -0.1705181);
        L11  = vec3( 0.7110400,  0.5423169,  0.5587956);
        L2m2 = vec3( 0.6430452,  0.4971454,  0.5156357);
        L2m1 = vec3(-0.1150112, -0.0936603, -0.0839287);
        L20  = vec3(-0.3742487, -0.2755962, -0.2875017);
        L21  = vec3(-0.1694954, -0.1343096, -0.1335315);
        L22  = vec3( 0.5515260,  0.4222179,  0.4162488);
    }
	// if (Type==6) {
	//	   // Constants for Vine Street kitchen lighting
	//	   L00	= vec3( 0.6396604,	0.6740969,	0.7286833);
	//	   L1m1 = vec3( 0.2828940,	0.3159227,	0.3313502);
	//	   L10	= vec3( 0.4200835,	0.5994586,	0.7748295);
	//	   L11	= vec3(-0.0474917, -0.0372616, -0.0199377);
	//	   L2m2 = vec3(-0.0984616, -0.0765437, -0.0509038);
	//	   L2m1 = vec3( 0.2496256,	0.3935312,	0.5333141);
	//	   L20	= vec3( 0.3813504,	0.5424832,	0.7141644);
	//	   L21	= vec3( 0.0583734,	0.0066377, -0.0234326);
	//	   L22	= vec3(-0.0325933, -0.0239167, -0.0330796);
	// }
	// if (Type==7) {
	//	   // Constants for Breezeway lighting
	//	   L00	= vec3( 0.3175995,	0.3571678,	0.3784286);
	//	   L1m1 = vec3( 0.3655063,	0.4121290,	0.4490332);
	//	   L10	= vec3(-0.0071628, -0.0123780, -0.0146215);
	//	   L11	= vec3(-0.1047419, -0.1183074, -0.1260049);
	//	   L2m2 = vec3(-0.1304345, -0.1507366, -0.1702497);
	//	   L2m1 = vec3(-0.0098978, -0.0155750, -0.0178279);
	//	   L20	= vec3(-0.0704158, -0.0762753, -0.0865235);
	//	   L21	= vec3( 0.0242531,	0.0279176,	0.0335200);
	//	   L22	= vec3(-0.2858534, -0.3235718, -0.3586478);
	// }
    if (Type==8) {
        // Constants for Campus Sunset lighting
        L00  = vec3( 0.7870665,  0.9379944,  0.9799986);
        L1m1 = vec3( 0.4376419,  0.5579443,  0.7024107);
        L10  = vec3(-0.1020717, -0.1824865, -0.2749662);
        L11  = vec3( 0.4543814,  0.3750162,  0.1968642);
        L2m2 = vec3( 0.1841687,  0.1396696,  0.0491580);
        L2m1 = vec3(-0.1417495, -0.2186370, -0.3132702);
        L20  = vec3(-0.3890121, -0.4033574, -0.3639718);
        L21  = vec3( 0.0872238,  0.0744587,  0.0353051);
        L22  = vec3( 0.6662600,  0.6706794,  0.5246173);
    }
    if (Type==9) {
        // Constants for Funston Beach Sunset lighting
        L00  = vec3( 0.6841148,  0.6929004,  0.7069543);
        L1m1 = vec3( 0.3173355,  0.3694407,  0.4406839);
        L10  = vec3(-0.1747193, -0.1737154, -0.1657420);
        L11  = vec3(-0.4496467, -0.4155184, -0.3416573);
        L2m2 = vec3(-0.1690202, -0.1703022, -0.1525870);
        L2m1 = vec3(-0.0837808, -0.0940454, -0.1027518);
        L20  = vec3(-0.0319670, -0.0214051, -0.0147691);
        L21  = vec3( 0.1641816,  0.1377558,  0.1010403);
        L22  = vec3( 0.3697189,  0.3097930,  0.2029923);
    }
	// if (Type==10) {
	//	   // Constants for Old Town Square lighting
	//	   L00	= vec3( 0.871297,  0.875222,  0.864470);
	//	   L1m1 = vec3( 0.175058,  0.245335,  0.312891);
	//	   L10	= vec3( 0.034675,  0.036107,  0.037362);
	//	   L11	= vec3(-0.004629, -0.029448, -0.048028);
	//	   L2m2 = vec3(-0.120535, -0.121160, -0.117507);
	//	   L2m1 = vec3( 0.003242,  0.003624,  0.007511);
	//	   L20	= vec3(-0.028667, -0.024926, -0.020998);
	//	   L21	= vec3(-0.077539, -0.086325, -0.091591);
	//	   L22	= vec3(-0.161784, -0.191783, -0.219152);
	// }

    vec3 tnorm    = normalize(gl_NormalMatrix * gl_Normal);
    DiffuseColor  = C1 * L22 * (tnorm.x * tnorm.x - tnorm.y * tnorm.y) +
                    C3 * L20 * tnorm.z * tnorm.z +
                    C4 * L00 -
                    C5 * L20 +
                    2.0 * C1 * L2m2 * tnorm.x * tnorm.y +
                    2.0 * C1 * L21  * tnorm.x * tnorm.z +
                    2.0 * C1 * L2m1 * tnorm.y * tnorm.z +
                    2.0 * C2 * L11  * tnorm.x +
                    2.0 * C2 * L1m1 * tnorm.y +
                    2.0 * C2 * L10  * tnorm.z;
    //DiffuseColor *= ScaleFactor;
    gl_Position    = ftransform();
}
