//////////////////////////////////////////////////////////////////////////////
// Name:        SVGFEConvolveMatrixElement.h
// Author:      Alex Thuering
// Copyright:   (c) 2005 Alex Thuering
// Licence:     wxWindows licence
// Notes:       generated by generate.py
//////////////////////////////////////////////////////////////////////////////

#ifndef WX_SVG_FE_CONVOLVE_MATRIX_ELEMENT_H
#define WX_SVG_FE_CONVOLVE_MATRIX_ELEMENT_H

#include "SVGElement.h"
#include "SVGFilterPrimitiveStandardAttributes.h"
#include "SVGAnimatedInteger.h"
#include "SVGAnimatedNumberList.h"
#include "SVGAnimatedNumber.h"
#include "SVGAnimatedEnumeration.h"
#include "SVGAnimatedLength.h"
#include "SVGAnimatedBoolean.h"
#include "SVGSVGElement.h"
#include "String_wxsvg.h"
#include "Element.h"


enum wxSVG_EDGEMODE
{
  wxSVG_EDGEMODE_UNKNOWN = 0,
  wxSVG_EDGEMODE_DUPLICATE = 1,
  wxSVG_EDGEMODE_WRAP = 2,
  wxSVG_EDGEMODE_NONE = 3
};

class wxSVGFEConvolveMatrixElement:
  public wxSVGElement,
  public wxSVGFilterPrimitiveStandardAttributes
{
  protected:
    wxSVGAnimatedInteger m_orderX;
    wxSVGAnimatedInteger m_orderY;
    wxSVGAnimatedNumberList m_kernelMatrix;
    wxSVGAnimatedNumber m_divisor;
    wxSVGAnimatedNumber m_bias;
    wxSVGAnimatedInteger m_targetX;
    wxSVGAnimatedInteger m_targetY;
    wxSVGAnimatedEnumeration m_edgeMode;
    wxSVGAnimatedLength m_kernelUnitLengthX;
    wxSVGAnimatedLength m_kernelUnitLengthY;
    wxSVGAnimatedBoolean m_preserveAlpha;

  public:
    inline const wxSVGAnimatedInteger& GetOrderX() const { return m_orderX; }
    inline void SetOrderX(const wxSVGAnimatedInteger& n) { m_orderX = n; }
    inline void SetOrderX(long n) { m_orderX.SetBaseVal(n); }

    inline const wxSVGAnimatedInteger& GetOrderY() const { return m_orderY; }
    inline void SetOrderY(const wxSVGAnimatedInteger& n) { m_orderY = n; }
    inline void SetOrderY(long n) { m_orderY.SetBaseVal(n); }

    inline const wxSVGAnimatedNumberList& GetKernelMatrix() const { return m_kernelMatrix; }
    inline void SetKernelMatrix(const wxSVGAnimatedNumberList& n) { m_kernelMatrix = n; }
    inline void SetKernelMatrix(const wxSVGNumberList& n) { m_kernelMatrix.SetBaseVal(n); }

    inline const wxSVGAnimatedNumber& GetDivisor() const { return m_divisor; }
    inline void SetDivisor(const wxSVGAnimatedNumber& n) { m_divisor = n; }
    inline void SetDivisor(float n) { m_divisor.SetBaseVal(n); }

    inline const wxSVGAnimatedNumber& GetBias() const { return m_bias; }
    inline void SetBias(const wxSVGAnimatedNumber& n) { m_bias = n; }
    inline void SetBias(float n) { m_bias.SetBaseVal(n); }

    inline const wxSVGAnimatedInteger& GetTargetX() const { return m_targetX; }
    inline void SetTargetX(const wxSVGAnimatedInteger& n) { m_targetX = n; }
    inline void SetTargetX(long n) { m_targetX.SetBaseVal(n); }

    inline const wxSVGAnimatedInteger& GetTargetY() const { return m_targetY; }
    inline void SetTargetY(const wxSVGAnimatedInteger& n) { m_targetY = n; }
    inline void SetTargetY(long n) { m_targetY.SetBaseVal(n); }

    inline const wxSVGAnimatedEnumeration& GetEdgeMode() const { return m_edgeMode; }
    inline void SetEdgeMode(const wxSVGAnimatedEnumeration& n) { m_edgeMode = n; }
    inline void SetEdgeMode(unsigned char n) { m_edgeMode.SetBaseVal(n); }

    inline const wxSVGAnimatedLength& GetKernelUnitLengthX() const { WX_SVG_ANIM_LENGTH_CALC_WIDTH(m_kernelUnitLengthX, GetViewportElement()); return m_kernelUnitLengthX; }
    inline void SetKernelUnitLengthX(const wxSVGAnimatedLength& n) { m_kernelUnitLengthX = n; }
    inline void SetKernelUnitLengthX(const wxSVGLength& n) { m_kernelUnitLengthX.SetBaseVal(n); }

    inline const wxSVGAnimatedLength& GetKernelUnitLengthY() const { WX_SVG_ANIM_LENGTH_CALC_HEIGHT(m_kernelUnitLengthY, GetViewportElement()); return m_kernelUnitLengthY; }
    inline void SetKernelUnitLengthY(const wxSVGAnimatedLength& n) { m_kernelUnitLengthY = n; }
    inline void SetKernelUnitLengthY(const wxSVGLength& n) { m_kernelUnitLengthY.SetBaseVal(n); }

    inline const wxSVGAnimatedBoolean& GetPreserveAlpha() const { return m_preserveAlpha; }
    inline void SetPreserveAlpha(const wxSVGAnimatedBoolean& n) { m_preserveAlpha = n; }
    inline void SetPreserveAlpha(bool n) { m_preserveAlpha.SetBaseVal(n); }

  public:
    wxSVGFEConvolveMatrixElement(wxString tagName = wxT("feConvolveMatrix")):
      wxSVGElement(tagName) {}
    virtual ~wxSVGFEConvolveMatrixElement() {}
    wxSvgXmlNode* CloneNode(bool deep = true) { return new wxSVGFEConvolveMatrixElement(*this); }
    bool HasAttribute(const wxString& name);
    wxString GetAttribute(const wxString& name);
    bool SetAttribute(const wxString& name, const wxString& value);
    wxSvgXmlAttrHash GetAttributes() const;
    virtual wxSVGDTD GetDtd() const { return wxSVG_FECONVOLVEMATRIX_ELEMENT; }
};

#endif // WX_SVG_FE_CONVOLVE_MATRIX_ELEMENT_H
