
/*Xcin Anywhere 0.3a by weijr */

#include <stdio.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xutil.h>
#include <X11/Shell.h>
#include "config.h"

typedef struct {
  char key;
  char *key_string;
} KeyPair;

#define NumOfXAMode 4
#define NumOfCVMode 2

static KeyPair mode_str[4] = {{XA_MODE_DISABLE,"Disable"},
			      {XA_MODE_TRADITION, "Traditional"},
			      {XA_MODE_DISCRETE, "Discrete"},
			      {XA_MODE_PASTE, "CopyPaste"}};

static KeyPair cvmode_str[2] = {{CV_MODE_ENABLE,"Enable"},
				{CV_MODE_DISABLE,"Disable"}};

static XWMHints wmhints;
static GC gc;
static XClassHint class;
static XSizeHints sizehint;
static Window mywin;
#define MW_EVENTS (	KeyPressMask		|\
			FocusChangeMask		|\
			StructureNotifyMask	|\
			ButtonPressMask		|\
			ExposureMask		|\
			PropertyChangeMask	|\
			VisibilityChangeMask	\
		)

void __Xcin_Anywhere_Select_Mode__(Display * d,char *mode,char *cvmode)
{
  char *uu = "Xcin Anywhere Select Mode";
  unsigned long fg, bg;
  int hide = 0;
  int count = 0;
  char buf[200];
  char *now_xamode_str,*now_cvmode_str;
  int i;
  XEvent event;
  XKeyEvent *xke;

  XTextProperty name;
  KeySym keysym;
  static XComposeStatus compose = {NULL, 0};
  sizehint.flags = (PPosition | PSize);
  sizehint.height = 400;
  sizehint.width = 40;
  sizehint.x = DisplayWidth(d, DefaultScreen(d)) / 2;
  sizehint.y = DisplayHeight(d, DefaultScreen(d)) / 2;
  
  wmhints.initial_state = NormalState;
  wmhints.flags = InputHint | StateHint;
  class.res_class = "XA";
  class.res_name = "XA";
  
  fg = WhitePixel(d, DefaultScreen(d));
  bg = BlackPixel(d, DefaultScreen(d));
  
  for(i=0;i<NumOfXAMode;i++)
    if( *mode == mode_str[i].key)
      now_xamode_str=mode_str[i].key_string;
  
  for(i=0;i<NumOfCVMode;i++)
    if( *cvmode == cvmode_str[i].key)
      now_cvmode_str=cvmode_str[i].key_string;

  mywin = XCreateSimpleWindow(d, DefaultRootWindow(d),
			      sizehint.x, sizehint.y, 
			      sizehint.height, sizehint.width,
			      1, fg, bg);
  
  gc = XCreateGC(d, mywin, 0, NULL);
  if (XStringListToTextProperty(&uu, 1, &name) == 0) {
    error("cannot allocate window name");
    return;
  }
  XSetWMProperties(d, mywin,
		   &name, &name,
		   NULL, 0, &sizehint, &wmhints, &class);
  XSelectInput(d, mywin, MW_EVENTS);
  XMapWindow(d, mywin);
  XMoveWindow(d, mywin, sizehint.x, sizehint.y);
  while (1) {

    XSetForeground(d, gc, fg);
    XSetBackground(d, gc, bg);
    sprintf(buf, "XA Mode:%c)%s [0-3];+CV Mode:%c)%s [a-b]"
            ,*mode, now_xamode_str
            ,*cvmode, now_cvmode_str);
    XDrawString(d, mywin, gc, 10, 30, buf, strlen(buf));

    count = 0;
    XNextEvent(d, &event);
    /*sleep(2); */
    switch (event.type) {
    case KeyPress:
      xke = (XKeyEvent *) (&event);
      count = XLookupString(xke, buf, 10, &keysym, &compose);
      count = 1;
      break;
    }
    if (count > 0) {
      if (buf[0] >= '0' && buf[0] <= '3')
	*mode = buf[0];
      else if (buf[0] >= 'a' && buf[0] <= 'b')
	*cvmode = buf[0];
      break;
    }
  };
  XDestroyWindow(d, mywin);
  XFreeGC(d, gc);
}

