/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.NodeInfo;
import java.util.Vector;
import org.xml.sax.SAXException;

public class Sum
extends Function {
    public String getName() {
        return "sum";
    }

    public int getDataType() {
        return 2;
    }

    public boolean isNumeric() {
        return true;
    }

    public Value eval(Vector vector, Context context) throws SAXException {
        int n = this.checkArgumentCount(1, 1);
        Value value = (Value)vector.elementAt(0);
        if (!(value instanceof NodeSetValue)) {
            throw new SAXException("Argument to sum() is not a node set");
        }
        return new NumericValue(Sum.total((NodeSetValue)value));
    }

    public static double total(NodeSetValue nodeSetValue) throws SAXException {
        NodeInfo[] nodeInfoArray = nodeSetValue.getNodes();
        double d = 0.0;
        int n = 0;
        while (n < nodeInfoArray.length) {
            String string = nodeInfoArray[n].getValue();
            d += Value.stringToNumber(string);
            ++n;
        }
        return d;
    }
}

