/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.CDATAFilter;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.HTMLEmitter;
import com.icl.saxon.output.HTMLIndenter;
import com.icl.saxon.output.ProxyEmitter;
import com.icl.saxon.output.XMLEmitter;
import com.icl.saxon.output.XMLIndenter;
import java.util.Vector;
import org.xml.sax.SAXException;

public class UncommittedEmitter
extends ProxyEmitter {
    boolean committed = false;
    boolean initialNewline = false;
    boolean initialEscaping = true;
    StringBuffer pendingCharacters;
    Vector pendingNamespaces;

    public void startDocument() throws SAXException {
        this.committed = false;
    }

    public void endDocument() throws SAXException {
        if (!this.committed) {
            this.switchToXML();
        }
        super.endDocument();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (!this.committed) {
            if (this.pendingNamespaces == null) {
                this.pendingNamespaces = new Vector();
            }
            this.pendingNamespaces.addElement(string);
            this.pendingNamespaces.addElement(string2);
        } else {
            super.startPrefixMapping(string, string2);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.committed) {
            boolean bl = true;
            if (this.pendingCharacters == null) {
                this.pendingCharacters = new StringBuffer();
            }
            int n3 = n;
            while (n3 < n + n2) {
                char c = cArray[n3];
                if (!Character.isWhitespace(c)) {
                    bl = false;
                }
                if (this.initialEscaping) {
                    if (c == '<') {
                        this.pendingCharacters.append("&lt;");
                    } else if (c == '>') {
                        this.pendingCharacters.append("&gt;");
                    } else if (c == '&') {
                        this.pendingCharacters.append("&amp;");
                    } else {
                        this.pendingCharacters.append(c);
                    }
                } else {
                    this.pendingCharacters.append(c);
                }
                ++n3;
            }
            if (!bl) {
                this.switchToXML();
            }
        } else {
            super.characters(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (!this.committed) {
            if (this.pendingCharacters == null) {
                this.pendingCharacters = new StringBuffer();
            }
            this.pendingCharacters.append("<?" + string + " " + string2 + "?>");
        } else {
            super.processingInstruction(string, string2);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (!this.committed) {
            if (this.pendingCharacters == null) {
                this.pendingCharacters = new StringBuffer();
            }
            this.pendingCharacters.append("<!--" + new String(cArray, n, n2) + "-->");
        } else {
            super.comment(cArray, n, n2);
        }
    }

    public void startElement(Name name, AttributeCollection attributeCollection) throws SAXException {
        if (!this.committed) {
            String string = name.getLocalName();
            String string2 = name.getURI();
            if (string.equalsIgnoreCase("html") && string2 == "") {
                this.switchToHTML();
            } else {
                this.switchToXML();
            }
        }
        super.startElement(name, attributeCollection);
    }

    private void switchToXML() throws SAXException {
        ProxyEmitter proxyEmitter;
        Emitter emitter = new XMLEmitter();
        String string = this.outputDetails.getIndent();
        if (string != null && string.equals("yes")) {
            proxyEmitter = new XMLIndenter();
            proxyEmitter.setUnderlyingEmitter(emitter);
            emitter = proxyEmitter;
        }
        if (this.outputDetails.getCdataElements().size() > 0) {
            proxyEmitter = new CDATAFilter();
            proxyEmitter.setUnderlyingEmitter(emitter);
            emitter = proxyEmitter;
        }
        this.switchTo(emitter);
    }

    private void switchToHTML() throws SAXException {
        Emitter emitter = new HTMLEmitter();
        String string = this.outputDetails.getIndent();
        if (string == null || string.equals("yes")) {
            HTMLIndenter hTMLIndenter = new HTMLIndenter();
            hTMLIndenter.setUnderlyingEmitter(emitter);
            emitter = hTMLIndenter;
        }
        this.switchTo(emitter);
    }

    public void setEscaping(boolean bl) throws SAXException {
        if (!this.committed) {
            this.initialEscaping = bl;
        }
        super.setEscaping(bl);
    }

    private void switchTo(Emitter emitter) throws SAXException {
        int n;
        this.setUnderlyingEmitter(emitter);
        this.committed = true;
        emitter.setWriter(this.writer);
        emitter.setCharacterSet(this.characterSet);
        emitter.setOutputDetails(this.outputDetails);
        emitter.startDocument();
        if (this.pendingCharacters != null) {
            emitter.setEscaping(false);
            n = this.pendingCharacters.length();
            char[] cArray = new char[n];
            this.pendingCharacters.getChars(0, n, cArray, 0);
            emitter.characters(cArray, 0, n);
        }
        if (this.pendingNamespaces != null) {
            n = 0;
            while (n < this.pendingNamespaces.size()) {
                emitter.startPrefixMapping((String)this.pendingNamespaces.elementAt(n), (String)this.pendingNamespaces.elementAt(n + 1));
                n += 2;
            }
        }
        emitter.setEscaping(this.initialEscaping);
    }
}

