/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Mode;
import com.icl.saxon.NameTest;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.expr.AnyNameTest;
import com.icl.saxon.expr.ContextNodeExpression;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.PathExpression;
import com.icl.saxon.expr.Step;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.TextInfo;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLSort;
import com.icl.saxon.style.XSLWithParam;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XSLApplyTemplates
extends StyleElement {
    private Expression select;
    private boolean usesParams;
    private String modeName = null;
    private Mode mode;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws SAXException {
        Object object;
        String[] stringArray = new String[]{"mode", "select"};
        this.allowAttributes(stringArray);
        String string = this.getAttributeValue("mode");
        if (string != null) {
            object = new Name(string, this, false);
            this.modeName = ((Name)object).getAbsoluteName();
        }
        if ((object = this.getAttributeValue("select")) != null) {
            this.select = Expression.make((String)object, this);
        }
    }

    public void validate() throws SAXException {
        this.checkWithinTemplate();
        this.mode = this.getPrincipalStyleSheet().getRuleManager().getMode(this.modeName);
        boolean bl = false;
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof XSLSort) {
                bl = true;
            } else if (node instanceof XSLWithParam) {
                this.usesParams = true;
            } else if (node instanceof TextInfo) {
                if (!((TextInfo)node).isWhite()) {
                    throw this.styleError("No character data allowed within xsl:apply-templates");
                }
            } else {
                throw this.styleError("Invalid element within xsl:apply-templates: ");
            }
            node = node.getNextSibling();
        }
        if (this.select == null && bl) {
            this.select = new PathExpression(new ContextNodeExpression(), new Step(4, 0, (NameTest)new AnyNameTest()));
        }
        if (this.select != null) {
            this.select = this.handleSortKeys(this.select);
        }
    }

    public void process(Context context) throws SAXException {
        ParameterSet parameterSet = null;
        if (this.usesParams) {
            parameterSet = new ParameterSet();
            Node node = this.getFirstChild();
            while (node != null) {
                if (node instanceof XSLWithParam) {
                    XSLWithParam xSLWithParam = (XSLWithParam)node;
                    parameterSet.put(xSLWithParam.getVariableName(), xSLWithParam.getParamValue(context));
                }
                node = node.getNextSibling();
            }
        }
        context.getController().applyTemplates(context, this.select, this.mode, parameterSet);
    }
}

