/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLOtherwise;
import com.icl.saxon.style.XSLWhen;
import com.icl.saxon.trace.TraceListener;
import org.xml.sax.SAXException;

public class XSLChoose
extends StyleElement {
    private StyleElement otherwise;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws SAXException {
        String[] stringArray = new String[]{};
        this.allowAttributes(stringArray);
    }

    public void validate() throws SAXException {
        this.checkWithinTemplate();
        NodeInfo nodeInfo = null;
        NodeInfo[] nodeInfoArray = this.getAllChildNodes();
        int n = 0;
        while (n < nodeInfoArray.length) {
            if (nodeInfoArray[n] instanceof XSLWhen) {
                if (this.otherwise != null) {
                    throw this.styleError("xsl:otherwise must come last");
                }
                nodeInfo = nodeInfoArray[n];
            } else if (nodeInfoArray[n] instanceof XSLOtherwise) {
                if (this.otherwise != null) {
                    throw this.styleError("Only one xsl:otherwise allowed in an xsl:choose");
                }
                this.otherwise = (StyleElement)nodeInfoArray[n];
            } else {
                throw this.styleError("Only xsl:when and xsl:otherwise are allowed here");
            }
            ++n;
        }
        if (nodeInfo == null) {
            throw this.styleError("xsl:choose with no xsl:when");
        }
    }

    public void process(Context context) throws SAXException {
        boolean bl = context.getController().isTracing();
        StyleElement styleElement = (StyleElement)this.getFirstChild();
        while (styleElement != null) {
            boolean bl2 = styleElement instanceof XSLWhen ? ((XSLWhen)styleElement).getCondition().evaluateAsBoolean(context) : true;
            if (bl2) {
                if (bl) {
                    TraceListener traceListener = context.getController().getTraceListener();
                    traceListener.enter(styleElement, context);
                    styleElement.process(context);
                    traceListener.leave(styleElement, context);
                } else {
                    styleElement.process(context);
                }
                styleElement = null;
                continue;
            }
            styleElement = (StyleElement)styleElement.getNextSibling();
        }
    }
}

