/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.DecimalFormatManager;
import com.icl.saxon.om.Name;
import com.icl.saxon.style.StyleElement;
import java.text.DecimalFormatSymbols;
import org.xml.sax.SAXException;

public class XSLDecimalFormat
extends StyleElement {
    public void prepareAttributes() throws SAXException {
        String[] stringArray = new String[]{"name", "decimal-separator", "grouping-separator", "infinity", "minus-sign", "NaN", "percent", "per-mille", "zero-digit", "digit", "pattern-separator"};
        this.allowAttributes(stringArray);
    }

    public void validate() throws SAXException {
        this.checkTopLevel();
    }

    public void preprocess() throws SAXException {
        String string = this.attributeList.getValue("name");
        String string2 = this.attributeList.getValue("decimal-separator");
        String string3 = this.attributeList.getValue("grouping-separator");
        String string4 = this.attributeList.getValue("infinity");
        String string5 = this.attributeList.getValue("minus-sign");
        String string6 = this.attributeList.getValue("NaN");
        String string7 = this.attributeList.getValue("percent");
        String string8 = this.attributeList.getValue("per-mille");
        String string9 = this.attributeList.getValue("zero-digit");
        String string10 = this.attributeList.getValue("digit");
        String string11 = this.attributeList.getValue("pattern-separator");
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        DecimalFormatManager.setDefaults(decimalFormatSymbols);
        if (string2 != null) {
            decimalFormatSymbols.setDecimalSeparator(this.toChar(string2));
        }
        if (string3 != null) {
            decimalFormatSymbols.setGroupingSeparator(this.toChar(string3));
        }
        if (string4 != null) {
            decimalFormatSymbols.setInfinity(string4);
        }
        if (string5 != null) {
            decimalFormatSymbols.setMinusSign(this.toChar(string5));
        }
        if (string6 != null) {
            decimalFormatSymbols.setNaN(string6);
        }
        if (string7 != null) {
            decimalFormatSymbols.setPercent(this.toChar(string7));
        }
        if (string8 != null) {
            decimalFormatSymbols.setPerMill(this.toChar(string8));
        }
        if (string9 != null) {
            decimalFormatSymbols.setZeroDigit(this.toChar(string9));
        }
        if (string10 != null) {
            decimalFormatSymbols.setDigit(this.toChar(string10));
        }
        if (string11 != null) {
            decimalFormatSymbols.setPatternSeparator(this.toChar(string11));
        }
        DecimalFormatManager decimalFormatManager = this.getPrincipalStyleSheet().getDecimalFormatManager();
        if (string == null) {
            decimalFormatManager.setDefaultDecimalFormat(decimalFormatSymbols);
        } else {
            Name name = new Name(string, this, false);
            decimalFormatManager.setNamedDecimalFormat(name.getAbsoluteName(), decimalFormatSymbols);
        }
    }

    public void process(Context context) {
    }

    private char toChar(String string) throws SAXException {
        if (string.length() != 1) {
            throw this.styleError("Attribute \"" + string + "\" should be a single character");
        }
        return string.charAt(0);
    }
}

